/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.classfile.CPClassInfo;
import org.netbeans.modules.classfile.CPDoubleInfo;
import org.netbeans.modules.classfile.CPEntry;
import org.netbeans.modules.classfile.CPFieldInfo;
import org.netbeans.modules.classfile.CPFloatInfo;
import org.netbeans.modules.classfile.CPIntegerInfo;
import org.netbeans.modules.classfile.CPInterfaceMethodInfo;
import org.netbeans.modules.classfile.CPLongInfo;
import org.netbeans.modules.classfile.CPMethodInfo;
import org.netbeans.modules.classfile.CPNameAndTypeInfo;
import org.netbeans.modules.classfile.CPStringInfo;
import org.netbeans.modules.classfile.CPUTF8Info;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.ConstantPoolReader;

public final class ConstantPool {
    private static final int CONSTANT_POOL_START = 1;
    static final int CONSTANT_Utf8 = 1;
    static final int CONSTANT_Integer = 3;
    static final int CONSTANT_Float = 4;
    static final int CONSTANT_Long = 5;
    static final int CONSTANT_Double = 6;
    static final int CONSTANT_Class = 7;
    static final int CONSTANT_String = 8;
    static final int CONSTANT_FieldRef = 9;
    static final int CONSTANT_MethodRef = 10;
    static final int CONSTANT_InterfaceMethodRef = 11;
    static final int CONSTANT_NameAndType = 12;
    CPEntry[] cpEntries;
    int constantPoolCount = 0;
    static /* synthetic */ Class class$org$netbeans$modules$classfile$CPClassInfo;

    ConstantPool(int size, InputStream bytes) {
        if (size < 0) {
            throw new IllegalArgumentException("size cannot be negative");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("byte stream not specified");
        }
        this.constantPoolCount = size;
        this.cpEntries = new CPEntry[this.constantPoolCount];
        this.load(bytes);
    }

    ConstantPool() {
        this.constantPoolCount = 1;
        this.cpEntries = new CPEntry[this.constantPoolCount];
    }

    public final CPEntry get(int index) {
        if (index <= 0 || index >= this.cpEntries.length) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        return this.cpEntries[index];
    }

    public final CPClassInfo getClass(int index) {
        if (index <= 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        return (CPClassInfo)this.get(index);
    }

    public final Collection getAllConstants(Class classType) {
        return Collections.unmodifiableCollection(this.getAllConstantsImpl(classType));
    }

    private Collection getAllConstantsImpl(Class classType) {
        int n = this.cpEntries.length;
        ArrayList<CPEntry> c = new ArrayList<CPEntry>(n);
        int i = 1;
        while (i < n) {
            if (this.cpEntries[i] != null && this.cpEntries[i].getClass().equals(classType)) {
                c.add(this.cpEntries[i]);
            }
            ++i;
        }
        return c;
    }

    public final Set getAllClassNames() {
        HashSet<ClassName> set = new HashSet<ClassName>();
        Collection c = this.getAllConstantsImpl(class$org$netbeans$modules$classfile$CPClassInfo == null ? (class$org$netbeans$modules$classfile$CPClassInfo = ConstantPool.class$("org.netbeans.modules.classfile.CPClassInfo")) : class$org$netbeans$modules$classfile$CPClassInfo);
        Iterator i = c.iterator();
        while (i.hasNext()) {
            CPClassInfo ci = (CPClassInfo)i.next();
            set.add(ci.getClassName());
        }
        return Collections.unmodifiableSet(set);
    }

    final String getString(int index) {
        CPUTF8Info utf = (CPUTF8Info)this.cpEntries[index];
        return utf.getName();
    }

    private void load(InputStream cpBytes) {
        try {
            ConstantPoolReader cpr = new ConstantPoolReader(cpBytes);
            int i = 1;
            while (i < this.constantPoolCount) {
                CPEntry newEntry;
                this.cpEntries[i] = newEntry = this.getConstantPoolEntry(cpr);
                if (newEntry.usesTwoSlots()) {
                    ++i;
                }
                ++i;
            }
            int i2 = 1;
            while (i2 < this.constantPoolCount) {
                CPEntry entry = this.cpEntries[i2];
                if (entry != null) {
                    entry.resolve(this.cpEntries);
                }
                ++i2;
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("invalid class format");
        }
    }

    private CPEntry getConstantPoolEntry(ConstantPoolReader cpr) throws IOException {
        CPEntry newEntry = null;
        byte type = cpr.readByte();
        switch (type) {
            case 1: {
                newEntry = new CPUTF8Info(this, cpr.readRawUTF());
                break;
            }
            case 3: {
                newEntry = new CPIntegerInfo(this, cpr.readInt());
                break;
            }
            case 4: {
                newEntry = new CPFloatInfo(this, cpr.readFloat());
                break;
            }
            case 5: {
                newEntry = new CPLongInfo(this, cpr.readLong());
                break;
            }
            case 6: {
                newEntry = new CPDoubleInfo(this, cpr.readDouble());
                break;
            }
            case 7: {
                short nameIndex = cpr.readShort();
                newEntry = new CPClassInfo(this, nameIndex);
                break;
            }
            case 8: {
                short nameIndex = cpr.readShort();
                newEntry = new CPStringInfo(this, nameIndex);
                break;
            }
            case 9: {
                short classIndex = cpr.readShort();
                short natIndex = cpr.readShort();
                newEntry = new CPFieldInfo(this, classIndex, natIndex);
                break;
            }
            case 10: {
                short classIndex = cpr.readShort();
                short natIndex = cpr.readShort();
                newEntry = new CPMethodInfo(this, classIndex, natIndex);
                break;
            }
            case 11: {
                short classIndex = cpr.readShort();
                short natIndex = cpr.readShort();
                newEntry = new CPInterfaceMethodInfo(this, classIndex, natIndex);
                break;
            }
            case 12: {
                short nameIndex = cpr.readShort();
                short descIndex = cpr.readShort();
                newEntry = new CPNameAndTypeInfo(this, nameIndex, descIndex);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid constant pool type: " + type);
            }
        }
        if (newEntry == null) {
            throw new InternalError("assertion failure");
        }
        return newEntry;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

