/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.netbeans.modules.classfile.Access;
import org.netbeans.modules.classfile.CPUTF8Info;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ConstantPool;

public abstract class Field {
    CPUTF8Info utfName;
    CPUTF8Info utfType;
    private String _name;
    private String _type;
    int access;
    ClassFile classFile;
    private boolean deprecated = false;
    private boolean synthetic = false;

    Field(DataInputStream in, ConstantPool pool, ClassFile classFile) throws IOException {
        this.access = in.readUnsignedShort();
        this.classFile = classFile;
        Object entry = null;
        try {
            this.utfName = (CPUTF8Info)pool.get(in.readUnsignedShort());
            this.utfType = (CPUTF8Info)pool.get(in.readUnsignedShort());
        }
        catch (ClassCastException e) {
            System.out.println("error looking up constant pool entry: wanted type CPUTF8Info, got " + entry.getClass().getName() + "; e=" + e);
            e.printStackTrace();
            throw new IOException("internal error");
        }
    }

    final void loadAttributes(DataInputStream in, ConstantPool pool) throws IOException {
        int n = in.readUnsignedShort();
        int i = 0;
        while (i < n) {
            CPUTF8Info entry = (CPUTF8Info)pool.get(in.readUnsignedShort());
            int len = in.readInt();
            String name = entry.getName();
            if (name.equals("Deprecated")) {
                this.deprecated = true;
            } else if (name.equals("Synthetic")) {
                this.synthetic = true;
            } else if (!this.loadAttribute(name, len, in, pool)) {
                ClassFile.skip(in, len);
            }
            ++i;
        }
    }

    abstract boolean loadAttribute(String var1, int var2, DataInputStream var3, ConstantPool var4) throws IOException;

    public final String getName() {
        if (this._name == null) {
            this._name = this.utfName.getName();
            this.utfName = null;
        }
        return this._name;
    }

    public final String getDescriptor() {
        if (this._type == null) {
            this._type = this.utfType.getName();
            this.utfType = null;
        }
        return this._type;
    }

    public abstract String getDeclaration();

    public final int getAccess() {
        return this.access;
    }

    public final boolean isStatic() {
        return Access.isStatic(this.access);
    }

    public final boolean isPublic() {
        return Access.isPublic(this.access);
    }

    public final boolean isProtected() {
        return Access.isProtected(this.access);
    }

    public final boolean isPackagePrivate() {
        return Access.isPackagePrivate(this.access);
    }

    public final boolean isPrivate() {
        return Access.isPrivate(this.access);
    }

    public final boolean isDeprecated() {
        return this.deprecated;
    }

    public final boolean isSynthetic() {
        return this.synthetic;
    }

    public final ClassFile getClassFile() {
        return this.classFile;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        if (this.synthetic) {
            sb.append(" (synthetic)");
        }
        if (this.deprecated) {
            sb.append(" (deprecated)");
        }
        sb.append(" type=");
        sb.append(this.getDescriptor());
        sb.append(", access=");
        sb.append(Access.toString(this.access));
        return sb.toString();
    }
}

