/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.netbeans.modules.classfile.CPUTF8Info;
import org.netbeans.modules.classfile.ConstantPool;

public final class LocalVariableTableEntry {
    int startPC;
    int length;
    String name;
    String description;
    int index;

    static LocalVariableTableEntry[] loadLocalVariableTable(DataInputStream in, ConstantPool pool) throws IOException {
        int n = in.readUnsignedShort();
        LocalVariableTableEntry[] exceptions = new LocalVariableTableEntry[n];
        int i = 0;
        while (i < n) {
            exceptions[i] = new LocalVariableTableEntry(in, pool);
            ++i;
        }
        return exceptions;
    }

    LocalVariableTableEntry(DataInputStream in, ConstantPool pool) throws IOException {
        this.loadLocalVariableEntry(in, pool);
    }

    private void loadLocalVariableEntry(DataInputStream in, ConstantPool pool) throws IOException {
        this.startPC = in.readUnsignedShort();
        this.length = in.readUnsignedShort();
        CPUTF8Info entry = (CPUTF8Info)pool.get(in.readUnsignedShort());
        this.name = entry.getName();
        entry = (CPUTF8Info)pool.get(in.readUnsignedShort());
        this.description = entry.getName();
        this.index = in.readUnsignedShort();
    }

    public final int getStartPC() {
        return this.startPC;
    }

    public final int getLength() {
        return this.length;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final int getIndex() {
        return this.index;
    }
}

