/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.netbeans.modules.classfile.CPClassInfo;
import org.netbeans.modules.classfile.CPMethodInfo;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.Code;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.Field;

public final class Method
extends Field {
    private boolean includeCode;
    private Code code;
    private CPClassInfo[] exceptions;

    static Method[] loadMethods(DataInputStream in, ConstantPool pool, ClassFile cls, boolean includeCode) throws IOException {
        int count = in.readUnsignedShort();
        Method[] methods = new Method[count];
        int i = 0;
        while (i < count) {
            methods[i] = new Method(in, pool, cls, includeCode);
            ++i;
        }
        return methods;
    }

    Method(DataInputStream in, ConstantPool pool, ClassFile cls, boolean includeCode) throws IOException {
        super(in, pool, cls);
        this.includeCode = includeCode;
        super.loadAttributes(in, pool);
    }

    final boolean loadAttribute(String name, int len, DataInputStream in, ConstantPool pool) throws IOException {
        if (this.includeCode && name.equals("Code")) {
            this.code = new Code(in, pool);
            return true;
        }
        if (name.equals("Exceptions")) {
            this.exceptions = ClassFile.getCPClassList(in, pool);
            return true;
        }
        return false;
    }

    public final Code getCode() {
        return this.code;
    }

    public final CPClassInfo[] getExceptionClasses() {
        if (this.exceptions == null) {
            this.exceptions = new CPClassInfo[0];
        }
        return this.exceptions;
    }

    public String toString() {
        String s = super.toString();
        CPClassInfo[] ec = this.getExceptionClasses();
        if (ec.length > 0) {
            StringBuffer sb = new StringBuffer(s);
            sb.append(", throws");
            int i = 0;
            while (i < ec.length) {
                sb.append(' ');
                sb.append(ec[i].getName());
                ++i;
            }
        }
        return s;
    }

    public final String getDeclaration() {
        return CPMethodInfo.getFullMethodName(this.getName(), this.getDescriptor());
    }
}

