/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.netbeans.modules.classfile.CPEntry;
import org.netbeans.modules.classfile.CPFieldMethodInfo;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.Field;

public final class Variable
extends Field {
    private boolean constant;
    private Object value;

    static Variable[] loadFields(DataInputStream in, ConstantPool pool, ClassFile cls) throws IOException {
        int count = in.readUnsignedShort();
        Variable[] variables = new Variable[count];
        int i = 0;
        while (i < count) {
            variables[i] = new Variable(in, pool, cls);
            ++i;
        }
        return variables;
    }

    Variable(DataInputStream in, ConstantPool pool, ClassFile cls) throws IOException {
        super(in, pool, cls);
        this.loadAttributes(in, pool);
    }

    final boolean loadAttribute(String name, int len, DataInputStream in, ConstantPool pool) throws IOException {
        if (name.equals("ConstantValue")) {
            this.constant = true;
            int index = in.readUnsignedShort();
            CPEntry cpe = pool.get(index);
            this.value = cpe.getValue();
            return true;
        }
        return false;
    }

    public final boolean isConstant() {
        return this.constant;
    }

    public final Object getValue() {
        return this.value;
    }

    public final String getDeclaration() {
        StringBuffer sb = new StringBuffer();
        sb.append(CPFieldMethodInfo.getSignature(this.getDescriptor(), false));
        sb.append(' ');
        sb.append(this.getName());
        return sb.toString();
    }

    public String toString() {
        String s = super.toString();
        if (this.isConstant()) {
            s = s + ", const value=" + this.getValue();
        }
        return s;
    }
}

