/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.UIManager;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class OutputSettings
extends SystemOption {
    static final long serialVersionUID = 5773055866277884154L;
    private static ResourceBundle bundle;
    public static final String PROP_FONT_SIZE = "fontSize";
    public static final String PROP_TAB_SIZE = "tabSize";
    public static final String PROP_FOREGROUND = "foreground";
    public static final String PROP_CURSOR_FOREGROUND = "cursorForeground";
    public static final String PROP_JUMP_CURSOR_FOREGROUND = "jumpCursorForeground";
    public static final String PROP_JUMP_LINK_FOREGROUND = "jumpLinkForeground";
    public static final String PROP_BACKGROUND = "background";
    public static final String PROP_CURSOR_BACKGROUND = "cursorBackground";
    public static final String PROP_JUMP_CURSOR_BACKGROUND = "jumpCursorBackground";
    public static final String PROP_HISTORY_SIZE = "historySize";
    public static final String PROP_REDIRECTION = "redirection";
    public static final String PROP_DIRECTORY = "directory";
    public static final String PROP_SELECTION_BACKGROUND = "selectionBackground";
    public static final String PROP_OPEN_AFTER_COMPILE = "alwaysOpenAfterCompile";
    private static final String REDIR_FOLDER = "output";
    private static int fontSize;
    private static int tabSize;
    private static int historySize;
    private static boolean redirection;
    private static Color fBase;
    private static Color fSelect;
    private static Color fJumpSelect;
    private static Color fLinkSelect;
    private static Color bBase;
    private static Color bSelect;
    private static Color bJumpSelect;
    private static File directory;
    private static Color selectionBackground;
    private boolean alwaysOpenAfterCompile = true;
    static /* synthetic */ Class class$org$netbeans$core$output$OutputSettings;

    public String displayName() {
        return OutputSettings.getString("CTL_Output_settings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$core$output$OutputSettings == null ? (class$org$netbeans$core$output$OutputSettings = OutputSettings.class$("org.netbeans.core.output.OutputSettings")) : class$org$netbeans$core$output$OutputSettings);
    }

    public int getFontSize() {
        return fontSize;
    }

    public void setFontSize(int fontSize) {
        if (OutputSettings.fontSize != fontSize) {
            OutputSettings.fontSize = fontSize;
            this.change();
        }
    }

    public boolean isRedirection() {
        return redirection;
    }

    public void setRedirection(boolean redirection) {
        if (OutputSettings.redirection != redirection) {
            Boolean old = OutputSettings.redirection ? Boolean.TRUE : Boolean.FALSE;
            OutputSettings.redirection = redirection;
            this.firePropertyChange(PROP_REDIRECTION, old, redirection ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public File getDirectory() {
        return directory;
    }

    public void setDirectory(File s) {
        if (directory != s) {
            File old = directory;
            directory = s;
            this.firePropertyChange(PROP_DIRECTORY, old, directory);
        }
    }

    public int getTabSize() {
        return tabSize;
    }

    public void setTabSize(int tabSize) {
        if (OutputSettings.tabSize != tabSize) {
            OutputSettings.tabSize = tabSize;
            this.change();
        }
    }

    public int getHistorySize() {
        return historySize;
    }

    public void setHistorySize(int historySize) {
        if (OutputSettings.historySize != historySize) {
            OutputSettings.historySize = historySize;
            this.change();
        }
    }

    public Color getBaseForeground() {
        if (fBase == null) {
            return Color.black;
        }
        return fBase;
    }

    public Color getCursorForeground() {
        if (fSelect == null) {
            return Color.white;
        }
        return fSelect;
    }

    public Color getJumpCursorForeground() {
        if (fJumpSelect == null) {
            return Color.white;
        }
        return fJumpSelect;
    }

    public Color getJumpLinkForeground() {
        if (fLinkSelect == null) {
            return Color.blue;
        }
        return fLinkSelect;
    }

    public Color getBaseBackground() {
        if (bBase == null) {
            return (Color)UIManager.getDefaults().get("Label.background");
        }
        return bBase;
    }

    public Color getCursorBackground() {
        if (bSelect == null) {
            return Color.blue;
        }
        return bSelect;
    }

    public Color getJumpCursorBackground() {
        if (bJumpSelect == null) {
            return Color.lightGray;
        }
        return bJumpSelect;
    }

    public void setBaseForeground(Color c) {
        fBase = c;
        this.change();
    }

    public void setCursorForeground(Color c) {
        fSelect = c;
        this.change();
    }

    public void setJumpCursorForeground(Color c) {
        fJumpSelect = c;
        this.change();
    }

    public void setJumpLinkForeground(Color c) {
        fLinkSelect = c;
        this.change();
    }

    public void setBaseBackground(Color c) {
        bBase = c;
        this.change();
    }

    public void setCursorBackground(Color c) {
        bSelect = c;
        this.change();
    }

    public void setJumpCursorBackground(Color c) {
        bJumpSelect = c;
        this.change();
    }

    private void change() {
        this.firePropertyChange(null, null, null);
    }

    static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputSettings == null ? (class$org$netbeans$core$output$OutputSettings = OutputSettings.class$("org.netbeans.core.output.OutputSettings")) : class$org$netbeans$core$output$OutputSettings));
        }
        return bundle.getString(s);
    }

    public Color getSelectionBackground() {
        if (selectionBackground == null) {
            return new Color(204, 204, 255);
        }
        return selectionBackground;
    }

    public void setSelectionBackground(Color selectionBackground) {
        OutputSettings.selectionBackground = selectionBackground;
        this.change();
    }

    public boolean isAlwaysOpenAfterCompile() {
        return this.alwaysOpenAfterCompile;
    }

    public void setAlwaysOpenAfterCompile(boolean alwaysOpenAfterCompile) {
        Boolean old = this.alwaysOpenAfterCompile ? Boolean.TRUE : Boolean.FALSE;
        this.alwaysOpenAfterCompile = alwaysOpenAfterCompile;
        this.firePropertyChange(PROP_OPEN_AFTER_COMPILE, old, alwaysOpenAfterCompile ? Boolean.TRUE : Boolean.FALSE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Font f = UIManager.getFont("controlFont");
        fontSize = f != null ? f.getSize() : 12;
        tabSize = 8;
        historySize = 10000;
        redirection = false;
        String userDir = System.getProperty("netbeans.user");
        if (userDir == null) {
            userDir = System.getProperty("netbeans.home");
        }
        if (userDir != null) {
            userDir = new File(userDir).getAbsolutePath();
            directory = new File(userDir, REDIR_FOLDER);
            directory.mkdirs();
        } else {
            directory = new File(System.getProperty("user.dir"));
        }
    }
}

