/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Observable;
import java.util.Observer;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.Keymap;
import org.netbeans.core.output.FindDialogPanel;
import org.netbeans.core.output.NextOutJumpAction;
import org.netbeans.core.output.OutputSettings;
import org.netbeans.core.output.OutputTabProvider;
import org.netbeans.core.output.OutputTabTerm;
import org.netbeans.core.output.PreviousOutJumpAction;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.SelectedNodesChangedEvent;
import org.netbeans.core.windows.TopComponentChangedEvent;
import org.netbeans.core.windows.TopComponentListener;
import org.netbeans.core.windows.WellKnownModeNames;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.lib.terminalemulator.ActiveRegion;
import org.netbeans.lib.terminalemulator.ActiveTerm;
import org.netbeans.lib.terminalemulator.ActiveTermListener;
import org.netbeans.lib.terminalemulator.Coord;
import org.netbeans.lib.terminalemulator.Extent;
import org.netbeans.lib.terminalemulator.LineDiscipline;
import org.netbeans.lib.terminalemulator.RegionException;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.lib.terminalemulator.TermInputListener;
import org.netbeans.lib.terminalemulator.TermListener;
import org.netbeans.lib.terminalemulator.TermStream;
import org.netbeans.lib.terminalemulator.WordDelineator;
import org.openide.ErrorManager;
import org.openide.actions.CloneViewAction;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PopupAction;
import org.openide.awt.MouseUtils;
import org.openide.awt.SplittedPanel;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.io.NullOutputStream;
import org.openide.windows.InputOutput;
import org.openide.windows.Mode;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class OutputTabTerm
extends TopComponent
implements InputOutput,
WellKnownModeNames,
TopComponentListener {
    public static boolean DEBUG = false;
    public static final String ICON_RESOURCE = "/org/netbeans/core/resources/frames/output.gif";
    private boolean focusTaken = false;
    private boolean amISelected;
    private Reader inReader;
    PipedWriter inWriter = new PipedWriter();
    private boolean errSeparated;
    private Boolean inputVisible = null;
    private boolean errVisible;
    private static boolean compilerPrinted = false;
    static WeakHashMap ioCache = new WeakHashMap(7);
    private SplittedPanel splittedInside;
    private int splitTypeBackup = 2;
    private static OutputTabTerm standard;
    private static OutputTabTerm compiler;
    private static final long serialVersionUID = 3276412782250080205L;
    private static String compiler_name;
    private OutTermPane output;
    private OutTermPane error;
    private static Factory factory;
    private boolean hideOnly = false;
    private Replace replace;
    private static HashSet keyStrokeSet;
    private static HashSet keyStrokeSet2;
    private static final boolean safe_way = true;
    static /* synthetic */ Class class$org$netbeans$core$output$OutputTabTerm;
    static /* synthetic */ Class class$org$netbeans$core$output$OutputSettings;
    static /* synthetic */ Class class$javax$swing$text$Keymap;

    private static void debug(String s) {
        if (!DEBUG) {
            return;
        }
        s = "OutputTabTerm:" + s + "\r\n";
        try {
            String dir = OutputTabTerm.outputSettings().getDirectory().getAbsolutePath();
            FileOutputStream fos = new FileOutputStream(dir + "/debug.log", true);
            fos.write(s.getBytes());
            fos.close();
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    private OutputTabTerm(String name) {
        Class clazz = class$org$netbeans$core$output$OutputTabTerm == null ? (class$org$netbeans$core$output$OutputTabTerm = OutputTabTerm.class$("org.netbeans.core.output.OutputTabTerm")) : class$org$netbeans$core$output$OutputTabTerm;
        synchronized (clazz) {
            this.setName(name);
            this.setActivatedNodes(null);
            ((JComponent)((Object)this)).putClientProperty("PersistenceType", "OnlyOpened");
            this.errSeparated = false;
            ((WindowManagerImpl)WindowManager.getDefault()).addTopComponentListener((TopComponentListener)this);
            ((Container)((Object)this)).setLayout(new GridBagLayout());
            GridBagConstraints gd = new GridBagConstraints();
            gd.anchor = 10;
            gd.fill = 1;
            gd.gridwidth = 1;
            gd.gridheight = 1;
            gd.gridx = 0;
            gd.gridy = 0;
            gd.weightx = 1.0;
            gd.weighty = 1.0;
            gd.insets = new Insets(0, 0, 0, 0);
            this.splittedInside = new SplittedPanel();
            ((Container)((Object)this)).add((Component)this.splittedInside, gd);
            this.output = new OutTermPane(this);
            this.error = new OutTermPane(this);
            this.splittedInside.add((Component)this.output, SplittedPanel.ADD_FIRST);
            this.splittedInside.add((Component)this.error, SplittedPanel.ADD_SECOND);
            this.errVisible = false;
            this.splittedInside.setSplitType(0);
            ioCache.put(name, this);
            this.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputTabTerm == null ? (class$org$netbeans$core$output$OutputTabTerm = OutputTabTerm.class$("org.netbeans.core.output.OutputTabTerm")) : class$org$netbeans$core$output$OutputTabTerm)).getString("ACSN_OutputWindow"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputTabTerm == null ? (class$org$netbeans$core$output$OutputTabTerm = OutputTabTerm.class$("org.netbeans.core.output.OutputTabTerm")) : class$org$netbeans$core$output$OutputTabTerm)).getString("ACSD_OutputWindow"));
            ((JComponent)((Object)this)).setBorder(null);
        }
    }

    static synchronized Factory getFactory() {
        if (factory == null) {
            factory = new Factory();
        }
        return factory;
    }

    public static InputOutput getIO(String name, boolean newIO) {
        InputOutput inpo = OutputTabTerm.getFactory().getIO(name, newIO);
        return inpo;
    }

    public SystemAction[] getSystemActions() {
        SystemAction[] actions = super.getSystemActions();
        ArrayList<SystemAction> al = new ArrayList<SystemAction>(actions.length - 1);
        int i = 0;
        while (i < actions.length) {
            if (!(actions[i] instanceof CloneViewAction)) {
                al.add(actions[i]);
            }
            ++i;
        }
        return al.toArray(actions);
    }

    public static OutputWriter getStdOut() {
        return OutputTabTerm.getFactory().getStdOut();
    }

    public static TopComponent getStdOutputTab() {
        return OutputTabTerm.getFactory().getStdOutputTab();
    }

    public synchronized Object writeReplace() throws ObjectStreamException {
        if (!((Object)((Object)this)).equals((Object)standard) && !((Object)((Object)this)).equals((Object)compiler)) {
            return null;
        }
        if (this.replace == null) {
            this.replace = new Replace(((Object)((Object)this)).equals((Object)standard));
            if (((Object)((Object)this)).equals((Object)compiler)) {
                this.replace.setInstanceType(1);
            }
        }
        return this.replace;
    }

    public Term getTerm() {
        return this.getTerm(true);
    }

    public Term getTerm(boolean fromOutputPane) {
        if (fromOutputPane) {
            return this.output.getTerm();
        }
        return this.error.getTerm();
    }

    public String toString() {
        Term term = this.getTerm(true);
        if (term == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i <= term.getCursorCoord().row) {
            if (i > 0) {
                buf.append('\n');
            }
            buf.append(term.getRowText(i));
            ++i;
        }
        return buf.toString();
    }

    void ensureOpen() {
        if (this.isClosed()) {
            this.open();
        }
    }

    private static synchronized void initialize() {
        if (standard == null) {
            standard = new OutputTabTerm(NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputTabTerm == null ? (class$org$netbeans$core$output$OutputTabTerm = OutputTabTerm.class$("org.netbeans.core.output.OutputTabTerm")) : class$org$netbeans$core$output$OutputTabTerm)).getString("CTL_OutputWindow_OutputTab"));
            ((JComponent)((Object)standard)).putClientProperty("PersistenceType", null);
        }
    }

    private static synchronized void initializeComp() {
        if (compiler == null) {
            compiler = new OutputTabTerm(OutputTabTerm.getCompilerName());
            ((JComponent)((Object)compiler)).putClientProperty("PersistenceType", null);
        }
    }

    static String getOutDisplayName() {
        return NbBundle.getBundle((String)"org.netbeans.core.windows.Bundle").getString("CTL_OutputWindow");
    }

    protected void componentActivated() {
        this.amISelected = true;
        this.output.activated();
    }

    public void requestFocus() {
        super.requestFocus();
        this.output.requestFocus();
    }

    protected void componentDeactivated() {
        this.amISelected = false;
        this.output.deactivated();
    }

    public boolean isFocusTaken() {
        return this.focusTaken;
    }

    public void setFocusTaken(boolean value) {
        this.focusTaken = value;
    }

    public OutputWriter getOut() {
        return this.output.writer;
    }

    public void select() {
        if (((Object)((Object)this)).equals((Object)compiler) && !compilerPrinted) {
            return;
        }
        this.ensureOpen();
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                if (((Object)((Object)OutputTabTerm.this)).equals((Object)compiler)) {
                    OutputTabTerm.this.requestVisible();
                } else {
                    OutputTabTerm.this.requestFocus();
                }
            }
        });
    }

    public OutputWriter getErr() {
        if (this.errSeparated) {
            return this.error.writer;
        }
        return this.output.writer;
    }

    public Reader getIn() {
        this.flushReader();
        if (this.inputVisible == null || this.inputVisible.booleanValue()) {
            this.setInputVisible(true);
        }
        return this.inReader;
    }

    public void setErrSeparated(boolean value) {
        if (this.errSeparated == value) {
            return;
        }
        this.errSeparated = value;
        this.setErrVisible(this.errSeparated);
    }

    public Reader flushReader() {
        this.inWriter = new PipedWriter();
        try {
            this.inReader = new PipedReader(this.inWriter);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return null;
        }
        return this.inReader;
    }

    public void setOutputVisible(boolean param) {
        if (param) {
            this.ensureOpen();
            this.requestFocus();
        } else {
            this.hideOnly = true;
            this.doClose();
        }
    }

    public void setErrVisible(boolean value) {
        if (this.errVisible == value) {
            return;
        }
        this.errVisible = value;
        if (this.errVisible && this.errSeparated) {
            this.splittedInside.setSplitType(this.splitTypeBackup);
        } else {
            this.splitTypeBackup = this.splittedInside.getSplitType();
            if (this.splitTypeBackup == 0) {
                this.splitTypeBackup = 2;
            }
            this.splittedInside.setSplitType(0);
        }
        ((Container)((Object)this)).invalidate();
        Container parent = ((Component)((Object)this)).getParent();
        if (parent != null) {
            parent.validate();
        }
    }

    public boolean isClosed() {
        Workspace wrkSpace = WindowManager.getDefault().getCurrentWorkspace();
        return !this.isOpened(wrkSpace);
    }

    public void setInputVisible(boolean param) {
        if (param) {
            this.ensureOpen();
            this.requestFocus();
        }
        this.inputVisible = param ? Boolean.TRUE : Boolean.FALSE;
        this.output.setReadWrite(param);
    }

    public boolean isErrSeparated() {
        return this.errSeparated;
    }

    public void closeInputOutput() {
        this.doClose();
        try {
            this.inWriter.flush();
            this.inWriter.close();
        }
        catch (IOException ioe) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.output.writer.close();
        this.error.writer.close();
    }

    private void doClose() {
        if (this.isOpened()) {
            Runnable run = new Runnable(){

                public void run() {
                    OutputTabTerm.this.close();
                }
            };
            EventQueue.invokeLater(run);
        }
    }

    public void open(Workspace workspace) {
        Mode tcMode;
        Workspace realWorkspace = workspace == null ? WindowManager.getDefault().getCurrentWorkspace() : workspace;
        Mode mode = realWorkspace.findMode("output");
        if (mode == null) {
            mode = realWorkspace.createMode("output", OutputTabTerm.getOutDisplayName(), (class$org$netbeans$core$output$OutputTabTerm == null ? (class$org$netbeans$core$output$OutputTabTerm = OutputTabTerm.class$("org.netbeans.core.output.OutputTabTerm")) : class$org$netbeans$core$output$OutputTabTerm).getResource(ICON_RESOURCE));
            ((ModeImpl)mode).addIgnoredNameClass(((Object)((Object)this)).getClass());
        }
        if ((tcMode = realWorkspace.findMode((TopComponent)this)) == null) {
            mode.dockInto((TopComponent)this);
        }
        super.open(workspace);
    }

    public void setCompilationFinished() {
        this.output.setCompilationFinished();
    }

    static String getCompilerName() {
        if (compiler_name == null) {
            try {
                compiler_name = NbBundle.getBundle((String)"org.netbeans.core.compiler.Bundle").getString("CTL_CompileTab");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return compiler_name;
    }

    public void selectedNodesChanged(SelectedNodesChangedEvent ev) {
    }

    public void topComponentClosed(TopComponentChangedEvent ev) {
        if (ev.topComponent == this && !this.hideOnly) {
            this.output.doClear();
            this.error.doClear();
        }
        this.hideOnly = false;
    }

    public void topComponentOpened(TopComponentChangedEvent ev) {
    }

    public void topComponentActivated(TopComponentChangedEvent ev) {
    }

    private static OutputSettings outputSettings() {
        return (OutputSettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$output$OutputSettings == null ? (class$org$netbeans$core$output$OutputSettings = OutputTabTerm.class$("org.netbeans.core.output.OutputSettings")) : class$org$netbeans$core$output$OutputSettings), (boolean)true);
    }

    private static void updateKeyStrokeSet() {
        keyStrokeSet.clear();
        keyStrokeSet.addAll(Arrays.asList(((Keymap)Lookup.getDefault().lookup(class$javax$swing$text$Keymap == null ? (class$javax$swing$text$Keymap = OutputTabTerm.class$("javax.swing.text.Keymap")) : class$javax$swing$text$Keymap)).getBoundKeyStrokes()));
        int ks = 65;
        while (ks <= 90) {
            keyStrokeSet.add(KeyStroke.getKeyStroke(ks, 8));
            ++ks;
        }
        KeyStroke ks1 = KeyStroke.getKeyStroke(new Character('\u0014'), 3);
        KeyStroke ks2 = KeyStroke.getKeyStroke(new Character('\u0014'), 2);
        keyStrokeSet2 = (HashSet)keyStrokeSet.clone();
        keyStrokeSet2.add(ks1);
        keyStrokeSet2.add(ks2);
    }

    private static HashSet getCommonKeyStrokeSet() {
        if (keyStrokeSet != null) {
            return keyStrokeSet;
        }
        keyStrokeSet = new HashSet();
        Keymap map = (Keymap)Lookup.getDefault().lookup(class$javax$swing$text$Keymap == null ? (class$javax$swing$text$Keymap = OutputTabTerm.class$("javax.swing.text.Keymap")) : class$javax$swing$text$Keymap);
        if (map instanceof Observable) {
            Observable o = (Observable)((Object)map);
            o.addObserver(new Observer(){

                public void update(Observable o, Object arg) {
                    OutputTabTerm.updateKeyStrokeSet();
                }
            });
        }
        OutputTabTerm.updateKeyStrokeSet();
        return keyStrokeSet;
    }

    private static HashSet getCommonKeyStrokeSet2() {
        OutputTabTerm.getCommonKeyStrokeSet();
        return keyStrokeSet2;
    }

    private static void invokeLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        compiler_name = null;
        keyStrokeSet = null;
        keyStrokeSet2 = null;
    }

    public static final class OutTermPane
    extends JPanel
    implements ActionPerformer,
    ActionListener,
    PropertyChangeListener,
    Runnable {
        static final long serialVersionUID = -633812012958420549L;
        private static final String REDIR_EXT = ".out";
        TermOutputWriter writer;
        OutputTabTerm tab;
        private static CopyAction copy = (CopyAction)SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = OutTermPane.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction));
        private static FindAction find = (FindAction)SystemAction.get((Class)(class$org$openide$actions$FindAction == null ? (class$org$openide$actions$FindAction = OutTermPane.class$("org.openide.actions.FindAction")) : class$org$openide$actions$FindAction));
        private static CutAction cut = (CutAction)SharedClassObject.findObject((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = OutTermPane.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction), (boolean)true);
        private static DeleteAction delete = (DeleteAction)SharedClassObject.findObject((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = OutTermPane.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction), (boolean)true);
        private static PasteAction paste = (PasteAction)SharedClassObject.findObject((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = OutTermPane.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction), (boolean)true);
        private static NextOutJumpAction nextAction = (NextOutJumpAction)SystemAction.get((Class)(class$org$netbeans$core$output$NextOutJumpAction == null ? (class$org$netbeans$core$output$NextOutJumpAction = OutTermPane.class$("org.netbeans.core.output.NextOutJumpAction")) : class$org$netbeans$core$output$NextOutJumpAction));
        private static PreviousOutJumpAction previousAction = (PreviousOutJumpAction)SystemAction.get((Class)(class$org$netbeans$core$output$PreviousOutJumpAction == null ? (class$org$netbeans$core$output$PreviousOutJumpAction = OutTermPane.class$("org.netbeans.core.output.PreviousOutJumpAction")) : class$org$netbeans$core$output$PreviousOutJumpAction));
        private JumpActionPerformer jumpPerformer = new JumpActionPerformer();
        private ActionPerformer copyActionPerformer = null;
        CallbackSystemAction csa;
        private HashMap listeners = new HashMap();
        JPopupMenu jPopup;
        private JMenuItem selectAllItem;
        private JMenuItem findNextItem;
        private JMenuItem clearItem;
        private JMenuItem redirItem;
        private TermListener listener;
        private TermInputListener input_listener;
        ActiveTerm term;
        private boolean redirection = false;
        private int tabSize;
        private static MessageFormat formatOfException;
        private ActiveRegion currentHyperlink = null;
        private ActiveRegion activeHyperlink = null;
        private boolean next_wrap_warned = false;
        private boolean prev_wrap_warned = false;
        private boolean linkOnStart = false;
        private boolean hyperlinkNavigationEnabled = false;
        private ArrayList runnables = new ArrayList();
        private boolean runningRunnables;
        private Object syncObject = new Object();
        static /* synthetic */ Class class$org$openide$actions$CopyAction;
        static /* synthetic */ Class class$org$openide$actions$FindAction;
        static /* synthetic */ Class class$org$openide$actions$CutAction;
        static /* synthetic */ Class class$org$openide$actions$DeleteAction;
        static /* synthetic */ Class class$org$openide$actions$PasteAction;
        static /* synthetic */ Class class$org$netbeans$core$output$NextOutJumpAction;
        static /* synthetic */ Class class$org$netbeans$core$output$PreviousOutJumpAction;
        static /* synthetic */ Class class$org$netbeans$core$output$OutputTabTerm$OutTermPane;
        static /* synthetic */ Class class$org$netbeans$core$output$OutputTabTerm;
        static /* synthetic */ Class class$java$awt$datatransfer$Clipboard;
        static /* synthetic */ Class class$org$openide$cookies$EditorCookie;
        static /* synthetic */ Class class$org$netbeans$core$output$OutputSettings;

        public OutTermPane() {
            this((OutputTabTerm)null);
        }

        public OutTermPane(OutputTabTerm tab) {
            this.tab = tab;
            this.listener = new TermListener(this){
                private final /* synthetic */ OutTermPane this$0;
                {
                    this.this$0 = this$0;
                }

                public void sizeChanged(Dimension cells, Dimension pixels) {
                }
            };
            this.term = new ActiveTerm();
            this.updateNextPrevActions();
            OutTermPane.outputSettings().addPropertyChangeListener(this);
            this.term.addListener(this.listener);
            this.setReadWrite(false);
            this.term.setHistorySize(OutTermPane.outputSettings().getHistorySize());
            this.term.pushStream((TermStream)new LineDiscipline());
            if (tab != null) {
                this.input_listener = new TIListener(tab);
                this.term.addInputListener(this.input_listener);
            }
            this.term.setClickToType(true);
            this.term.setAutoCopy(false);
            this.term.setScrollOnOutput(false);
            if (tab != null) {
                this.term.getAccessibleContext().setAccessibleName(((Component)((Object)tab)).getName());
            }
            this.writer = new TermOutputWriter(this.term);
            this.term.setWordDelineator(new WordDelineator(this){
                private final /* synthetic */ OutTermPane this$0;
                {
                    this.this$0 = this$0;
                }

                public int charClass(char c) {
                    if (Character.isJavaIdentifierPart(c)) {
                        return 1;
                    }
                    return 0;
                }
            });
            this.setLayout(new BorderLayout());
            this.add((Component)this.term);
            this.jPopup = SystemAction.createPopupMenu((SystemAction[])new SystemAction[]{copy, find});
            this.redirection = tab == null ? false : OutTermPane.outputSettings().isRedirection();
            this.findNextItem = new JMenuItem(NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputTabTerm$OutTermPane == null ? (class$org$netbeans$core$output$OutputTabTerm$OutTermPane = OutTermPane.class$("org.netbeans.core.output.OutputTabTerm$OutTermPane")) : class$org$netbeans$core$output$OutputTabTerm$OutTermPane)).getString("CTL_FindNext"));
            this.findNextItem.addActionListener(this);
            this.findNextItem.setAccelerator(KeyStroke.getKeyStroke(114, 0));
            this.jPopup.add(this.findNextItem);
            this.selectAllItem = new JMenuItem(NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputTabTerm$OutTermPane == null ? (class$org$netbeans$core$output$OutputTabTerm$OutTermPane = OutTermPane.class$("org.netbeans.core.output.OutputTabTerm$OutTermPane")) : class$org$netbeans$core$output$OutputTabTerm$OutTermPane)).getString("CTL_SelectAll"));
            this.selectAllItem.addActionListener(this);
            this.selectAllItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
            this.jPopup.add(this.selectAllItem);
            this.jPopup.addSeparator();
            this.clearItem = new JMenuItem(NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputTabTerm$OutTermPane == null ? (class$org$netbeans$core$output$OutputTabTerm$OutTermPane = OutTermPane.class$("org.netbeans.core.output.OutputTabTerm$OutTermPane")) : class$org$netbeans$core$output$OutputTabTerm$OutTermPane)).getString("CTL_Clear"));
            this.clearItem.addActionListener(this);
            this.jPopup.add(this.clearItem);
            this.redirItem = new JMenuItem();
            this.redirItem.addActionListener(this);
            this.redirItem.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputTabTerm == null ? (class$org$netbeans$core$output$OutputTabTerm = OutTermPane.class$("org.netbeans.core.output.OutputTabTerm")) : class$org$netbeans$core$output$OutputTabTerm)).getString("HINT_Redirect_Tab"));
            if (tab != null) {
                this.checkRedirItem();
                this.jPopup.addSeparator();
                this.jPopup.add(this.redirItem);
            }
            this.term.setActionListener(new ActiveTermListener(this){
                private final /* synthetic */ OutTermPane this$0;
                {
                    this.this$0 = this$0;
                }

                public void action(ActiveRegion r, InputEvent e) {
                    if (r.end.equals(new Coord())) {
                        return;
                    }
                    if (e instanceof MouseEvent) {
                        MouseEvent me = (MouseEvent)e;
                        if (r.parent() != this.this$0.term.regionManager().root()) {
                            r = r.parent();
                        }
                        OutTermPane.access$600(this.this$0, r);
                        OutTermPane.access$700(this.this$0, true);
                    }
                }
            });
            this.term.setKeyStrokeSet(OutputTabTerm.getCommonKeyStrokeSet());
            this.term.getCanvas().addMouseListener((MouseListener)new MouseUtils.PopupMouseAdapter(this){
                private final /* synthetic */ OutTermPane this$0;
                {
                    this.this$0 = this$0;
                }

                public void showPopup(MouseEvent mevt) {
                    this.this$0.jPopup.show((Component)this.this$0.term, mevt.getX(), mevt.getY());
                }
            });
            this.term.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ OutTermPane this$0;
                {
                    this.this$0 = this$0;
                }

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("selectionExtent".equals(evt.getPropertyName())) {
                        OutTermPane.access$900(this.this$0);
                    }
                }
            });
            this.term.getCanvas().addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ OutTermPane this$0;
                {
                    this.this$0 = this$0;
                }

                public void keyPressed(KeyEvent e) {
                    Object jump = null;
                    switch (e.getKeyCode()) {
                        case 10: 
                        case 32: {
                            e.consume();
                            OutTermPane.access$700(this.this$0, true);
                            break;
                        }
                        case 84: {
                            if (e.getModifiers() == 3) {
                                OutTermPane.access$1000(this.this$0);
                                e.consume();
                                break;
                            }
                            if (e.getModifiers() != 2) break;
                            OutTermPane.access$1102(this.this$0, false);
                            OutTermPane.access$1200(this.this$0);
                            e.consume();
                            break;
                        }
                        case 65: {
                            if (e.getModifiers() != 2) break;
                            OutTermPane.access$1300(this.this$0);
                            break;
                        }
                        case 114: {
                            if (e.getModifiers() != 0) break;
                            OutTermPane.access$1400(this.this$0);
                        }
                    }
                }
            });
            this.setSettings();
        }

        public Term getTerm() {
            return this.term;
        }

        public OutputWriter getOut() {
            return this.writer;
        }

        void updateNextPrevActions() {
            if (this.firstHyperlink() != null) {
                nextAction.setActionPerformer(this.jumpPerformer);
                previousAction.setActionPerformer(this.jumpPerformer);
            } else {
                nextAction.setActionPerformer(null);
                previousAction.setActionPerformer(null);
            }
        }

        private boolean updateCopyCutAction() {
            boolean ret;
            cut.setActionPerformer(null);
            delete.setActionPerformer(null);
            find.setActionPerformer(new ActionPerformer(this){
                private final /* synthetic */ OutTermPane this$0;
                {
                    this.this$0 = this$0;
                }

                public void performAction(SystemAction action) {
                    OutputTabTerm.access$1700(new Runnable(this){
                        private final /* synthetic */ 10 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            String pattern;
                            FindDialogPanel findDialog = FindDialogPanel.showFindDialog();
                            if (findDialog.isAccepted() && (pattern = FindDialogPanel.getPattern()) != null && pattern.length() > 0) {
                                OutTermPane.access$1600(10.access$1500(this.this$1), pattern, !FindDialogPanel.isBackwardSearch(), FindDialogPanel.isMatchCase(), FindDialogPanel.isWholeWordsOnly());
                            }
                        }
                    });
                }

                static /* synthetic */ OutTermPane access$1500(10 x0) {
                    return x0.this$0;
                }
            });
            if (this.term.getSelectedText() != null && this.term.getSelectedText().length() > 0) {
                copy.setActionPerformer(this.getCopyActionPerformer());
                ret = true;
            } else {
                copy.setActionPerformer(null);
                ret = false;
            }
            this.updatePasteAction();
            return ret;
        }

        private void findPattern(String pattern, boolean forward, boolean matchcase, boolean wholewords) {
            int lastFindRow = 0;
            int lastFindCol = 0;
            boolean doClearSel = false;
            if (this.term.getSelectionExtent() != null) {
                doClearSel = true;
                lastFindRow = this.term.getSelectionExtent().begin.row;
                lastFindCol = this.term.getSelectionExtent().begin.col;
            } else if (!forward) {
                lastFindRow = this.term.getCursorCoord().row;
                lastFindCol = this.term.getCursorCoord().col;
            }
            int row = lastFindRow;
            int found = -1;
            int n = this.term.getCursorRow();
            while (found == -1 && row <= n && row >= 0) {
                int bcol;
                int ecol;
                String s = this.term.getRowText(row);
                if (row == lastFindRow) {
                    if (forward) {
                        ecol = s.length();
                        bcol = lastFindCol + 1 < ecol ? lastFindCol + 1 : ecol;
                    } else {
                        bcol = 0;
                        ecol = lastFindCol + pattern.length() - 1 < s.length() ? lastFindCol + pattern.length() - 1 : 0;
                    }
                } else {
                    bcol = 0;
                    ecol = s.length();
                }
                if (s.length() > 0) {
                    found = this.nextIndexOf(s, bcol, ecol, pattern, forward, matchcase, wholewords);
                }
                if (found != -1) continue;
                if (forward) {
                    ++row;
                    continue;
                }
                --row;
            }
            if (found > -1) {
                Coord beginC = Coord.make((int)row, (int)found);
                Extent selExt = new Extent(beginC, Coord.make((int)row, (int)(found + pattern.length() - 1)));
                this.term.setSelectionExtent(selExt);
                this.term.possiblyNormalize(beginC);
                this.findNextItem.setEnabled(true);
            } else if (doClearSel) {
                this.term.clearSelection();
            }
        }

        private void findNextPattern() {
            String pattern = FindDialogPanel.getPattern();
            if (pattern != null && pattern.length() > 0) {
                this.findPattern(pattern, !FindDialogPanel.isBackwardSearch(), FindDialogPanel.isMatchCase(), FindDialogPanel.isWholeWordsOnly());
            }
        }

        private int nextIndexOf(String line, int bcol, int ecol, String pattern, boolean forward, boolean matchcase, boolean wholewords) {
            int found = -1;
            if (!matchcase) {
                pattern = pattern.toLowerCase();
                line = line.toLowerCase();
            }
            int len = pattern.length();
            while (found == -1 && bcol < ecol) {
                found = forward ? line.substring(bcol, ecol).indexOf(pattern) : line.substring(bcol, ecol).lastIndexOf(pattern);
                if (found <= -1) break;
                if (!wholewords || ((found += bcol) <= 0 || !Character.isUnicodeIdentifierPart(line.charAt(found - 1))) && (found + len >= line.length() || !Character.isUnicodeIdentifierPart(line.charAt(found + len)))) continue;
                if (forward) {
                    bcol = found + len;
                } else {
                    ecol = found;
                }
                found = -1;
            }
            return found;
        }

        private void updatePasteAction() {
            if (this.term.isReadOnly()) {
                paste.setPasteTypes(null);
                return;
            }
            Clipboard clipboard = OutTermPane.getClipboard();
            Transferable contents = clipboard.getContents(this);
            if (contents == null) {
                paste.setPasteTypes(null);
                return;
            }
            if (!contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                paste.setPasteTypes(null);
                return;
            }
            paste.setPasteTypes(new PasteType[]{new PasteType(this){
                private final /* synthetic */ OutTermPane this$0;
                {
                    this.this$0 = this$0;
                }

                public Transferable paste() throws IOException {
                    this.this$0.term.paste();
                    return null;
                }
            }});
        }

        private ActionPerformer getCopyActionPerformer() {
            if (this.copyActionPerformer == null) {
                this.copyActionPerformer = new CopyActionPerformer(this.term);
            }
            return this.copyActionPerformer;
        }

        private static Clipboard getClipboard() {
            Clipboard c = (Clipboard)Lookup.getDefault().lookup(class$java$awt$datatransfer$Clipboard == null ? (class$java$awt$datatransfer$Clipboard = OutTermPane.class$("java.awt.datatransfer.Clipboard")) : class$java$awt$datatransfer$Clipboard);
            if (c == null) {
                c = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            return c;
        }

        private void activateHyperlink(boolean doAction) {
            if (this.currentHyperlink != null) {
                int r;
                int erow;
                int brow;
                this.invokeJumpListener(this.currentHyperlink.begin, doAction);
                if (this.activeHyperlink != null) {
                    brow = this.activeHyperlink.begin.row;
                    erow = this.activeHyperlink.end.row;
                    r = brow;
                    while (r <= erow) {
                        this.term.setRowGlyph(r, 0, 0);
                        ++r;
                    }
                }
                this.activeHyperlink = this.currentHyperlink;
                if (this.activeHyperlink != null) {
                    brow = this.activeHyperlink.begin.row;
                    erow = this.activeHyperlink.end.row;
                    r = brow;
                    while (r <= erow) {
                        this.term.setRowGlyph(r, 0, 59);
                        ++r;
                    }
                    this.term.flush();
                }
            }
        }

        private ActiveRegion firstHyperlink() {
            ActiveRegion ar = this.term.regionManager().root();
            if (ar != null) {
                ar = ar.firstChild();
            }
            return ar;
        }

        private ActiveRegion lastHyperlink() {
            ActiveRegion ar = this.term.regionManager().root();
            if (ar != null) {
                ar = ar.lastChild();
            }
            return ar;
        }

        private boolean nextHyperlink() {
            return this.nextHyperlink(false);
        }

        private boolean nextHyperlink(boolean forAction) {
            ActiveRegion ar = this.currentHyperlink;
            if (ar == null) {
                ar = this.firstHyperlink();
            } else if (forAction && this.linkOnStart) {
                ar = this.firstHyperlink();
            } else {
                this.prev_wrap_warned = false;
                if ((ar = ar.getNextSibling()) == null) {
                    if (this.next_wrap_warned) {
                        this.next_wrap_warned = false;
                        ar = this.firstHyperlink();
                    } else {
                        String msg = NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputTabTerm == null ? (class$org$netbeans$core$output$OutputTabTerm = OutTermPane.class$("org.netbeans.core.output.OutputTabTerm")) : class$org$netbeans$core$output$OutputTabTerm)).getString("MSG_AtLastError");
                        StatusDisplayer.getDefault().setStatusText(msg);
                        this.next_wrap_warned = true;
                        return false;
                    }
                }
            }
            this.gotoHyperlink(ar);
            return true;
        }

        private boolean prevHyperlink() {
            ActiveRegion ar = this.currentHyperlink;
            if (ar == null) {
                ar = this.lastHyperlink();
            } else {
                this.next_wrap_warned = false;
                if ((ar = ar.getPreviousSibling()) == null) {
                    if (this.prev_wrap_warned) {
                        this.prev_wrap_warned = false;
                        ar = this.lastHyperlink();
                    } else {
                        String msg = NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputTabTerm == null ? (class$org$netbeans$core$output$OutputTabTerm = OutTermPane.class$("org.netbeans.core.output.OutputTabTerm")) : class$org$netbeans$core$output$OutputTabTerm)).getString("MSG_AtFirstError");
                        StatusDisplayer.getDefault().setStatusText(msg);
                        this.prev_wrap_warned = true;
                        return false;
                    }
                }
            }
            this.gotoHyperlink(ar);
            return true;
        }

        private void gotoHyperlink(ActiveRegion ar) {
            if (ar == null) {
                return;
            }
            ActiveRegion link = ar.firstChild();
            if (link == null) {
                link = ar;
            }
            this.currentHyperlink = ar;
            this.term.setSelectionExtent(link.getExtent());
            this.term.possiblyNormalize(ar);
        }

        private void invokeJumpListener(Coord index, boolean doAction) {
            OutputListener olistener = (OutputListener)this.listeners.get(index);
            String str = this.term.textWithin(this.currentHyperlink.begin, this.currentHyperlink.end);
            this.linkOnStart = false;
            if (olistener != null) {
                if (doAction) {
                    olistener.outputLineAction((OutputEvent)new OutputEventImpl(InputOutput.NULL, str));
                } else {
                    olistener.outputLineSelected((OutputEvent)new OutputEventImpl(InputOutput.NULL, str));
                }
            } else if (doAction) {
                this.parseException(str, true);
            }
        }

        public void activated() {
            this.updateCopyCutAction();
            if (this.csa == null) {
                try {
                    Class<?> popup = Class.forName("org.openide.actions.PopupAction");
                    this.csa = (CallbackSystemAction)SystemAction.get(popup);
                }
                catch (ClassNotFoundException e) {
                    NoClassDefFoundError err = new NoClassDefFoundError();
                    ErrorManager.getDefault().annotate((Throwable)err, (Throwable)e);
                    throw err;
                }
            }
            this.csa.setActionPerformer((ActionPerformer)this);
            this.findNextItem.setEnabled(FindDialogPanel.getPattern() != null);
        }

        public void deactivated() {
            if (this.csa != null && this.equals(this.csa.getActionPerformer())) {
                this.csa.setActionPerformer(null);
            }
        }

        public void focusGained(FocusEvent ev) {
        }

        public void focusLost(FocusEvent ev) {
        }

        boolean parseException(String s, boolean openEditor) {
            if ((s = s.trim()).length() <= 0) {
                return false;
            }
            try {
                if (OutTermPane.isExceptionHeuristic(s)) {
                    String path;
                    int idx = s.indexOf("at ");
                    if (idx < 0) {
                        return false;
                    }
                    s = s.substring(idx += 3);
                    Object[] o = OutTermPane.getExceptionFormat().parse(s);
                    String all = o[0].toString();
                    String file = o[1].toString();
                    String ext = o[2].toString();
                    int line = Integer.parseInt(o[3].toString());
                    int i = OutTermPane.lastIndexOfWord(all, file);
                    if (i < 0) {
                        int dotIdx = all.lastIndexOf(46);
                        dotIdx = all.lastIndexOf(46, dotIdx - 1);
                        path = all.substring(0, dotIdx + 1).replace('.', '/') + file + ".java";
                    } else {
                        path = all.substring(0, i + file.length()).replace('.', '/') + ".java";
                    }
                    FileObject fo = this.getFileObject(path);
                    if (fo == null) {
                        return false;
                    }
                    DataObject data = DataObject.find((FileObject)fo);
                    EditorCookie cookie = (EditorCookie)data.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = OutTermPane.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                    if (cookie == null) {
                        return false;
                    }
                    Line l = cookie.getLineSet().getOriginal(line - 1);
                    if (openEditor) {
                        l.show(2, 0);
                    }
                    return true;
                }
            }
            catch (ParseException e) {
            }
            catch (NumberFormatException e) {
            }
            catch (DataObjectNotFoundException e) {
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            return false;
        }

        private FileObject getFileObject(String path) {
            Enumeration en = Repository.getDefault().getFileSystems();
            while (en.hasMoreElements()) {
                FileObject fo;
                FileSystem fs = (FileSystem)en.nextElement();
                if (!fs.getCapability().capableOf(FileSystemCapability.EXECUTE) || (fo = fs.findResource(path)) == null) continue;
                return fo;
            }
            return Repository.getDefault().findResource(path);
        }

        private static int lastIndexOfWord(String all, String sub) {
            int ret = all.lastIndexOf(sub);
            int len = sub.length();
            if (ret > 0 && Character.isJavaIdentifierPart(all.charAt(ret - 1)) || ret + len < all.length() && Character.isJavaIdentifierPart(all.charAt(ret + len))) {
                ret = all.substring(0, ret).lastIndexOf(sub);
            }
            return ret;
        }

        static boolean isExceptionHeuristic(String s) {
            return OutTermPane.startsOK(s = s.trim()) && s.charAt(s.length() - 1) == ')';
        }

        private static boolean startsOK(String s) {
            return s.startsWith("at ") || s.startsWith("[catch] at ");
        }

        static MessageFormat getExceptionFormat() {
            if (formatOfException == null) {
                formatOfException = new MessageFormat("{0}({1}.{2}:{3})");
            }
            return formatOfException;
        }

        public void performAction(SystemAction action) {
            if (!(action instanceof PopupAction)) {
                return;
            }
            Mutex.EVENT.readAccess(new Runnable(this){
                private final /* synthetic */ OutTermPane this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    Coord xy = null;
                    if (!this.this$0.term.isReadOnly() && this.this$0.term.isCoordVisible(this.this$0.term.getCursorCoord())) {
                        xy = this.this$0.term.getCursorCoord();
                    } else if (this.this$0.term.getSelectionExtent() != null) {
                        if (this.this$0.term.isCoordVisible(this.this$0.term.getSelectionExtent().begin)) {
                            xy = this.this$0.term.getSelectionExtent().begin;
                        } else if (this.this$0.term.isCoordVisible(this.this$0.term.getSelectionExtent().end)) {
                            xy = this.this$0.term.getSelectionExtent().end;
                        }
                    }
                    if (xy == null && OutTermPane.access$4800(this.this$0) != null) {
                        if (this.this$0.term.isCoordVisible(OutTermPane.access$4800((OutTermPane)this.this$0).begin)) {
                            xy = OutTermPane.access$4800((OutTermPane)this.this$0).begin;
                        } else if (this.this$0.term.isCoordVisible(OutTermPane.access$4800((OutTermPane)this.this$0).end)) {
                            xy = OutTermPane.access$4800((OutTermPane)this.this$0).end;
                        }
                    }
                    Point p = null;
                    p = xy == null ? new Point(0, 0) : this.this$0.term.toPixel(xy);
                    if (p == null) {
                        return;
                    }
                    this.this$0.jPopup.show((Component)this.this$0.term, p.x, p.y);
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.selectAllItem) {
                this.selectAll();
            } else if (actionEvent.getSource() == this.findNextItem) {
                this.findNextPattern();
            } else if (actionEvent.getSource() == this.clearItem) {
                this.doClear();
            } else if (actionEvent.getSource() == this.redirItem) {
                this.redirection = !this.redirection;
                this.checkRedirItem();
            }
        }

        void doClear() {
            this.term.clearHistory();
            this.term.clear();
            this.setHyperlinkNavigationEnabled(false);
            Iterator it = this.listeners.values().iterator();
            while (it.hasNext()) {
                OutputListener oli = (OutputListener)it.next();
                oli.outputLineCleared((OutputEvent)new OutputEventImpl(InputOutput.NULL, null));
            }
            this.listeners.clear();
            this.activeHyperlink = null;
            this.currentHyperlink = null;
            this.updateNextPrevActions();
            if (this.tab != null && ((Object)((Object)this.tab)).equals((Object)compiler)) {
                compilerPrinted = false;
            }
        }

        private static OutputSettings outputSettings() {
            return (OutputSettings)SharedClassObject.findObject((Class)(class$org$netbeans$core$output$OutputSettings == null ? (class$org$netbeans$core$output$OutputSettings = OutTermPane.class$("org.netbeans.core.output.OutputSettings")) : class$org$netbeans$core$output$OutputSettings), (boolean)true);
        }

        private void setHyperlinkNavigationEnabled(boolean hlne) {
            if (this.hyperlinkNavigationEnabled == hlne) {
                return;
            }
            this.hyperlinkNavigationEnabled = hlne;
            if (hlne) {
                this.term.setScrollOnInput(false);
                this.term.setKeyStrokeSet(OutputTabTerm.getCommonKeyStrokeSet2());
            } else {
                this.term.setScrollOnInput(true);
                this.term.setKeyStrokeSet(OutputTabTerm.getCommonKeyStrokeSet());
            }
        }

        private void checkRedirItem() {
            if (this.tab == null) {
                return;
            }
            if (!this.redirection && this.writer != null) {
                this.writer.redirClose();
            }
            if (this.redirItem == null) {
                return;
            }
            if (this.redirection) {
                this.redirItem.setText(NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputTabTerm == null ? (class$org$netbeans$core$output$OutputTabTerm = OutTermPane.class$("org.netbeans.core.output.OutputTabTerm")) : class$org$netbeans$core$output$OutputTabTerm)).getString("CTL_Redirect_Off"));
            } else {
                this.redirItem.setText(NbBundle.getBundle((Class)(class$org$netbeans$core$output$OutputTabTerm == null ? (class$org$netbeans$core$output$OutputTabTerm = OutTermPane.class$("org.netbeans.core.output.OutputTabTerm")) : class$org$netbeans$core$output$OutputTabTerm)).getString("CTL_Redirect_On"));
            }
        }

        private void checkFont() {
            Font font = this.term.getFont();
            if (font != null && font.isPlain() && font.getSize() == OutTermPane.outputSettings().getFontSize()) {
                return;
            }
            Font nf = new Font("monospaced", 0, OutTermPane.outputSettings().getFontSize());
            this.term.setFont(nf);
        }

        private void setSettings() {
            this.checkFont();
            this.term.setForeground(OutTermPane.outputSettings().getBaseForeground());
            this.term.setBackground(OutTermPane.outputSettings().getBaseBackground());
            this.term.setCustomColor(1, OutTermPane.outputSettings().getJumpCursorBackground());
            this.term.setHistorySize(OutTermPane.outputSettings().getHistorySize());
            this.tabSize = OutTermPane.outputSettings().getTabSize();
            this.term.setTabSize(this.tabSize);
            this.term.setCustomColor(0, OutTermPane.outputSettings().getJumpLinkForeground());
            this.term.setHighlightColor(OutTermPane.outputSettings().getSelectionBackground());
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("redirection".equals(evt.getPropertyName())) {
                if (this.tab != null) {
                    this.redirection = (Boolean)evt.getNewValue();
                    this.checkRedirItem();
                }
            } else if ("directory".equals(evt.getPropertyName())) {
                if (this.tab != null && this.redirection && this.writer != null) {
                    this.writer.redirClose();
                    this.writer.redirOpen();
                }
            } else {
                this.setSettings();
            }
        }

        private void selectAll() {
            Extent allExt = new Extent(Coord.make((int)0, (int)0), this.term.getCursorCoord());
            this.term.setSelectionExtent(allExt);
        }

        private void ensureOpen() {
            if (this.tab != null) {
                this.tab.ensureOpen();
                if (((Object)((Object)this.tab)).equals((Object)compiler) && !compilerPrinted) {
                    this.tab.requestVisible();
                    compilerPrinted = true;
                }
            }
        }

        private void invokeNow(Runnable runnable) {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                Object object = this.syncObject;
                synchronized (object) {
                    if (this.runningRunnables) {
                        try {
                            this.syncObject.wait(500L);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                    }
                    this.runnables.add(runnable);
                    if (this.runnables.size() > 50) {
                        try {
                            this.syncObject.wait(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.runnables.size() == 1) {
                        SwingUtilities.invokeLater(this);
                    }
                }
            }
        }

        public void run() {
            ArrayList torun;
            Object object = this.syncObject;
            synchronized (object) {
                this.runningRunnables = true;
                torun = (ArrayList)this.runnables.clone();
                this.runnables = new ArrayList();
            }
            Iterator it = ((AbstractList)torun).iterator();
            while (it.hasNext()) {
                ((Runnable)it.next()).run();
            }
            Object object2 = this.syncObject;
            synchronized (object2) {
                this.runningRunnables = false;
                this.syncObject.notifyAll();
            }
        }

        private int getLinkAttr() {
            return 50;
        }

        void setCompilationFinished() {
            this.nextHyperlink();
            this.linkOnStart = true;
            this.updateNextPrevActions();
        }

        public void requestFocus() {
            super.requestFocus();
            this.term.requestFocus();
        }

        void setReadWrite(boolean rw) {
            this.term.setCursorVisible(rw);
            this.term.setReadOnly(!rw);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ void access$600(OutTermPane x0, ActiveRegion x1) {
            x0.gotoHyperlink(x1);
        }

        static /* synthetic */ void access$700(OutTermPane x0, boolean x1) {
            x0.activateHyperlink(x1);
        }

        static /* synthetic */ boolean access$900(OutTermPane x0) {
            return x0.updateCopyCutAction();
        }

        static /* synthetic */ boolean access$1000(OutTermPane x0) {
            return x0.prevHyperlink();
        }

        static /* synthetic */ boolean access$1102(OutTermPane x0, boolean x1) {
            x0.linkOnStart = x1;
            return x0.linkOnStart;
        }

        static /* synthetic */ boolean access$1200(OutTermPane x0) {
            return x0.nextHyperlink();
        }

        static /* synthetic */ void access$1300(OutTermPane x0) {
            x0.selectAll();
        }

        static /* synthetic */ void access$1400(OutTermPane x0) {
            x0.findNextPattern();
        }

        static /* synthetic */ void access$1600(OutTermPane x0, String x1, boolean x2, boolean x3, boolean x4) {
            x0.findPattern(x1, x2, x3, x4);
        }

        static /* synthetic */ boolean access$2502(OutTermPane x0, boolean x1) {
            x0.prev_wrap_warned = x1;
            return x0.prev_wrap_warned;
        }

        static /* synthetic */ boolean access$2602(OutTermPane x0, boolean x1) {
            x0.next_wrap_warned = x1;
            return x0.next_wrap_warned;
        }

        static /* synthetic */ boolean access$4600(OutTermPane x0, boolean x1) {
            return x0.nextHyperlink(x1);
        }

        static /* synthetic */ void access$4700(OutTermPane x0, Coord x1, boolean x2) {
            x0.invokeJumpListener(x1, x2);
        }

        static /* synthetic */ ActiveRegion access$4800(OutTermPane x0) {
            return x0.currentHyperlink;
        }

        private class TIListener
        implements TermInputListener {
            private OutputTabTerm tab;

            public TIListener(OutputTabTerm tab) {
                this.tab = tab;
            }

            public void sendChar(char c) {
                try {
                    this.tab.inWriter.write(c);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void sendChars(char[] c, int offset, int n) {
                try {
                    this.tab.inWriter.write(c, offset, n);
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
        }

        class CopyActionPerformer
        implements ActionPerformer {
            ActiveTerm at;

            public CopyActionPerformer(ActiveTerm at) {
                this.at = at;
            }

            public void performAction(SystemAction action) {
                OutputTabTerm.invokeLater(new Runnable(this){
                    private final /* synthetic */ CopyActionPerformer this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        this.this$1.at.copy();
                    }
                });
            }
        }

        final class JumpActionPerformer
        implements ActionPerformer {
            JumpActionPerformer() {
            }

            public void performAction(SystemAction action) {
                OutputTabTerm.invokeLater(new Runnable(this, action){
                    private final /* synthetic */ SystemAction val$action;
                    private final /* synthetic */ JumpActionPerformer this$1;
                    {
                        this.this$1 = this$1;
                        this.val$action = val$action;
                    }

                    public void run() {
                        Coord jump = null;
                        if (this.val$action instanceof NextOutJumpAction && OutTermPane.access$4600(JumpActionPerformer.access$4500(this.this$1), true)) {
                            OutTermPane.access$700(JumpActionPerformer.access$4500(this.this$1), true);
                        }
                        if (this.val$action instanceof PreviousOutJumpAction && OutTermPane.access$1000(JumpActionPerformer.access$4500(this.this$1))) {
                            OutTermPane.access$700(JumpActionPerformer.access$4500(this.this$1), true);
                        }
                        if (jump != null) {
                            OutTermPane.access$4700(JumpActionPerformer.access$4500(this.this$1), jump, true);
                        }
                        JumpActionPerformer.access$4500(this.this$1).updateNextPrevActions();
                    }
                });
            }

            static /* synthetic */ OutTermPane access$4500(JumpActionPerformer x0) {
                return x0.OutTermPane.this;
            }
        }

        class TermOutputWriter
        extends OutputWriter {
            private int lastParsedRow = -1;
            ActiveTerm aterm = null;
            boolean timerSet = false;
            Boolean timerMode = null;
            boolean redirOpened = false;
            FileWriter redirWriter = null;
            private ActiveRegion region = null;
            private State state = State.init;
            private StringBuffer line_buf = new StringBuffer();

            TermOutputWriter(ActiveTerm term) {
                super((Writer)new OutputStreamWriter((OutputStream)new NullOutputStream()));
                this.aterm = term;
                this.setPageMode(false);
                this.aterm.setRefreshEnabled(false);
                if (OutTermPane.this.tab != null) {
                    OutTermPane.this.redirection = OutTermPane.outputSettings().isRedirection();
                }
                OutTermPane.this.checkRedirItem();
                if (OutTermPane.this.redirection) {
                    this.redirOpen();
                }
            }

            public void reset() throws IOException {
                OutTermPane.this.invokeNow(new Runnable(this){
                    private final /* synthetic */ TermOutputWriter this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        TermOutputWriter.access$2100(this.this$1).doClear();
                        this.this$1.aterm.setRefreshEnabled(false);
                        TermOutputWriter.access$2202(this.this$1, -1);
                        TermOutputWriter.access$2300(this.this$1);
                        TermOutputWriter.access$2402(this.this$1, State.init);
                        OutTermPane.access$2502(TermOutputWriter.access$2100(this.this$1), false);
                        OutTermPane.access$2602(TermOutputWriter.access$2100(this.this$1), false);
                    }
                });
            }

            public void println(String str, OutputListener outputListener) throws IOException {
                String strCopy = new String(str);
                OutTermPane.this.ensureOpen();
                OutTermPane.this.invokeNow(new Runnable(this, outputListener, strCopy){
                    private final /* synthetic */ OutputListener val$outputListener;
                    private final /* synthetic */ String val$strCopy;
                    private final /* synthetic */ TermOutputWriter this$1;
                    {
                        this.this$1 = this$1;
                        this.val$outputListener = val$outputListener;
                        this.val$strCopy = val$strCopy;
                    }

                    public void run() {
                        TermOutputWriter.access$2900(this.this$1);
                        if (this.val$outputListener != null) {
                            if (TermOutputWriter.access$3000(this.this$1, this.val$outputListener)) {
                                if (TermOutputWriter.access$3100(this.this$1, this.val$outputListener)) {
                                    TermOutputWriter.access$3200(this.this$1, this.val$strCopy);
                                    TermOutputWriter.access$3400(this.this$1, TermOutputWriter.access$3300(this.this$1), this.val$outputListener);
                                } else {
                                    TermOutputWriter.access$3500(this.this$1, this.val$strCopy);
                                }
                            } else {
                                TermOutputWriter.access$3600(this.this$1, this.val$strCopy, true);
                                TermOutputWriter.access$3400(this.this$1, TermOutputWriter.access$3300(this.this$1), this.val$outputListener);
                            }
                        } else {
                            TermOutputWriter.access$3700(this.this$1, this.val$strCopy, false);
                        }
                        TermOutputWriter.access$3800(this.this$1);
                    }
                });
            }

            public void println() {
                OutTermPane.this.ensureOpen();
                OutTermPane.this.invokeNow(new Runnable(this){
                    private final /* synthetic */ TermOutputWriter this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        TermOutputWriter.access$3800(this.this$1);
                    }
                });
            }

            public void write(char[] cbuf, int off, int len) {
                OutTermPane.this.ensureOpen();
                char[] cbufCopy = new char[cbuf.length];
                System.arraycopy(cbuf, 0, cbufCopy, 0, cbuf.length);
                OutTermPane.this.invokeNow(new Runnable(this, cbufCopy, off, len){
                    private final /* synthetic */ char[] val$cbufCopy;
                    private final /* synthetic */ int val$off;
                    private final /* synthetic */ int val$len;
                    private final /* synthetic */ TermOutputWriter this$1;
                    {
                        this.this$1 = this$1;
                        this.val$cbufCopy = val$cbufCopy;
                        this.val$off = val$off;
                        this.val$len = val$len;
                    }

                    public void run() {
                        TermOutputWriter.access$3700(this.this$1, new String(this.val$cbufCopy, this.val$off, this.val$len), !TermOutputWriter.access$3900(this.this$1));
                    }
                });
            }

            public void write(int ch) {
                OutTermPane.this.invokeNow(new Runnable(this, ch){
                    private final /* synthetic */ int val$ch;
                    private final /* synthetic */ TermOutputWriter this$1;
                    {
                        this.this$1 = this$1;
                        this.val$ch = val$ch;
                    }

                    public void run() {
                        this.this$1.write(new char[]{(char)this.val$ch}, 0, 1);
                    }
                });
            }

            public void write(String str, int off, int len) {
                char[] chars = new char[len];
                str.getChars(off, off + len, chars, 0);
                OutTermPane.this.invokeNow(new Runnable(this, chars, len){
                    private final /* synthetic */ char[] val$chars;
                    private final /* synthetic */ int val$len;
                    private final /* synthetic */ TermOutputWriter this$1;
                    {
                        this.this$1 = this$1;
                        this.val$chars = val$chars;
                        this.val$len = val$len;
                    }

                    public void run() {
                        this.this$1.write(this.val$chars, 0, this.val$len);
                    }
                });
            }

            public void flush() {
                OutTermPane.this.invokeNow(new Runnable(this){
                    private final /* synthetic */ TermOutputWriter this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        this.this$1.aterm.flush();
                        if (this.this$1.redirWriter != null) {
                            try {
                                this.this$1.redirWriter.flush();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }

            public void close() {
                OutTermPane.this.invokeNow(new Runnable(this){
                    private final /* synthetic */ TermOutputWriter this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (this.this$1.redirOpened) {
                            TermOutputWriter.access$4000(this.this$1);
                        }
                    }
                });
            }

            private void tryParsing() {
                int row = this.aterm.getCursorRow() - 1;
                int i = this.lastParsedRow + 1;
                while (i <= row) {
                    this.linkException(i);
                    ++i;
                }
                this.lastParsedRow = row;
            }

            private void linkException(int row) {
                try {
                    if (!this.aterm.regionManager().findRegion(Coord.make((int)row, (int)0)).equals(this.aterm.regionManager().root())) {
                        return;
                    }
                    String line = this.aterm.getRowText(row);
                    if (line != null && OutTermPane.this.parseException(line, false)) {
                        Coord beginC = Coord.make((int)row, (int)this.getStartOfLink(line));
                        Coord endC = Coord.make((int)row, (int)line.length());
                        this.aterm.setCharacterAttribute(beginC, endC, OutTermPane.this.getLinkAttr(), true);
                        this.aterm.setCharacterAttribute(beginC, endC, 4, true);
                        this.resetRegion();
                        this.setPageMode(true);
                        this.region = this.aterm.regionManager().beginRegion(beginC);
                        this.region.setFeedbackEnabled(false);
                        this.region.setSelectable(false);
                        this.aterm.regionManager().endRegion(endC);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            private int getStartOfLink(String line) {
                int start = 0;
                int pos = 0;
                while (pos < line.length() && (line.charAt(pos) == ' ' || line.charAt(pos) == '\t' || line.charAt(pos) == '\n')) {
                    if (line.charAt(pos) == ' ') {
                        ++start;
                    } else if (line.charAt(pos) == '\t') {
                        start += OutTermPane.this.tabSize;
                    }
                    ++pos;
                }
                return start;
            }

            private void redirOpen() {
                File redirFile = null;
                try {
                    int ispace;
                    File redirDirFile = OutTermPane.outputSettings().getDirectory();
                    String name = "";
                    if (OutTermPane.this.tab != null && (ispace = (name = ((Component)((Object)OutTermPane.this.tab)).getName()).indexOf(32)) > 0) {
                        name = name.substring(0, ispace);
                    }
                    name = name.replace(File.separatorChar, '_');
                    name = name + OutTermPane.REDIR_EXT;
                    redirFile = new File(redirDirFile, name);
                    redirFile.createNewFile();
                    this.redirWriter = new FileWriter(redirFile.getAbsolutePath(), true);
                    this.redirOpened = true;
                }
                catch (Exception e) {
                    ErrorManager.getDefault().annotate((Throwable)e, 0, "Redir file: " + redirFile, null, null, null);
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }

            private void redirClose() {
                if (this.redirWriter != null) {
                    try {
                        this.redirWriter.close();
                        this.redirWriter = null;
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                }
            }

            private void redirPrint(char[] chars, int offs, int len) {
                if (this.redirWriter == null) {
                    this.redirOpen();
                }
                if (this.redirWriter == null) {
                    return;
                }
                try {
                    this.redirWriter.write(chars, offs, len);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }

            private void redirPrint(String str) {
                if (this.redirWriter == null) {
                    this.redirOpen();
                }
                if (this.redirWriter == null) {
                    return;
                }
                try {
                    this.redirWriter.write(str);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }

            private ActiveRegion createRegion(String str, boolean hyperlink) {
                this.beginRegion(str, hyperlink);
                return this.endRegion(null);
            }

            private ActiveRegion beginRegion(String str, boolean hyperlink) {
                this.resetRegion();
                this.setPageMode(true);
                Coord beginCoord = Coord.make((int)this.aterm.getCursorCoord().row, (int)0);
                try {
                    this.region = this.aterm.regionManager().beginRegion(beginCoord);
                }
                catch (RegionException x) {
                    return null;
                }
                this.region.setFeedbackEnabled(false);
                this.region.setSelectable(false);
                if (hyperlink) {
                    this.aterm.setAttribute(OutTermPane.this.getLinkAttr());
                    this.aterm.setAttribute(4);
                }
                if (str != null) {
                    this.appendText(str, false, false);
                }
                return this.region;
            }

            private ActiveRegion endRegion(String str) {
                this.aterm.setAttribute(0);
                if (str != null) {
                    this.appendText(str, false);
                }
                this.aterm.endRegion();
                OutTermPane.this.updateNextPrevActions();
                return this.region;
            }

            private void firstHalf(String str) {
                this.setPageMode(true);
                Coord beginCoord = Coord.make((int)this.aterm.getCursorCoord().row, (int)0);
                try {
                    this.region = this.aterm.regionManager().beginRegion(beginCoord);
                }
                catch (RegionException x) {
                    return;
                }
                this.region.setFeedbackEnabled(false);
                this.region.setSelectable(false);
                try {
                    ActiveRegion link_region = this.aterm.regionManager().beginRegion(beginCoord);
                }
                catch (RegionException x) {
                    return;
                }
                this.aterm.setAttribute(OutTermPane.this.getLinkAttr());
                this.aterm.setAttribute(4);
                this.appendText(str, false);
                this.aterm.setAttribute(0);
                this.aterm.endRegion();
            }

            private void secondHalf(String str) {
                this.appendText(str, false);
                this.aterm.endRegion();
                OutTermPane.this.updateNextPrevActions();
            }

            private boolean isTimerMode() {
                if (this.timerMode == null) {
                    String tempStr = System.getProperty("org.netbeans.core.output.OutputTabTerm.timerMode");
                    this.timerMode = tempStr != null && tempStr.equalsIgnoreCase("false") ? Boolean.FALSE : Boolean.TRUE;
                }
                return this.timerMode;
            }

            private void repaintTimer() {
                if (!this.timerSet) {
                    this.timerSet = true;
                    RequestProcessor.getDefault().post(new Runnable(this){
                        private final /* synthetic */ TermOutputWriter this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            this.this$1.flush();
                            this.this$1.timerSet = false;
                        }
                    }, 120);
                }
            }

            private void setPageMode(boolean pageMode) {
                if (this.isPageMode()) {
                    return;
                }
                this.aterm.setAnchored(pageMode);
            }

            private boolean isPageMode() {
                return this.aterm.isAnchored();
            }

            private void historySizeKeeper() {
                if (!this.isPageMode()) {
                    return;
                }
                if (this.aterm.getHistoryBuffSize() - this.aterm.getHistorySize() > 0) {
                    try {
                        this.reset();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            private boolean isHyperLink(OutputListener ol) {
                return ol.getClass().getName().indexOf("CompilerDisplayer$ErrorCtl") != -1;
            }

            private boolean isFromCompiler(OutputListener ol) {
                return ol.getClass().getName().indexOf("CompilerDisplayer") != -1;
            }

            private void resetRegion() {
                if (this.region != null) {
                    this.aterm.endRegion();
                    this.region = null;
                }
            }

            private void registerListener(ActiveRegion regRegion, OutputListener outpList) {
                if (regRegion != null && outpList != null) {
                    OutTermPane.this.listeners.put(regRegion.begin, outpList);
                }
            }

            private void printEOL() {
                this.appendText("\n", !this.isTimerMode());
            }

            private void putException(String str, boolean repaint) {
                if (str == null) {
                    return;
                }
                if (!OutTermPane.this.parseException(str, false)) {
                    this.aterm.appendText(str, repaint);
                    return;
                }
                Coord beginCoord = this.aterm.getCursorCoord();
                try {
                    ActiveRegion link_region = this.aterm.regionManager().beginRegion(beginCoord);
                    this.aterm.setAttribute(OutTermPane.this.getLinkAttr());
                    this.aterm.setAttribute(4);
                    this.aterm.appendText(str, repaint);
                    this.aterm.setAttribute(0);
                    this.aterm.endRegion();
                    OutTermPane.this.setHyperlinkNavigationEnabled(true);
                }
                catch (RegionException x) {
                    return;
                }
            }

            private void appendText(String str, boolean repaint) {
                this.appendText(str, repaint, true);
            }

            private void appendText(String str, boolean repaint, boolean checkException) {
                StringBuffer stringBuffer = this.line_buf;
                synchronized (stringBuffer) {
                    if (this.isTimerMode()) {
                        if (OutTermPane.this.redirection) {
                            this.redirPrint(str);
                        }
                        int sx = 0;
                        while (sx < str.length()) {
                            char c = str.charAt(sx);
                            if (this.state == State.init) {
                                if (c == '\n') {
                                    this.aterm.putChar(c);
                                } else if (c == ' ' || c == '\t') {
                                    this.aterm.putChar(c);
                                } else if (checkException && c == 'a') {
                                    this.line_buf.setLength(0);
                                    this.line_buf.append(c);
                                    this.state = State.collect;
                                } else {
                                    this.aterm.putChar(c);
                                    this.state = State.pass;
                                }
                            } else if (this.state == State.collect) {
                                if (c == '\n') {
                                    this.line_buf.append(c);
                                    this.putException(this.line_buf.toString(), repaint);
                                    this.state = State.init;
                                } else {
                                    this.line_buf.append(c);
                                }
                            } else if (this.state == State.pass) {
                                if (c == '\n') {
                                    this.aterm.putChar(c);
                                    this.state = State.init;
                                } else {
                                    this.aterm.putChar(c);
                                }
                            }
                            ++sx;
                        }
                        this.repaintTimer();
                        return;
                    }
                    char[] tmp = new char[str.length()];
                    str.getChars(0, str.length(), tmp, 0);
                    this.appendChars(tmp, 0, str.length(), repaint);
                    this.tryParsing();
                }
            }

            private void appendChars(char[] chars, int offs, int len, boolean repaint) {
                if (this.isTimerMode()) {
                    this.appendText(new String(chars, offs, len), repaint);
                    return;
                }
                if (OutTermPane.this.redirection) {
                    this.redirPrint(chars, offs, len);
                }
                if (!repaint && this.aterm.isRefreshEnabled()) {
                    this.aterm.setRefreshEnabled(false);
                    this.aterm.putChars(chars, offs, len);
                    this.aterm.setRefreshEnabled(true);
                } else {
                    this.aterm.putChars(chars, offs, len);
                }
            }

            static /* synthetic */ OutTermPane access$2100(TermOutputWriter x0) {
                return x0.OutTermPane.this;
            }

            static /* synthetic */ int access$2202(TermOutputWriter x0, int x1) {
                x0.lastParsedRow = x1;
                return x0.lastParsedRow;
            }

            static /* synthetic */ void access$2300(TermOutputWriter x0) {
                x0.resetRegion();
            }

            static /* synthetic */ State access$2402(TermOutputWriter x0, State x1) {
                x0.state = x1;
                return x0.state;
            }

            static /* synthetic */ void access$2900(TermOutputWriter x0) {
                x0.historySizeKeeper();
            }

            static /* synthetic */ boolean access$3000(TermOutputWriter x0, OutputListener x1) {
                return x0.isFromCompiler(x1);
            }

            static /* synthetic */ boolean access$3100(TermOutputWriter x0, OutputListener x1) {
                return x0.isHyperLink(x1);
            }

            static /* synthetic */ void access$3200(TermOutputWriter x0, String x1) {
                x0.firstHalf(x1);
            }

            static /* synthetic */ ActiveRegion access$3300(TermOutputWriter x0) {
                return x0.region;
            }

            static /* synthetic */ void access$3400(TermOutputWriter x0, ActiveRegion x1, OutputListener x2) {
                x0.registerListener(x1, x2);
            }

            static /* synthetic */ void access$3500(TermOutputWriter x0, String x1) {
                x0.secondHalf(x1);
            }

            static /* synthetic */ ActiveRegion access$3600(TermOutputWriter x0, String x1, boolean x2) {
                return x0.createRegion(x1, x2);
            }

            static /* synthetic */ void access$3700(TermOutputWriter x0, String x1, boolean x2) {
                x0.appendText(x1, x2);
            }

            static /* synthetic */ void access$3800(TermOutputWriter x0) {
                x0.printEOL();
            }

            static /* synthetic */ boolean access$3900(TermOutputWriter x0) {
                return x0.isTimerMode();
            }
        }

        private final class OutputEventImpl
        extends OutputEvent {
            private String txt;
            static final long serialVersionUID = -437312125483471519L;

            public OutputEventImpl(InputOutput src, String txt) {
                super(src);
                this.txt = txt;
            }

            public String getLine() {
                return this.txt;
            }
        }
    }

    public static class Factory
    implements OutputTabProvider {
        Factory() {
        }

        public OutputWriter getStdOut() {
            OutputTabTerm.initialize();
            return standard.getOut();
        }

        public InputOutput getIO(String name, boolean newIO) {
            OutputTabTerm.initialize();
            if (name != null && name.equals(OutputTabTerm.getCompilerName())) {
                OutputTabTerm.initializeComp();
                return compiler;
            }
            if (newIO) {
                return new OutputTabTerm(name);
            }
            InputOutput ino = (InputOutput)ioCache.get(name);
            if (ino == null) {
                ino = new OutputTabTerm(name);
            }
            return ino;
        }

        public TopComponent getStdOutputTab() {
            OutputTabTerm.initialize();
            return standard;
        }

        public TopComponent getCompOutputTab() {
            OutputTabTerm.initializeComp();
            return compiler;
        }
    }

    static class Replace
    implements Serializable {
        static final int COMPILER_INSTANCE = 1;
        boolean defaultInstance;
        int instanceType;
        private static final long serialVersionUID = -3126744916624172415L;

        public Replace(boolean defaultInstance) {
            this.defaultInstance = defaultInstance;
        }

        public void setInstanceType(int instanceType) {
            this.instanceType = instanceType;
        }

        public Object readResolve() throws ObjectStreamException {
            if (this.defaultInstance) {
                return OutputTabTerm.getFactory().getStdOutputTab();
            }
            if (this.instanceType == 1) {
                return OutputTabTerm.getFactory().getCompOutputTab();
            }
            return null;
        }
    }

    private static class State {
        private final String name;
        public static final State init = new State("init");
        public static final State collect = new State("collect");
        public static final State pass = new State("pass");

        private State(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

