/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javadoc.ExternalOptionListProducer;
import org.netbeans.modules.javadoc.NotifyJavadocGenerated;
import org.netbeans.modules.javadoc.ResourceUtils;
import org.netbeans.modules.javadoc.settings.DocumentationSettings;
import org.netbeans.modules.javadoc.settings.ExternalJavadocSettingsService;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.ExecInfo;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbClassPath;
import org.openide.execution.NbProcessDescriptor;
import org.openide.execution.ProcessExecutor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.MapFormat;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public class ExternalJavadocExecutor
extends ProcessExecutor {
    private static boolean running = false;
    private static final NbProcessDescriptor DEFAULT = new NbProcessDescriptor("{jdk.home}{/}bin{/}javadoc", " {params} -classpath {filesystems} {files}");
    private ExecutorTask javadocProcess = null;
    private static List args;
    private static String files;
    static List pckList;
    private static final String PREFIX = "javadocparams";
    private static final String SUFFIX = "pms";
    private static final long serialVersionUID = 4377377355485697603L;
    static /* synthetic */ Class class$org$netbeans$modules$javadoc$settings$ExternalJavadocSettingsService;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$netbeans$modules$java$JavaDataObject;

    public ExternalJavadocExecutor() {
        this.setExternalExecutor(DEFAULT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(Node[] activatedNodes) {
        boolean success;
        block9: {
            if (ExternalJavadocExecutor.isRunning()) {
                return;
            }
            ExternalJavadocExecutor.setRunning(true);
            LifecycleManager.getDefault().saveAll();
            files = ExternalJavadocExecutor.createLists(activatedNodes);
            if (files == null) {
                StatusDisplayer.getDefault().setStatusText(ResourceUtils.getBundledString("MSG_NoFilesInList"));
                ExternalJavadocExecutor.setRunning(false);
                return;
            }
            args = new ArrayList();
            args.addAll(ExternalOptionListProducer.getOptionList(activatedNodes));
            if (Boolean.getBoolean("netbeans.debug.javadoc")) {
                JavadocFormat jf = new JavadocFormat(ExternalJavadocExecutor.createParametersLine(), files);
                System.out.println(MapFormat.format((String)DEFAULT.getProcessName(), (Map)jf.getMap()) + " " + MapFormat.format((String)DEFAULT.getArguments(), (Map)jf.getMap()));
            }
            success = true;
            try {
                try {
                    StatusDisplayer.getDefault().setStatusText(ResourceUtils.getBundledString("MSG_GeneratingJavadoc"));
                    this.javadocProcess = this.execute(new ExecInfo(ResourceUtils.getBundledString("CTL_Javadoc_IOTab")));
                    this.setIOTab(this.javadocProcess.getInputOutput());
                    this.javadocProcess.waitFinished();
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                    success = false;
                    Object var5_5 = null;
                    ExternalJavadocExecutor.setRunning(false);
                    break block9;
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                ExternalJavadocExecutor.setRunning(false);
                throw throwable;
            }
            ExternalJavadocExecutor.setRunning(false);
        }
        if (DocumentationSettings.getDefault().getAskAfterGenerating() && success && this.javadocProcess.result() == 0) {
            NotifyJavadocGenerated.showNotifyDialog();
        }
        if (this.javadocProcess.result() != 0 || !success) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ResourceUtils.getBundledString("MSG_Error_When_Generating"), 0));
        }
        StatusDisplayer.getDefault().setStatusText(ResourceUtils.getBundledString("CTL_Javadoc_Finished"));
        this.javadocProcess = null;
    }

    public static boolean isRunning() {
        return running;
    }

    public static void setRunning(boolean run) {
        running = run;
    }

    public void stopJavadoc() {
        if (running) {
            this.javadocProcess.stop();
        }
    }

    void setIOTab(InputOutput ioTab) {
        ioTab.setErrSeparated(true);
        ioTab.setOutputVisible(true);
        ioTab.setErrVisible(true);
        ioTab.setFocusTaken(true);
        ioTab.setInputVisible(false);
        ioTab.select();
    }

    protected Process createProcess(ExecInfo info) throws IOException {
        return this.getExternalExecutor().exec((Format)((Object)new JavadocFormat(ExternalJavadocExecutor.createParametersLine(), files)));
    }

    private static String createParametersLine() {
        StringBuffer params = new StringBuffer();
        Iterator iter = args.iterator();
        while (iter.hasNext()) {
            params.append(iter.next().toString());
            params.append(" ");
        }
        return params.toString();
    }

    public static String createLists(Node[] activatedNodes) {
        pckList = new ArrayList();
        ArrayList<String> list = new ArrayList<String>();
        ExternalJavadocSettingsService javadocS = (ExternalJavadocSettingsService)((Object)Lookup.getDefault().lookup(class$org$netbeans$modules$javadoc$settings$ExternalJavadocSettingsService == null ? (class$org$netbeans$modules$javadoc$settings$ExternalJavadocSettingsService = ExternalJavadocExecutor.class$("org.netbeans.modules.javadoc.settings.ExternalJavadocSettingsService")) : class$org$netbeans$modules$javadoc$settings$ExternalJavadocSettingsService));
        int i = 0;
        while (i < activatedNodes.length) {
            DataFolder df = (DataFolder)activatedNodes[i].getCookie(class$org$openide$loaders$DataFolder == null ? ExternalJavadocExecutor.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder);
            if (df != null) {
                if (ExternalJavadocExecutor.isAvailableFile(df.getPrimaryFile())) {
                    String pck = df.getPrimaryFile().getPackageName('.');
                    if (ExternalJavadocExecutor.existsJdoFilesInFolder(df) && !pckList.contains(pck)) {
                        pckList.add(pck);
                        list.add(pck);
                    }
                    if (javadocS == null || javadocS.getRecursive()) {
                        list.addAll(ExternalJavadocExecutor.parseFolders(df));
                    }
                }
            } else {
                FileObject fo;
                DataObject jdo = (DataObject)activatedNodes[i].getCookie(class$org$netbeans$modules$java$JavaDataObject == null ? ExternalJavadocExecutor.class$("org.netbeans.modules.java.JavaDataObject") : class$org$netbeans$modules$java$JavaDataObject);
                if (jdo != null && ExternalJavadocExecutor.isAvailableFile(fo = jdo.getPrimaryFile())) {
                    String pck = ExternalJavadocExecutor.getFileObjectPackage(fo);
                    if (fo.hasExt("java") && !pckList.contains(pck)) {
                        try {
                            list.add(FileUtil.toFile((FileObject)fo).toString());
                        }
                        catch (Exception exEx) {
                            // empty catch block
                        }
                    }
                }
            }
            ++i;
        }
        if (list.size() != 0) {
            return ExternalJavadocExecutor.asParameterString(list.toArray(new String[1]));
        }
        return null;
    }

    private static List parseFolders(DataFolder df) {
        ArrayList<String> list = new ArrayList<String>();
        DataObject[] objects = df.getChildren();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof JavaDataObject) {
                JavaDataObject jdo = (JavaDataObject)objects[i];
                FileObject fo = jdo.getPrimaryFile();
                if (ExternalJavadocExecutor.isAvailableFile(fo)) {
                    String pck = ExternalJavadocExecutor.getFileObjectPackage(fo);
                    if (fo.hasExt("java") && !pckList.contains(pck)) {
                        try {
                            list.add(FileUtil.toFile((FileObject)fo).toString());
                        }
                        catch (Exception exEx) {}
                    }
                }
            } else if (objects[i] instanceof DataFolder) {
                String pck = ((DataFolder)objects[i]).getPrimaryFile().getPackageName('.');
                if (ExternalJavadocExecutor.isAvailableFile(df.getPrimaryFile())) {
                    if (!pckList.contains(pck)) {
                        pckList.add(pck);
                        if (ExternalJavadocExecutor.existsJdoFilesInFolder((DataFolder)objects[i])) {
                            list.add(pck);
                        }
                    }
                    list.addAll(ExternalJavadocExecutor.parseFolders((DataFolder)objects[i]));
                }
            }
            ++i;
        }
        return list;
    }

    private static boolean existsJdoFilesInFolder(DataFolder df) {
        DataObject[] dataob = df.getChildren();
        int i = 0;
        while (i < dataob.length) {
            if (dataob[i] instanceof JavaDataObject) {
                JavaDataObject jdo = (JavaDataObject)dataob[i];
                Set filesSet = jdo.files();
                Iterator iterator = filesSet.iterator();
                while (iterator.hasNext()) {
                    if (!((FileObject)iterator.next()).hasExt("java")) continue;
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static boolean isAvailableFile(FileObject fo) {
        try {
            FileUtil.toFile((FileObject)fo).toString();
        }
        catch (Exception exEx) {
            return false;
        }
        return true;
    }

    private static String getFileObjectPackage(FileObject fo) {
        String pck = fo.getPackageName('.');
        int dot = pck.lastIndexOf(46);
        if (dot != -1) {
            pck = pck.substring(0, dot);
        }
        return pck;
    }

    private static String asParameterString(String[] files) {
        if (files.length > 10 && Utilities.isWindows()) {
            File f = ExternalJavadocExecutor.constructFile(files);
            if (f == null) {
                return null;
            }
            return "@" + f;
        }
        return ExternalJavadocExecutor.constructString(files);
    }

    private static File constructFile(String[] files) {
        try {
            File f = File.createTempFile(PREFIX, SUFFIX);
            f.deleteOnExit();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream(f)));
            Iterator<String> iter = Arrays.asList(files).iterator();
            while (iter.hasNext()) {
                pw.println(iter.next());
            }
            pw.close();
            return f;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String constructString(String[] files) {
        StringBuffer sb = new StringBuffer();
        String add = "";
        int i = 0;
        while (i < files.length) {
            sb.append(add);
            if (files[i].indexOf(32) >= 0) {
                sb.append("\"");
                sb.append(files[i]);
                sb.append("\"");
            } else {
                sb.append(files[i]);
            }
            add = " ";
            ++i;
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        files = null;
        pckList = null;
    }

    private static class JavadocFormat
    extends MapFormat {
        public static final String TAG_CLASSPATH = "classpath";
        public static final String TAG_BOOTCLASSPATH = "bootclasspath";
        public static final String TAG_REPOSITORY = "filesystems";
        public static final String TAG_LIBRARY = "library";
        public static final String TAG_FILES = "files";
        public static final String TAG_PARAMS = "params";
        public static final String TAG_JDKHOME = "jdk.home";
        public static final String TAG_SEPARATOR = "/";
        public static final String TAG_PATHSEPARATOR = ":";
        private Map map = this.getMap();
        private static final long serialVersionUID = 7560001740739774352L;

        public JavadocFormat(String params, String files) {
            super(new HashMap(9));
            this.map.put(TAG_CLASSPATH, NbClassPath.createClassPath().getClassPath());
            this.map.put(TAG_BOOTCLASSPATH, NbClassPath.createBootClassPath().getClassPath());
            this.map.put(TAG_REPOSITORY, NbClassPath.createRepositoryPath().getClassPath());
            this.map.put(TAG_LIBRARY, NbClassPath.createLibraryPath().getClassPath());
            this.map.put(TAG_JDKHOME, System.getProperty(TAG_JDKHOME));
            this.map.put(TAG_SEPARATOR, File.separator);
            this.map.put(TAG_PATHSEPARATOR, File.pathSeparator);
            this.map.put(TAG_PARAMS, params);
            this.map.put(TAG_FILES, files);
        }
    }
}

