/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.comments;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.TooManyListenersException;
import javax.swing.DefaultListModel;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.javadoc.comments.JavaTagNames;
import org.netbeans.modules.javadoc.comments.ResourceUtils;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SourceCookie;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.ElementFormat;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.JavaDoc;
import org.openide.src.JavaDocSupport;
import org.openide.src.JavaDocTag;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.WeakListener;

public class AutoCommenter
implements JavaTagNames {
    public static final int JDC_OK = 1;
    public static final int JDC_MISSING = 2;
    public static final int JDC_ERROR = 4;
    ArrayList elements;
    final ArrayList dataObjects = new ArrayList();
    Node[] nodes;
    private AutoCommentChangeListener autoCommentChangeListener = null;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie$Editor;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;

    AutoCommenter() {
        this(new Node[0]);
    }

    AutoCommenter(Node[] nodes) {
        this.nodes = nodes;
        int i = 0;
        while (i < nodes.length) {
            DataFolder df = (DataFolder)nodes[i].getCookie(class$org$openide$loaders$DataFolder == null ? AutoCommenter.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder);
            SourceCookie sc = null;
            if (df != null) {
                DataObject[] children = df.getChildren();
                int n = 0;
                while (n < children.length) {
                    final DataObject child = children[n];
                    sc = (SourceCookie)child.getCookie(class$org$openide$cookies$SourceCookie$Editor == null ? AutoCommenter.class$("org.openide.cookies.SourceCookie$Editor") : class$org$openide$cookies$SourceCookie$Editor);
                    if (sc != null && !child.getPrimaryFile().isReadOnly() && !this.dataObjects.contains(child)) {
                        child.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)new PropertyChangeListener(){

                            public void propertyChange(PropertyChangeEvent evt) {
                                if (evt.getPropertyName().equals("valid")) {
                                    ArrayList arrayList = AutoCommenter.this.dataObjects;
                                    synchronized (arrayList) {
                                        ((AbstractCollection)AutoCommenter.this.dataObjects).remove(child);
                                    }
                                    AutoCommenter.this.fireAutocommentChangeEvent();
                                }
                            }
                        }, (Object)child));
                        ArrayList arrayList = this.dataObjects;
                        synchronized (arrayList) {
                            this.dataObjects.add(child);
                        }
                    }
                    ++n;
                }
            } else {
                sc = (SourceCookie)nodes[i].getCookie(class$org$openide$cookies$SourceCookie$Editor == null ? AutoCommenter.class$("org.openide.cookies.SourceCookie$Editor") : class$org$openide$cookies$SourceCookie$Editor);
                final DataObject doj = (DataObject)nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? AutoCommenter.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (sc != null && !doj.getPrimaryFile().isReadOnly() && !this.dataObjects.contains(doj)) {
                    doj.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent evt) {
                            if (evt.getPropertyName().equals("valid")) {
                                ArrayList arrayList = AutoCommenter.this.dataObjects;
                                synchronized (arrayList) {
                                    ((AbstractCollection)AutoCommenter.this.dataObjects).remove(doj);
                                }
                                AutoCommenter.this.fireAutocommentChangeEvent();
                            }
                        }
                    }, (Object)doj));
                    ArrayList arrayList = this.dataObjects;
                    synchronized (arrayList) {
                        this.dataObjects.add(doj);
                    }
                }
            }
            ++i;
        }
    }

    void refreshFromSource() {
        this.elements = new ArrayList();
        int i = 0;
        while (i < this.dataObjects.size()) {
            SourceCookie sc = (SourceCookie)((DataObject)this.dataObjects.get(i)).getCookie(class$org$openide$cookies$SourceCookie == null ? AutoCommenter.class$("org.openide.cookies.SourceCookie") : class$org$openide$cookies$SourceCookie);
            this.addCommentable(sc);
            ++i;
        }
    }

    void addCommentable(SourceCookie sc) {
        SourceElement se = sc.getSource();
        if (se != null) {
            ClassElement[] ces = se.getAllClasses();
            int j = 0;
            while (j < ces.length) {
                this.addElements(ces[j]);
                ++j;
            }
        }
    }

    void prepareListModel(DefaultListModel listModel, int mask, boolean pckg, int err_mask) {
        Iterator it = ((AbstractList)this.elements).iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            if (!AutoCommenter.acceptElement(el, mask, pckg, err_mask)) continue;
            listModel.addElement(el);
        }
    }

    static int getEffectiveAccess(MemberElement el) {
        int access = el.getModifiers() & 7;
        if (access == 2) {
            return access;
        }
        ClassElement decl = el.getDeclaringClass();
        if (decl == null) {
            return access;
        }
        if (!decl.isClassOrInterface()) {
            access = 1;
        }
        int parentAccess = AutoCommenter.getEffectiveAccess((MemberElement)decl);
        switch (parentAccess) {
            case 0: 
            case 2: {
                return parentAccess;
            }
            case 4: {
                return access == 0 ? 0 : parentAccess;
            }
        }
        return access;
    }

    static boolean acceptElement(Element el, int mask, boolean pckg, int err_mask) {
        if ((el.getErrorNumber() & err_mask) == 0) {
            return false;
        }
        int access = AutoCommenter.getEffectiveAccess(el.getSrcElement());
        if (access == 0) {
            return pckg;
        }
        return (access & mask) > 0;
    }

    DefaultListModel prepareListModel(int mask, boolean pckg, int err_mask) {
        DefaultListModel dm = new DefaultListModel();
        this.prepareListModel(dm, mask, pckg, err_mask);
        return dm;
    }

    private void addElements(ClassElement classElement) {
        this.elements.add(new Element.Class(classElement));
        FieldElement[] fe = classElement.getFields();
        int i = 0;
        while (i < fe.length) {
            this.elements.add(new Element.Field(fe[i]));
            ++i;
        }
        ConstructorElement[] ce = classElement.getConstructors();
        int i2 = 0;
        while (i2 < ce.length) {
            this.elements.add(new Element.Constructor(ce[i2]));
            ++i2;
        }
        MethodElement[] me = classElement.getMethods();
        int i3 = 0;
        while (i3 < me.length) {
            this.elements.add(new Element.Method(me[i3]));
            ++i3;
        }
    }

    public synchronized void addAutoCommentChangeListener(AutoCommentChangeListener listener) throws TooManyListenersException {
        if (this.autoCommentChangeListener != null) {
            throw new TooManyListenersException();
        }
        this.autoCommentChangeListener = listener;
    }

    public synchronized void removeAutoCommentChangeListener(AutoCommentChangeListener listener) {
        this.autoCommentChangeListener = null;
    }

    private void fireAutocommentChangeEvent() {
        if (this.autoCommentChangeListener == null) {
            return;
        }
        this.autoCommentChangeListener.listChanged();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface AutoCommentChangeListener
    extends EventListener {
        public void listChanged();
    }

    static abstract class Element {
        protected DefaultListModel errorList;
        MemberElement srcElement = null;
        int srcError = 1;
        static /* synthetic */ java.lang.Class class$org$openide$cookies$OpenCookie;

        Element(MemberElement srcElement) {
            this.srcElement = srcElement;
            PropertyChangeListener pp = new PropertyChangeListener(this){
                private final /* synthetic */ Element this$0;
                {
                    this.this$0 = this$0;
                }

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getSource() instanceof JavaDataObject) {
                        return;
                    }
                }
            };
            srcElement.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)pp, (Object)srcElement));
            this.checkError();
        }

        String getName() {
            return this.getNameFormat().format((org.openide.src.Element)this.srcElement);
        }

        MemberElement getSrcElement() {
            return this.srcElement;
        }

        int getModifiers() {
            return this.srcElement.getModifiers();
        }

        int getErrorNumber() {
            return this.srcError;
        }

        void viewSource() {
            OpenCookie oc = (OpenCookie)this.srcElement.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = Element.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
            oc.open();
        }

        DefaultListModel getErrorList() {
            return this.errorList;
        }

        SourceElement findSource() {
            ClassElement decl = this.srcElement.getDeclaringClass();
            if (decl == null && this.srcElement instanceof ClassElement) {
                decl = (ClassElement)this.srcElement;
            }
            if (decl == null) {
                return null;
            }
            return decl.getSource();
        }

        abstract String[] getNotPermittedTags();

        abstract boolean elementTagsOk();

        abstract void autoCorrect() throws SourceException;

        abstract JavaDoc getJavaDoc();

        abstract ElementFormat getNameFormat();

        abstract String typeToString();

        static boolean isPermittedTag(JavaDocTag tag, String[] notPermittedTags) {
            String tagName = tag.name();
            int i = 0;
            while (i < notPermittedTags.length) {
                if (tagName.equals(notPermittedTags[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        void modifyJavaDoc(Runnable mutator) throws SourceException {
            SourceElement src = this.findSource();
            if (src == null) {
                mutator.run();
            } else {
                src.runAtomicAsUser(mutator);
            }
        }

        private static boolean isEmptyString(String string) {
            return string == null || string.trim().length() <= 0;
        }

        boolean isOkTag(JavaDocTag tag) {
            if (Element.isEmptyString(tag.text())) {
                this.errorList.addElement(MessageFormat.format(ResourceUtils.getBundledString("ERR_EmptyTag"), tag.name()));
                return false;
            }
            if (tag instanceof JavaDocTag.See) {
                JavaDocTag.See seetag = (JavaDocTag.See)tag;
                if (seetag.referencedClassName() != null || seetag.referencedMemberName() != null) {
                    return true;
                }
                String text = tag.text();
                int len = text.length();
                if (len >= 2) {
                    char first = text.charAt(0);
                    char last = text.charAt(len - 1);
                    if (first == '\"' && last == first) {
                        return true;
                    }
                    if (first == '<' && last == '>') {
                        return true;
                    }
                }
                this.errorList.addElement(MessageFormat.format(ResourceUtils.getBundledString("ERR_InvalidTag"), seetag));
                return false;
            }
            if (tag instanceof JavaDocTag.Param) {
                if (Element.isEmptyString(((JavaDocTag.Param)tag).parameterName())) {
                    this.errorList.addElement(MessageFormat.format(ResourceUtils.getBundledString("ERR_ParamNoName"), tag.name()));
                    return false;
                }
                if (Element.isEmptyString(((JavaDocTag.Param)tag).parameterComment())) {
                    this.errorList.addElement(MessageFormat.format(ResourceUtils.getBundledString("ERR_ParamNoDescr"), tag.name(), ((JavaDocTag.Param)tag).parameterName()));
                    return false;
                }
            } else if (tag instanceof JavaDocTag.Throws) {
                if (Element.isEmptyString(((JavaDocTag.Throws)tag).exceptionName())) {
                    this.errorList.addElement(MessageFormat.format(ResourceUtils.getBundledString("ERR_ThrowsNoName"), tag.name()));
                    return false;
                }
                if (Element.isEmptyString(((JavaDocTag.Throws)tag).exceptionComment())) {
                    this.errorList.addElement(MessageFormat.format(ResourceUtils.getBundledString("ERR_ThrowsNoDescr"), tag.name(), ((JavaDocTag.Throws)tag).exceptionName()));
                    return false;
                }
            } else if (tag instanceof JavaDocTag.SerialField) {
                if (Element.isEmptyString(((JavaDocTag.SerialField)tag).fieldName())) {
                    this.errorList.addElement(MessageFormat.format(ResourceUtils.getBundledString("ERR_SerialFieldNoName"), tag.name()));
                    return false;
                }
                if (Element.isEmptyString(((JavaDocTag.SerialField)tag).fieldType())) {
                    this.errorList.addElement(MessageFormat.format(ResourceUtils.getBundledString("ERR_SerialFieldNoType"), tag.name(), ((JavaDocTag.SerialField)tag).fieldName()));
                    return false;
                }
                if (Element.isEmptyString(((JavaDocTag.SerialField)tag).description())) {
                    this.errorList.addElement(MessageFormat.format(ResourceUtils.getBundledString("ERR_SerialFieldNoDescr"), tag.name(), ((JavaDocTag.SerialField)tag).fieldName()));
                    return false;
                }
            }
            return true;
        }

        boolean isMultipleTags(String tag) {
            boolean error = false;
            JavaDocTag[] tags = this.getJavaDoc().getTags(tag);
            if (tags.length > 1) {
                this.errorList.addElement(MessageFormat.format(ResourceUtils.getBundledString("ERR_DuplicatedTag"), tags[0].name()));
                error = true;
            }
            return error;
        }

        void checkError() {
            this.errorList = new DefaultListModel();
            JavaDoc jdoc = this.getJavaDoc();
            if (jdoc.isEmpty()) {
                this.srcError = 2;
                this.errorList.addElement(ResourceUtils.getBundledString("ERR_JavadocMissing"));
                return;
            }
            JavaDocTag[] tags = jdoc.getTags();
            boolean error = false;
            if (jdoc.getText() == null || jdoc.getText().trim().length() <= 0) {
                this.errorList.addElement(ResourceUtils.getBundledString("ERR_EmptyText"));
                error = true;
            }
            int i = 0;
            while (i < tags.length) {
                if (!Element.isPermittedTag(tags[i], this.getNotPermittedTags())) {
                    this.errorList.addElement(MessageFormat.format(ResourceUtils.getBundledString("ERR_BadTag"), tags[i].name(), this.typeToString()));
                    error = true;
                } else if (!this.isOkTag(tags[i])) {
                    error = true;
                }
                ++i;
            }
            if (this.isMultipleTags("@since")) {
                error = true;
            }
            if (this.isMultipleTags("@deprecated")) {
                error = true;
            }
            if (!this.elementTagsOk()) {
                error = true;
            }
            if (!error) {
                this.errorList.addElement(ResourceUtils.getBundledString("ERR_JavadocOK"));
            }
            this.srcError = error ? 4 : 1;
        }

        boolean isCorrectable() {
            JavaDocTag[] tags = this.getJavaDoc().getTags();
            int i = 0;
            while (i < tags.length) {
                if (!Element.isPermittedTag(tags[i], this.getNotPermittedTags())) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        void autoCorrect(JavaDoc jdoc) throws SourceException {
            JavaDocTag[] tags = jdoc.getTags();
            ArrayList<JavaDocTag> correctedTags = new ArrayList<JavaDocTag>(tags.length);
            String correctedText = jdoc.getText();
            if (correctedText == null) {
                correctedText = "";
            }
            int i = 0;
            while (i < tags.length) {
                if (Element.isPermittedTag(tags[i], this.getNotPermittedTags())) {
                    correctedTags.add(tags[i]);
                }
                ++i;
            }
            jdoc.changeTags(correctedTags.toArray(new JavaDocTag[correctedTags.size()]), 3);
        }

        static /* synthetic */ java.lang.Class class$(String x0) {
            try {
                return java.lang.Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static class Method
        extends Constructor {
            private static final ElementFormat nameFormat = new ElementFormat("{m} {r} {n} ( {p} )");
            private static final String[] NOT_PERMITTED_TAGS = new String[]{"@author", "@serial", "@serialField", "@version"};

            Method(MethodElement element) {
                super((ConstructorElement)element);
            }

            JavaDoc getJavaDoc() {
                return ((MethodElement)this.srcElement).getJavaDoc();
            }

            String typeToString() {
                return "method";
            }

            String[] getNotPermittedTags() {
                return NOT_PERMITTED_TAGS;
            }

            boolean elementTagsOk() {
                boolean superOk = super.elementTagsOk();
                boolean retOk = this.checkReturnType(false);
                return !superOk ? false : retOk;
            }

            private boolean checkReturnType(boolean checkOnly) {
                boolean retOk = true;
                Type ret = ((MethodElement)this.srcElement).getReturn();
                JavaDocTag[] retTags = ((MethodElement)this.srcElement).getJavaDoc().getTags("@return");
                if (ret == Type.VOID && retTags.length > 0) {
                    if (checkOnly) {
                        return false;
                    }
                    this.errorList.addElement(ResourceUtils.getBundledString("ERR_ReturnForVoid"));
                    retOk = false;
                } else if (ret != Type.VOID && retTags.length <= 0) {
                    if (checkOnly) {
                        return false;
                    }
                    this.errorList.addElement(ResourceUtils.getBundledString("ERR_NoReturn"));
                    retOk = false;
                } else if (ret != Type.VOID && retTags.length > 1) {
                    if (checkOnly) {
                        return false;
                    }
                    this.errorList.addElement(ResourceUtils.getBundledString("ERR_DuplicatedReturn"));
                    retOk = false;
                }
                return retOk;
            }

            boolean isCorrectable() {
                if (super.isCorrectable()) {
                    return true;
                }
                return !this.checkReturnType(true);
            }

            void autoCorrect() throws SourceException {
                JavaDoc.Method jdTemp = JavaDocSupport.createMethodJavaDoc((String)this.getJavaDoc().getRawText());
                super.autoCorrect((JavaDoc)jdTemp);
                if (!this.checkReturnType(true)) {
                    if (((MethodElement)this.srcElement).getReturn() != Type.VOID) {
                        jdTemp.changeTags(new JavaDocTag[]{JavaDocSupport.createTag((String)"@return", (String)"")}, 1);
                    } else {
                        JavaDocTag[] toRemove = jdTemp.getTags("@return");
                        jdTemp.changeTags(toRemove, 2);
                    }
                }
                this.getJavaDoc().setRawText(jdTemp.getRawText());
            }

            ElementFormat getNameFormat() {
                return nameFormat;
            }
        }

        static class Constructor
        extends Element {
            private static final String[] NOT_PERMITTED_TAGS = new String[]{"@author", "@serial", "@serialField", "@version", "@return"};
            private static final ElementFormat nameFormat = new ElementFormat("{m} {n} ( {p} )");

            Constructor(ConstructorElement element) {
                super((MemberElement)element);
            }

            JavaDoc getJavaDoc() {
                return ((ConstructorElement)this.srcElement).getJavaDoc();
            }

            String[] getNotPermittedTags() {
                return NOT_PERMITTED_TAGS;
            }

            String typeToString() {
                return "constructor";
            }

            boolean elementTagsOk() {
                return this.elementTagsOk(null, false);
            }

            boolean elementTagsOk(ArrayList correctedTags, boolean checkOnly) {
                boolean error = false;
                JavaDocTag.Param[] ptags = ((ConstructorElement)this.srcElement).getJavaDoc().getParamTags();
                boolean[] ptags_found = new boolean[ptags.length];
                MethodParameter[] params = ((ConstructorElement)this.srcElement).getParameters();
                int j = 0;
                while (j < params.length) {
                    boolean tagFound = false;
                    boolean duplicateTagAlreadyFound = false;
                    int i = 0;
                    while (i < ptags.length) {
                        if (ptags[i].parameterName() != null && ptags[i].parameterName().equals(params[j].getName())) {
                            ptags_found[i] = true;
                            if (!tagFound) {
                                tagFound = true;
                            } else if (!duplicateTagAlreadyFound) {
                                if (checkOnly) {
                                    return false;
                                }
                                if (correctedTags == null) {
                                    this.errorList.addElement(MessageFormat.format(ResourceUtils.getBundledString("ERR_DuplicatedParamTag"), params[j].getName()));
                                }
                                error = true;
                                duplicateTagAlreadyFound = true;
                            }
                        }
                        ++i;
                    }
                    if (!tagFound) {
                        if (checkOnly) {
                            return false;
                        }
                        if (correctedTags == null) {
                            error = true;
                            this.errorList.addElement(MessageFormat.format(ResourceUtils.getBundledString("ERR_NoTagForParam"), params[j].getName()));
                        } else {
                            correctedTags.add(JavaDocSupport.createParamTag((String)"@param", (String)params[j].getName()));
                        }
                    }
                    ++j;
                }
                int i = 0;
                while (i < ptags.length) {
                    if (!ptags_found[i]) {
                        if (checkOnly) {
                            return false;
                        }
                        if (correctedTags == null) {
                            this.errorList.addElement(MessageFormat.format(ResourceUtils.getBundledString("ERR_NoSuchParam"), ptags[i].name(), ptags[i].parameterName()));
                        }
                        error = true;
                    } else if (correctedTags != null) {
                        correctedTags.add(ptags[i]);
                    }
                    ++i;
                }
                JavaDocTag.Throws[] ttags = ((ConstructorElement)this.srcElement).getJavaDoc().getThrowsTags();
                boolean[] ttags_found = new boolean[ttags.length];
                Identifier[] excs = ((ConstructorElement)this.srcElement).getExceptions();
                int j2 = 0;
                while (j2 < excs.length) {
                    boolean tagFound = false;
                    boolean duplicateTagAlreadyFound = false;
                    int i2 = 0;
                    while (i2 < ttags.length) {
                        Identifier tagExId = Identifier.create((String)ttags[i2].exceptionName());
                        if (tagExId != null && (tagExId.compareTo(excs[j2], false) || tagExId.getName().equals(excs[j2].getName()))) {
                            ttags_found[i2] = true;
                            if (!tagFound) {
                                tagFound = true;
                            } else if (!duplicateTagAlreadyFound) {
                                if (checkOnly) {
                                    return false;
                                }
                                if (correctedTags == null) {
                                    this.errorList.addElement(MessageFormat.format(ResourceUtils.getBundledString("ERR_DuplicatedExceptionTag"), excs[j2].getName()));
                                }
                                error = true;
                                duplicateTagAlreadyFound = true;
                            }
                        }
                        ++i2;
                    }
                    if (!tagFound) {
                        if (checkOnly) {
                            return false;
                        }
                        if (correctedTags == null) {
                            error = true;
                            this.errorList.addElement(MessageFormat.format(ResourceUtils.getBundledString("ERR_NoTagForException"), excs[j2].getName()));
                        } else {
                            correctedTags.add(JavaDocSupport.createThrowsTag((String)"@throws", (String)excs[j2].getName()));
                        }
                    }
                    ++j2;
                }
                int i3 = 0;
                while (i3 < ttags.length) {
                    if (!ttags_found[i3]) {
                        if (checkOnly) {
                            return false;
                        }
                        if (correctedTags == null) {
                            this.errorList.addElement(MessageFormat.format(ResourceUtils.getBundledString("ERR_NoSuchException"), ttags[i3].name(), ttags[i3].exceptionName()));
                        }
                        error = true;
                    } else if (correctedTags != null) {
                        correctedTags.add(ttags[i3]);
                    }
                    ++i3;
                }
                return !error;
            }

            boolean isCorrectable() {
                if (super.isCorrectable()) {
                    return true;
                }
                return !this.elementTagsOk(null, true);
            }

            void autoCorrect() throws SourceException {
                this.autoCorrect(this.getJavaDoc());
            }

            void autoCorrect(JavaDoc jDoc) throws SourceException {
                JavaDoc.Method jdTemp = JavaDocSupport.createMethodJavaDoc((String)this.getJavaDoc().getRawText());
                JavaDocTag[] tags = jdTemp.getTags();
                ArrayList<JavaDocTag> stdTags = new ArrayList<JavaDocTag>(tags.length);
                int i = 0;
                while (i < tags.length) {
                    if (!(tags[i] instanceof JavaDocTag.Param) && !(tags[i] instanceof JavaDocTag.Throws)) {
                        stdTags.add(tags[i]);
                    }
                    ++i;
                }
                jdTemp.changeTags(stdTags.toArray(new JavaDocTag[stdTags.size()]), 3);
                super.autoCorrect((JavaDoc)jdTemp);
                ArrayList correctedTags = new ArrayList();
                this.elementTagsOk(correctedTags, false);
                ArrayList<Object> allTags = new ArrayList<Object>(correctedTags.size() + tags.length);
                tags = jdTemp.getTags();
                int i2 = 0;
                while (i2 < tags.length) {
                    allTags.add(tags[i2]);
                    ++i2;
                }
                allTags.addAll(correctedTags);
                jDoc.changeTags(allTags.toArray(new JavaDocTag[allTags.size()]), 3);
            }

            ElementFormat getNameFormat() {
                return nameFormat;
            }
        }

        static class Field
        extends Element {
            private static final String[] NOT_PERMITTED_TAGS = new String[]{"@author", "@exception", "@param", "@return", "@serialData", "@throws", "@version"};
            private static final ElementFormat nameFormat = new ElementFormat("{m} {t} {n}");

            Field(FieldElement element) {
                super((MemberElement)element);
            }

            JavaDoc getJavaDoc() {
                return ((FieldElement)this.srcElement).getJavaDoc();
            }

            String[] getNotPermittedTags() {
                return NOT_PERMITTED_TAGS;
            }

            String typeToString() {
                return "field";
            }

            boolean elementTagsOk() {
                boolean error = false;
                if (this.isMultipleTags("@serial")) {
                    error = true;
                }
                return !error;
            }

            void autoCorrect() throws SourceException {
                super.autoCorrect(this.getJavaDoc());
            }

            boolean isCorrectable() {
                return super.isCorrectable();
            }

            ElementFormat getNameFormat() {
                return nameFormat;
            }
        }

        static class Class
        extends Element {
            private static final String[] NOT_PERMITTED_TAGS = new String[]{"@exception", "@param", "@return", "@serial", "@serialData", "@serialField", "@throws"};
            private static final ElementFormat nameFormat = new ElementFormat("{m} {C}");

            Class(ClassElement element) {
                super((MemberElement)element);
            }

            String[] getNotPermittedTags() {
                return NOT_PERMITTED_TAGS;
            }

            boolean elementTagsOk() {
                boolean error = false;
                if (this.isMultipleTags("@version")) {
                    error = true;
                }
                return !error;
            }

            void autoCorrect() throws SourceException {
                super.autoCorrect(this.getJavaDoc());
            }

            boolean isCorrectable() {
                return super.isCorrectable();
            }

            String typeToString() {
                return ((ClassElement)this.srcElement).isInterface() ? "interface" : "class";
            }

            JavaDoc getJavaDoc() {
                return ((ClassElement)this.srcElement).getJavaDoc();
            }

            ElementFormat getNameFormat() {
                return nameFormat;
            }
        }
    }
}

