/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.httpfs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.netbeans.modules.javadoc.httpfs.HTTPFileObject;
import org.netbeans.modules.javadoc.httpfs.HTTPRootFileObject;
import org.netbeans.modules.javadoc.httpfs.RefreshAction;
import org.netbeans.modules.javadoc.httpfs.ResourceUtils;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;

public class HTTPFileSystem
extends FileSystem
implements VetoableChangeListener {
    public static final String PROP_URL = "URL";
    public static final String PROP_REFRESH_RATE = "RefreshRate";
    public static final String PROP_STATE = "State";
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_READING = 1;
    public static final int STATE_COMPLETE = 2;
    private static final long serialVersionUID = 200104L;
    private static final String DEFAULT_URL = "http://www.netbeans.org/download/apis/";
    transient URL baseURL;
    transient HTTPRootFileObject rootFileObject;
    transient int refreshRate;
    transient int currentState;
    static /* synthetic */ Class class$org$netbeans$modules$javadoc$httpfs$RefreshAction;

    public HTTPFileSystem() {
        FileSystemCapability.Bean httpFileSystemCapabilities = new FileSystemCapability.Bean();
        httpFileSystemCapabilities.setDoc(true);
        httpFileSystemCapabilities.setExecute(false);
        httpFileSystemCapabilities.setCompile(false);
        httpFileSystemCapabilities.setDebug(false);
        this.setCapability((FileSystemCapability)httpFileSystemCapabilities);
        this.setHidden(true);
        this.addVetoableChangeListener(this);
        this.refreshRate = 0;
        this.currentState = 0;
        try {
            this.setURL(DEFAULT_URL);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.baseURL.toString());
        out.writeInt(this.refreshRate);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.addVetoableChangeListener(this);
        try {
            this.setURL((String)in.readObject());
            try {
                this.refreshRate = in.readInt();
            }
            catch (IOException e) {
                this.refreshRate = 0;
            }
        }
        catch (PropertyVetoException e) {
            throw new IOException(e.getMessage());
        }
    }

    public String getURL() {
        return this.baseURL.toString();
    }

    public synchronized void setURL(String url) throws PropertyVetoException {
        URL oldURL = this.baseURL;
        HTTPRootFileObject oldRootFileObject = this.rootFileObject;
        try {
            try {
                this.baseURL = new URL(url);
            }
            catch (MalformedURLException mlfEx) {
                throw new PropertyVetoException(mlfEx.toString(), new PropertyChangeEvent(this, PROP_URL, oldURL != null ? oldURL.toExternalForm() : null, url));
            }
            this.rootFileObject = new HTTPRootFileObject(this);
            this.fireVetoableChange(PROP_URL, oldURL != null ? oldURL.toExternalForm() : null, url);
            this.setSystemName(this.getClass().getName() + "/" + this.baseURL.toExternalForm());
        }
        catch (PropertyVetoException e) {
            this.baseURL = oldURL;
            this.rootFileObject = oldRootFileObject;
            throw e;
        }
        this.firePropertyChange(PROP_URL, oldURL != null ? oldURL.toExternalForm() : null, url);
        this.firePropertyChange("root", oldRootFileObject, this.rootFileObject);
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int newRefreshRate) throws PropertyVetoException {
        int oldRefreshRate = this.refreshRate;
        try {
            this.refreshRate = newRefreshRate;
            this.fireVetoableChange(PROP_REFRESH_RATE, new Integer(oldRefreshRate), new Integer(newRefreshRate));
        }
        catch (PropertyVetoException e) {
            this.refreshRate = oldRefreshRate;
            throw e;
        }
        this.firePropertyChange(PROP_REFRESH_RATE, new Integer(oldRefreshRate), new Integer(newRefreshRate));
    }

    public int getState() {
        return this.currentState;
    }

    void setState(int newState) {
        if (newState != this.currentState) {
            String oldDisplayName = this.getDisplayName();
            int oldState = this.currentState;
            this.currentState = newState;
            this.firePropertyChange(PROP_STATE, new Integer(oldState), new Integer(newState));
            if (!oldDisplayName.equals(this.getDisplayName())) {
                this.firePropertyChange("displayName", oldDisplayName, this.getDisplayName());
            }
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        int newRefreshRate;
        if (propertyChangeEvent.getSource() == this && propertyChangeEvent.getPropertyName().equals(PROP_URL)) {
            URL newURL;
            try {
                newURL = new URL((String)propertyChangeEvent.getNewValue());
            }
            catch (MalformedURLException mlfEx) {
                throw new PropertyVetoException(mlfEx.toString(), propertyChangeEvent);
            }
            if (!newURL.getProtocol().equals("http") && !newURL.getProtocol().equals("https")) {
                throw new PropertyVetoException(ResourceUtils.getBundledString("MSG_NotHTTPProtocol"), propertyChangeEvent);
            }
            if (!newURL.toExternalForm().endsWith("/")) {
                throw new PropertyVetoException(ResourceUtils.getBundledString("MSG_NotDirectory"), propertyChangeEvent);
            }
        } else if (propertyChangeEvent.getSource() == this && propertyChangeEvent.getPropertyName().equals(PROP_REFRESH_RATE) && (newRefreshRate = ((Integer)propertyChangeEvent.getNewValue()).intValue()) < 0) {
            throw new PropertyVetoException(ResourceUtils.getBundledString("MSG_RefreshRateCannotBeNegative"), propertyChangeEvent);
        }
    }

    public FileObject getRoot() {
        return this.rootFileObject;
    }

    public String getDisplayName() {
        Object[] replacementValues = new Object[]{this.baseURL.toExternalForm()};
        String messageKey = this.getState() == 1 ? "DisplayName_Scanning" : "DisplayName_Normal";
        return ResourceUtils.getFormattedBundledString(messageKey, replacementValues);
    }

    public FileObject findResource(String resourceName) {
        StringTokenizer pathParser = new StringTokenizer(resourceName, "/");
        HTTPFileObject foundFileObject = (HTTPFileObject)this.getRoot();
        while (foundFileObject != null && pathParser.hasMoreElements()) {
            foundFileObject = foundFileObject.child((String)pathParser.nextElement());
        }
        return foundFileObject;
    }

    public boolean isReadOnly() {
        return true;
    }

    public SystemAction[] getActions() {
        Class refreshActionClass = class$org$netbeans$modules$javadoc$httpfs$RefreshAction == null ? (class$org$netbeans$modules$javadoc$httpfs$RefreshAction = HTTPFileSystem.class$("org.netbeans.modules.javadoc.httpfs.RefreshAction")) : class$org$netbeans$modules$javadoc$httpfs$RefreshAction;
        RefreshAction refreshAction = (RefreshAction)SharedClassObject.findObject((Class)refreshActionClass, (boolean)true);
        return new SystemAction[]{refreshAction};
    }

    public void prepareEnvironment(FileSystem.Environment env) throws EnvironmentNotSupportedException {
        throw new EnvironmentNotSupportedException((FileSystem)this);
    }

    protected void finalize() throws Throwable {
        this.removeVetoableChangeListener(this);
        this.rootFileObject = null;
        this.baseURL = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

