/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.util.ArrayList;
import java.util.Enumeration;
import org.netbeans.modules.javadoc.search.JavaDocFSSettings;
import org.netbeans.modules.javadoc.search.JavadocSearchType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.loaders.DataFolder;

public class DocFileSystem {
    FileObject indexFileObject;

    public DocFileSystem(FileObject indexFileObject) {
        this.indexFileObject = indexFileObject;
    }

    FileObject getIndexFile() {
        return this.indexFileObject;
    }

    static boolean isDocFolder(DataFolder df) {
        return false;
    }

    public static FileObject getDocFileObject(FileSystem fs) {
        JavadocSearchType st = JavaDocFSSettings.getDefaultJavaDocSearchType();
        if (st != null) {
            return st.getDocFileObject(fs, null);
        }
        return null;
    }

    static DocFileSystem[] getFolders() {
        ArrayList<DocFileSystem> result = new ArrayList<DocFileSystem>();
        Enumeration fileSystems = FileSystemCapability.DOC.fileSystems();
        while (fileSystems.hasMoreElements()) {
            FileObject fo;
            FileSystem fs = (FileSystem)fileSystems.nextElement();
            JavaDocFSSettings setting = JavaDocFSSettings.getSettingForFS(fs);
            JavadocSearchType st = setting.getSearchTypeEngine();
            FileObject fileObject = fo = st != null ? st.getDocFileObject(fs, setting.getSecondRoot()) : null;
            if (fo == null) continue;
            result.add(new DocFileSystem(fo));
        }
        DocFileSystem[] dsa = new DocFileSystem[result.size()];
        result.toArray(dsa);
        return dsa;
    }
}

