/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Comparator;

class DocIndexItem {
    public static final Comparator REFERENCE_COMPARATOR = new ReferenceComparator();
    public static final Comparator TYPE_COMPARATOR = new TypeComparator();
    public static final Comparator ALPHA_COMPARATOR = new AlphaComparator();
    private String text = null;
    private URL contextURL = null;
    private String spec = null;
    private String remark = null;
    private String pckg = null;
    private String declaringClass = null;
    private int iconIndex = 0;

    public DocIndexItem(String text, String remark, URL contextURL, String spec) {
        this.text = text;
        this.remark = remark;
        this.contextURL = contextURL;
        this.spec = spec;
    }

    public URL getURL() throws MalformedURLException {
        return new URL(this.contextURL, this.spec);
    }

    public String toString() {
        if (this.remark != null) {
            return this.text + this.remark;
        }
        return this.text;
    }

    public int getIconIndex() {
        return this.iconIndex;
    }

    public void setIconIndex(int iconIndex) {
        this.iconIndex = iconIndex;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getPackage() {
        return this.pckg == null ? "" : this.pckg;
    }

    public void setPackage(String pckg) {
        this.pckg = pckg;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public void setDeclaringClass(String declaringClass) {
        this.declaringClass = declaringClass;
    }

    public String getField() {
        return this.text != null ? this.text : "";
    }

    public void setField(String text) {
        this.text = text;
    }

    static class AlphaComparator
    implements Comparator {
        AlphaComparator() {
        }

        public int compare(Object dii1, Object dii2) {
            return ((DocIndexItem)dii1).toString().compareTo(((DocIndexItem)dii2).toString());
        }

        public boolean equals(Object comp) {
            return comp instanceof AlphaComparator;
        }
    }

    static class TypeComparator
    implements Comparator {
        TypeComparator() {
        }

        public int compare(Object dii1, Object dii2) {
            return ((DocIndexItem)dii1).getIconIndex() - ((DocIndexItem)dii2).getIconIndex();
        }

        public boolean equals(Object comp) {
            return comp instanceof TypeComparator;
        }
    }

    static class ReferenceComparator
    implements Comparator {
        ReferenceComparator() {
        }

        public int compare(Object dii1, Object dii2) {
            int res = ((DocIndexItem)dii1).getPackage().compareTo(((DocIndexItem)dii2).getPackage());
            return res != 0 ? res : ALPHA_COMPARATOR.compare(dii1, dii2);
        }

        public boolean equals(Object comp) {
            return comp instanceof ReferenceComparator;
        }
    }
}

