/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.Parser;
import org.netbeans.modules.javadoc.search.IndexBuilder;
import org.netbeans.modules.javadoc.search.JavaDocFSSettings;
import org.netbeans.modules.javadoc.search.JavadocSearchType;
import org.netbeans.modules.javadoc.search.ResourceUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.util.RequestProcessor;

public class IndexBuilder
implements Runnable,
RepositoryListener {
    private static final String[] INDEX_FILE_NAMES = new String[]{"overview-summary.html", "api/overview-summary.html", "index.html", "api/index.html", "index.htm", "api/index.htm"};
    private static IndexBuilder INSTANCE;
    private static RequestProcessor.Task task;
    private final ErrorManager err;
    private Reference cachedData;
    Map filesystemInfo = Collections.EMPTY_MAP;

    private IndexBuilder() {
        Repository.getDefault().addRepositoryListener((RepositoryListener)this);
        this.err = ErrorManager.getDefault().getInstance("org.netbeans.modules.javadoc.search.IndexBuilder");
        if (this.err.isLoggable(1)) {
            this.err.log("new IndexBuilder");
        }
    }

    public static synchronized IndexBuilder getDefault() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = new IndexBuilder();
        IndexBuilder.scheduleTask();
        return INSTANCE;
    }

    public void run() {
        this.cachedData = null;
        this.refreshIndex();
    }

    public List[] getIndices() {
        List[] data;
        task.waitFinished();
        if (this.cachedData != null && (data = (List[])this.cachedData.get()) != null) {
            if (this.err.isLoggable(1)) {
                this.err.log("getIndices (cached)");
            }
            return data;
        }
        if (this.err.isLoggable(1)) {
            this.err.log("getIndices");
        }
        Map m = this.filesystemInfo;
        Iterator it = m.entrySet().iterator();
        Collator c = Collator.getInstance();
        class Pair
        implements Comparable {
            public String display;
            public FileObject fo;
            private final /* synthetic */ Collator val$c;
            private final /* synthetic */ IndexBuilder this$0;

            Pair(IndexBuilder this$0, Collator val$c) {
                this.this$0 = this$0;
                this.val$c = val$c;
            }

            public int compareTo(Object o) {
                return this.val$c.compare(this.display, ((Pair)o).display);
            }
        }
        TreeSet<Pair> pairs = new TreeSet<Pair>();
        int i = 0;
        while (i < m.size()) {
            Map.Entry e = it.next();
            FileSystem fs = (FileSystem)e.getKey();
            Info info = (Info)e.getValue();
            FileObject fo = fs.findResource(info.indexFileName);
            if (fo != null) {
                Pair p = new Pair(this, c);
                p.display = info.title;
                p.fo = fo;
                pairs.add(p);
            }
            ++i;
        }
        ArrayList<String> display = new ArrayList<String>(pairs.size());
        ArrayList<FileObject> fos = new ArrayList<FileObject>(pairs.size());
        it = pairs.iterator();
        while (it.hasNext()) {
            Pair p = (Pair)((Object)it.next());
            display.add(p.display);
            fos.add(p.fo);
        }
        List[] data2 = new List[]{display, fos};
        this.cachedData = new WeakReference<List[]>(data2);
        return data2;
    }

    private void refreshIndex() {
        Map oldMap;
        if (this.err.isLoggable(1)) {
            this.err.log("refreshIndex");
        }
        IndexBuilder indexBuilder = this;
        synchronized (indexBuilder) {
            oldMap = this.filesystemInfo;
        }
        Enumeration e = FileSystemCapability.DOC.fileSystems();
        WeakHashMap<FileSystem, Info> m = new WeakHashMap<FileSystem, Info>();
        while (e.hasMoreElements()) {
            FileSystem fs = (FileSystem)e.nextElement();
            Info oldInfo = (Info)oldMap.get(fs);
            if (oldInfo != null) {
                m.put(fs, oldInfo);
                continue;
            }
            FileObject index = null;
            int i = 0;
            while (i < INDEX_FILE_NAMES.length) {
                index = fs.findResource(INDEX_FILE_NAMES[i]);
                if (index != null) break;
                ++i;
            }
            if (index == null || index.getName().equals("index")) {
                FileObject packageList = fs.findResource("package-list");
                if (packageList == null) {
                    packageList = fs.findResource("api/package-list");
                }
                if (packageList != null) {
                    try {
                        Object var16_17;
                        InputStream is = packageList.getInputStream();
                        try {
                            BufferedReader r = new BufferedReader(new InputStreamReader(is));
                            String line = r.readLine();
                            if (line != null && r.readLine() == null) {
                                String resName = line.replace('.', '/') + "/package-summary.html";
                                FileObject pindex = fs.findResource(resName);
                                if (pindex == null) {
                                    pindex = fs.findResource("api/" + resName);
                                }
                                if (pindex != null) {
                                    index = pindex;
                                }
                            }
                            var16_17 = null;
                        }
                        catch (Throwable throwable) {
                            var16_17 = null;
                            is.close();
                            throw throwable;
                        }
                        is.close();
                        {
                        }
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify(1, (Throwable)ioe);
                    }
                }
            }
            if (index != null) {
                String title = this.parseTitle(index);
                JavaDocFSSettings fss = JavaDocFSSettings.getSettingForFS(fs);
                if (title != null && fss != null) {
                    JavadocSearchType st = fss.getSearchTypeEngine();
                    if (st == null) continue;
                    title = st.getOverviewTitleBase(title);
                }
                if ("".equals(title)) {
                    title = MessageFormat.format(ResourceUtils.getBundledString("FMT_NoOverviewTitle"), index.getPath(), fs.getDisplayName(), fs.getSystemName());
                }
                Info info = new Info();
                info.title = title == null ? fs.getDisplayName() : title;
                info.indexFileName = index.getPath();
                m.put(fs, info);
            }
            IndexBuilder indexBuilder2 = this;
            synchronized (indexBuilder2) {
                this.filesystemInfo = m;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private String parseTitle(FileObject html) {
        try {
            String string;
            String[] title;
            String line;
            BufferedReader b = new BufferedReader(new InputStreamReader(html.getInputStream()));
            while ((line = b.readLine()) != null) {
                String next;
                void var3_4;
                if (!var3_4.equalsIgnoreCase("<title>") || (title = b.readLine()) == null || !"</title>".equalsIgnoreCase(next = b.readLine())) continue;
                if (this.err.isLoggable(1)) {
                    this.err.log("Fast parsing of " + (String)title);
                }
                return title;
            }
            title = new String[1];
            InputStreamReader r = new InputStreamReader(html.getInputStream());
            try {
                class TitleParser
                extends Parser {
                    private final /* synthetic */ String[] val$title;
                    private final /* synthetic */ IndexBuilder this$0;

                    public TitleParser(IndexBuilder this$0, String[] val$title) throws IOException {
                        super(DTD.getDTD("html32"));
                        this.this$0 = this$0;
                        this.val$title = val$title;
                    }

                    protected void handleTitle(char[] text) {
                        this.val$title[0] = new String(text);
                        if (IndexBuilder.access$100(this.this$0).isLoggable(1)) {
                            IndexBuilder.access$100(this.this$0).log("Slow parsing of " + this.val$title[0]);
                        }
                    }
                }
                new TitleParser(this, title).parse(r);
                string = title[0];
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                ((Reader)r).close();
                throw throwable;
            }
            ((Reader)r).close();
            return string;
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
            return null;
        }
    }

    private static synchronized void scheduleTask() {
        if (task == null) {
            task = RequestProcessor.getDefault().create((Runnable)IndexBuilder.getDefault());
        }
        task.schedule(100);
    }

    public void fileSystemAdded(RepositoryEvent ev) {
        IndexBuilder.scheduleTask();
    }

    public void fileSystemRemoved(RepositoryEvent ev) {
        IndexBuilder.scheduleTask();
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent ev) {
    }

    static /* synthetic */ ErrorManager access$100(IndexBuilder x0) {
        return x0.err;
    }

    private static class Info {
        String title;
        String indexFileName;

        private Info() {
        }
    }
}

