/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.modules.javadoc.search.IndexBuilder;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class IndexOverviewAction
extends SystemAction
implements Presenter.Menu {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.javadoc.search.IndexOverviewAction.IndexMenu");
    static /* synthetic */ Class class$org$netbeans$modules$javadoc$search$IndexOverviewAction;

    public void actionPerformed(ActionEvent ev) {
    }

    public String getName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$javadoc$search$IndexOverviewAction == null ? (class$org$netbeans$modules$javadoc$search$IndexOverviewAction = IndexOverviewAction.class$("org.netbeans.modules.javadoc.search.IndexOverviewAction")) : class$org$netbeans$modules$javadoc$search$IndexOverviewAction), (String)"CTL_INDICES_MenuItem");
    }

    protected String iconResource() {
        return "org/netbeans/modules/javadoc/resources/JavaDoc.gif";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("javadoc.search");
    }

    public JMenuItem getMenuPresenter() {
        return new IndexMenu();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class IndexMenuItem
    extends JMenuItem
    implements ActionListener,
    HelpCtx.Provider {
        private final URL u;

        public IndexMenuItem(String display, FileObject index) throws FileStateInvalidException {
            super(display);
            this.u = index.getURL();
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent ev) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(this.u);
        }

        public HelpCtx getHelpCtx() {
            return IndexOverviewAction.this.getHelpCtx();
        }
    }

    private final class IndexMenu
    extends JMenu
    implements HelpCtx.Provider {
        private int itemHash = 0;
        static /* synthetic */ Class class$org$netbeans$modules$javadoc$search$IndexOverviewAction;

        public IndexMenu() {
            Mnemonics.setLocalizedText((AbstractButton)this, (String)IndexOverviewAction.this.getName());
            this.setIcon(IndexOverviewAction.this.getIcon());
        }

        public HelpCtx getHelpCtx() {
            return IndexOverviewAction.this.getHelpCtx();
        }

        public void addNotify() {
            if (err.isLoggable(1)) {
                err.log("addNotify");
            }
            super.addNotify();
            IndexBuilder.getDefault();
        }

        public JPopupMenu getPopupMenu() {
            List[] data = IndexBuilder.getDefault().getIndices();
            int newHash = this.computeDataHash(data);
            if (newHash != this.itemHash) {
                if (err.isLoggable(1)) {
                    err.log("recreating popup menu (" + this.itemHash + " -> " + newHash + ")");
                }
                this.itemHash = newHash;
                this.removeAll();
                List names = data[0];
                List indices = data[1];
                int size = names.size();
                if (size != indices.size()) {
                    throw new IllegalStateException();
                }
                if (size > 0) {
                    int i = 0;
                    while (i < size) {
                        try {
                            this.add(new IndexMenuItem((String)names.get(i), (FileObject)indices.get(i)));
                        }
                        catch (FileStateInvalidException e) {
                            err.notify(1, (Throwable)e);
                        }
                        ++i;
                    }
                } else {
                    JMenuItem dummy = new JMenuItem(NbBundle.getMessage((Class)(class$org$netbeans$modules$javadoc$search$IndexOverviewAction == null ? (class$org$netbeans$modules$javadoc$search$IndexOverviewAction = IndexMenu.class$("org.netbeans.modules.javadoc.search.IndexOverviewAction")) : class$org$netbeans$modules$javadoc$search$IndexOverviewAction), (String)"CTL_no_indices_found"));
                    dummy.setEnabled(false);
                    this.add(dummy);
                }
            }
            return super.getPopupMenu();
        }

        private int computeDataHash(List[] data) {
            int x = data[0].hashCode();
            Iterator it = data[1].iterator();
            while (it.hasNext()) {
                FileObject fo = (FileObject)it.next();
                x += fo.getPath().hashCode();
                try {
                    x += fo.getFileSystem().getSystemName().hashCode();
                }
                catch (FileStateInvalidException e) {
                    err.notify(1, (Throwable)e);
                }
            }
            return x;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

