/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.javadoc.JavadocModule;
import org.netbeans.modules.javadoc.search.DocIndexItem;
import org.netbeans.modules.javadoc.search.IndexListCellRenderer;
import org.netbeans.modules.javadoc.search.JavadocSearchEngine;
import org.netbeans.modules.javadoc.search.NoJavadocException;
import org.netbeans.modules.javadoc.search.ResourceUtils;
import org.netbeans.modules.javadoc.search.SrcFinder;
import org.netbeans.modules.javadoc.settings.DocumentationSettings;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.SplittedPanel;
import org.openide.cookies.OpenCookie;
import org.openide.src.Element;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class IndexSearch
extends TopComponent
implements Externalizable {
    private static final String INDEX_SEARCH_HELP_CTX_KEY = "javadoc.search.window";
    private static final Dimension PREFFERED_SIZE = new Dimension(580, 430);
    static final long serialVersionUID = 1200348578933093459L;
    private static IndexSearch indexSearch;
    private JavadocSearchEngine searchEngine = null;
    DocumentationSettings ds = DocumentationSettings.getDefault();
    private String quickFind;
    private static final ImageIcon refSortIcon;
    private static final ImageIcon typeSortIcon;
    private static final ImageIcon alphaSortIcon;
    private static final ImageIcon listOnlyIcon;
    private static final ImageIcon listHtmlIcon;
    private static final ImageIcon showSourceIcon;
    private static final String ICON_RESOURCE = "/org/netbeans/modules/javadoc/resources/searchDoc.gif";
    private static final Image windowIcon;
    private String currentSort = "A";
    private JScrollPane resultsScrollPane;
    private JList resultsList;
    private HtmlBrowser quickBrowser;
    private SplittedPanel splitPanel;
    private static final String STR_FIND;
    private static final String STR_STOP;
    private ArrayList results = new ArrayList();
    private DefaultListModel referenceModel = null;
    private DefaultListModel typeModel = null;
    private DefaultListModel alphaModel = null;
    private int oldSplit = DocumentationSettings.getDefault().getIdxSearchSplit();
    private static final DefaultListModel waitModel;
    private static final DefaultListModel notModel;
    RequestProcessor.Task task = null;
    private JButton searchButton;
    private JPanel jPanel1;
    private JButton sourceButton;
    private JComboBox searchComboBox;
    private JToggleButton byNameButton;
    private JButton helpButton;
    private JToggleButton byReferenceButton;
    private JToggleButton quickViewButton;
    private JToggleButton byTypeButton;
    static /* synthetic */ Class class$org$netbeans$modules$javadoc$search$IndexSearch;
    static /* synthetic */ Class class$org$netbeans$api$javahelp$Help;
    static /* synthetic */ Class class$org$openide$cookies$OpenCookie;

    public IndexSearch() {
        this.initComponents();
        ((JComponent)((Object)this)).putClientProperty("TabPolicy", "HideWhenAlone");
        ComboBoxEditor editor = this.searchComboBox.getEditor();
        editor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (IndexSearch.this.searchEngine == null) {
                    IndexSearch.this.searchButtonActionPerformed(evt);
                }
            }
        });
        this.splitPanel = new SplittedPanel();
        this.splitPanel.setSplitType(1);
        this.splitPanel.setSplitAbsolute(false);
        this.splitPanel.setSplitPosition(this.oldSplit);
        this.splitPanel.setSplitDragable(true);
        this.splitPanel.setSplitTypeChangeEnabled(true);
        this.splitPanel.setPreferredSize(PREFFERED_SIZE);
        this.splitPanel.addSplitChangeListener(new SplittedPanel.SplitChangeListener(){

            public void splitChanged(SplittedPanel.SplitChangeEvent evt) {
                int value = evt.getNewValue();
                IndexSearch.this.ds.setIdxSearchSplit(value);
                if (value == 100) {
                    IndexSearch.this.quickViewButton.setSelected(false);
                    IndexSearch.this.ds.setIdxSearchNoHtml(true);
                } else {
                    IndexSearch.this.quickViewButton.setSelected(true);
                    IndexSearch.this.ds.setIdxSearchNoHtml(false);
                }
            }
        });
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        ((Container)((Object)this)).add((Component)this.splitPanel, gridBagConstraints1);
        this.resultsScrollPane = new JScrollPane();
        this.resultsList = new JList();
        this.resultsList.setSelectionMode(0);
        this.resultsList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                IndexSearch.this.resultsListKeyPressed(evt);
            }
        });
        this.resultsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                IndexSearch.this.resultsListMouseClicked(evt);
            }
        });
        this.resultsScrollPane.setViewportView(this.resultsList);
        this.splitPanel.add((Component)this.resultsScrollPane, SplittedPanel.ADD_FIRST);
        this.quickBrowser = new HtmlBrowser(true, false);
        this.quickBrowser.setEnableLocation(false);
        this.quickBrowser.setEnableHome(false);
        this.quickBrowser.setBorder(new EmptyBorder(new Insets(8, 0, 0, 0)));
        this.splitPanel.add((Component)this.quickBrowser, SplittedPanel.ADD_SECOND);
        DefaultListModel listModel = new DefaultListModel();
        this.resultsList.setModel(listModel);
        IndexListCellRenderer cr = new IndexListCellRenderer();
        this.resultsList.setCellRenderer(cr);
        this.resultsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                IndexSearch.this.showHelp(true);
            }
        });
        this.resultsScrollPane.validate();
        this.searchButton.setText(STR_FIND);
        this.sourceButton.setIcon(showSourceIcon);
        this.byReferenceButton.setIcon(refSortIcon);
        this.byTypeButton.setIcon(typeSortIcon);
        this.byNameButton.setIcon(alphaSortIcon);
        this.quickViewButton.setIcon(listHtmlIcon);
        this.quickViewButton.setSelectedIcon(listOnlyIcon);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.byReferenceButton);
        bg.add(this.byTypeButton);
        bg.add(this.byNameButton);
        this.searchButton.setToolTipText(ResourceUtils.getBundledString("CTL_SEARCH_search_ToolTip"));
        this.byReferenceButton.setToolTipText(ResourceUtils.getBundledString("CTL_SEARCH_byReference_ToolTip"));
        this.byReferenceButton.setMnemonic(ResourceUtils.getBundledString("CTL_SEARCH_byReference_Mnemonic").charAt(0));
        this.byTypeButton.setToolTipText(ResourceUtils.getBundledString("CTL_SEARCH_byType_ToolTip"));
        this.byTypeButton.setMnemonic(ResourceUtils.getBundledString("CTL_SEARCH_byType_Mnemonic").charAt(0));
        this.byNameButton.setToolTipText(ResourceUtils.getBundledString("CTL_SEARCH_byName_ToolTip"));
        this.byNameButton.setMnemonic(ResourceUtils.getBundledString("CTL_SEARCH_byName_Mnemonic").charAt(0));
        this.quickViewButton.setToolTipText(ResourceUtils.getBundledString("CTL_SEARCH_quickView_ToolTip"));
        this.quickViewButton.setMnemonic(ResourceUtils.getBundledString("CTL_SEARCH_quickView_Mnemonic").charAt(0));
        this.sourceButton.setToolTipText(ResourceUtils.getBundledString("CTL_SEARCH_showSource_ToolTip"));
        this.sourceButton.setMnemonic(ResourceUtils.getBundledString("CTL_SEARCH_showSource_Mnemonic").charAt(0));
        this.searchComboBox.setToolTipText(ResourceUtils.getBundledString("ACS_SEARCH_SearchComboBoxA11yDesc"));
        this.resultsList.setToolTipText(ResourceUtils.getBundledString("ACS_SEARCH_ResultsListA11yDesc"));
        this.quickBrowser.setToolTipText(ResourceUtils.getBundledString("ACS_SEARCH_QuickBrowserA11yDesc"));
        this.searchButton.setMnemonic(ResourceUtils.getBundledString("CTL_SEARCH_ButtonFind_Mnemonic").charAt(0));
        this.helpButton.setMnemonic(ResourceUtils.getBundledString("CTL_SEARCH_ButtonHelp_Mnemonic").charAt(0));
        this.initAccessibility();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(INDEX_SEARCH_HELP_CTX_KEY);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(ResourceUtils.getBundledString("ACS_SEARCH_PanelA11yName"));
        this.getAccessibleContext().setAccessibleDescription(ResourceUtils.getBundledString("ACS_SEARCH_PanelA11yDesc"));
        this.searchComboBox.getAccessibleContext().setAccessibleName(ResourceUtils.getBundledString("ACS_SEARCH_SearchComboBoxA11yName"));
        this.searchComboBox.getAccessibleContext().setAccessibleDescription(ResourceUtils.getBundledString("ACS_SEARCH_SearchComboBoxA11yDesc"));
        this.resultsList.getAccessibleContext().setAccessibleName(ResourceUtils.getBundledString("ACS_SEARCH_ResultsListA11yName"));
        this.resultsList.getAccessibleContext().setAccessibleDescription(ResourceUtils.getBundledString("ACS_SEARCH_ResultsListA11yDesc"));
        this.quickBrowser.getAccessibleContext().setAccessibleName(ResourceUtils.getBundledString("ACS_SEARCH_QuickBrowserA11yName"));
        this.quickBrowser.getAccessibleContext().setAccessibleDescription(ResourceUtils.getBundledString("ACS_SEARCH_QuickBrowserA11yDesc"));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.searchComboBox = new JComboBox();
        this.searchButton = new JButton();
        this.sourceButton = new JButton();
        this.byNameButton = new JToggleButton();
        this.byReferenceButton = new JToggleButton();
        this.byTypeButton = new JToggleButton();
        this.quickViewButton = new JToggleButton();
        this.helpButton = new JButton();
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        ((JComponent)((Object)this)).setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        this.jPanel1.setLayout(new GridBagLayout());
        this.searchComboBox.setEditable(true);
        this.searchComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IndexSearch.this.searchComboBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        this.jPanel1.add((Component)this.searchComboBox, gridBagConstraints);
        this.searchButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$javadoc$search$IndexSearch == null ? (class$org$netbeans$modules$javadoc$search$IndexSearch = IndexSearch.class$("org.netbeans.modules.javadoc.search.IndexSearch")) : class$org$netbeans$modules$javadoc$search$IndexSearch)).getString("IndexSearch.searchButton.text"));
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IndexSearch.this.searchButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel1.add((Component)this.searchButton, gridBagConstraints);
        this.sourceButton.setMinimumSize(new Dimension(25, 25));
        this.sourceButton.setPreferredSize(new Dimension(25, 25));
        this.sourceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IndexSearch.this.showSource(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jPanel1.add((Component)this.sourceButton, gridBagConstraints);
        this.byNameButton.setSelected(true);
        this.byNameButton.setActionCommand("A");
        this.byNameButton.setMinimumSize(new Dimension(25, 25));
        this.byNameButton.setPreferredSize(new Dimension(25, 25));
        this.byNameButton.setRequestFocusEnabled(false);
        this.byNameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IndexSearch.this.sortButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.byNameButton, new GridBagConstraints());
        this.byReferenceButton.setActionCommand("R");
        this.byReferenceButton.setMinimumSize(new Dimension(25, 25));
        this.byReferenceButton.setPreferredSize(new Dimension(25, 25));
        this.byReferenceButton.setRequestFocusEnabled(false);
        this.byReferenceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IndexSearch.this.sortButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.byReferenceButton, new GridBagConstraints());
        this.byTypeButton.setActionCommand("T");
        this.byTypeButton.setMinimumSize(new Dimension(25, 25));
        this.byTypeButton.setPreferredSize(new Dimension(25, 25));
        this.byTypeButton.setRequestFocusEnabled(false);
        this.byTypeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IndexSearch.this.sortButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.byTypeButton, new GridBagConstraints());
        this.quickViewButton.setSelected(true);
        this.quickViewButton.setRequestFocusEnabled(false);
        this.quickViewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IndexSearch.this.quickViewButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel1.add((Component)this.quickViewButton, gridBagConstraints);
        this.helpButton.setText(NbBundle.getBundle((Class)(class$org$netbeans$modules$javadoc$search$IndexSearch == null ? (class$org$netbeans$modules$javadoc$search$IndexSearch = IndexSearch.class$("org.netbeans.modules.javadoc.search.IndexSearch")) : class$org$netbeans$modules$javadoc$search$IndexSearch)).getString("CTL_SEARCH_ButtonHelp"));
        this.helpButton.setToolTipText(NbBundle.getBundle((Class)(class$org$netbeans$modules$javadoc$search$IndexSearch == null ? (class$org$netbeans$modules$javadoc$search$IndexSearch = IndexSearch.class$("org.netbeans.modules.javadoc.search.IndexSearch")) : class$org$netbeans$modules$javadoc$search$IndexSearch)).getString("CTL_SEARCH_ButtonHelp_tooltip"));
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IndexSearch.this.helpButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel1.add((Component)this.helpButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        ((Container)((Object)this)).add(this.jPanel1, gridBagConstraints);
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
        Help help = (Help)Lookup.getDefault().lookup(class$org$netbeans$api$javahelp$Help == null ? (class$org$netbeans$api$javahelp$Help = IndexSearch.class$("org.netbeans.api.javahelp.Help")) : class$org$netbeans$api$javahelp$Help);
        help.showHelp(this.getHelpCtx());
    }

    private void showSource(ActionEvent evt) {
        this.showSource();
    }

    private void sortButtonActionPerformed(ActionEvent evt) {
        this.currentSort = evt.getActionCommand();
        this.ds.setIdxSearchSort(this.currentSort);
        this.sortResults();
    }

    private void quickViewButtonActionPerformed(ActionEvent evt) {
        if (this.quickViewButton.isSelected()) {
            this.splitPanel.setSplitPosition(this.oldSplit == 100 ? 50 : this.oldSplit);
            this.ds.setIdxSearchSplit(this.oldSplit == 100 ? 50 : this.oldSplit);
            this.ds.setIdxSearchNoHtml(false);
            this.showHelp(true);
        } else {
            this.oldSplit = this.splitPanel.getSplitPosition();
            this.splitPanel.setSplitPosition(100);
            this.ds.setIdxSearchSplit(100);
            this.ds.setIdxSearchNoHtml(true);
        }
    }

    private void resultsListKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10 || evt.getKeyCode() == 32) {
            this.showHelp();
        }
    }

    private void resultsListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.isShiftDown()) {
                this.showSource();
                evt.consume();
            } else {
                this.showHelp();
            }
        }
    }

    private void showHelp() {
        this.showHelp(false);
    }

    private void showHelp(boolean quick) {
        if (quick && this.splitPanel.getSplitPosition() == 100) {
            return;
        }
        if (this.resultsList.getMinSelectionIndex() < 0) {
            return;
        }
        DocIndexItem dii = (DocIndexItem)this.resultsList.getModel().getElementAt(this.resultsList.getMinSelectionIndex());
        try {
            URL url = dii.getURL();
            if (url == null) {
                return;
            }
            String strUrl = url.toString();
            if (strUrl.startsWith("nbfs:") && strUrl.charAt(5) != '/') {
                url = new URL("nbfs:/" + strUrl.substring(5));
            }
            if (quick) {
                final URL furl = url;
                if (this.task != null) {
                    this.task.cancel();
                }
                this.task = RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        IndexSearch.this.quickBrowser.setURL(furl);
                    }
                }, 100);
            } else {
                HtmlBrowser.URLDisplayer.getDefault().showURL(url);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void showSource() {
        if (this.resultsList.getMinSelectionIndex() < 0) {
            return;
        }
        DocIndexItem dii = (DocIndexItem)this.resultsList.getModel().getElementAt(this.resultsList.getMinSelectionIndex());
        try {
            Element e = SrcFinder.findSource(dii.getPackage(), dii.getURL());
            if (e != null) {
                OpenCookie oc = (OpenCookie)e.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = IndexSearch.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
                if (oc != null) {
                    oc.open();
                } else {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ResourceUtils.getBundledString("MSG_SEARCH_SrcNotFound"));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
            } else {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ResourceUtils.getBundledString("MSG_SEARCH_SrcNotFound"));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void searchComboBoxActionPerformed(ActionEvent evt) {
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        if (this.searchEngine == null) {
            if (this.searchComboBox.getEditor().getItem().toString() != null && this.searchComboBox.getEditor().getItem().toString().length() > 0) {
                this.searchEngine = JavadocSearchEngine.getDefault();
                this.go();
            }
        } else {
            this.searchEngine.stop();
            this.searchEngine = null;
        }
    }

    private void searchStoped() {
        this.searchEngine = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IndexSearch.this.searchButton.setText(STR_FIND);
                IndexSearch.this.searchButton.setMnemonic(ResourceUtils.getBundledString("CTL_SEARCH_ButtonFind_Mnemonic").charAt(0));
                if (IndexSearch.this.resultsList.getModel().getSize() > 0) {
                    IndexSearch.this.resultsList.setSelectedIndex(0);
                    IndexSearch.this.resultsList.grabFocus();
                }
                IndexSearch.this.referenceModel = (IndexSearch.this.typeModel = (IndexSearch.this.alphaModel = null));
                IndexSearch.this.sortResults();
            }
        });
    }

    void setTextToFind(String toFind) {
        this.quickFind = toFind;
    }

    public void open() {
        super.open();
        if (this.quickFind != null) {
            this.searchComboBox.getEditor().setItem(this.quickFind);
            if (this.searchEngine == null) {
                this.searchButtonActionPerformed(null);
            }
        }
        this.quickFind = null;
        this.searchComboBox.getEditor().selectAll();
    }

    Dimension getPrefferedSize() {
        return PREFFERED_SIZE;
    }

    public static IndexSearch getDefault() {
        if (indexSearch == null) {
            indexSearch = new IndexSearch();
            Workspace workspace = WindowManager.getDefault().getCurrentWorkspace();
            JavadocModule.registerTopComponent(indexSearch);
            indexSearch.setName(ResourceUtils.getBundledString("CTL_SEARCH_WindowTitle"));
        }
        indexSearch.setIcon(windowIcon);
        return indexSearch;
    }

    public void resolveButtonState() {
        final String sort = this.ds.getIdxSearchSort();
        final boolean noHtml = this.ds.isIdxSearchNoHtml();
        final int split = this.ds.getIdxSearchSplit();
        this.currentSort = sort;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IndexSearch.this.byNameButton.setSelected(sort.equals("A"));
                IndexSearch.this.byReferenceButton.setSelected(sort.equals("R"));
                IndexSearch.this.byTypeButton.setSelected(sort.equals("T"));
                IndexSearch.this.quickViewButton.setSelected(!noHtml);
                IndexSearch.this.splitPanel.setSplitPosition(split);
            }
        });
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        indexSearch = this;
        this.resolveButtonState();
        indexSearch = IndexSearch.getDefault();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    void go() {
        String toFind = new String(this.searchComboBox.getEditor().getItem().toString());
        this.results = new ArrayList();
        this.referenceModel = null;
        this.typeModel = null;
        this.alphaModel = null;
        int i = 0;
        while (i < this.searchComboBox.getItemCount()) {
            if (this.searchComboBox.getItemAt(i).toString().equals(toFind) || i >= 10) {
                this.searchComboBox.removeItemAt(i);
            }
            ++i;
        }
        this.searchComboBox.insertItemAt(toFind, 0);
        this.searchComboBox.getEditor().setItem(toFind);
        this.resultsList.setModel(waitModel);
        try {
            this.searchEngine.search(new String[]{toFind}, new JavadocSearchEngine.SearchEngineCallback(){

                public void finished() {
                    IndexSearch.this.searchStoped();
                }

                public void addItem(DocIndexItem item) {
                    IndexSearch.this.results.add(item);
                }
            });
        }
        catch (NoJavadocException noJdc) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)noJdc.getMessage()));
            this.searchStoped();
            return;
        }
        this.searchButton.setText(STR_STOP);
        this.searchButton.setMnemonic(ResourceUtils.getBundledString("CTL_SEARCH_ButtonStop_Mnemonic").charAt(0));
    }

    DefaultListModel generateModel(Comparator comp) {
        DefaultListModel<DocIndexItem> model = new DefaultListModel<DocIndexItem>();
        Collections.sort(this.results, comp);
        Iterator it = ((AbstractList)this.results).iterator();
        String pckg = null;
        while (it.hasNext()) {
            DocIndexItem dii = (DocIndexItem)it.next();
            if (comp == DocIndexItem.REFERENCE_COMPARATOR && !dii.getPackage().equals(pckg) && dii.getIconIndex() != 1) {
                DocIndexItem ndii = new DocIndexItem("PACKAGE ", dii.getPackage(), null, "");
                ndii.setIconIndex(1);
                model.addElement(ndii);
                pckg = dii.getPackage();
            }
            model.addElement(dii);
        }
        return model;
    }

    void sortResults() {
        if (this.results.size() < 1) {
            this.resultsList.setModel(notModel);
        } else if (this.currentSort.equals("R")) {
            if (this.referenceModel == null) {
                this.resultsList.setModel(waitModel);
                this.resultsList.invalidate();
                this.resultsList.revalidate();
                this.referenceModel = this.generateModel(DocIndexItem.REFERENCE_COMPARATOR);
            }
            this.resultsList.setModel(this.referenceModel);
        } else if (this.currentSort.equals("T")) {
            if (this.typeModel == null) {
                this.resultsList.setModel(waitModel);
                this.resultsList.invalidate();
                this.resultsList.revalidate();
                this.typeModel = this.generateModel(DocIndexItem.TYPE_COMPARATOR);
            }
            this.resultsList.setModel(this.typeModel);
        } else if (this.currentSort.equals("A")) {
            if (this.alphaModel == null) {
                this.resultsList.setModel(waitModel);
                this.resultsList.invalidate();
                this.resultsList.revalidate();
                this.alphaModel = this.generateModel(DocIndexItem.ALPHA_COMPARATOR);
            }
            this.resultsList.setModel(this.alphaModel);
        }
        this.resultsList.invalidate();
        this.resultsList.revalidate();
        this.resultsList.repaint();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        refSortIcon = new ImageIcon((class$org$netbeans$modules$javadoc$search$IndexSearch == null ? (class$org$netbeans$modules$javadoc$search$IndexSearch = IndexSearch.class$("org.netbeans.modules.javadoc.search.IndexSearch")) : class$org$netbeans$modules$javadoc$search$IndexSearch).getResource("/org/netbeans/modules/javadoc/resources/refSort.gif"));
        typeSortIcon = new ImageIcon((class$org$netbeans$modules$javadoc$search$IndexSearch == null ? (class$org$netbeans$modules$javadoc$search$IndexSearch = IndexSearch.class$("org.netbeans.modules.javadoc.search.IndexSearch")) : class$org$netbeans$modules$javadoc$search$IndexSearch).getResource("/org/netbeans/modules/javadoc/resources/typeSort.gif"));
        alphaSortIcon = new ImageIcon((class$org$netbeans$modules$javadoc$search$IndexSearch == null ? (class$org$netbeans$modules$javadoc$search$IndexSearch = IndexSearch.class$("org.netbeans.modules.javadoc.search.IndexSearch")) : class$org$netbeans$modules$javadoc$search$IndexSearch).getResource("/org/netbeans/modules/javadoc/resources/alphaSort.gif"));
        listOnlyIcon = new ImageIcon((class$org$netbeans$modules$javadoc$search$IndexSearch == null ? (class$org$netbeans$modules$javadoc$search$IndexSearch = IndexSearch.class$("org.netbeans.modules.javadoc.search.IndexSearch")) : class$org$netbeans$modules$javadoc$search$IndexSearch).getResource("/org/netbeans/modules/javadoc/resources/list_only.gif"));
        listHtmlIcon = new ImageIcon((class$org$netbeans$modules$javadoc$search$IndexSearch == null ? (class$org$netbeans$modules$javadoc$search$IndexSearch = IndexSearch.class$("org.netbeans.modules.javadoc.search.IndexSearch")) : class$org$netbeans$modules$javadoc$search$IndexSearch).getResource("/org/netbeans/modules/javadoc/resources/list_html.gif"));
        showSourceIcon = new ImageIcon((class$org$netbeans$modules$javadoc$search$IndexSearch == null ? (class$org$netbeans$modules$javadoc$search$IndexSearch = IndexSearch.class$("org.netbeans.modules.javadoc.search.IndexSearch")) : class$org$netbeans$modules$javadoc$search$IndexSearch).getResource("/org/netbeans/modules/javadoc/resources/showSource.gif"));
        windowIcon = Toolkit.getDefaultToolkit().getImage((class$org$netbeans$modules$javadoc$search$IndexSearch == null ? (class$org$netbeans$modules$javadoc$search$IndexSearch = IndexSearch.class$("org.netbeans.modules.javadoc.search.IndexSearch")) : class$org$netbeans$modules$javadoc$search$IndexSearch).getResource(ICON_RESOURCE));
        STR_FIND = ResourceUtils.getBundledString("CTL_SEARCH_ButtonFind");
        STR_STOP = ResourceUtils.getBundledString("CTL_SEARCH_ButtonStop");
        waitModel = new DefaultListModel();
        notModel = new DefaultListModel();
        DocIndexItem dii = new DocIndexItem(ResourceUtils.getBundledString("CTL_SEARCH_Wait"), "", null, "");
        dii.setIconIndex(12);
        waitModel.addElement(dii);
        DocIndexItem diin = new DocIndexItem(ResourceUtils.getBundledString("CTL_SEARCH_NotFound"), "", null, "");
        diin.setIconIndex(11);
        notModel.addElement(diin);
    }
}

