/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import org.netbeans.modules.javadoc.search.JavaDocFSNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListener;

public class JavaDocChildren
extends Children.Keys
implements RepositoryListener {
    private PropertyChangeListener fsPCL = new fsChangeListener();
    private PropertyChangeListener wFsPCL = WeakListener.propertyChange((PropertyChangeListener)this.fsPCL, null);
    private PropertyChangeListener capabilityPCL = new capChangeListener();
    private PropertyChangeListener wCapabilityPCL = WeakListener.propertyChange((PropertyChangeListener)this.capabilityPCL, null);

    public JavaDocChildren() {
        Repository repository = Repository.getDefault();
        repository.addRepositoryListener(WeakListener.repository((RepositoryListener)this, (Object)repository));
        Enumeration fsEnum = repository.getFileSystems();
        while (fsEnum.hasMoreElements()) {
            FileSystem fs = (FileSystem)fsEnum.nextElement();
            fs.addPropertyChangeListener(this.wFsPCL);
            fs.getCapability().addPropertyChangeListener(this.wCapabilityPCL);
        }
    }

    protected void addNotify() {
        this.setKeys(this.getDocFileSystems());
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
    }

    protected Node[] createNodes(Object key) {
        try {
            DataFolder df = DataFolder.findFolder((FileObject)((FileSystem)key).getRoot());
            return new Node[]{new JavaDocFSNode(df, this.getFSChildren((FileSystem)key))};
        }
        catch (IntrospectionException introspectionException) {
            return new Node[0];
        }
    }

    private Collection getDocFileSystems() {
        Enumeration dfsEnum = FileSystemCapability.DOC.fileSystems();
        ArrayList<FileSystem> docFileSystems = new ArrayList<FileSystem>();
        while (dfsEnum.hasMoreElements()) {
            FileSystem fs = (FileSystem)dfsEnum.nextElement();
            docFileSystems.add(fs);
        }
        return docFileSystems;
    }

    void refreshFs(Object fs) {
        this.refreshKey(fs);
    }

    private Children getFSChildren(FileSystem fs) {
        DataFolder df = DataFolder.findFolder((FileObject)fs.getRoot());
        return df.createNodeChildren(DataFilter.ALL);
    }

    public void fileSystemAdded(RepositoryEvent ev) {
        FileSystem fs = ev.getFileSystem();
        fs.addPropertyChangeListener(this.wFsPCL);
        fs.getCapability().addPropertyChangeListener(this.wCapabilityPCL);
        this.setKeys(this.getDocFileSystems());
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent ev) {
        this.setKeys(this.getDocFileSystems());
    }

    public void fileSystemRemoved(RepositoryEvent ev) {
        FileSystem fs = ev.getFileSystem();
        fs.removePropertyChangeListener(this.wFsPCL);
        fs.getCapability().removePropertyChangeListener(this.wCapabilityPCL);
        this.setKeys(this.getDocFileSystems());
    }

    void refreshAll() {
        this.setKeys(this.getDocFileSystems());
    }

    class capChangeListener
    implements PropertyChangeListener {
        capChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("doc")) {
                JavaDocChildren.this.refreshAll();
            }
        }
    }

    class fsChangeListener
    implements PropertyChangeListener {
        fsChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("root")) {
                JavaDocChildren.this.refreshFs(evt.getSource());
            }
        }
    }
}

