/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashMap;
import org.netbeans.modules.javadoc.search.JavadocSearchType;
import org.netbeans.modules.javadoc.settings.DocumentationSettings;
import org.openide.ServiceType;
import org.openide.filesystems.FileSystem;

public class JavaDocFSSettings
implements Serializable,
PropertyChangeListener {
    static final long serialVersionUID = -1524542458662425748L;
    private String secondRoot;
    private ServiceType.Handle searchEngine;
    private String fsName;
    private static HashMap fsSetting;

    public static JavaDocFSSettings getSettingForFS(FileSystem fs) {
        String systemName;
        if (fsSetting == null) {
            fsSetting = DocumentationSettings.getDefault().getFileSystemSettings();
        }
        if (fsSetting.get(systemName = fs.getSystemName()) == null || !(fsSetting.get(systemName) instanceof JavaDocFSSettings)) {
            fsSetting.put(systemName, new JavaDocFSSettings(systemName));
            DocumentationSettings.getDefault().setFileSystemSettings(fsSetting);
        }
        return (JavaDocFSSettings)fsSetting.get(fs.getSystemName());
    }

    public JavaDocFSSettings() {
    }

    public JavaDocFSSettings(String fsName) {
        this.fsName = fsName;
    }

    public ServiceType getSearchEngine() {
        JavadocSearchType type = null;
        if (this.searchEngine != null) {
            type = (JavadocSearchType)this.searchEngine.getServiceType();
        }
        if (type == null) {
            type = JavaDocFSSettings.getDefaultJavaDocSearchType();
            if (type == null) {
                return null;
            }
            type.removePropertyChangeListener(this);
            fsSetting.put(this.fsName, this);
            DocumentationSettings.getDefault().setFileSystemSettings(fsSetting);
        }
        type.addPropertyChangeListener(this);
        return type;
    }

    public void setSearchEngine(ServiceType searchEngine) {
        this.searchEngine = searchEngine == null ? null : new ServiceType.Handle(searchEngine);
        searchEngine.removePropertyChangeListener((PropertyChangeListener)this);
        fsSetting.put(this.fsName, this);
        DocumentationSettings.getDefault().setFileSystemSettings(fsSetting);
        searchEngine.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public JavadocSearchType getSearchTypeEngine() {
        JavadocSearchType jst = (JavadocSearchType)this.getSearchEngine();
        return jst;
    }

    public String getSecondRoot() {
        return this.secondRoot;
    }

    public void setSecondRoot(String secondRoot) {
        this.secondRoot = secondRoot;
        fsSetting.put(this.fsName, this);
        DocumentationSettings.getDefault().setFileSystemSettings(fsSetting);
    }

    public static JavadocSearchType getDefaultJavaDocSearchType() {
        return (JavadocSearchType)DocumentationSettings.getDefault().getSearchEngine();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        fsSetting.put(this.fsName, this);
        DocumentationSettings.getDefault().setFileSystemSettings(fsSetting);
    }
}

