/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.netbeans.modules.javadoc.search.DocFileSystem;
import org.netbeans.modules.javadoc.search.DocIndexItem;
import org.netbeans.modules.javadoc.search.IndexSearchThread;
import org.netbeans.modules.javadoc.search.JavaDocFSSettings;
import org.netbeans.modules.javadoc.search.JavadocSearchEngine;
import org.netbeans.modules.javadoc.search.JavadocSearchType;
import org.netbeans.modules.javadoc.search.NoJavadocException;
import org.netbeans.modules.javadoc.search.SearchThreadJdk12;
import org.openide.filesystems.FileStateInvalidException;

class JavadocSearchEngineImpl
extends JavadocSearchEngine {
    private ArrayList tasks;
    private DocFileSystem[] docSystems;
    private IndexSearchThread.DocIndexItemConsumer diiConsumer;

    JavadocSearchEngineImpl() {
    }

    public void search(String[] items, final JavadocSearchEngine.SearchEngineCallback callback) throws NoJavadocException {
        this.docSystems = DocFileSystem.getFolders();
        this.tasks = new ArrayList(this.docSystems.length);
        this.diiConsumer = new IndexSearchThread.DocIndexItemConsumer(){

            public void addDocIndexItem(DocIndexItem dii) {
                callback.addItem(dii);
            }

            public void indexSearchThreadFinished(IndexSearchThread t) {
                ((AbstractCollection)JavadocSearchEngineImpl.this.tasks).remove(t);
                if (JavadocSearchEngineImpl.this.tasks.isEmpty()) {
                    callback.finished();
                }
            }
        };
        if (this.docSystems.length <= 0) {
            callback.finished();
            throw new NoJavadocException();
        }
        String toFind = items[0];
        int i = 0;
        while (i < this.docSystems.length) {
            try {
                JavaDocFSSettings setting = JavaDocFSSettings.getSettingForFS(this.docSystems[i].getIndexFile().getFileSystem());
                JavadocSearchType st = setting.getSearchTypeEngine();
                if (st != null) {
                    IndexSearchThread searchThread = st.getSearchThread(toFind, this.docSystems[i].getIndexFile(), this.diiConsumer);
                    this.tasks.add(searchThread);
                    searchThread.go();
                }
            }
            catch (FileStateInvalidException fsEx) {
                fsEx.printStackTrace();
            }
            ++i;
        }
    }

    public void stop() {
        int i = 0;
        while (i < this.tasks.size()) {
            SearchThreadJdk12 searchThread = (SearchThreadJdk12)this.tasks.get(i);
            searchThread.finish();
            ++i;
        }
    }
}

