/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.netbeans.modules.javadoc.search.IndexSearchThread;
import org.openide.ErrorManager;
import org.openide.ServiceType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public abstract class JavadocSearchType
extends ServiceType {
    static final long serialVersionUID = -7643543247564581246L;
    private RE[] overviewLabelFilters;

    public abstract FileObject getDocFileObject(FileSystem var1, String var2);

    private synchronized void prepareOverviewFilter() {
        if (this.overviewLabelFilters != null) {
            return;
        }
        String filter = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"FILTER_OverviewIndiceLabel");
        StringTokenizer tok = new StringTokenizer(filter, "\n");
        LinkedList<RE> ll = new LinkedList<RE>();
        int i = 0;
        while (tok.hasMoreTokens()) {
            try {
                RECompiler rec = new RECompiler();
                String expr = tok.nextToken();
                REProgram rep = rec.compile(expr);
                RE re = new RE(rep, 1);
                ll.add(re);
            }
            catch (RESyntaxException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            ++i;
        }
        this.overviewLabelFilters = ll.toArray(new RE[ll.size()]);
    }

    public String getOverviewTitleBase(String overviewTitle) {
        this.prepareOverviewFilter();
        RE match = null;
        String t = overviewTitle.trim();
        int i = 0;
        while (i < this.overviewLabelFilters.length) {
            if (this.overviewLabelFilters[i].match(t)) {
                match = this.overviewLabelFilters[i];
                break;
            }
            ++i;
        }
        if (match == null) {
            return overviewTitle;
        }
        return match.getParen(1);
    }

    public abstract IndexSearchThread getSearchThread(String var1, FileObject var2, IndexSearchThread.DocIndexItemConsumer var3);
}

