/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.netbeans.modules.javadoc.search.DocIndexItem;
import org.netbeans.modules.javadoc.search.IndexSearchThread;
import org.netbeans.modules.javadoc.search.ResourceUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;

class SearchThreadJdk12_japan
extends IndexSearchThread {
    private BufferedReader in;
    private URL contextURL;
    private boolean stopSearch = false;
    private boolean splitedIndex = false;
    private int currentIndexNumber;
    private FileObject folder = null;
    private String JapanEncoding;
    private static final String STR_CLASS = ResourceUtils.getBundledString("JDK12_CLASS");
    private static final String STR_INTERFACE = ResourceUtils.getBundledString("JDK12_INTERFACE");
    private static final String STR_EXCEPTION = ResourceUtils.getBundledString("JDK12_EXCEPTION");
    private static final String STR_CONSTRUCTOR = ResourceUtils.getBundledString("JDK12_CONSTRUCTOR");
    private static final String STR_METHOD = ResourceUtils.getBundledString("JDK12_METHOD");
    private static final String STR_ERROR = ResourceUtils.getBundledString("JDK12_ERROR");
    private static final String STR_VARIABLE = ResourceUtils.getBundledString("JDK12_VARIABLE");
    private static final String STR_STATIC = ResourceUtils.getBundledString("JDK12_STATIC");
    private static final String STR_DASH = ResourceUtils.getBundledString("JDK12_DASH");
    private static final String STR_PACKAGE = ResourceUtils.getBundledString("JDK12_PACKAGE");
    private static final String STR_CONSTRUCTOR_JA = ResourceUtils.getBundledString("JDK12_CONSTRUCTOR_JA");
    private static final String STR_METHOD_JA = ResourceUtils.getBundledString("JDK12_METHOD_JA");
    private static final String STR_VARIABLE_JA = ResourceUtils.getBundledString("JDK12_VARIABLE_JA");
    private static final int IN_BALAST = 0;
    private static final int IN_DT = 1;
    private static final int IN_AREF = 2;
    private static final int IN_B = 3;
    private static final int IN_DESCRIPTION = 4;
    private static final int IN_DESCRIPTION_SUFFIX = 5;

    public SearchThreadJdk12_japan(String toFind, FileObject fo, IndexSearchThread.DocIndexItemConsumer diiConsumer, boolean caseSensitive, String JapanEncoding) {
        super(toFind, fo, diiConsumer, caseSensitive);
        this.JapanEncoding = JapanEncoding;
        if (fo.isFolder()) {
            this.folder = fo;
            this.currentIndexNumber = Character.toUpperCase(this.lastField.charAt(0)) - 65 + 1;
            if (this.currentIndexNumber < 1) {
                this.currentIndexNumber = 1;
            } else if (this.currentIndexNumber > 26) {
                this.currentIndexNumber = 27;
            }
            this.findFileObject(0);
            this.splitedIndex = true;
        } else {
            try {
                this.contextURL = this.fo.getURL();
            }
            catch (FileStateInvalidException e) {
                throw new InternalError("Can't create documentation folder URL - file state invalid");
            }
            this.splitedIndex = false;
        }
    }

    public void stopSearch() {
        this.stopSearch = true;
        try {
            this.in.close();
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    public void run() {
        ParserDelegator pd = new ParserDelegator();
        if (this.fo == null || this.lastField == null || this.lastField.length() == 0) {
            this.taskFinished();
            return;
        }
        SearchCallbackJdk12_japan sc = null;
        int theDirection = 0;
        do {
            if (sc != null) {
                if (sc.badFile != theDirection) break;
                this.findFileObject(sc.badFile);
                if (this.fo == null) break;
            }
            try {
                this.in = new BufferedReader(new InputStreamReader(this.fo.getInputStream(), this.JapanEncoding));
                sc = new SearchCallbackJdk12_japan(this.splitedIndex, this.caseSensitive);
                pd.parse(this.in, sc, true);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (sc.badFile == 0 || theDirection != 0) continue;
            theDirection = sc.badFile;
        } while (sc.badFile != 0);
        try {
            this.in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.taskFinished();
    }

    void findFileObject(int direction) {
        if (direction < 0) {
            --this.currentIndexNumber;
        } else if (direction > 0) {
            ++this.currentIndexNumber;
        }
        do {
            if (this.currentIndexNumber < 0 || this.currentIndexNumber > 27) {
                this.fo = null;
                return;
            }
            Integer fileNumber = new Integer(this.currentIndexNumber);
            String fileName = new String("index-" + fileNumber.toString());
            if (this.folder == null) {
                this.fo = null;
                return;
            }
            this.fo = this.folder.getFileObject(fileName, "html");
            if (this.fo != null) {
                try {
                    this.contextURL = this.fo.getURL();
                }
                catch (FileStateInvalidException e) {
                    throw new InternalError("Can't create documentation folder URL - file state invalid");
                }
            } else {
                this.currentIndexNumber += direction > 0 ? 1 : -1;
            }
        } while (this.fo == null);
    }

    private class SearchCallbackJdk12_japan
    extends HTMLEditorKit.ParserCallback {
        private String hrefVal;
        private DocIndexItem currentDii = null;
        private int where = 0;
        private boolean splited;
        private boolean stopOnNext = false;
        private int badFile = 0;
        int printText = 0;

        SearchCallbackJdk12_japan(boolean splited, boolean caseSensitive) {
            this.splited = splited;
        }

        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            if (t == HTML.Tag.DT) {
                this.where = 1;
                this.currentDii = null;
            } else if (t == HTML.Tag.A && this.where == 1) {
                this.where = 2;
                Object val = a.getAttribute(HTML.Attribute.HREF);
                if (val != null) {
                    this.hrefVal = val.toString();
                    this.currentDii = new DocIndexItem(null, null, SearchThreadJdk12_japan.this.contextURL, this.hrefVal);
                }
            } else if (t != HTML.Tag.A || this.where != 5) {
                this.where = t == HTML.Tag.B && this.where == 2 ? 2 : 0;
            }
        }

        public void handleText(char[] data, int pos) {
            if (this.where == 2) {
                char curr;
                char first;
                if (this.stopOnNext) {
                    try {
                        SearchThreadJdk12_japan.this.in.close();
                        this.where = 0;
                        return;
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
                String text = new String(data);
                if (this.splited && (first = Character.toUpperCase(SearchThreadJdk12_japan.this.lastField.charAt(0))) != (curr = Character.toUpperCase(data[0]))) {
                    this.badFile = first < curr ? -1 : 1;
                    try {
                        SearchThreadJdk12_japan.this.in.close();
                        this.where = 0;
                        return;
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
                this.currentDii.setField(text.trim());
                this.where = 4;
            } else if (this.where == 4) {
                String text = new String(data);
                this.currentDii.setRemark(text);
                StringTokenizer st = new StringTokenizer(text);
                String token = st.nextToken();
                if (token.equals(STR_DASH)) {
                    token = st.nextToken();
                }
                boolean isStatic = false;
                if (token.equalsIgnoreCase(STR_STATIC)) {
                    isStatic = true;
                    token = st.nextToken();
                }
                if (token.equalsIgnoreCase(STR_CLASS)) {
                    this.currentDii.setIconIndex(2);
                } else if (token.equalsIgnoreCase(STR_INTERFACE)) {
                    this.currentDii.setIconIndex(3);
                } else if (token.equalsIgnoreCase(STR_EXCEPTION)) {
                    this.currentDii.setIconIndex(4);
                } else if (token.equalsIgnoreCase(STR_ERROR)) {
                    this.currentDii.setIconIndex(5);
                } else if (token.equalsIgnoreCase(STR_PACKAGE)) {
                    this.currentDii.setIconIndex(1);
                } else if (token.equalsIgnoreCase(STR_CONSTRUCTOR)) {
                    this.currentDii.setIconIndex(6);
                } else if (token.equalsIgnoreCase(STR_METHOD)) {
                    this.currentDii.setIconIndex(isStatic ? 8 : 7);
                } else if (token.equalsIgnoreCase(STR_VARIABLE)) {
                    this.currentDii.setIconIndex(isStatic ? 10 : 9);
                }
                if (text.endsWith(".")) {
                    this.where = 5;
                    this.currentDii.setPackage(text.substring(text.lastIndexOf(32)).trim());
                } else {
                    this.where = 0;
                }
            } else if (this.where == 5) {
                boolean isStatic = false;
                String text = new String(data);
                this.currentDii.setRemark(this.currentDii.getRemark() + text);
                String declaringClass = new String(data).trim();
                if (!".".equals(declaringClass)) {
                    this.currentDii.setDeclaringClass(declaringClass);
                    text = text.toUpperCase();
                    if (text.indexOf(STR_STATIC) != -1) {
                        isStatic = true;
                    }
                    if (text.indexOf(STR_CONSTRUCTOR_JA) != -1) {
                        this.currentDii.setIconIndex(6);
                    } else if (text.indexOf(STR_METHOD_JA) != -1) {
                        this.currentDii.setIconIndex(isStatic ? 8 : 7);
                    } else if (text.indexOf(STR_VARIABLE_JA) != -1) {
                        this.currentDii.setIconIndex(isStatic ? 10 : 9);
                    }
                    SearchThreadJdk12_japan.this.insertDocIndexItem(this.currentDii);
                }
            } else {
                this.where = 0;
            }
        }
    }
}

