/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search.environment;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.netbeans.modules.javadoc.search.environment.JavadocArchive;
import org.netbeans.modules.javadoc.search.environment.JavadocDirectory;
import org.netbeans.modules.javadoc.search.environment.JavadocHttp;
import org.netbeans.modules.javadoc.search.environment.Utilities;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.loaders.XMLDataObject;
import org.openide.modules.InstalledFileLocator;
import org.xml.sax.AttributeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class JavadocProcessor
implements XMLDataObject.Processor,
InstanceCookie {
    static final String JAVADOC_DTD_PUBLIC_ID = "-//NetBeans IDE//DTD JavadocLibrary//EN";
    static final String TAG_JAVADOC = "Javadoc";
    static final String TAG_ARCHIVE = "Archive";
    static final String TAG_FOLDER = "Folder";
    static final String TAG_HTTP = "Http";
    static final String ATTR_NAME = "name";
    private static final char FILE_SEPARATOR = File.separatorChar;
    protected XMLDataObject xmlDataObject;
    FileSystem libraryFileSystem;
    static /* synthetic */ Class class$org$openide$filesystems$FileSystem;

    public void attachTo(XMLDataObject xmlDO) {
        this.xmlDataObject = xmlDO;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        if (this.libraryFileSystem != null) {
            return this.libraryFileSystem;
        }
        File directory = null;
        String fileSep = System.getProperty("file.separator");
        try {
            directory = new File(System.getProperty("netbeans.user") + fileSep + "javadoc").getCanonicalFile();
        }
        catch (IOException e) {
            directory = new File(System.getProperty("netbeans.user") + fileSep + "javadoc").getAbsoluteFile();
        }
        if (!directory.isDirectory()) {
            directory.mkdirs();
        }
        this.loadLibrary(this.xmlDataObject);
        return this.libraryFileSystem;
    }

    public Class instanceClass() {
        return class$org$openide$filesystems$FileSystem == null ? (class$org$openide$filesystems$FileSystem = JavadocProcessor.class$("org.openide.filesystems.FileSystem")) : class$org$openide$filesystems$FileSystem;
    }

    public String instanceName() {
        return this.instanceClass().getName();
    }

    void throwIllegalMountException(String key, String mountedResource) throws SAXException {
        ErrorManager man = ErrorManager.getDefault();
        String message = MessageFormat.format(Utilities.getString(key), mountedResource, this.xmlDataObject.getPrimaryFile().toString());
        throw (SAXException)man.annotate((Throwable)new SAXException("Mount resource not found"), 256, null, message, null, null);
    }

    private void loadLibrary(final XMLDataObject xml) throws IOException {
        HandlerBase handler = new HandlerBase(){
            private boolean inJavadoc = false;

            public void startElement(String name, AttributeList attrlist) throws SAXException {
                File archiveRoot;
                if (JavadocProcessor.TAG_JAVADOC.equals(name)) {
                    this.inJavadoc = true;
                } else if (!this.inJavadoc || !JavadocProcessor.TAG_ARCHIVE.equals(name) && !JavadocProcessor.TAG_FOLDER.equals(name) && !JavadocProcessor.TAG_HTTP.equals(name)) {
                    JavadocProcessor.this.throwIllegalMountException("FMT_ILLEGAL_RESOURCE_SPEC", null);
                }
                String nameString = attrlist.getValue(JavadocProcessor.ATTR_NAME);
                if (nameString == null) {
                    return;
                }
                String systemName = xml.getPrimaryFile().getPackageNameExt('/', '.');
                if (systemName.equals("")) {
                    return;
                }
                if (JavadocProcessor.TAG_HTTP.equals(name)) {
                    try {
                        JavadocHttp httpFs = new JavadocHttp(systemName);
                        httpFs.setURL(nameString);
                        JavadocProcessor.this.libraryFileSystem = httpFs;
                        return;
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                if (FILE_SEPARATOR != '/') {
                    nameString.replace('/', FILE_SEPARATOR);
                }
                if ((archiveRoot = InstalledFileLocator.getDefault().locate(nameString, null, false)) == null) {
                    JavadocProcessor.this.throwIllegalMountException("FMT_RESOURCE_NOT_FOUND", nameString);
                }
                try {
                    Object jfs;
                    if (JavadocProcessor.TAG_ARCHIVE.equals(name)) {
                        jfs = new JavadocArchive(systemName);
                        jfs.setJarFile(archiveRoot);
                        JavadocProcessor.this.libraryFileSystem = jfs;
                    } else if (JavadocProcessor.TAG_FOLDER.equals(name)) {
                        jfs = new JavadocDirectory(systemName);
                        jfs.setRootDirectory(archiveRoot);
                        JavadocProcessor.this.libraryFileSystem = jfs;
                    } else {
                        JavadocProcessor.this.throwIllegalMountException("FMT_ILLEGAL_RESOURCE_SPEC", null);
                    }
                    JavadocProcessor.this.libraryFileSystem.setHidden(true);
                    FileSystemCapability capab = JavadocProcessor.this.libraryFileSystem.getCapability();
                    if (capab instanceof FileSystemCapability.Bean) {
                        FileSystemCapability.Bean bean = (FileSystemCapability.Bean)capab;
                        bean.setCompile(false);
                        bean.setExecute(false);
                        bean.setDebug(false);
                        bean.setDoc(true);
                    }
                }
                catch (PropertyVetoException ex) {
                    JavadocProcessor.this.libraryFileSystem = null;
                    JavadocProcessor.this.throwIllegalMountException("FMT_ILLEGAL_RESOURCE_SPEC", null);
                    return;
                }
                catch (IOException ex) {
                    JavadocProcessor.this.libraryFileSystem = null;
                    JavadocProcessor.this.throwIllegalMountException("FMT_ILLEGAL_RESOURCE_SPEC", null);
                    return;
                }
            }

            public void endElement(String name) throws SAXException {
                if (JavadocProcessor.TAG_JAVADOC.equals(name)) {
                    this.inJavadoc = false;
                }
            }
        };
        Parser parser = XMLDataObject.createParser();
        parser.setDocumentHandler(handler);
        parser.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String pubid, String sysid) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
        });
        try {
            parser.parse(new InputSource(xml.getPrimaryFile().getInputStream()));
        }
        catch (SAXException e) {
            IOException ex = new IOException();
            ErrorManager.getDefault().annotate((Throwable)ex, (Throwable)e);
            throw ex;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

