/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util.xml;

import java.lang.reflect.Method;
import java.util.Stack;
import org.apache.catalina.util.xml.SaxContext;
import org.apache.catalina.util.xml.XmlAction;

class MethodSetter
extends XmlAction {
    String mName;
    int paramC;
    String[] paramTypes;
    static final Class STRING_CLASS = "String".getClass();

    public MethodSetter(String mName, int paramC) {
        this.mName = mName;
        this.paramC = paramC;
    }

    public MethodSetter(String mName, int paramC, String[] paramTypes) {
        this.mName = mName;
        this.paramC = paramC;
        this.paramTypes = paramTypes;
    }

    public void start(SaxContext ctx) {
        Stack st = ctx.getObjectStack();
        if (this.paramC == 0) {
            return;
        }
        String[] params = new String[this.paramC];
        st.push(params);
    }

    public void end(SaxContext ctx) throws Exception {
        Stack st = ctx.getObjectStack();
        String[] params = null;
        if (this.paramC > 0) {
            params = (String[])st.pop();
        }
        Object parent = st.peek();
        if (this.paramC == 0) {
            params = new String[]{ctx.getBody().trim()};
            if (ctx.getDebug() > 0) {
                ctx.log("" + parent.getClass().getName() + "." + this.mName + "( " + params[0] + ")");
            }
        }
        Class[] paramT = new Class[params.length];
        Object[] realParam = new Object[params.length];
        int i = 0;
        while (i < params.length) {
            if (this.paramTypes == null) {
                realParam[i] = params[i];
                paramT[i] = STRING_CLASS;
            } else if ("int".equals(this.paramTypes[i])) {
                realParam[i] = new Integer(params[i]);
                paramT[i] = Integer.TYPE;
            } else {
                realParam[i] = params[i];
                paramT[i] = STRING_CLASS;
            }
            ++i;
        }
        Method m = null;
        try {
            m = parent.getClass().getMethod(this.mName, paramT);
        }
        catch (NoSuchMethodException ex) {
            ctx.log("Can't find method " + this.mName + " in " + parent + " CLASS " + parent.getClass());
            return;
        }
        m.invoke(parent, realParam);
        if (ctx.getDebug() > 0 && this.paramC > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("" + parent.getClass().getName() + "." + this.mName + "( ");
            int i2 = 0;
            while (i2 < this.paramC) {
                if (i2 > 0) {
                    sb.append(", ");
                }
                sb.append(params[i2]);
                ++i2;
            }
            sb.append(")");
            ctx.log(sb.toString());
        }
    }
}

