/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.util.Collection;
import java.util.Iterator;
import org.netbeans.tax.AbstractUtil;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeCharacterReference;
import org.netbeans.tax.TreeData;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeElement;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeGeneralEntityReference;
import org.netbeans.tax.TreeName;
import org.netbeans.tax.TreeNamedObjectMap;
import org.netbeans.tax.TreeNamespace;
import org.netbeans.tax.TreeNamespaceContext;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeObjectList;
import org.netbeans.tax.TreeText;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.Util;
import org.netbeans.tax.spec.Element;

public class TreeAttribute
extends TreeNode
implements Element.Attribute,
TreeNamedObjectMap.NamedObject {
    public static final String PROP_NAME = "name";
    public static final String PROP_VALUE = "value";
    public static final String PROP_OWNER_ELEMENT = "ownerElement";
    public static final String PROP_SPECIFIED = "specified";
    private TreeElement ownerElement;
    private TreeName name;
    private TreeObjectList valueList;
    private boolean specified;
    private TreeNamedObjectMap.KeyListener mapKeyListener;

    public TreeAttribute(String qName, String value, boolean specified) throws InvalidArgumentException {
        TreeName treeName = new TreeName(qName);
        this.checkName(treeName);
        this.checkValue(value);
        this.name = treeName;
        this.specified = specified;
        this.valueList = new TreeObjectList(this.createValueListContentManager());
        this.setValueImpl(value);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeAttribute::INIT : name = " + qName + " : specified = " + specified);
        }
    }

    public TreeAttribute(String qName, String value) throws InvalidArgumentException {
        this(qName, value, true);
    }

    protected TreeAttribute(TreeAttribute attribute) {
        super(attribute);
        this.name = attribute.name;
        this.specified = true;
        this.valueList = new TreeObjectList(this.createValueListContentManager());
        this.valueList.addAll((Collection)((TreeObjectList)attribute.valueList.clone()));
    }

    public Object clone() {
        return new TreeAttribute(this);
    }

    public boolean equals(Object object, boolean deep) {
        if (!super.equals(object, deep)) {
            return false;
        }
        TreeAttribute peer = (TreeAttribute)object;
        if (!AbstractUtil.equals(this.getTreeName(), peer.getTreeName())) {
            return false;
        }
        if (this.specified != peer.isSpecified()) {
            return false;
        }
        return AbstractUtil.equals(this.valueList, peer.valueList);
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeAttribute peer = (TreeAttribute)treeObject;
        try {
            this.setTreeNameImpl(peer.getTreeName());
            this.setSpecifiedImpl(peer.isSpecified());
            this.valueList.merge(peer.valueList);
        }
        catch (Exception exc) {
            throw new CannotMergeException(treeObject, exc);
        }
    }

    protected void setReadOnly(boolean newReadOnly) {
        super.setReadOnly(newReadOnly);
        this.valueList.setReadOnly(newReadOnly);
    }

    public final boolean isInContext() {
        return this.getOwnerElement() != null;
    }

    public final void removeFromContext() throws ReadOnlyException {
        if (this.isInContext()) {
            this.getOwnerElement().removeAttribute(this);
        }
    }

    public final String getQName() {
        return this.name.getQualifiedName();
    }

    public final void setQName(String name) throws ReadOnlyException, InvalidArgumentException {
        this.setTreeName(new TreeName(name));
    }

    public final TreeName getTreeName() {
        return this.name;
    }

    private final void setTreeNameImpl(TreeName newName) {
        TreeName oldName = this.name;
        this.name = newName;
        this.fireMapKeyChanged(oldName);
        this.firePropertyChange(PROP_NAME, oldName, newName);
    }

    public final void setTreeName(TreeName newName) throws ReadOnlyException, InvalidArgumentException {
        if (AbstractUtil.equals(this.name, newName)) {
            return;
        }
        this.checkReadOnly();
        this.checkName(newName);
        this.setTreeNameImpl(newName);
    }

    protected final void checkName(TreeName name) throws InvalidArgumentException {
        TreeUtilities.checkAttributeName(name);
    }

    public boolean isSpecified() {
        return this.specified;
    }

    private void setSpecifiedImpl(boolean newValue) {
        if (this.specified == newValue) {
            return;
        }
        Boolean oldValue = this.specified ? Boolean.TRUE : Boolean.FALSE;
        this.specified = newValue;
        this.firePropertyChange(PROP_SPECIFIED, oldValue, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    public final TreeObjectList getValueList() {
        return this.valueList;
    }

    public final String getValue() {
        StringBuffer value = new StringBuffer(23);
        Iterator it = this.valueList.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (next instanceof TreeData) {
                value.append(((TreeData)next).getData());
                continue;
            }
            if (next instanceof TreeGeneralEntityReference) {
                value.append("&" + ((TreeGeneralEntityReference)next).getName() + ";");
                continue;
            }
            if (!(next instanceof TreeCharacterReference)) continue;
            value.append(((TreeCharacterReference)next).getData());
        }
        return value.toString();
    }

    public final String getNonNormalizedValue() {
        StringBuffer value = new StringBuffer(23);
        Iterator it = this.valueList.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (next instanceof TreeData) {
                value.append(((TreeData)next).getData());
                continue;
            }
            if (next instanceof TreeGeneralEntityReference) {
                value.append("&" + ((TreeGeneralEntityReference)next).getName() + ";");
                continue;
            }
            if (!(next instanceof TreeCharacterReference)) continue;
            value.append("&" + ((TreeCharacterReference)next).getName() + ";");
        }
        return value.toString();
    }

    private final void setValueImpl(String newValue) {
        String oldValue = this.getValue();
        this.valueList.clear();
        if (newValue.length() != 0) {
            try {
                TreeText newText = new TreeText(newValue);
                this.valueList.add(newText);
            }
            catch (TreeException treeException) {
                // empty catch block
            }
        }
        this.firePropertyChange(PROP_VALUE, oldValue, newValue);
    }

    public final void setValue(String newValue) throws ReadOnlyException, InvalidArgumentException {
        if (AbstractUtil.equals(this.getValue(), newValue)) {
            return;
        }
        this.checkReadOnly();
        this.checkValue(newValue);
        this.setValueImpl(newValue);
    }

    protected final void checkValue(String value) throws InvalidArgumentException {
        TreeUtilities.checkAttributeValue(value);
    }

    public final TreeNamespace getNamespace() {
        if (this.getOwnerElement() != null) {
            String prefix;
            TreeElement owner = this.getOwnerElement();
            TreeNamespaceContext ctx = owner.getNamespaceContext();
            String uri = ctx.getURI(prefix = this.getNamespacePrefix());
            if (uri == null) {
                return TreeNamespace.NO_NAMESPACE;
            }
            return new TreeNamespace(prefix, uri);
        }
        return TreeNamespace.NO_NAMESPACE;
    }

    public final String getNamespacePrefix() {
        return this.name.getPrefix();
    }

    public final String getNamespaceURI() {
        return this.getNamespace().getURI();
    }

    public final String getLocalName() {
        return this.name.getName();
    }

    public Object mapKey() {
        return this.getTreeName();
    }

    public void setKeyListener(TreeNamedObjectMap.KeyListener keyListener) {
        this.mapKeyListener = keyListener;
    }

    private void fireMapKeyChanged(Object oldKey) {
        if (this.mapKeyListener == null) {
            return;
        }
        this.mapKeyListener.mapKeyChanged(oldKey);
    }

    public final TreeDocumentRoot getOwnerDocument() {
        if (this.getOwnerElement() == null) {
            return null;
        }
        return this.getOwnerElement().getOwnerDocument();
    }

    public final TreeElement getOwnerElement() {
        return this.ownerElement;
    }

    protected final void setOwnerElement(TreeElement newOwnerElement) {
        if (AbstractUtil.equals(this.ownerElement, newOwnerElement)) {
            return;
        }
        TreeElement oldOwnerElement = this.ownerElement;
        this.ownerElement = newOwnerElement;
        this.firePropertyChange(this.getEventChangeSupport().createEvent(PROP_OWNER_ELEMENT, oldOwnerElement, newOwnerElement));
    }

    protected TreeObjectList.ContentManager createValueListContentManager() {
        return new ValueListContentManager();
    }

    protected class ValueListContentManager
    extends TreeObjectList.ContentManager {
        static /* synthetic */ Class class$org$netbeans$tax$spec$Attribute$Value;

        protected ValueListContentManager() {
        }

        public TreeNode getOwnerNode() {
            return TreeAttribute.this;
        }

        public void checkAssignableObject(Object obj) {
            super.checkAssignableObject(obj);
            this.checkAssignableClass(class$org$netbeans$tax$spec$Attribute$Value == null ? (class$org$netbeans$tax$spec$Attribute$Value = ValueListContentManager.class$("org.netbeans.tax.spec.Attribute$Value")) : class$org$netbeans$tax$spec$Attribute$Value, obj);
        }

        public void objectInserted(TreeObject obj) {
            TreeAttribute.this.firePropertyChange(TreeAttribute.PROP_VALUE, TreeAttribute.this.valueList, obj);
        }

        public void objectRemoved(TreeObject obj) {
            TreeAttribute.this.firePropertyChange(TreeAttribute.PROP_VALUE, TreeAttribute.this.valueList, obj);
        }

        public void orderChanged(int[] permutation) {
            TreeAttribute.this.firePropertyChange(TreeAttribute.PROP_VALUE, TreeAttribute.this.valueList, permutation);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

