/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import org.netbeans.tax.AbstractUtil;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeCharacterData;
import org.netbeans.tax.TreeChild;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeReference;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.spec.Attribute;
import org.netbeans.tax.spec.DocumentFragment;
import org.netbeans.tax.spec.Element;
import org.netbeans.tax.spec.GeneralEntityReference;

public class TreeCharacterReference
extends TreeChild
implements TreeReference,
TreeCharacterData,
DocumentFragment.Child,
Element.Child,
GeneralEntityReference.Child,
Attribute.Value {
    public static final String PROP_NAME = "name";
    private String name;

    public TreeCharacterReference(String name) throws InvalidArgumentException {
        this.checkName(name);
        this.name = name;
    }

    protected TreeCharacterReference(TreeCharacterReference characterReference) {
        super(characterReference);
        this.name = characterReference.name;
    }

    public Object clone() {
        return new TreeCharacterReference(this);
    }

    public boolean equals(Object object, boolean deep) {
        if (!super.equals(object, deep)) {
            return false;
        }
        TreeCharacterReference peer = (TreeCharacterReference)object;
        return AbstractUtil.equals(this.getName(), peer.getName());
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeCharacterReference peer = (TreeCharacterReference)treeObject;
        this.setNameImpl(peer.getName());
    }

    public final String getName() {
        return this.name;
    }

    private final void setNameImpl(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChange(PROP_NAME, oldName, newName);
    }

    public final void setName(String newName) throws ReadOnlyException, InvalidArgumentException {
        if (AbstractUtil.equals(this.name, newName)) {
            return;
        }
        this.checkReadOnly();
        this.checkName(newName);
        this.setNameImpl(newName);
    }

    protected final void checkName(String name) throws InvalidArgumentException {
        TreeUtilities.checkCharacterReferenceName(name);
    }

    public final String getData() {
        short val = this.name.startsWith("#x") ? Short.parseShort(this.name.substring(2), 16) : Short.parseShort(this.name.substring(1));
        return new String(new char[]{(char)val});
    }
}

