/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.jpda.RemoteDebuggerInfo;
import org.netbeans.modules.debugger.support.SecondaryDebuggerSupport;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.JavaDebuggerSettings;
import org.netbeans.modules.j2ee.impl.DefaultExecPerformer;
import org.netbeans.modules.j2ee.impl.ProgressObject;
import org.netbeans.modules.j2ee.server.DebugInfo;
import org.netbeans.modules.j2ee.server.ServerEvent;
import org.netbeans.modules.j2ee.server.ServerException;
import org.netbeans.modules.j2ee.server.ServerInstance;
import org.netbeans.modules.j2ee.server.ServerListener;
import org.netbeans.modules.j2ee.server.ServerOutput;
import org.netbeans.modules.j2ee.server.ServerStatus;
import org.netbeans.modules.j2ee.server.datamodel.ModuleChangeEvent;
import org.netbeans.modules.j2ee.server.datamodel.ModuleStandardData;
import org.openide.ErrorManager;
import org.openide.actions.AbstractCompileAction;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.CompilerCookie;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class DefaultServerInstanceManager
implements TaskListener,
ServerListener {
    private boolean debug = false;
    protected static Map serverInstanceManagerMap = null;
    protected ServerInstance serverInstance = null;
    protected CopyMaker[] copyMakers = null;
    protected ExecutorTask executorTask = null;
    protected InputStream[] inputStreams = null;
    protected BufferedReader[] inputStreamReaders = null;
    protected CopyMakerServerInstanceListener copyMakerServerInstanceListener = null;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$impl$DefaultServerInstanceManager;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;
    static /* synthetic */ Class class$org$openide$debugger$Debugger;

    protected static ExecutorTask serverInstanceStartExecution(ServerInstance serverInstance, DefaultExecPerformer ep) {
        DefaultServerInstanceManager.prepareServerInstanceManagerMap(serverInstance);
        DefaultServerInstanceManager serverInstanceManager = (DefaultServerInstanceManager)serverInstanceManagerMap.get(serverInstance);
        return serverInstanceManager.startExecution(ep);
    }

    protected static ExecutorTask serverInstanceDeployment(ServerInstance serverInstance, DefaultExecPerformer ep) {
        DefaultServerInstanceManager.prepareServerInstanceManagerMap(serverInstance);
        DefaultServerInstanceManager serverInstanceManager = (DefaultServerInstanceManager)serverInstanceManagerMap.get(serverInstance);
        return serverInstanceManager.startDeployment(ep);
    }

    protected static void serverInstanceStartDebugging(ServerInstance serverInstance, boolean stopOnMain, DefaultExecPerformer ep) {
        DefaultServerInstanceManager.prepareServerInstanceManagerMap(serverInstance);
        DefaultServerInstanceManager serverInstanceManager = (DefaultServerInstanceManager)serverInstanceManagerMap.get(serverInstance);
        serverInstanceManager.startDebugger(ep, stopOnMain);
    }

    protected static void prepareServerInstanceManagerMap(ServerInstance serverInstance) {
        if (serverInstanceManagerMap == null) {
            serverInstanceManagerMap = new HashMap(5);
        }
        if (serverInstanceManagerMap.get(serverInstance) == null) {
            serverInstanceManagerMap.put(serverInstance, new DefaultServerInstanceManager(serverInstance));
        }
    }

    protected DefaultServerInstanceManager(ServerInstance serverInstance) {
        this.serverInstance = serverInstance;
        this.copyMakerServerInstanceListener = new CopyMakerServerInstanceListener(serverInstance);
    }

    private ProgressObject doDeploy(DefaultExecPerformer ep, boolean incr) throws ServerException {
        ProgressObject po = ep.getProgressObject();
        if (po == null) {
            po = new ProgressObject();
        }
        ModuleStandardData data = ep.getModuleData();
        if (incr) {
            ModuleChangeEvent[] events = ep.getModuleEvents(po);
            this.serverInstance.deploy(data, events, po);
        } else {
            this.serverInstance.deploy(data, po);
        }
        DataObject deployed = ep.getDataObject();
        String deployedName = deployed != null ? deployed.getName() : "";
        String text = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$impl$DefaultServerInstanceManager == null ? (class$org$netbeans$modules$j2ee$impl$DefaultServerInstanceManager = DefaultServerInstanceManager.class$("org.netbeans.modules.j2ee.impl.DefaultServerInstanceManager")) : class$org$netbeans$modules$j2ee$impl$DefaultServerInstanceManager), (String)"MSG_FinishedDeploying", (Object)deployedName);
        StatusDisplayer.getDefault().setStatusText(text);
        ep.deployCompleted();
        return po;
    }

    protected ExecutorTask startExecution(DefaultExecPerformer ep) {
        try {
            this.serverInstance.setMode(1);
            this.debug = false;
            this.copyMakerServerInstanceListener.prepare();
            ProgressObject po = this.doDeploy(ep, ep.tryIncremental());
            if (po != null && po.checkCancelled()) {
                return this.executorTask;
            }
            this.serverInstance.ensureAvailable(po);
            po.finished();
            this.copyMakerServerInstanceListener.deactivate();
            ep.startClient();
            DataObject deployed = ep.getDataObject();
            String deployedName = deployed != null ? deployed.getName() : "";
            String text = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$impl$DefaultServerInstanceManager == null ? (class$org$netbeans$modules$j2ee$impl$DefaultServerInstanceManager = DefaultServerInstanceManager.class$("org.netbeans.modules.j2ee.impl.DefaultServerInstanceManager")) : class$org$netbeans$modules$j2ee$impl$DefaultServerInstanceManager), (String)"MSG_FinishedExecuting", (Object)deployedName);
            StatusDisplayer.getDefault().setStatusText(text);
        }
        catch (ServerException e) {
            ErrorManager.getDefault().log(16, e.getMessage());
        }
        return this.executorTask;
    }

    protected ExecutorTask startDeployment(DefaultExecPerformer ep) {
        try {
            this.debug = false;
            this.copyMakerServerInstanceListener.prepare();
            ProgressObject po = this.doDeploy(ep, false);
            if (po != null && po.checkCancelled()) {
                return this.executorTask;
            }
            this.serverInstance.ensureAvailable(po);
            po.finished();
            this.copyMakerServerInstanceListener.deactivate();
        }
        catch (ServerException e) {
            ErrorManager.getDefault().log(16, e.getMessage());
        }
        return this.executorTask;
    }

    protected void startDebugger(DefaultExecPerformer ep, boolean stopOnMain) {
        try {
            DataObject objectToCompile = ep.getObjectToCompile();
            if (!this.compile(objectToCompile)) {
                return;
            }
            this.serverInstance.setMode(2);
            this.debug = true;
            this.copyMakerServerInstanceListener.prepare();
            ProgressObject po = this.doDeploy(ep, ep.tryIncremental());
            if (po != null && po.checkCancelled()) {
                return;
            }
            this.serverInstance.ensureAvailable(po);
            po.finished();
            this.copyMakerServerInstanceListener.deactivate();
            ep.startClient();
        }
        catch (Exception e) {
            ErrorManager.getDefault().log(16, e.getMessage());
        }
    }

    public boolean compile(DataObject dobj) {
        JavaDebuggerSettings jds = (JavaDebuggerSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings == null ? (class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings = DefaultServerInstanceManager.class$("org.netbeans.modules.debugger.support.java.JavaDebuggerSettings")) : class$org$netbeans$modules$debugger$support$java$JavaDebuggerSettings), (boolean)true);
        if (!jds.getRunCompilation()) {
            return true;
        }
        if (dobj == null) {
            return true;
        }
        HashSet<CompilerCookie> compile = new HashSet<CompilerCookie>();
        CompilerCookie comp = (CompilerCookie)dobj.getCookie(class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = DefaultServerInstanceManager.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile);
        if (comp == null) {
            return true;
        }
        compile.add(comp);
        return AbstractCompileAction.compile(Collections.enumeration(compile), (String)"");
    }

    protected DebuggerInfo getDebuggerInfo(DebugInfo debugInfo) {
        if (debugInfo instanceof DebugInfo.SocketDebugInfo) {
            return new RemoteDebuggerInfo(((DebugInfo.SocketDebugInfo)debugInfo).getHost(), ((DebugInfo.SocketDebugInfo)debugInfo).getPort());
        }
        if (debugInfo instanceof DebugInfo.SharedMemoryDebugInfo) {
            return new RemoteDebuggerInfo(((DebugInfo.SharedMemoryDebugInfo)debugInfo).getAdress());
        }
        return null;
    }

    private void connectIDEDebugger() {
        try {
            DebugInfo debugInfo = this.serverInstance.getDebugInfo();
            DebuggerInfo debuggerInfo = this.getDebuggerInfo(debugInfo);
            Debugger debugger = (Debugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = DefaultServerInstanceManager.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
            debugger.addPropertyChangeListener((PropertyChangeListener)new DebuggerPropertyChangeListener(debuggerInfo));
            int time = 100;
            int cycles = 7;
            int i = 0;
            while (i < cycles) {
                try {
                    debugger.startDebugger(debuggerInfo);
                    break;
                }
                catch (DebuggerException e) {
                    try {
                        Thread.sleep(time);
                        time *= 2;
                    }
                    catch (InterruptedException ee) {
                        // empty catch block
                    }
                    if (i == cycles - 1) {
                        throw e;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
    }

    protected synchronized void createExecutorTask() {
        try {
            if (this.executorTask == null) {
                this.executorTask = ExecutionEngine.getDefault().execute(this.serverInstance.getDisplayName(), (Runnable)new EmptyThread(), null);
                this.executorTask.addTaskListener((TaskListener)this);
                this.serverInstance.addServerChangeListener(this);
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
    }

    public synchronized void taskFinished(Task p1) {
        if (this.executorTask != null) {
            p1.removeTaskListener((TaskListener)this);
            this.serverInstance.removeServerChangeListener(this);
            this.serverInstance.stopExecution();
            this.executorTask.stop();
            this.clearCopyMaker();
            this.executorTask = null;
        }
    }

    public synchronized void serverStatusChanged(ServerEvent sse) {
        if (sse.getServerInstance().equals(this.serverInstance) && sse.getServerStatus().equals(ServerStatus.STATUS_STOPPED) && this.executorTask != null) {
            this.executorTask.removeTaskListener((TaskListener)this);
            this.serverInstance.removeServerChangeListener(this);
            this.executorTask.stop();
            this.clearCopyMaker();
            this.executorTask = null;
        }
    }

    protected void createCopyMaker() {
        try {
            Debugger tempD = (Debugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = DefaultServerInstanceManager.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
            JavaDebugger debugger = (JavaDebugger)((CoreDebugger)tempD).getCurrentDebugger();
            ServerOutput[] serverOutputs = this.serverInstance.getServerOutput();
            if (serverOutputs == null) {
                serverOutputs = new ServerOutput[]{};
            }
            if (this.copyMakers == null) {
                this.copyMakers = new CopyMaker[serverOutputs.length];
                this.inputStreams = new InputStream[serverOutputs.length];
                this.inputStreamReaders = new BufferedReader[serverOutputs.length];
            }
            int i = 0;
            while (i < this.copyMakers.length) {
                if (this.copyMakers[i] == null && serverOutputs[i] != null) {
                    InputStream is = serverOutputs[i].getStream();
                    if (this.inputStreams[i] == null || this.inputStreams[i] != is) {
                        this.inputStreamReaders[i] = new BufferedReader(new InputStreamReader(is), 50);
                    }
                    this.inputStreams[i] = is;
                    this.copyMakers[i] = this.debug ? new DebugCopyMaker(this.inputStreamReaders[i], (Debugger)debugger, false) : new ExecCopyMaker(this.inputStreamReaders[i], (Writer)this.executorTask.getInputOutput().getOut(), false);
                    this.copyMakers[i].start();
                }
                ++i;
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
    }

    protected void clearCopyMaker() {
        if (this.copyMakers != null) {
            int i = 0;
            while (i < this.copyMakers.length) {
                if (this.copyMakers[i] != null) {
                    this.copyMakers[i].finishThread();
                    this.copyMakers[i].interrupt();
                    this.copyMakers[i] = null;
                }
                ++i;
            }
            this.copyMakers = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class CopyMakerServerInstanceListener
    implements ServerListener {
        private boolean activation = false;

        public CopyMakerServerInstanceListener(ServerInstance serverInstance) {
            serverInstance.addServerChangeListener(this);
        }

        public void serverStatusChanged(ServerEvent sse) {
            if (sse.getServerStatus().equals(ServerStatus.STATUS_RESTART)) {
                if (this.activation) {
                    this.go();
                }
                this.activation = false;
            }
        }

        public void prepare() {
            this.activation = true;
        }

        public void deactivate() {
            if (this.activation) {
                this.activation = false;
                this.go();
            }
        }

        private void go() {
            DefaultServerInstanceManager defaultServerInstanceManager = DefaultServerInstanceManager.this;
            synchronized (defaultServerInstanceManager) {
                if (DefaultServerInstanceManager.this.debug) {
                    DefaultServerInstanceManager.this.connectIDEDebugger();
                    DefaultServerInstanceManager.this.clearCopyMaker();
                    DefaultServerInstanceManager.this.createCopyMaker();
                } else {
                    DefaultServerInstanceManager.this.createExecutorTask();
                    DefaultServerInstanceManager.this.clearCopyMaker();
                    DefaultServerInstanceManager.this.createCopyMaker();
                }
            }
        }
    }

    protected class CurrentDebuggerPropertyChangeListener
    implements PropertyChangeListener {
        protected Debugger debugger = null;

        public CurrentDebuggerPropertyChangeListener(Debugger debugger) {
            this.debugger = debugger;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals("debuggerState") && event.getNewValue() == SecondaryDebuggerSupport.STATE_NOT_RUNNING) {
                this.debugger.removePropertyChangeListener((PropertyChangeListener)this);
                if (DefaultServerInstanceManager.this.debug) {
                    DefaultServerInstanceManager.this.serverInstance.removeServerChangeListener(DefaultServerInstanceManager.this);
                    DefaultServerInstanceManager.this.serverInstance.stopExecution();
                    DefaultServerInstanceManager.this.clearCopyMaker();
                    DefaultServerInstanceManager.this.debug = false;
                }
            }
        }
    }

    protected class DebuggerPropertyChangeListener
    implements PropertyChangeListener {
        protected DebuggerInfo debuggerInfo = null;
        static /* synthetic */ Class class$org$openide$debugger$Debugger;

        public DebuggerPropertyChangeListener(DebuggerInfo debuggerInfo) {
            this.debuggerInfo = debuggerInfo;
        }

        public void propertyChange(PropertyChangeEvent event) {
            DebuggerInfo di;
            Debugger d;
            if (event.getPropertyName().equals("currentDebugger") && (d = (Debugger)event.getNewValue()) instanceof AbstractDebugger && (di = ((AbstractDebugger)d).getDebuggerInfo()) == this.debuggerInfo) {
                d.addPropertyChangeListener((PropertyChangeListener)new CurrentDebuggerPropertyChangeListener(d));
                Debugger d2 = (Debugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = DebuggerPropertyChangeListener.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
                if (d2 != null) {
                    d2.removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    protected class EmptyThread
    extends Thread {
        protected EmptyThread() {
        }

        public void run() {
            try {
                while (true) {
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    protected class DebugCopyMaker
    extends CopyMaker {
        Debugger debugger = null;

        public DebugCopyMaker(BufferedReader ir, Debugger debugger, boolean b) {
            super(ir, b);
            this.debugger = debugger;
        }

        void writeString(String read) throws Exception {
            ((JavaDebugger)this.debugger).getIOManager().println(read, 2);
            if (this.stop) {
                throw new Exception();
            }
        }
    }

    protected class ExecCopyMaker
    extends CopyMaker {
        Writer or = null;

        public ExecCopyMaker(BufferedReader ir, Writer or, boolean b) {
            super(ir, b);
            this.or = or;
        }

        void writeString(String read) throws Exception {
            this.or.write(read);
            if (this.stop) {
                throw new Exception();
            }
            this.or.write(System.getProperty("line.separator"));
            if (this.autoflush) {
                this.or.flush();
            }
        }
    }

    protected abstract class CopyMaker
    extends Thread {
        BufferedReader ir = null;
        boolean stop = false;
        boolean autoflush;

        public CopyMaker(BufferedReader ir, boolean b) {
            super("CopyMaker");
            this.ir = ir;
            this.autoflush = b;
        }

        public void finishThread() {
            this.stop = true;
        }

        public void run() {
            block3: {
                try {
                    String read;
                    while ((read = this.ir.readLine()) != null) {
                        this.writeString(read);
                    }
                }
                catch (Exception e) {
                    if (!DefaultServerInstanceManager.this.debug) break block3;
                    e.printStackTrace();
                }
            }
        }

        abstract void writeString(String var1) throws Exception;
    }
}

