/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.impl;

import java.awt.Component;
import java.awt.Dialog;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.ServiceType;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.CompilerTask;
import org.openide.cookies.ArgumentsCookie;
import org.openide.cookies.CompilerCookie;
import org.openide.cookies.DebuggerCookie;
import org.openide.cookies.ExecCookie;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerType;
import org.openide.execution.Executor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ExecSupport
implements ExecCookie,
ArgumentsCookie,
DebuggerCookie {
    private static final String EA_EXECUTOR = "NetBeansAttrExecutor";
    private static final String EA_ARGUMENTS = "NetBeansAttrArguments";
    private static final String EA_DEBUGGER_TYPE = "NetBeansAttrDebuggerType";
    public static final String PROP_FILE_PARAMS = "params";
    public static final String PROP_EXECUTION = "execution";
    public static final String PROP_DEBUGGER_TYPE = "debuggerType";
    protected MultiDataObject.Entry entry;
    private DataObject dobj;
    private boolean isReadOnly = false;
    static /* synthetic */ Class class$org$openide$execution$Executor;
    static /* synthetic */ Class class$org$openide$debugger$DebuggerType;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$loaders$ExecSupport;

    public ExecSupport(MultiDataObject.Entry entry) {
        this(entry.getFile());
        this.entry = entry;
    }

    public ExecSupport(DataObject dobj) {
        this(dobj.getPrimaryFile());
        this.dobj = dobj;
    }

    protected ExecSupport(FileObject fo) {
        this.isReadOnly = fo.isReadOnly();
    }

    protected FileObject getFile() {
        return this.entry != null ? this.entry.getFile() : this.dobj.getPrimaryFile();
    }

    protected DataObject getDataObject() {
        return this.entry != null ? this.entry.getDataObject() : this.dobj;
    }

    public void start() {
        Executor exec = ExecSupport.getExecutor(this.getFile());
        if (exec == null) {
            exec = this.defaultExecutor();
        }
        try {
            exec.execute(this.getDataObject());
        }
        catch (IOException ex) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    if (ExecSupport.this.startFailed(ex)) {
                        ExecSupport.this.start();
                    }
                }
            });
        }
    }

    public void debug(final boolean stopOnMain) throws DebuggerException {
        DebuggerType t = ExecSupport.getDebuggerType(this.getFile());
        if (t == null) {
            t = this.defaultDebuggerType();
        }
        try {
            t.startDebugger(this.getDataObject(), stopOnMain);
            return;
        }
        catch (DebuggerException ex) {
            try {
                Mutex.EVENT.readAccess(new Mutex.ExceptionAction(){

                    public Object run() throws DebuggerException {
                        if (ExecSupport.this.debugFailed(ex)) {
                            ExecSupport.this.debug(stopOnMain);
                        }
                        return null;
                    }
                });
            }
            catch (MutexException mx) {
                throw (DebuggerException)((Object)mx.getException());
            }
            return;
        }
    }

    protected boolean startFailed(IOException ex) {
        Executor e = (Executor)ExecSupport.choose((ServiceType)ExecSupport.getExecutor(this.getFile()), class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor, ex);
        if (e == null) {
            return false;
        }
        try {
            ExecSupport.setExecutor(this.getFile(), e);
            return true;
        }
        catch (IOException exc) {
            return false;
        }
    }

    protected boolean debugFailed(DebuggerException ex) {
        DebuggerType e = (DebuggerType)ExecSupport.choose((ServiceType)ExecSupport.getDebuggerType(this.getFile()), class$org$openide$debugger$DebuggerType == null ? (class$org$openide$debugger$DebuggerType = ExecSupport.class$("org.openide.debugger.DebuggerType")) : class$org$openide$debugger$DebuggerType, (Exception)((Object)ex));
        if (e == null) {
            return false;
        }
        try {
            ExecSupport.setDebuggerType(this.getFile(), e);
            return true;
        }
        catch (IOException exc) {
            return false;
        }
    }

    protected boolean checkCompiled() {
        CompilerCookie c = (CompilerCookie)this.getDataObject().getCookie(class$org$openide$cookies$CompilerCookie == null ? (class$org$openide$cookies$CompilerCookie = ExecSupport.class$("org.openide.cookies.CompilerCookie")) : class$org$openide$cookies$CompilerCookie);
        if (c != null) {
            CompilerJob job = new CompilerJob(Compiler.DEPTH_ZERO);
            job.setDisplayName(this.getDataObject().getName());
            c.addToJob(job, Compiler.DEPTH_ZERO);
            if (!job.isUpToDate()) {
                CompilerTask t = job.start();
                return t.isSuccessful();
            }
        }
        return true;
    }

    protected DebuggerType defaultDebuggerType() {
        return DebuggerType.getDefault();
    }

    protected Executor defaultExecutor() {
        return Executor.getDefault();
    }

    public static void setExecutor(MultiDataObject.Entry entry, Executor exec) throws IOException {
        ExecSupport.setExecutor(entry.getFile(), exec);
    }

    public static void setExecutor(FileObject fo, Executor exec) throws IOException {
        fo.setAttribute(EA_EXECUTOR, (Object)(exec == null ? null : new ServiceType.Handle((ServiceType)exec)));
    }

    public static Executor getExecutor(MultiDataObject.Entry entry) {
        return ExecSupport.getExecutor(entry.getFile());
    }

    public static Executor getExecutor(FileObject fo) {
        Object handle = fo.getAttribute(EA_EXECUTOR);
        if (handle != null && handle instanceof ServiceType.Handle) {
            try {
                ServiceType exec = ((ServiceType.Handle)handle).getServiceType();
                if (exec instanceof Executor) {
                    return (Executor)exec;
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public void setArguments(String[] args) throws IOException {
        this.getFile().setAttribute(EA_ARGUMENTS, (Object)args);
    }

    public static void setArguments(MultiDataObject.Entry entry, String[] args) throws IOException {
        ExecSupport.setArguments(entry.getFile(), args);
    }

    public static void setArguments(FileObject fo, String[] args) throws IOException {
        fo.setAttribute(EA_ARGUMENTS, (Object)args);
    }

    public String[] getArguments() {
        return ExecSupport.getArguments(this.getFile());
    }

    public static String[] getArguments(MultiDataObject.Entry entry) {
        return ExecSupport.getArguments(entry.getFile());
    }

    public static String[] getArguments(FileObject fo) {
        Object o = fo.getAttribute(EA_ARGUMENTS);
        if (o != null && o instanceof String[]) {
            return (String[])o;
        }
        return new String[0];
    }

    public static void setDebuggerType(MultiDataObject.Entry entry, DebuggerType type) throws IOException {
        ExecSupport.setDebuggerType(entry.getFile(), type);
    }

    public static void setDebuggerType(FileObject fo, DebuggerType type) throws IOException {
        fo.setAttribute(EA_DEBUGGER_TYPE, (Object)(type == null ? null : new ServiceType.Handle((ServiceType)type)));
    }

    public static DebuggerType getDebuggerType(MultiDataObject.Entry entry) {
        return ExecSupport.getDebuggerType(entry.getFile());
    }

    public static DebuggerType getDebuggerType(FileObject fo) {
        ServiceType dbg;
        Object handle = fo.getAttribute(EA_DEBUGGER_TYPE);
        if (handle != null && handle instanceof ServiceType.Handle && (dbg = ((ServiceType.Handle)handle).getServiceType()) instanceof DebuggerType) {
            return (DebuggerType)dbg;
        }
        return null;
    }

    public void addProperties(Sheet.Set set) {
        set.put((Node.Property)this.createParamsProperty());
        set.put((Node.Property)this.createExecutorProperty());
        set.put((Node.Property)this.createDebuggerProperty());
    }

    private PropertySupport createParamsProperty() {
        return new PropertySupport.ReadWrite(PROP_FILE_PARAMS, class$java$lang$String == null ? (class$java$lang$String = ExecSupport.class$("java.lang.String")) : class$java$lang$String, NbBundle.getMessage((Class)(class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor), (String)"PROP_fileParams"), NbBundle.getMessage((Class)(class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor), (String)"HINT_fileParams")){

            public Object getValue() {
                String[] args = ExecSupport.this.getArguments();
                return Utilities.escapeParameters((String[])args);
            }

            public void setValue(Object val) throws InvocationTargetException {
                if (val instanceof String) {
                    try {
                        ExecSupport.this.setArguments(Utilities.parseParameters((String)((String)val)));
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                try {
                    ExecSupport.this.setArguments(null);
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }

            public boolean canWrite() {
                return !ExecSupport.this.getFile().isReadOnly();
            }
        };
    }

    private PropertySupport createExecutorProperty() {
        return new PropertySupport.ReadWrite(PROP_EXECUTION, class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor, NbBundle.getMessage((Class)(class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor), (String)"PROP_execution"), NbBundle.getMessage((Class)(class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor), (String)"HINT_execution")){

            public Object getValue() {
                Executor e = ExecSupport.getExecutor(ExecSupport.this.getFile());
                if (e == null) {
                    return ExecSupport.this.defaultExecutor();
                }
                return e;
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    ExecSupport.setExecutor(ExecSupport.this.getFile(), (Executor)val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
            }

            public boolean canWrite() {
                return !ExecSupport.this.getFile().isReadOnly();
            }
        };
    }

    private PropertySupport createDebuggerProperty() {
        return new PropertySupport.ReadWrite(PROP_DEBUGGER_TYPE, class$org$openide$debugger$DebuggerType == null ? (class$org$openide$debugger$DebuggerType = ExecSupport.class$("org.openide.debugger.DebuggerType")) : class$org$openide$debugger$DebuggerType, NbBundle.getMessage((Class)(class$org$openide$debugger$DebuggerType == null ? (class$org$openide$debugger$DebuggerType = ExecSupport.class$("org.openide.debugger.DebuggerType")) : class$org$openide$debugger$DebuggerType), (String)"PROP_debuggerType"), NbBundle.getMessage((Class)(class$org$openide$debugger$DebuggerType == null ? (class$org$openide$debugger$DebuggerType = ExecSupport.class$("org.openide.debugger.DebuggerType")) : class$org$openide$debugger$DebuggerType), (String)"HINT_debuggerType")){

            public Object getValue() {
                DebuggerType dt = ExecSupport.getDebuggerType(ExecSupport.this.getFile());
                if (dt == null) {
                    return ExecSupport.this.defaultDebuggerType();
                }
                return dt;
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    ExecSupport.setDebuggerType(ExecSupport.this.getFile(), (DebuggerType)val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
            }

            public boolean canWrite() {
                return !ExecSupport.this.getFile().isReadOnly();
            }
        };
    }

    private static ServiceType choose(ServiceType current, Class clazz, Exception ex) {
        ErrorManager.getDefault().notify(1, (Throwable)ex);
        PropertyEditor ed = PropertyEditorManager.findEditor(clazz);
        if (ed == null) {
            return null;
        }
        ed.setValue(current);
        Component c = ed.getCustomEditor();
        if (c == null) {
            return null;
        }
        String configure = NbBundle.getBundle((Class)(class$org$openide$loaders$ExecSupport == null ? (class$org$openide$loaders$ExecSupport = ExecSupport.class$("org.openide.loaders.ExecSupport")) : class$org$openide$loaders$ExecSupport)).getString("CTL_ServiceConfigure");
        NotifyDescriptor.Exception exc = new NotifyDescriptor.Exception((Throwable)ex);
        exc.setTitle(NbBundle.getBundle((Class)(class$org$openide$loaders$ExecSupport == null ? (class$org$openide$loaders$ExecSupport = ExecSupport.class$("org.openide.loaders.ExecSupport")) : class$org$openide$loaders$ExecSupport)).getString("CTL_Service_Configuration_Title"));
        exc.setMessage((Object)ex.getLocalizedMessage());
        exc.setOptions(new Object[]{configure, NotifyDescriptor.CANCEL_OPTION});
        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)exc);
        if (!configure.equals(res)) {
            return null;
        }
        DialogDescriptor d = new DialogDescriptor((Object)c, NbBundle.getMessage((Class)(class$org$openide$execution$Executor == null ? (class$org$openide$execution$Executor = ExecSupport.class$("org.openide.execution.Executor")) : class$org$openide$execution$Executor), (String)"MSG_ConfigureService"));
        d.setOptions(new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(d);
        dialog.show();
        if (d.getValue() == NotifyDescriptor.OK_OPTION) {
            return (ServiceType)ed.getValue();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

