/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.server.Progress;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class ProgressObject
extends JPanel
implements Progress {
    private boolean changeFontSize;
    private boolean wasCancelled;
    private String dlgTitle;
    private String desc;
    private boolean modal;
    private Dialog dialog;
    private JLabel taskTitle;
    private JLabel msgText;
    private JProgressBar myMonitor;
    private JLabel errorText;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$impl$ProgressObject;

    public ProgressObject() {
        this(true);
    }

    public ProgressObject(boolean modal) {
        this.initComponents();
        this.changeFontSize = true;
        this.wasCancelled = false;
        this.modal = modal;
    }

    public ProgressObject(Component parent) {
        this(true);
    }

    public ProgressObject(Component parent, boolean modal) {
        this(modal);
    }

    public void addNotify() {
        super.addNotify();
        if (this.changeFontSize) {
            Font f = this.taskTitle.getFont();
            this.taskTitle.setFont(new Font(f.getName(), 1, f.getSize() + 2));
            this.changeFontSize = false;
            this.validate();
        }
        this.msgText.setText(" ");
        this.errorText.setText(" ");
    }

    public void setTitle(String s) {
        this.dlgTitle = s;
    }

    public void setAccessibleDescription(String s) {
        this.desc = s;
    }

    public void startTask(final String msg, final int max) {
        if (this.wasCancelled) {
            return;
        }
        if (this.dialog != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressObject.this.myMonitor.setMaximum(max);
                    ProgressObject.this.myMonitor.setValue(0);
                    ProgressObject.this.errorText.setText(" ");
                    ProgressObject.this.msgText.setText(" ");
                    ProgressObject.this.taskTitle.setText(msg);
                }
            });
            return;
        }
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Object o = evt.getSource();
                if (o == NotifyDescriptor.CANCEL_OPTION) {
                    ProgressObject.this.wasCancelled = true;
                }
            }
        };
        String title = this.dlgTitle;
        if (title == null) {
            title = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$impl$ProgressObject == null ? (class$org$netbeans$modules$j2ee$impl$ProgressObject = ProgressObject.class$("org.netbeans.modules.j2ee.impl.ProgressObject")) : class$org$netbeans$modules$j2ee$impl$ProgressObject), (String)"LBL_Progress");
        }
        if (this.desc != null) {
            this.getAccessibleContext().setAccessibleDescription(this.desc);
        } else {
            this.getAccessibleContext().setAccessibleDescription(title);
        }
        final DialogDescriptor dd = new DialogDescriptor(this, title, this.modal, listener){

            public int getOptionsAlign() {
                return -1;
            }
        };
        Object[] options = new Object[]{NotifyDescriptor.CANCEL_OPTION};
        dd.setOptions(options);
        dd.setClosingOptions(options);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressObject.this.myMonitor.setMaximum(max);
                ProgressObject.this.myMonitor.setValue(0);
                ProgressObject.this.taskTitle.setText(msg);
                ProgressObject.this.dialog = DialogDisplayer.getDefault().createDialog(dd);
                ((Component)ProgressObject.this.dialog).setVisible(true);
            }
        });
    }

    public void addError(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressObject.this.errorText.setText(msg);
            }
        });
    }

    public void addMessage(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressObject.this.msgText.setText(msg);
            }
        });
    }

    public void recordWork(final int value) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressObject.this.myMonitor.setValue(value);
            }
        });
    }

    public boolean checkCancelled() {
        return this.wasCancelled;
    }

    public void finished() {
        if (this.dialog == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((Component)ProgressObject.this.dialog).setVisible(false);
                ProgressObject.this.dialog.dispose();
                ProgressObject.this.dialog = null;
            }
        });
    }

    private void initComponents() {
        this.taskTitle = new JLabel();
        this.msgText = new JLabel();
        this.myMonitor = new JProgressBar();
        this.errorText = new JLabel();
        this.setLayout(new GridBagLayout());
        this.taskTitle.setText(" ");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(12, 12, 6, 12);
        gridBagConstraints1.anchor = 18;
        this.add((Component)this.taskTitle, gridBagConstraints1);
        this.msgText.setText(" ");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(12, 24, 6, 24);
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.msgText, gridBagConstraints1);
        this.myMonitor.setPreferredSize(new Dimension(400, 30));
        this.myMonitor.setMinimumSize(new Dimension(400, 30));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 24, 12, 24);
        gridBagConstraints1.weightx = 1.0;
        this.add((Component)this.myMonitor, gridBagConstraints1);
        this.errorText.setText(" ");
        this.errorText.setForeground(Color.red);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(0, 24, 12, 24);
        gridBagConstraints1.anchor = 18;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.errorText, gridBagConstraints1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

