/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.j2ee.impl.ServerInstanceData;
import org.netbeans.modules.j2ee.impl.ServerOptions;
import org.netbeans.modules.j2ee.impl.ServerUtilities;
import org.netbeans.modules.j2ee.server.Server;
import org.netbeans.modules.j2ee.server.ServerInstall;
import org.netbeans.modules.j2ee.server.ServerInstance;
import org.netbeans.modules.j2ee.server.ServerListener;
import org.netbeans.modules.j2ee.server.ServerRegistry;
import org.netbeans.modules.j2ee.server.ServerStatus;
import org.netbeans.modules.j2ee.server.app.AppServer;
import org.netbeans.modules.j2ee.server.web.WebServer;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakListener;

public class ServerRegistryImpl
extends ServerRegistry
implements ServerListener {
    private PropertyChangeListener pcl = null;
    private Vector serverList = new Vector();
    private ServerInstance webInstance = null;
    private ServerInstance appInstance = null;
    private Map pluginMap = null;
    private boolean inited = false;
    private boolean initing = false;
    EventListenerList listeners;
    EventListenerList elisteners;
    static /* synthetic */ Class class$org$openide$filesystems$Repository;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$ErrorManager;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$impl$ServerOptions;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryListener;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryExtensionListener;

    public static ServerRegistryImpl getRegistry() {
        if (ServerRegistry.registry == null) {
            ServerRegistry.registry = new ServerRegistryImpl();
        }
        return (ServerRegistryImpl)ServerRegistry.getServerRegistry();
    }

    void readLayerFile() {
        if (this.pluginMap != null) {
            return;
        }
        FileObject[] ch = this.readLayerFileImpl();
        int i = 0;
        while (i < ch.length) {
            this.addPlugin(ch[i], false);
            ++i;
        }
    }

    synchronized FileObject[] readLayerFileImpl() {
        if (this.pluginMap != null) {
            return new FileObject[0];
        }
        this.pluginMap = new HashMap();
        Repository rep = (Repository)Lookup.getDefault().lookup(class$org$openide$filesystems$Repository == null ? (class$org$openide$filesystems$Repository = ServerRegistryImpl.class$("org.openide.filesystems.Repository")) : class$org$openide$filesystems$Repository);
        FileObject dir = rep.findResource("/J2EE/OldPlugins");
        dir.addFileChangeListener(new FileChangeListener(){

            public void fileAttributeChanged(FileAttributeEvent fae) {
            }

            public void fileChanged(FileEvent fe) {
            }

            public void fileFolderCreated(FileEvent fe) {
            }

            public void fileRenamed(FileRenameEvent fe) {
            }

            public void fileDataCreated(FileEvent fe) {
                ServerRegistryImpl.this.addPlugin(fe.getFile(), true);
            }

            public void fileDeleted(FileEvent fe) {
            }
        });
        return dir.getChildren();
    }

    void addPlugin(FileObject fo, boolean init) {
        if (init && this.inited) {
            this.initPlugin(fo);
            this.fireExtensionEvent();
        } else {
            this.pluginMap.put(fo, null);
        }
    }

    void initLayerFile() {
        if (this.inited || this.initing) {
            return;
        }
        this.initing = true;
        this.readLayerFile();
        Iterator i = this.pluginMap.keySet().iterator();
        while (i.hasNext()) {
            FileObject fo = (FileObject)i.next();
            this.initPlugin(fo);
        }
        this.inited = true;
    }

    void initPlugin(FileObject fo) {
        try {
            DataObject dobj = DataObject.find((FileObject)fo);
            InstanceCookie cookie = (InstanceCookie)dobj.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = ServerRegistryImpl.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
            if (cookie == null) {
                throw new IllegalStateException("Incorrect server plugin installation");
            }
            ServerInstall installer = (ServerInstall)cookie.instanceCreate();
            ServerRegistryImpl serverRegistryImpl = this;
            synchronized (serverRegistryImpl) {
                if (this.pluginMap.get(fo) != null) {
                    return;
                }
                this.pluginMap.put(fo, installer);
            }
            installer.restored();
        }
        catch (Exception e) {
            ErrorManager err = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = ServerRegistryImpl.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
            err.notify((Throwable)e);
        }
    }

    void setListener() {
        this.initLayerFile();
        if (this.pcl != null) {
            return;
        }
        ServerOptions options = this.setListenerImpl();
        if (options != null) {
            this.getOptionsWebInstance(options.getWebDefault());
            this.getOptionsAppInstance(options.getAppDefault());
        }
    }

    synchronized ServerOptions setListenerImpl() {
        if (this.pcl != null) {
            return null;
        }
        this.pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pce) {
                if (pce.getPropertyName() == "appDefault") {
                    ServerRegistryImpl.this.getOptionsAppInstance((ServerInstanceData)pce.getNewValue());
                }
                if (pce.getPropertyName() == "webDefault") {
                    ServerRegistryImpl.this.getOptionsWebInstance((ServerInstanceData)pce.getNewValue());
                }
            }
        };
        Object webDefault = null;
        Object appDefault = null;
        try {
            ServerOptions o = (ServerOptions)SharedClassObject.findObject((Class)(class$org$netbeans$modules$j2ee$impl$ServerOptions == null ? (class$org$netbeans$modules$j2ee$impl$ServerOptions = ServerRegistryImpl.class$("org.netbeans.modules.j2ee.impl.ServerOptions")) : class$org$netbeans$modules$j2ee$impl$ServerOptions), (boolean)true);
            o.addPropertyChangeListener(this.pcl);
            return o;
        }
        catch (Exception e) {
            this.pcl = null;
            return null;
        }
    }

    private synchronized void getOptionsWebInstance(ServerInstanceData data) {
        if (this.webInstance != null) {
            this.webInstance.removeServerChangeListener(this);
        }
        ServerInstance serverInstance = this.webInstance = data == null ? null : ServerUtilities.findServerInstance(data);
        if (this.webInstance != null) {
            this.webInstance.addServerChangeListener(this);
        }
        this.fireInstanceEvent(this.webInstance, false);
    }

    private synchronized void getOptionsAppInstance(ServerInstanceData data) {
        if (this.appInstance != null) {
            this.appInstance.removeServerChangeListener(this);
        }
        ServerInstance serverInstance = this.appInstance = data == null ? null : ServerUtilities.findServerInstance(data);
        if (this.appInstance != null) {
            this.appInstance.addServerChangeListener(this);
        }
        this.fireInstanceEvent(this.appInstance, true);
    }

    public void serverStatusChanged(org.netbeans.modules.j2ee.server.ServerEvent se) {
        if (se == null) {
            return;
        }
        if (se.getServerStatus() == ServerStatus.STATUS_REMOVED && se.getServerInstance() != null) {
            if (se.getServerInstance() == this.webInstance) {
                this.webInstance.removeServerChangeListener(this);
                this.setDefaultWebInstance(null);
                this.getDefaultWebInstance();
            }
            if (se.getServerInstance() == this.appInstance) {
                this.appInstance.removeServerChangeListener(this);
                this.setDefaultAppInstance(null);
                this.getDefaultAppInstance();
            }
        }
    }

    public Server[] getServers() {
        return this.getServers(null);
    }

    public WebServer[] getWebServers() {
        Server[] servers = this.getServers(null);
        int num = 0;
        int i = 0;
        while (i < servers.length) {
            if (servers[i].supportsWarFiles() || servers[i].supportsEarFiles()) {
                ++num;
            }
            ++i;
        }
        WebServer[] webservers = new WebServer[num];
        int j = 0;
        int i2 = 0;
        while (i2 < servers.length) {
            if (servers[i2].supportsWarFiles() || servers[i2].supportsEarFiles()) {
                webservers[j++] = (WebServer)servers[i2];
            }
            ++i2;
        }
        return webservers;
    }

    public WebServer[] getWebOnlyServers() {
        Server[] servers = this.getServers(null);
        int num = 0;
        int i = 0;
        while (i < servers.length) {
            if (servers[i].supportsWarFiles()) {
                ++num;
            }
            ++i;
        }
        WebServer[] webservers = new WebServer[num];
        int j = 0;
        int i2 = 0;
        while (i2 < servers.length) {
            if (servers[i2].supportsWarFiles()) {
                webservers[j++] = (WebServer)servers[i2];
            }
            ++i2;
        }
        return webservers;
    }

    public AppServer[] getAppServers() {
        Server[] servers = this.getServers(null);
        int num = 0;
        int i = 0;
        while (i < servers.length) {
            if (servers[i].supportsEarFiles()) {
                ++num;
            }
            ++i;
        }
        AppServer[] appservers = new AppServer[num];
        int j = 0;
        int i2 = 0;
        while (i2 < servers.length) {
            if (servers[i2].supportsEarFiles()) {
                appservers[j++] = (AppServer)servers[i2];
            }
            ++i2;
        }
        return appservers;
    }

    private ServerInstance selectInstance(Server[] servers) {
        Repository rep = (Repository)Lookup.getDefault().lookup(class$org$openide$filesystems$Repository == null ? (class$org$openide$filesystems$Repository = ServerRegistryImpl.class$("org.openide.filesystems.Repository")) : class$org$openide$filesystems$Repository);
        FileObject dir = rep.findResource("/J2EE/OldPlugins");
        String defaultServerClass = (String)dir.getAttribute("default");
        if (defaultServerClass == null) {
            defaultServerClass = "";
        }
        ServerInstance ret = null;
        int i = 0;
        while (i < servers.length) {
            ServerInstance[] inst = servers[i].getServerInstances();
            String serverName = servers[i].getClass().getName();
            if (inst.length > 0) {
                if (ret == null) {
                    ret = inst[0];
                }
                if (defaultServerClass.equals(serverName)) {
                    return inst[0];
                }
            }
            ++i;
        }
        return ret;
    }

    public void setDefaultWebInstance(ServerInstance instance) {
        ServerInstanceData data = null;
        if (instance != null) {
            data = new ServerInstanceData(instance);
        }
        ServerOptions o = (ServerOptions)SharedClassObject.findObject((Class)(class$org$netbeans$modules$j2ee$impl$ServerOptions == null ? (class$org$netbeans$modules$j2ee$impl$ServerOptions = ServerRegistryImpl.class$("org.netbeans.modules.j2ee.impl.ServerOptions")) : class$org$netbeans$modules$j2ee$impl$ServerOptions), (boolean)true);
        o.setWebDefault(data);
    }

    public ServerInstance getDefaultWebInstance() {
        this.setListener();
        if (this.appInstance == null && this.webInstance == null) {
            this.setDefaultWebInstance(this.selectInstance(this.getWebOnlyServers()));
        }
        if (this.webInstance != null) {
            return this.webInstance;
        }
        if (this.appInstance != null && this.appInstance.getServer().supportsWarFiles()) {
            return this.appInstance;
        }
        return null;
    }

    public void setDefaultAppInstance(ServerInstance instance) {
        ServerInstanceData data = null;
        if (instance != null) {
            data = new ServerInstanceData(instance);
        }
        ServerOptions o = (ServerOptions)SharedClassObject.findObject((Class)(class$org$netbeans$modules$j2ee$impl$ServerOptions == null ? (class$org$netbeans$modules$j2ee$impl$ServerOptions = ServerRegistryImpl.class$("org.netbeans.modules.j2ee.impl.ServerOptions")) : class$org$netbeans$modules$j2ee$impl$ServerOptions), (boolean)true);
        o.setAppDefault(data);
    }

    public ServerInstance getDefaultAppInstance() {
        this.setListener();
        if (this.appInstance == null) {
            this.setDefaultAppInstance(this.selectInstance(this.getAppServers()));
        }
        return this.appInstance;
    }

    public Server[] getServers(ServerRegistryListener listener) {
        this.initLayerFile();
        if (listener != null) {
            this.addServerRegistryListener(listener);
        }
        Object[] rval = new Server[this.serverList.size()];
        this.serverList.copyInto(rval);
        return rval;
    }

    public static ServerRegistryListener weakServerRegistryListener(ServerRegistryListener l, Object source) {
        return (ServerRegistryListener)WeakListener.create((Class)(class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryListener == null ? (class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryListener = ServerRegistryImpl.class$("org.netbeans.modules.j2ee.impl.ServerRegistryImpl$ServerRegistryListener")) : class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryListener), (EventListener)l, (Object)source);
    }

    public static ServerRegistryExtensionListener weakServerRegistryExtensionListener(ServerRegistryExtensionListener l, Object source) {
        return (ServerRegistryExtensionListener)WeakListener.create((Class)(class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryExtensionListener == null ? (class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryExtensionListener = ServerRegistryImpl.class$("org.netbeans.modules.j2ee.impl.ServerRegistryImpl$ServerRegistryExtensionListener")) : class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryExtensionListener), (EventListener)l, (Object)source);
    }

    public synchronized void addServerRegistryListener(ServerRegistryListener l) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryListener == null ? (class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryListener = ServerRegistryImpl.class$("org.netbeans.modules.j2ee.impl.ServerRegistryImpl$ServerRegistryListener")) : class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryListener, l);
    }

    public synchronized void removeServerRegistryListener(ServerRegistryListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryListener == null ? (class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryListener = ServerRegistryImpl.class$("org.netbeans.modules.j2ee.impl.ServerRegistryImpl$ServerRegistryListener")) : class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryListener, l);
    }

    public void addServerRegistryExtensionListener(ServerRegistryExtensionListener l) {
        if (this.elisteners == null) {
            this.elisteners = new EventListenerList();
        }
        this.elisteners.add(class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryExtensionListener == null ? (class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryExtensionListener = ServerRegistryImpl.class$("org.netbeans.modules.j2ee.impl.ServerRegistryImpl$ServerRegistryExtensionListener")) : class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryExtensionListener, l);
    }

    public void removeServerRegistryExtensionListener(ServerRegistryExtensionListener l) {
        if (this.elisteners == null) {
            return;
        }
        this.elisteners.remove(class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryExtensionListener == null ? (class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryExtensionListener = ServerRegistryImpl.class$("org.netbeans.modules.j2ee.impl.ServerRegistryImpl$ServerRegistryExtensionListener")) : class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryExtensionListener, l);
    }

    public void add(Server newServer) {
        this.initLayerFile();
        ServerRegistryImpl serverRegistryImpl = this;
        synchronized (serverRegistryImpl) {
            this.serverList.add(newServer);
        }
        if (this.pcl != null) {
            this.getDefaultAppInstance();
            this.getDefaultWebInstance();
        }
        this.fireServerEvent(newServer, true);
        if (this.inited) {
            this.fireExtensionEvent();
        }
    }

    public void remove(Server oldServer) {
        this.initLayerFile();
        if (oldServer == null) {
            return;
        }
        this.removeImpl(oldServer);
        this.fireServerEvent(oldServer, false);
        this.fireExtensionEvent();
    }

    public synchronized void removeImpl(Server oldServer) {
        this.serverList.removeElement(oldServer);
        if (this.webInstance != null && this.webInstance.getServer().equals(oldServer)) {
            this.setDefaultWebInstance(null);
            this.getDefaultWebInstance();
        }
        if (this.appInstance != null && this.appInstance.getServer().equals(oldServer)) {
            this.setDefaultAppInstance(null);
            this.getDefaultAppInstance();
        }
    }

    private String[] readExtension(String attributeName) {
        this.readLayerFile();
        Iterator i = this.pluginMap.keySet().iterator();
        Vector<String> v = new Vector<String>();
        while (i.hasNext()) {
            FileObject fo = (FileObject)i.next();
            String att = (String)fo.getAttribute(attributeName);
            if (att == null) continue;
            StringTokenizer tok = new StringTokenizer(att, ",");
            while (tok.hasMoreElements()) {
                v.add(tok.nextToken());
            }
        }
        Object[] ret = new String[v.size()];
        v.copyInto(ret);
        return ret;
    }

    public String[] getAppExtensions() {
        return this.readExtension("appext");
    }

    public String[] getAppClientExtensions() {
        return this.readExtension("appclientext");
    }

    public String[] getJ2eeConnExtensions() {
        return this.readExtension("connext");
    }

    public String[] getEjbModuleExtensions() {
        return this.readExtension("ejbmoduleext");
    }

    public String[] getEjbExtensions() {
        return this.readExtension("ejbext");
    }

    public String[] getWebExtensions() {
        return this.readExtension("webext");
    }

    private static String getStackTrace() {
        Exception t = new Exception();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    private void fireExtensionEvent() {
        if (this.elisteners == null) {
            return;
        }
        Object[] list = this.elisteners.getListenerList();
        int i = 0;
        while (i < list.length) {
            if (list[i] == (class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryExtensionListener == null ? ServerRegistryImpl.class$("org.netbeans.modules.j2ee.impl.ServerRegistryImpl$ServerRegistryExtensionListener") : class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryExtensionListener)) {
                ((ServerRegistryExtensionListener)list[i + 1]).extensionsChanged();
            }
            i += 2;
        }
    }

    private void fireServerEvent(Server srv, boolean added) {
        if (this.listeners == null) {
            return;
        }
        ServerEvent evt = new ServerEvent(this, srv);
        Object[] list = this.listeners.getListenerList();
        int i = 0;
        while (i < list.length) {
            if (list[i] == (class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryListener == null ? ServerRegistryImpl.class$("org.netbeans.modules.j2ee.impl.ServerRegistryImpl$ServerRegistryListener") : class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryListener)) {
                if (added) {
                    ((ServerRegistryListener)list[i + 1]).added(evt);
                } else {
                    ((ServerRegistryListener)list[i + 1]).removed(evt);
                }
            }
            i += 2;
        }
    }

    private void fireInstanceEvent(ServerInstance inst, boolean appSrv) {
        if (this.listeners == null) {
            return;
        }
        InstanceEvent evt = new InstanceEvent(this, inst);
        Object[] list = this.listeners.getListenerList();
        int i = 0;
        while (i < list.length) {
            if (list[i] == (class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryListener == null ? ServerRegistryImpl.class$("org.netbeans.modules.j2ee.impl.ServerRegistryImpl$ServerRegistryListener") : class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryListener)) {
                if (appSrv) {
                    ((ServerRegistryListener)list[i + 1]).setAppDefault(evt);
                } else {
                    ((ServerRegistryListener)list[i + 1]).setWebDefault(evt);
                }
            }
            i += 2;
        }
    }

    String getServersString() {
        Server[] slist = this.getServers();
        StringBuffer rval = new StringBuffer();
        int i = 0;
        while (slist != null && i < slist.length) {
            rval.append("#");
            rval.append(i);
            rval.append(": ");
            rval.append(slist[i].getClass().getName());
            rval.append(" - ");
            rval.append(slist[i].getDisplayName());
            rval.append("\n");
            ++i;
        }
        return rval.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class WeakServerRegistryListener
    extends WeakListener
    implements ServerRegistryListener {
        static /* synthetic */ Class class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryListener;

        public WeakServerRegistryListener(ServerRegistryListener l) {
            super(class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryListener == null ? (class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryListener = WeakServerRegistryListener.class$("org.netbeans.modules.j2ee.impl.ServerRegistryImpl$ServerRegistryListener")) : class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryListener, (EventListener)l);
        }

        protected String removeMethodName() {
            return "removeServerRegistryListener";
        }

        public void added(ServerEvent added) {
            ServerRegistryListener l = (ServerRegistryListener)super.get((EventObject)added);
            if (l != null) {
                l.added(added);
            }
        }

        public void setAppDefault(InstanceEvent inst) {
            ServerRegistryListener l = (ServerRegistryListener)super.get((EventObject)inst);
            if (l != null) {
                l.setAppDefault(inst);
            }
        }

        public void setWebDefault(InstanceEvent inst) {
            ServerRegistryListener l = (ServerRegistryListener)super.get((EventObject)inst);
            if (l != null) {
                l.setWebDefault(inst);
            }
        }

        public void removed(ServerEvent removed) {
            ServerRegistryListener l = (ServerRegistryListener)super.get((EventObject)removed);
            if (l != null) {
                l.removed(removed);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class WeakServerRegistryExtensionListener
    extends WeakListener
    implements ServerRegistryExtensionListener {
        static /* synthetic */ Class class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryExtensionListener;

        public WeakServerRegistryExtensionListener(ServerRegistryExtensionListener l) {
            super(class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryExtensionListener == null ? (class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryExtensionListener = WeakServerRegistryExtensionListener.class$("org.netbeans.modules.j2ee.impl.ServerRegistryImpl$ServerRegistryExtensionListener")) : class$org$netbeans$modules$j2ee$impl$ServerRegistryImpl$ServerRegistryExtensionListener, (EventListener)l);
        }

        protected String removeMethodName() {
            return "removeServerRegistryExtensionListener";
        }

        public void extensionsChanged() {
            ServerRegistryExtensionListener l = (ServerRegistryExtensionListener)super.get(new EventObject(ServerRegistryImpl.getRegistry()));
            if (l != null) {
                l.extensionsChanged();
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static interface ServerRegistryListener
    extends EventListener {
        public void added(ServerEvent var1);

        public void setAppDefault(InstanceEvent var1);

        public void setWebDefault(InstanceEvent var1);

        public void removed(ServerEvent var1);
    }

    public static interface ServerRegistryExtensionListener
    extends EventListener {
        public void extensionsChanged();
    }

    public static class ServerEvent
    extends EventObject {
        protected Server appSrv;

        public ServerEvent(ServerRegistryImpl reg, Server theServer) {
            super(reg);
            this.appSrv = theServer;
        }

        public Server getServer() {
            return this.appSrv;
        }
    }

    public static class InstanceEvent
    extends EventObject {
        protected ServerInstance instance;

        public InstanceEvent(ServerRegistryImpl reg, ServerInstance theInstance) {
            super(reg);
            this.instance = theInstance;
        }

        public ServerInstance getInstance() {
            return this.instance;
        }
    }
}

