/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.impl;

import org.netbeans.modules.j2ee.impl.ServerInstanceData;
import org.netbeans.modules.j2ee.impl.ServerRegistryImpl;
import org.netbeans.modules.j2ee.server.Server;
import org.netbeans.modules.j2ee.server.ServerInstance;

public final class ServerUtilities {
    public static final Server findServer(String serverID) {
        return ServerUtilities.findServer(serverID, true, true);
    }

    public static final Server findServer(String serverID, boolean searchWebServers, boolean searchAppServers) {
        if (serverID == null || serverID.length() < 1) {
            return null;
        }
        Server[] servers = ServerUtilities.getServers(searchWebServers, searchAppServers);
        if (servers == null || servers.length == 0) {
            return null;
        }
        int i = 0;
        while (i < servers.length) {
            if (servers[i].getID().equals(serverID)) {
                return servers[i];
            }
            ++i;
        }
        return null;
    }

    public static final ServerInstance findServerInstance(String instanceID) {
        return ServerUtilities.findServerInstance(instanceID, null, true, true);
    }

    public static final ServerInstance findServerInstance(String instanceID, String serverID) {
        return ServerUtilities.findServerInstance(instanceID, serverID, true, true);
    }

    public static final ServerInstance findServerInstance(String instanceID, boolean searchWebServers, boolean searchAppServers) {
        return ServerUtilities.findServerInstance(instanceID, null, searchWebServers, searchAppServers);
    }

    public static final ServerInstance findServerInstance(ServerInstanceData siData) {
        return ServerUtilities.findServerInstance(siData.getInstanceID(), siData.getServerID(), true, true);
    }

    public static final ServerInstance findServerInstance(ServerInstanceData siData, boolean searchWebServers, boolean searchAppServers) {
        return ServerUtilities.findServerInstance(siData.getInstanceID(), siData.getServerID(), searchWebServers, searchAppServers);
    }

    public static final ServerInstance findServerInstance(String instanceID, String serverID, boolean searchWebServers, boolean searchAppServers) {
        block9: {
            Server server;
            block8: {
                if (instanceID == null || instanceID.length() < 1) {
                    return null;
                }
                server = ServerUtilities.findServer(serverID, searchWebServers, searchWebServers);
                if (server != null) break block8;
                Server[] servers = ServerUtilities.getServers(searchWebServers, searchAppServers);
                if (servers == null || servers.length <= 0) break block9;
                int i = 0;
                while (i < servers.length) {
                    ServerInstance[] instances = servers[i].getServerInstances();
                    if (instances != null && instances.length > 0) {
                        int j = 0;
                        while (j < instances.length) {
                            if (instances[j].getID() != null && instances[j].getID().equals(instanceID)) {
                                return instances[j];
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                break block9;
            }
            ServerInstance[] instances = server.getServerInstances();
            if (instances == null || instances.length == 0) {
                return null;
            }
            int j = 0;
            while (j < instances.length) {
                if (instances[j].getID().equals(instanceID)) {
                    return instances[j];
                }
                ++j;
            }
        }
        return null;
    }

    public static Server[] getServers(boolean webServers, boolean appServers) {
        Server[] servers = null;
        ServerRegistryImpl registry = ServerRegistryImpl.getRegistry();
        if (webServers) {
            servers = appServers ? registry.getServers() : registry.getWebOnlyServers();
        } else if (appServers) {
            servers = registry.getAppServers();
        }
        return servers;
    }
}

