/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import org.openide.ErrorManager;

public class TrailingFileInputStream
extends FileInputStream {
    static final long DEFAULT_POLLING_INTERVAL = 500L;
    private long pollingInterval = 500L;

    public void setPollingInterval(long milliSeconds) {
        this.pollingInterval = milliSeconds;
    }

    public long getPollingInterval() {
        return this.pollingInterval;
    }

    public TrailingFileInputStream(String filename) throws FileNotFoundException {
        super(filename);
        try {
            while (this.available() > 1) {
                this.skip(this.available() - 1);
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(4096, (Throwable)ioe);
        }
    }

    public TrailingFileInputStream(File f) throws FileNotFoundException {
        super(f);
        try {
            while (this.available() > 1) {
                this.skip(this.available() - 1);
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(4096, (Throwable)ioe);
        }
    }

    public int read() throws IOException {
        try {
            while (this.available() <= 1) {
                Thread.sleep(this.pollingInterval);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return super.read();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            while (this.available() <= 1) {
                Thread.sleep(this.pollingInterval);
            }
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        int readLen = this.available() - 1;
        if (readLen > b.length - off) {
            readLen = b.length - off;
        }
        if (readLen > len) {
            readLen = len;
        }
        return super.read(b, off, readLen);
    }

    public static void main(String[] args) {
        try {
            TrailingFileInputStream tis = new TrailingFileInputStream(new File("/tmp/Test.txt"));
            BufferedReader br = new BufferedReader(new InputStreamReader(tis));
            while (true) {
                String line = br.readLine();
                System.out.println(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

