/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.j2ee.impl.ServerInstanceData;
import org.netbeans.modules.j2ee.impl.ServerUtilities;
import org.netbeans.modules.j2ee.server.Server;
import org.netbeans.modules.j2ee.server.ServerInstance;
import org.netbeans.modules.j2ee.ui.ServerRegistryCookie;
import org.netbeans.modules.j2ee.ui.ServerRegistryNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ServerInstanceSelector
extends JPanel
implements EnhancedCustomPropertyEditor {
    private String subTitle;
    private boolean showWebServers;
    private boolean showAppServers;
    private ServerInstance curInstance;
    private Server curServer;
    private Node curNode;
    private Dialog dialog;
    private DialogDescriptor dialogDescriptor;
    private PropertyChangeSupport propSupp;
    private String subTitleMnemonic;
    private String subTitleA11yDesc;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$server$ServerInstance;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$ui$ServerRegistryCookie;

    public ServerInstanceSelector() {
        this(true, true);
    }

    public ServerInstanceSelector(boolean showWebServers, boolean showAppServers) {
        if (!showWebServers && !showAppServers) {
            this.showWebServers = true;
            this.showAppServers = true;
        } else {
            this.showWebServers = showWebServers;
            this.showAppServers = showAppServers;
        }
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector == null ? (class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector = ServerInstanceSelector.class$("org.netbeans.modules.j2ee.ui.ServerInstanceSelector")) : class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector), (String)"ACS_ServerInstanceDesc"));
    }

    public void addNotify() {
        this.initComponent();
        super.addNotify();
    }

    private Node findInstanceNode(Node root, ServerInstance instance, Server server) {
        Children ch = root.getChildren();
        Node[] n = ch.getNodes();
        if (n == null || n.length < 1) {
            return null;
        }
        int i = 0;
        while (i < n.length) {
            Node node = null;
            ServerInstance siInst = (ServerInstance)n[i].getCookie(class$org$netbeans$modules$j2ee$server$ServerInstance == null ? ServerInstanceSelector.class$("org.netbeans.modules.j2ee.server.ServerInstance") : class$org$netbeans$modules$j2ee$server$ServerInstance);
            if (siInst != null) {
                if (siInst.getID() != null && siInst.getID().equals(instance.getID()) && siInst.getServer() != null && siInst.getServer().getID() != null && siInst.getServer().getID().equals(server.getID())) {
                    node = n[i];
                }
            } else {
                node = this.findInstanceNode(n[i], instance, server);
            }
            if (node != null) {
                return node;
            }
            ++i;
        }
        return null;
    }

    private void enableOKButton(Boolean b) {
        if (this.propSupp != null) {
            this.propSupp.firePropertyChange("propertyValueValid", null, b);
        }
        if (this.dialogDescriptor != null) {
            this.dialogDescriptor.setValid(b.booleanValue());
        }
    }

    private void initComponent() {
        ExplorerManager mgr;
        GridBagConstraints gbc;
        JLabel[] subTitleLabel;
        int yval;
        block10: {
            yval = 0;
            subTitleLabel = new JLabel[]{null};
            if (this.subTitle != null) {
                subTitleLabel[0] = new JLabel(this.subTitle);
                if (this.subTitleMnemonic != null) {
                    subTitleLabel[0].setDisplayedMnemonic(this.subTitleMnemonic.charAt(0));
                }
                if (this.subTitleA11yDesc != null) {
                    subTitleLabel[0].getAccessibleContext().setAccessibleDescription(this.subTitleA11yDesc);
                }
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = yval++;
                gbc.gridwidth = 0;
                gbc.anchor = 18;
                gbc.insets = new Insets(12, 12, 0, 12);
                this.add((Component)subTitleLabel[0], gbc);
            }
            Node n = ServerRegistryNode.getRuntimeTabNode();
            Children ch = n.getChildren();
            Node[] chNodes = ch.getNodes();
            int i = 0;
            while (i < chNodes.length) {
                if (chNodes[i].getCookie(class$org$netbeans$modules$j2ee$ui$ServerRegistryCookie == null ? ServerInstanceSelector.class$("org.netbeans.modules.j2ee.ui.ServerRegistryCookie") : class$org$netbeans$modules$j2ee$ui$ServerRegistryCookie) != null) break;
                ++i;
            }
            if (i == chNodes.length) {
                JLabel l = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector == null ? (class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector = ServerInstanceSelector.class$("org.netbeans.modules.j2ee.ui.ServerInstanceSelector")) : class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector), (String)"MSG_NoServers"));
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = yval++;
                gbc.gridwidth = 0;
                gbc.anchor = 18;
                gbc.insets = new Insets(12, 12, 0, 12);
                this.add((Component)l, gbc);
                return;
            }
            Node rootNode = chNodes[i];
            if (!this.showAppServers || !this.showWebServers) {
                rootNode = this.showWebServers ? ((ServerRegistryCookie)chNodes[i].getCookie(class$org$netbeans$modules$j2ee$ui$ServerRegistryCookie == null ? (class$org$netbeans$modules$j2ee$ui$ServerRegistryCookie = ServerInstanceSelector.class$("org.netbeans.modules.j2ee.ui.ServerRegistryCookie")) : class$org$netbeans$modules$j2ee$ui$ServerRegistryCookie)).getWebNode() : ((ServerRegistryCookie)chNodes[i].getCookie(class$org$netbeans$modules$j2ee$ui$ServerRegistryCookie == null ? (class$org$netbeans$modules$j2ee$ui$ServerRegistryCookie = ServerInstanceSelector.class$("org.netbeans.modules.j2ee.ui.ServerRegistryCookie")) : class$org$netbeans$modules$j2ee$ui$ServerRegistryCookie)).getAppNode();
            }
            this.curNode = null;
            if (this.curInstance != null && this.curServer != null) {
                this.curNode = this.findInstanceNode(rootNode, this.curInstance, this.curServer);
            }
            mgr = new ExplorerManager();
            mgr.addPropertyChangeListener(new PropertyChangeListener(){
                static /* synthetic */ Class class$org$netbeans$modules$j2ee$server$ServerInstance;

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("selectedNodes")) {
                        Node[] nodes = (Node[])evt.getNewValue();
                        Boolean selOK = Boolean.FALSE;
                        ServerInstanceSelector.this.curInstance = null;
                        ServerInstanceSelector.this.curServer = null;
                        ServerInstanceSelector.this.curNode = null;
                        if (nodes == null || nodes.length == 0) {
                            return;
                        }
                        ServerInstanceSelector.this.curNode = nodes[0];
                        ServerInstanceSelector.this.curInstance = (ServerInstance)nodes[0].getCookie(1.class$org$netbeans$modules$j2ee$server$ServerInstance == null ? (1.class$org$netbeans$modules$j2ee$server$ServerInstance = 1.class$("org.netbeans.modules.j2ee.server.ServerInstance")) : 1.class$org$netbeans$modules$j2ee$server$ServerInstance);
                        if (ServerInstanceSelector.this.curInstance != null) {
                            ServerInstanceSelector.this.curServer = ServerInstanceSelector.this.curInstance.getServer();
                            selOK = Boolean.TRUE;
                        }
                        ServerInstanceSelector.this.enableOKButton(selOK);
                    }
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            });
            mgr.setRootContext(rootNode);
            if (this.curNode != null) {
                try {
                    mgr.setSelectedNodes(new Node[]{this.curNode});
                }
                catch (Exception ex) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block10;
                    ex.printStackTrace();
                }
            }
        }
        ExplorerPanel expPanel = new ExplorerPanel(mgr);
        expPanel.setPreferredSize(new Dimension(300, 200));
        BeanTreeView tView = new BeanTreeView(){

            public void addNotify() {
                ((TreeView)this).tree.getSelectionModel().setSelectionMode(1);
                if (subTitleLabel[0] != null) {
                    subTitleLabel[0].setLabelFor(((TreeView)this).tree);
                }
                super.addNotify();
            }
        };
        tView.setPopupAllowed(false);
        tView.setDefaultActionAllowed(false);
        tView.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector == null ? (class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector = ServerInstanceSelector.class$("org.netbeans.modules.j2ee.ui.ServerInstanceSelector")) : class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector), (String)"ACS_TreeName"));
        tView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector == null ? (class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector = ServerInstanceSelector.class$("org.netbeans.modules.j2ee.ui.ServerInstanceSelector")) : class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector), (String)"ACS_TreeDesc"));
        expPanel.add((Component)tView, "Center");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = yval;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.insets = new Insets(12, 12, 12, 12);
        gbc.fill = 1;
        this.add((Component)expPanel, gbc);
    }

    public void setPropertyChangeSupport(PropertyChangeSupport supp) {
        this.propSupp = supp;
    }

    public void setText(String subtitle) {
        this.subTitle = subtitle;
    }

    public void setTextMnemonic(String mnemonic) {
        this.subTitleMnemonic = mnemonic;
    }

    public void setTextA11yDesc(String desc) {
        this.subTitleA11yDesc = desc;
    }

    public void setServerInstance(ServerInstance instObj) {
        this.curInstance = instObj;
        this.curServer = this.curInstance != null ? this.curInstance.getServer() : null;
    }

    public void setServerInstance(ServerInstanceData instData) {
        this.curServer = null;
        this.curInstance = null;
        if (instData == null) {
            return;
        }
        this.setServerInstance(instData.getServerID(), instData.getInstanceID());
    }

    public void setServerInstance(String instance) {
        this.setServerInstance(null, instance);
    }

    public void setServerInstance(String server, String instance) {
        this.curServer = null;
        this.curInstance = null;
        if (instance == null) {
            return;
        }
        if (server != null) {
            this.curServer = ServerUtilities.findServer(server, this.showWebServers, this.showAppServers);
        }
        this.curInstance = ServerUtilities.findServerInstance(instance, server, this.showWebServers, this.showAppServers);
        if (this.curInstance != null && this.curServer == null) {
            this.curServer = this.curInstance.getServer();
        }
    }

    public ServerInstance getServerInstance() {
        return this.curInstance;
    }

    public String getServerInstanceID() {
        if (this.curInstance == null) {
            return null;
        }
        return this.curInstance.getID();
    }

    public String getServerID() {
        if (this.curInstance == null) {
            return null;
        }
        return this.curInstance.getServer().getID();
    }

    public Object getPropertyValue() {
        if (this.curInstance == null && this.curServer == null && this.propSupp != null) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector == null ? (class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector = ServerInstanceSelector.class$("org.netbeans.modules.j2ee.ui.ServerInstanceSelector")) : class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector), (String)"MSG_NoInstanceSelected"), 0);
            this.propSupp.firePropertyChange("propertyValueValid", msg, Boolean.FALSE);
            throw new IllegalStateException();
        }
        return this.getServerInstanceData();
    }

    public ServerInstanceData getServerInstanceData() {
        if (this.curServer == null || this.curInstance == null) {
            return null;
        }
        return new ServerInstanceData(this.curServer.getID(), this.curInstance.getID());
    }

    private void closeDialog() {
        ((Component)this.dialog).setVisible(false);
        this.dialog.dispose();
        this.dialog = null;
    }

    public boolean showDialog(String title) {
        return this.showDialog(title, null);
    }

    public boolean showDialog(String title, String helpId) {
        ActionListener listener = new ActionListener(){
            static /* synthetic */ Class class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector;

            public void actionPerformed(ActionEvent evt) {
                Object o = evt.getSource();
                if (o == NotifyDescriptor.CANCEL_OPTION) {
                    ServerInstanceSelector.this.closeDialog();
                    return;
                }
                if (ServerInstanceSelector.this.curNode == null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector == null ? (class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector = 3.class$("org.netbeans.modules.j2ee.ui.ServerInstanceSelector")) : class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector), (String)"MSG_NoInstanceSelected"), 0));
                } else if (ServerInstanceSelector.this.curInstance == null || ServerInstanceSelector.this.curServer == null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector == null ? (class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector = 3.class$("org.netbeans.modules.j2ee.ui.ServerInstanceSelector")) : class$org$netbeans$modules$j2ee$ui$ServerInstanceSelector), (String)"MSG_NotServerInstance"), 0));
                } else {
                    ServerInstanceSelector.this.closeDialog();
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        };
        this.dialogDescriptor = new DialogDescriptor((Object)this, title, true, listener);
        if (helpId != null) {
            this.dialogDescriptor.setHelpCtx(new HelpCtx(helpId));
        }
        this.dialogDescriptor.setClosingOptions(new Object[]{NotifyDescriptor.CANCEL_OPTION});
        this.dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        ((Component)this.dialog).setVisible(true);
        if (this.dialogDescriptor.getValue() == NotifyDescriptor.OK_OPTION) {
            return true;
        }
        this.dialogDescriptor = null;
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

