/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ui.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditorSupport;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.netbeans.modules.j2ee.impl.ServerInstanceData;
import org.netbeans.modules.j2ee.impl.ServerRegistryImpl;
import org.netbeans.modules.j2ee.impl.ServerUtilities;
import org.netbeans.modules.j2ee.server.Server;
import org.netbeans.modules.j2ee.server.ServerInstance;
import org.netbeans.modules.j2ee.ui.ServerInstanceSelector;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.PropertySheetSettings;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public class ServerInstancePropEditor
extends PropertyEditorSupport {
    private static final String DEFAULT_APP_SERVER = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"LBL_UseDefaultApp");
    private static final String DEFAULT_WEB_SERVER = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"LBL_UseDefaultWeb");
    private static final int MAX_SERVERS = 10;
    private PropertyChangeSupport propSupp = new PropertyChangeSupport(this);
    private DisplayData allInstances;
    private boolean canUseWebServer = true;
    private boolean canUseAppServer = true;
    private static Dialog dialog = null;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertySheetSettings;

    public ServerInstancePropEditor() {
    }

    public ServerInstancePropEditor(boolean webServers, boolean appServers) {
        this();
        this.canUseWebServer = webServers;
        this.canUseAppServer = appServers;
    }

    private void getAllInstances() {
        ServerInstance sInst;
        this.allInstances = new DisplayData();
        Server[] servers = ServerUtilities.getServers(this.canUseWebServer, this.canUseAppServer);
        if (servers == null || servers.length == 0) {
            return;
        }
        if (this.canUseAppServer) {
            sInst = ServerRegistryImpl.getRegistry().getDefaultAppInstance();
            if (sInst != null) {
                this.allInstances.add(DEFAULT_APP_SERVER, null);
            }
        } else {
            sInst = ServerRegistryImpl.getRegistry().getDefaultWebInstance();
            if (sInst != null) {
                this.allInstances.add(DEFAULT_WEB_SERVER, null);
            }
        }
        int i = 0;
        while (i < servers.length) {
            ServerInstance[] instances = servers[i].getServerInstances();
            if (instances != null && instances.length > 0) {
                int j = 0;
                while (j < instances.length) {
                    this.allInstances.add(instances[j].getDisplayName(), instances[j]);
                    ++j;
                }
            }
            ++i;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.propSupp.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.propSupp.removePropertyChangeListener(listener);
    }

    public String getAsText() {
        if (!this.canUseWebServer && !this.canUseAppServer) {
            return null;
        }
        if (this.allInstances == null) {
            this.getAllInstances();
        }
        if (this.allInstances.size() == 0 || this.allInstances.size() > 10) {
            return null;
        }
        return this.getDisplayText();
    }

    private String getDisplayText() {
        ServerInstanceData siData = (ServerInstanceData)this.getValue();
        String disp = null;
        if (siData == null || siData.getInstanceID() == null) {
            disp = this.canUseAppServer ? DEFAULT_APP_SERVER : DEFAULT_WEB_SERVER;
        } else {
            ServerInstance inst = ServerUtilities.findServerInstance(siData, this.canUseWebServer, this.canUseAppServer);
            if (inst == null) {
                disp = this.canUseAppServer ? DEFAULT_APP_SERVER : DEFAULT_WEB_SERVER;
            } else {
                disp = inst.getDisplayName();
                if (disp == null || disp.length() < 1) {
                    disp = inst.getID();
                }
            }
        }
        return disp;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        String instString;
        if (this.allInstances == null || this.allInstances.size() == 0) {
            instString = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"LBL_NoServerInstances");
            gfx.setColor(Color.red);
        } else {
            instString = this.getDisplayText();
            PropertySheetSettings pss = (PropertySheetSettings)SharedClassObject.findObject((Class)(class$org$openide$explorer$propertysheet$PropertySheetSettings == null ? (class$org$openide$explorer$propertysheet$PropertySheetSettings = ServerInstancePropEditor.class$("org.openide.explorer.propertysheet.PropertySheetSettings")) : class$org$openide$explorer$propertysheet$PropertySheetSettings), (boolean)true);
            gfx.setColor(pss.getValueColor());
        }
        FontMetrics fm = gfx.getFontMetrics();
        gfx.drawString(instString, 4, (box.height - fm.getHeight()) / 2 + 1 + fm.getMaxAscent());
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (this.allInstances == null || this.allInstances.size() == 0) {
            return;
        }
        ServerInstance inst = this.allInstances.findServerInstance(text);
        if (inst != null) {
            ServerInstanceData data = new ServerInstanceData(inst.getServer().getID(), inst.getID());
            this.setValue(data);
        } else {
            this.setValue(null);
        }
    }

    public boolean supportsCustomEditor() {
        if (!this.canUseWebServer && !this.canUseAppServer) {
            return false;
        }
        if (this.allInstances == null || this.allInstances.size() == 0) {
            this.getAllInstances();
        }
        return this.allInstances.size() != 0 || dialog == null;
    }

    public Component getCustomEditor() {
        if (this.allInstances == null) {
            this.getAllInstances();
        }
        if (this.allInstances.size() == 0) {
            String aDesc;
            String err;
            if (dialog != null) {
                return null;
            }
            if (this.canUseWebServer) {
                if (this.canUseAppServer) {
                    err = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"LBL_NoServers");
                    aDesc = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"ACS_NoServers");
                } else {
                    err = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"LBL_NoWebServers");
                    aDesc = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"ACS_NoWebServers");
                }
            } else {
                err = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"LBL_NoAppServers");
                aDesc = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"ACS_NoAppServers");
            }
            JOptionPane oPane = new JOptionPane(err, 1);
            oPane.setOptions(new Object[0]);
            oPane.getAccessibleContext().setAccessibleDescription(aDesc);
            DialogDescriptor dd = new DialogDescriptor((Object)oPane, NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"LBL_NoServerInstances"), false, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION, -1, null, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    dialog = null;
                }
            });
            dialog = DialogDisplayer.getDefault().createDialog(dd);
            return dialog;
        }
        ServerInstanceSelector selector = new ServerInstanceSelector(this.canUseWebServer, this.canUseAppServer);
        selector.setServerInstance((ServerInstanceData)this.getValue());
        String title = this.canUseWebServer ? (this.canUseAppServer ? NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"LBL_SelectServer") : NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"LBL_SelectWebServer")) : NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"LBL_SelectAppServer");
        selector.setText(title);
        selector.setTextMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor == null ? (class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor = ServerInstancePropEditor.class$("org.netbeans.modules.j2ee.ui.editors.ServerInstancePropEditor")) : class$org$netbeans$modules$j2ee$ui$editors$ServerInstancePropEditor), (String)"LBL_SelectServer_Mnemonic"));
        selector.setPropertyChangeSupport(this.propSupp);
        return selector;
    }

    public String[] getTags() {
        if (!this.canUseWebServer && !this.canUseAppServer) {
            return null;
        }
        if (this.allInstances == null) {
            this.getAllInstances();
        }
        if (this.allInstances.size() == 0 || this.allInstances.size() > 10) {
            return null;
        }
        String[] retVals = this.allInstances.getDisplayNames();
        return retVals;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DisplayData {
        private Vector displayNames = new Vector();
        private Vector instances = new Vector();

        DisplayData() {
        }

        void add(String s, ServerInstance si) {
            if (s == null || s.trim().length() == 0) {
                return;
            }
            this.displayNames.add(s);
            if (si == null) {
                this.instances.add(new Object());
            } else {
                this.instances.add(si);
            }
        }

        int size() {
            return this.displayNames.size();
        }

        String[] getDisplayNames() {
            Object[] names = new String[this.displayNames.size()];
            this.displayNames.copyInto(names);
            return names;
        }

        ServerInstance findServerInstance(String text) {
            int idx = this.displayNames.indexOf(text);
            Object o = this.instances.get(idx);
            if (o instanceof ServerInstance) {
                return (ServerInstance)o;
            }
            return null;
        }
    }
}

