/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.grammar;

import java.util.Vector;
import org.netbeans.modules.xsl.grammar.ResultAttr;
import org.netbeans.modules.xsl.grammar.ResultDocument;
import org.netbeans.modules.xsl.grammar.ResultElement;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResultNode
implements Node {
    protected Node peer;
    protected String ignorePrefix;
    protected String onlyUsePrefix;

    public ResultNode(Node peer, String ignorePrefix, String onlyUsePrefix) {
        this.peer = peer;
        this.ignorePrefix = ignorePrefix;
        this.onlyUsePrefix = onlyUsePrefix;
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.createNode(this.peer.appendChild(newChild));
    }

    public Node cloneNode(boolean deep) {
        return this.createNode(this.peer.cloneNode(deep));
    }

    public NamedNodeMap getAttributes() {
        return this.peer.getAttributes();
    }

    public NodeList getChildNodes() {
        return new ResultNodeList(this.peer.getChildNodes());
    }

    public Node getFirstChild() {
        NodeList childNodes = this.getChildNodes();
        if (childNodes.getLength() == 0) {
            return null;
        }
        return childNodes.item(0);
    }

    public Node getLastChild() {
        ResultNodeList childNodes = new ResultNodeList(this.peer.getChildNodes());
        if (childNodes.getLength() == 0) {
            return null;
        }
        return childNodes.item(childNodes.getLength() - 1);
    }

    public String getLocalName() {
        return this.peer.getLocalName();
    }

    public String getNamespaceURI() {
        return this.peer.getNamespaceURI();
    }

    public Node getNextSibling() {
        Node node = this.peer.getNextSibling();
        while (node != null && node.getNodeName() != null && !this.hasAllowedPrefix(node.getNodeName())) {
            node = node.getNextSibling();
        }
        if (node == null) {
            return null;
        }
        return this.createNode(node);
    }

    public String getNodeName() {
        return this.peer.getNodeName();
    }

    public short getNodeType() {
        return this.peer.getNodeType();
    }

    public String getNodeValue() throws DOMException {
        return this.peer.getNodeValue();
    }

    public Document getOwnerDocument() {
        return this.peer.getOwnerDocument();
    }

    public Node getParentNode() {
        Node node = this.peer.getParentNode();
        while (node != null && node.getNodeName() != null && !this.hasAllowedPrefix(node.getNodeName())) {
            node = node.getParentNode();
        }
        if (node == null) {
            return null;
        }
        return this.createNode(node);
    }

    public String getPrefix() {
        return this.peer.getPrefix();
    }

    public Node getPreviousSibling() {
        Node node = this.peer.getPreviousSibling();
        while (node != null && node.getNodeName() != null && !this.hasAllowedPrefix(node.getNodeName())) {
            node = node.getPreviousSibling();
        }
        if (node == null) {
            return null;
        }
        return this.createNode(node);
    }

    public boolean hasAttributes() {
        return this.peer.hasAttributes();
    }

    public boolean hasChildNodes() {
        return this.getChildNodes().getLength() > 0;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.createNode(this.peer.insertBefore(newChild, refChild));
    }

    public boolean isSupported(String feature, String version) {
        return this.peer.isSupported(feature, version);
    }

    public void normalize() {
        this.peer.normalize();
    }

    public Node removeChild(Node oldChild) throws DOMException {
        return this.createNode(this.peer.removeChild(oldChild));
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return this.createNode(this.peer.replaceChild(newChild, oldChild));
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this.peer.setNodeValue(nodeValue);
    }

    public void setPrefix(String prefix) throws DOMException {
        this.peer.setPrefix(prefix);
    }

    protected Node createNode(Node orig) {
        if (orig.getNodeType() == 1) {
            return new ResultElement((Element)orig, this.ignorePrefix, this.onlyUsePrefix);
        }
        if (orig.getNodeType() == 9) {
            return new ResultDocument((Document)orig, this.ignorePrefix, this.onlyUsePrefix);
        }
        if (orig.getNodeType() == 2) {
            return new ResultAttr((Attr)orig, this.ignorePrefix, this.onlyUsePrefix);
        }
        return orig;
    }

    protected boolean hasAllowedPrefix(String name) {
        if (this.onlyUsePrefix != null) {
            return name.startsWith(this.onlyUsePrefix);
        }
        if (this.ignorePrefix != null) {
            return !name.startsWith(this.ignorePrefix);
        }
        return name.indexOf(58) == -1;
    }

    public class ResultNodeList
    implements NodeList {
        Vector nodeVector;

        public ResultNodeList(NodeList list) {
            this.nodeVector = new Vector(list.getLength());
            int ind = 0;
            while (ind < list.getLength()) {
                Node node = list.item(ind);
                if (node.getNodeName() != null && ResultNode.this.hasAllowedPrefix(node.getNodeName())) {
                    this.nodeVector.add(ResultNode.this.createNode(node));
                }
                ++ind;
            }
        }

        public int getLength() {
            return this.nodeVector.size();
        }

        public Node item(int index) {
            return (Node)this.nodeVector.elementAt(index);
        }
    }
}

