/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.grammar;

import java.beans.FeatureDescriptor;
import java.util.Enumeration;
import org.netbeans.modules.xml.api.model.GrammarEnvironment;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarQueryManager;
import org.netbeans.modules.xsl.grammar.XSLGrammarQuery;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.enum.EmptyEnumeration;
import org.openide.util.enum.SingletonEnumeration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSLGrammarQueryProvider
extends GrammarQueryManager {
    static final String PUBLIC = "!!! find it out";
    static final String SYSTEM = "!!! find it out";
    static final String NAMESPACE = "http://www.w3.org/1999/XSL/Transform";
    private String prefix = null;

    public Enumeration enabled(GrammarEnvironment ctx) {
        if (ctx.getFileObject() == null) {
            return null;
        }
        this.prefix = null;
        Enumeration en = ctx.getDocumentChildren();
        while (en.hasMoreElements()) {
            String ns;
            Node next = (Node)en.nextElement();
            if (next.getNodeType() == 10 || next.getNodeType() != 1) continue;
            Element element = (Element)next;
            String tag = element.getTagName();
            if (tag.indexOf(":") == -1) {
                String ns2;
                if (!"transformation".equals(tag) && !"stylesheet".equals(tag) || !NAMESPACE.equals(ns2 = element.getAttribute("xmlns"))) continue;
                return new SingletonEnumeration((Object)next);
            }
            this.prefix = tag.substring(0, tag.indexOf(":"));
            String local = tag.substring(tag.indexOf(":") + 1);
            if (!"transformation".equals(local) && !"stylesheet".equals(local) || !NAMESPACE.equals(ns = element.getAttribute("xmlns:" + this.prefix))) continue;
            return new SingletonEnumeration((Object)next);
        }
        FileObject fo = ctx.getFileObject();
        if (fo != null && "application/xslt+xml".equals(fo.getMIMEType())) {
            return EmptyEnumeration.EMPTY;
        }
        return null;
    }

    public FeatureDescriptor getDescriptor() {
        return new FeatureDescriptor();
    }

    public GrammarQuery getGrammar(GrammarEnvironment input) {
        try {
            FileObject fo = input.getFileObject();
            if (fo == null) {
                throw new IllegalStateException("GrammarEnvironment has changed between enabled() and getGrammar()!");
            }
            DataObject dataObj = DataObject.find((FileObject)fo);
            return new XSLGrammarQuery(dataObj);
        }
        catch (DataObjectNotFoundException e) {
            throw new IllegalStateException("Missing DataObject " + e.getFileObject().getPackageNameExt('/', '.') + "!");
        }
    }
}

