/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.scenario;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.modules.xml.core.actions.InputOutputReporter;
import org.netbeans.modules.xml.core.lib.FileUtilities;
import org.netbeans.modules.xml.core.lib.GuiUtil;
import org.netbeans.modules.xsl.api.XSLScenario;
import org.netbeans.modules.xsl.scenario.Util;
import org.netbeans.modules.xsl.transform.TransformServlet;
import org.netbeans.modules.xsl.ui.TransformPanel;
import org.netbeans.modules.xsl.utils.TransformUtil;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FileXSLScenario
implements Serializable,
XSLScenario,
PropertyChangeListener {
    protected Data data = new Data();
    protected String name = "";
    private transient Document sourceDoc;
    private transient TransformPanel transPanel;
    private transient DataObject lastDataObject;
    private transient PropertyChangeSupport support;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(DataObject dataObject) {
        InputOutputReporter cookieObserver;
        block21: {
            cookieObserver = new InputOutputReporter(Util.THIS.getString("PROP_transformation_io_name"));
            try {
                FileLock fileLock;
                block22: {
                    SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = FileXSLScenario.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
                    if (saveCookie != null) {
                        try {
                            saveCookie.save();
                        }
                        catch (IOException e) {
                            cookieObserver.message("Could not save file: " + e.getMessage());
                        }
                    }
                    FileObject baseFO = dataObject.getPrimaryFile();
                    URL baseURL = this.preferFileURL(baseFO);
                    Source xmlSource = TransformUtil.createSource(baseURL, this.data.getSourceXML());
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("    xmlSource = " + xmlSource.getSystemId());
                    }
                    String xslName = TransformUtil.getURLName(baseFO);
                    Source xslSource = TransformUtil.createSource(baseURL, xslName);
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("    xslSource = " + xslSource.getSystemId());
                    }
                    if (this.data.getOutput() == null) {
                        TransformServlet.prepare(null, xmlSource, xslSource);
                        this.showURL(TransformServlet.getServletURL());
                        break block21;
                    }
                    String fileName = this.data.getOutput().replace('\\', '/');
                    FileObject resultFO = FileUtilities.createFileObject((FileObject)baseFO.getParent(), (String)fileName, (boolean)this.data.isOverwrite());
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("    resultFO = " + resultFO);
                    }
                    OutputStream outputStream = null;
                    fileLock = null;
                    try {
                        try {
                            fileLock = resultFO.lock();
                            outputStream = resultFO.getOutputStream(fileLock);
                            StreamResult outputResult = new StreamResult(outputStream);
                            if (Util.THIS.isLoggable()) {
                                Util.THIS.debug("    resultFO = " + resultFO);
                                Util.THIS.debug("    outputResult = " + outputResult);
                            }
                            String xmlName = this.data.getSourceXML();
                            cookieObserver.message(Util.THIS.getString("MSG_transformation_1", xmlName, xslName));
                            TransformUtil.transform(xmlSource, null, xslSource, outputResult, null);
                            if (this.data.getProcess() == 1) {
                                GuiUtil.performDefaultAction((FileObject)resultFO);
                                GuiUtil.performDefaultAction((FileObject)resultFO);
                            } else if (this.data.getProcess() == 2) {
                                this.showURL(resultFO.getURL());
                            }
                            GuiUtil.setStatusText((String)Util.THIS.getString("MSG_opening_browser"));
                        }
                        catch (FileAlreadyLockedException exc) {
                            throw (FileAlreadyLockedException)ErrorManager.getDefault().annotate((Throwable)exc, Util.THIS.getString("ERR_FileAlreadyLockedException_output"));
                        }
                        Object var16_19 = null;
                        if (outputStream == null) break block22;
                    }
                    catch (Throwable throwable) {
                        Object var16_20 = null;
                        if (outputStream != null) {
                            outputStream.close();
                        }
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                        throw throwable;
                    }
                    outputStream.close();
                }
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
            catch (TransformerException exc) {
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
            }
        }
        cookieObserver.message(Util.THIS.getString("MSG_transformation_2"));
        cookieObserver.moveToFront();
        this.sourceDoc = null;
    }

    public Component getCustomizer(DataObject dataObject, boolean activatePropertyChange) {
        try {
            this.transPanel = new TransformPanel(null, null, dataObject);
            this.lastDataObject = dataObject;
            String sourceXML = this.data.getSourceXML();
            if (sourceXML.length() > 0) {
                FileObject baseFO = dataObject.getPrimaryFile();
                URL baseURL = this.preferFileURL(baseFO.getParent());
                URL sourceURL = new URL(baseURL, this.data.getSourceXML());
                sourceXML = sourceURL.toExternalForm();
            }
            TransformPanel.Data transData = new TransformPanel.Data(sourceXML, this.transPanel.getData().getXSL(), this.data.getOutput(), this.data.isOverwrite(), this.data.getProcess());
            this.transPanel.setData(transData);
            if (activatePropertyChange) {
                this.transPanel.addPropertyChangeListener(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.transPanel = null;
        }
        return this.transPanel;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
    }

    public void saveChanges() {
        if (this.transPanel != null) {
            TransformPanel.Data transData = this.transPanel.getData();
            String sourceXML = transData.getInput();
            FileObject baseFO = this.lastDataObject.getPrimaryFile();
            try {
                String baseURL = this.preferFileURL(baseFO.getParent()).toExternalForm();
                sourceXML = this.relativize(baseURL, sourceXML);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.data.setSourceXML(sourceXML);
            String outputStr = null;
            if (transData.getOutput() != null) {
                outputStr = transData.getOutput().toString();
            }
            this.data.setOutput(outputStr);
            this.data.setOverwrite(transData.isOverwriteOutput());
            this.data.setProcess(transData.getProcessOutput());
            this.sourceDoc = null;
        }
    }

    public Document getSourceDocument(DataObject dataObject, boolean reload) throws SAXException, IOException {
        if (this.sourceDoc == null || reload) {
            String sourceXML = this.data.getSourceXML();
            if (sourceXML == null || sourceXML.length() == 0) {
                return null;
            }
            FileObject baseFO = dataObject.getPrimaryFile();
            URL baseURL = this.preferFileURL(baseFO);
            URL url = new URL(baseURL, sourceXML);
            this.sourceDoc = XMLUtil.parse((InputSource)new InputSource(url.toExternalForm()), (boolean)false, (boolean)true, null, (EntityResolver)TransformUtil.getEntityResolver());
        }
        return this.sourceDoc;
    }

    public String toString() {
        return this.getName();
    }

    protected URL preferFileURL(FileObject fileObject) throws MalformedURLException, FileStateInvalidException {
        URL fileURL = null;
        File file = FileUtil.toFile((FileObject)fileObject);
        fileURL = file != null ? file.toURL() : fileObject.getURL();
        return fileURL;
    }

    private void showURL(URL url) {
        HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        GuiUtil.setStatusText((String)Util.THIS.getString("MSG_opening_browser"));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        this.support.removePropertyChangeListener(listener);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        if (evt.getPropertyName().equals("DATA_XML_MODIFIED") || evt.getPropertyName().equals("DATA_XSL_MODIFIED") || evt.getPropertyName().equals("DATA_OUTPUT_MODIFIED") || evt.getPropertyName().equals("DATA_OVERWRITE_MODIFIED") || evt.getPropertyName().equals("DATA_PROCESS_MODIFIED")) {
            this.support.firePropertyChange("SCENARIO_MODIFIED", evt.getOldValue(), evt.getNewValue());
        }
    }

    private String relativize(String baseURI, String url) {
        int parentTokens;
        StringTokenizer baseTok = new StringTokenizer(baseURI, "/");
        StringTokenizer urlTok = new StringTokenizer(url, "/");
        String curUrlTok = null;
        int origParentTokens = parentTokens = baseTok.countTokens();
        while (baseTok.hasMoreTokens()) {
            if (!urlTok.hasMoreTokens()) {
                curUrlTok = null;
                break;
            }
            curUrlTok = urlTok.nextToken();
            if (!curUrlTok.equals(baseTok.nextToken())) break;
            --parentTokens;
        }
        if (parentTokens == origParentTokens) {
            return url;
        }
        String resUrl = "";
        int ind = 0;
        while (ind < parentTokens) {
            resUrl = resUrl + "../";
            ++ind;
        }
        if (curUrlTok != null) {
            if (parentTokens != 0) {
                resUrl = resUrl + curUrlTok;
                if (urlTok.hasMoreTokens()) {
                    resUrl = resUrl + "/";
                }
            }
            while (urlTok.hasMoreTokens()) {
                resUrl = resUrl + urlTok.nextToken();
                if (!urlTok.hasMoreTokens()) continue;
                resUrl = resUrl + "/";
            }
        }
        return resUrl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Data
    implements Serializable {
        private String sourceXML = "";
        private String output = null;
        private boolean overwrite = true;
        private int process = -1;

        public String getSourceXML() {
            return this.sourceXML;
        }

        public void setSourceXML(String sourceXML) {
            this.sourceXML = sourceXML;
        }

        public String getOutput() {
            return this.output;
        }

        public void setOutput(String output) {
            this.output = output;
        }

        public boolean isOverwrite() {
            return this.overwrite;
        }

        public void setOverwrite(boolean overwrite) {
            this.overwrite = overwrite;
        }

        public int getProcess() {
            return this.process;
        }

        public void setProcess(int process) {
            this.process = process;
        }
    }
}

