/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.netbeans.api.xml.cookies.CookieMessage;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.cookies.TransformableCookie;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.xsl.XSLDataObject;
import org.netbeans.modules.xsl.utils.Util;
import org.netbeans.spi.xml.cookies.DefaultXMLProcessorDetail;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class TransformUtil {
    private static final String SAX_FEATURES_NAMESPACES = "http://xml.org/sax/features/namespaces";
    public static final String DEFAULT_OUTPUT_EXT = "html";
    private static TransformerFactory transformerFactory;
    private static SAXParserFactory saxParserFactory;

    public static boolean isXSLTransformation(DataObject dataObject) {
        return dataObject instanceof XSLDataObject;
    }

    public static String getURLName(FileObject fileObject) throws MalformedURLException, FileStateInvalidException {
        URL fileURL = null;
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file != null) {
            if (Util.THIS.isLoggable()) {
                try {
                    Util.THIS.debug("[TransformUtil.getURLName]");
                    Util.THIS.debug("    file = " + file);
                    Util.THIS.debug("    file.getCanonicalPath = " + file.getCanonicalPath());
                    Util.THIS.debug("    file.getAbsolutePath  = " + file.getAbsolutePath());
                    Util.THIS.debug("    file.toString  = " + file.toString());
                    Util.THIS.debug("    file.toURL  = " + file.toURL());
                }
                catch (Exception exc) {
                    Util.THIS.debug("DEBUG Exception", exc);
                }
            }
            fileURL = file.toURL();
        } else {
            fileURL = fileObject.getURL();
        }
        return fileURL.toExternalForm();
    }

    public static URL createURL(URL baseURL, String fileName) throws MalformedURLException, FileStateInvalidException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TransformUtil.createURL:");
            Util.THIS.debug("    baseURL = " + baseURL);
            Util.THIS.debug("    fileName = " + fileName);
        }
        URL url = new URL(baseURL, fileName);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    return URL = " + url);
        }
        return url;
    }

    public static Source createSource(URL baseURL, String fileName) throws IOException, MalformedURLException, FileStateInvalidException, ParserConfigurationException, SAXException {
        URL url = TransformUtil.createURL(baseURL, fileName);
        InputStream is = url.openStream();
        is.close();
        XMLReader reader = TransformUtil.newXMLReader();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TransformUtil.createSource: XMLReader (http://xml.org/sax/features/namespaces) : " + reader.getFeature(SAX_FEATURES_NAMESPACES));
        }
        reader.setEntityResolver(TransformUtil.getEntityResolver());
        SAXSource source = new SAXSource(reader, new InputSource(url.toExternalForm()));
        return source;
    }

    public static URIResolver getURIResolver() {
        UserCatalog catalog = UserCatalog.getDefault();
        URIResolver res = catalog == null ? null : catalog.getURIResolver();
        return res;
    }

    public static EntityResolver getEntityResolver() {
        UserCatalog catalog = UserCatalog.getDefault();
        EntityResolver res = catalog == null ? null : catalog.getEntityResolver();
        return res;
    }

    private static TransformerFactory getTransformerFactory() {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setURIResolver(TransformUtil.getURIResolver());
        }
        return transformerFactory;
    }

    private static SAXParserFactory getSAXParserFactory() throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (saxParserFactory == null) {
            saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setFeature(SAX_FEATURES_NAMESPACES, true);
        }
        return saxParserFactory;
    }

    public static Transformer newTransformer(Source xsl) throws TransformerConfigurationException {
        Transformer transformer = TransformUtil.getTransformerFactory().newTransformer(xsl);
        if (Util.THIS.isLoggable()) {
            transformer.setParameter("transformer", xsl);
        }
        return transformer;
    }

    public static XMLReader newXMLReader() throws ParserConfigurationException, SAXException {
        SAXParser parser = TransformUtil.getSAXParserFactory().newSAXParser();
        return parser.getXMLReader();
    }

    public static Source getAssociatedStylesheet(URL baseURL) {
        Source xml_stylesheet;
        block4: {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("TransformUtil.getAssociatedStylesheet:");
                Util.THIS.debug("    baseURL = " + baseURL);
            }
            xml_stylesheet = null;
            try {
                XMLReader reader = TransformUtil.newXMLReader();
                reader.setEntityResolver(TransformUtil.getEntityResolver());
                SAXSource source = new SAXSource(reader, new InputSource(baseURL.toExternalForm()));
                xml_stylesheet = TransformUtil.getTransformerFactory().getAssociatedStylesheet(source, null, null, null);
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("    source = " + source.getSystemId());
                    Util.THIS.debug("    xml_stylesheet = " + xml_stylesheet);
                }
            }
            catch (Exception exc) {
                if (!Util.THIS.isLoggable()) break block4;
                Util.THIS.debug("TransformUtil.getAssociatedStylesheet: !!!", exc);
            }
        }
        return xml_stylesheet;
    }

    public static String guessOutputExt(Source source) {
        String ext;
        block7: {
            ext = DEFAULT_OUTPUT_EXT;
            try {
                Transformer transformer = TransformUtil.newTransformer(source);
                String method = transformer.getOutputProperty("method");
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("[TransformUtil] guessOutputExt: method = " + method);
                }
                if ("text".equals(method)) {
                    ext = "txt";
                } else if (method != null) {
                    ext = method;
                }
            }
            catch (Exception exc) {
                if (!Util.THIS.isLoggable()) break block7;
                Util.THIS.debug(exc);
            }
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("[TransformUtil] guessOutputExt: extension = " + ext);
        }
        return ext;
    }

    public static void transform(Source xml, TransformableCookie transformable, Source xsl, Result output, CookieObserver notifier) throws TransformerException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TransformUtil.transform");
            Util.THIS.debug("    XML source = " + xml.getSystemId());
            Util.THIS.debug("    TransformableCookie = " + transformable);
            Util.THIS.debug("    XSL source = " + xsl.getSystemId());
            Util.THIS.debug("    Output Result = " + output.getSystemId());
            Util.THIS.debug("    CookieObserver = " + notifier);
        }
        if (transformable != null) {
            transformable.transform(xsl, output, notifier);
        } else {
            try {
                Transformer transformer = TransformUtil.newTransformer(xsl);
                if (notifier != null) {
                    Proxy proxy = new Proxy(notifier);
                    transformer.setErrorListener(proxy);
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("\n==> transform: param [transformer] = " + transformer.getParameter("transformer"));
                }
                transformer.transform(xml, output);
            }
            catch (Exception exc) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("    EXCEPTION during transformation: " + exc.getClass().getName(), exc);
                    Util.THIS.debug("    exception's message = " + exc.getLocalizedMessage());
                    Throwable tempExc = TransformUtil.unwrapException(exc);
                    Util.THIS.debug("    wrapped exception = " + tempExc.getLocalizedMessage());
                }
                TransformerException transExcept = null;
                DefaultXMLProcessorDetail detail = null;
                if (exc instanceof TransformerException) {
                    transExcept = (TransformerException)exc;
                    if (notifier != null && exc instanceof TransformerConfigurationException) {
                        detail = new DefaultXMLProcessorDetail(transExcept);
                    }
                } else if (exc instanceof SAXParseException) {
                    transExcept = new TransformerException(exc);
                    if (notifier != null) {
                        detail = new DefaultXMLProcessorDetail((SAXParseException)exc);
                    }
                } else {
                    transExcept = new TransformerException(exc);
                    if (notifier != null) {
                        detail = new DefaultXMLProcessorDetail(transExcept);
                    }
                }
                if (notifier != null && detail != null) {
                    CookieMessage message = new CookieMessage(TransformUtil.unwrapException(exc).getLocalizedMessage(), 3, (Object)detail);
                    notifier.receive(message);
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("--> throw transExcept: " + transExcept);
                }
                throw transExcept;
            }
        }
    }

    public static Throwable unwrapException(Throwable exc) {
        Throwable wrapped = null;
        if (exc instanceof TransformerException) {
            wrapped = ((TransformerException)exc).getException();
        } else if (exc instanceof SAXException) {
            wrapped = ((SAXException)exc).getException();
        } else {
            return exc;
        }
        if (wrapped == null) {
            return exc;
        }
        return TransformUtil.unwrapException(wrapped);
    }

    private static class Proxy
    implements ErrorListener {
        private final CookieObserver peer;

        public Proxy(CookieObserver peer) {
            if (peer == null) {
                throw new NullPointerException();
            }
            this.peer = peer;
        }

        public void error(TransformerException tex) throws TransformerException {
            this.report(2, tex);
        }

        public void fatalError(TransformerException tex) throws TransformerException {
            this.report(3, tex);
            throw tex;
        }

        public void warning(TransformerException tex) throws TransformerException {
            this.report(1, tex);
        }

        private void report(int level, TransformerException tex) throws TransformerException {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("[TransformableSupport::Proxy]: report [" + level + "]: ", tex);
                Util.THIS.debug("    exception's message = " + tex.getLocalizedMessage());
                Throwable tempExc = TransformUtil.unwrapException(tex);
                Util.THIS.debug("    wrapped exception = " + tempExc.getLocalizedMessage());
            }
            Throwable unwrappedExc = TransformUtil.unwrapException(tex);
            CookieMessage message = new CookieMessage(unwrappedExc.getLocalizedMessage(), level, (Object)new DefaultXMLProcessorDetail(tex));
            this.peer.receive(message);
        }
    }
}

