/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.netbeans.modules.autoupdate.AutoCheckInfo;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.ConnectingErrorDialog;
import org.netbeans.modules.autoupdate.Settings;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

class AutoChecker
implements Runnable,
Wizard.Validator {
    private Settings settings;
    private Updates updates;
    private HashMap allUpdates = new HashMap();
    static AutoChecker autoChecker;
    private boolean canceled = false;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$AutoChecker;

    static void doCheck() {
        autoChecker.run();
    }

    AutoChecker() {
        this.settings = Settings.getShared();
    }

    void install() {
        Autoupdater.installUpdateChecker(this);
        autoChecker = this;
    }

    public void run() {
        AutoCheckInfo info;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this);
            return;
        }
        if (!this.timeToCheck()) {
            return;
        }
        this.settings.setLastCheck(new Date());
        if (this.settings.isAskBefore() && !(info = new AutoCheckInfo(NbBundle.getMessage((Class)(class$org$netbeans$modules$autoupdate$AutoChecker == null ? (class$org$netbeans$modules$autoupdate$AutoChecker = AutoChecker.class$("org.netbeans.modules.autoupdate.AutoChecker")) : class$org$netbeans$modules$autoupdate$AutoChecker), (String)"MSG_AutoCheck_Before"), 1)).showDialog(true)) {
            return;
        }
        Autoupdater.setRunning(true);
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$autoupdate$AutoChecker == null ? (class$org$netbeans$modules$autoupdate$AutoChecker = AutoChecker.class$("org.netbeans.modules.autoupdate.AutoChecker")) : class$org$netbeans$modules$autoupdate$AutoChecker), (String)"CTL_Checking_StatusText"));
        Enumeration en = AutoupdateType.autoupdateTypes();
        int count = 0;
        while (en.hasMoreElements()) {
            AutoupdateType at = (AutoupdateType)((Object)en.nextElement());
            if (!at.isEnabled()) continue;
            ++count;
            this.updates = at.connectForUpdates();
            this.updates.checkUpdates((Wizard.Validator)this, at);
            int res = Wizard.checkConnect(this.updates);
            if (res == 0 && (this.updates.getTimeStamp() == null || at.getLastTimeStamp() == null || at.getLastTimeStamp().before(this.updates.getTimeStamp()))) {
                this.allUpdates.put(at, this.updates);
                continue;
            }
            if (res != 1) continue;
            Autoupdater.setRunning(false);
            StatusDisplayer.getDefault().setStatusText("");
            return;
        }
        if (count == 0) {
            ConnectingErrorDialog.showDialog(3, null);
            this.canceled = true;
            Autoupdater.setRunning(false);
            StatusDisplayer.getDefault().setStatusText("");
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                AutoChecker.this.reportResults();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    void reportResults() {
        Autoupdater.setRunning(false);
        StatusDisplayer.getDefault().setStatusText("");
        if (this.canceled) {
            return;
        }
        if (this.allUpdates.size() == 0) {
            if (this.settings.isNegativeResults()) {
                AutoCheckInfo info = new AutoCheckInfo(NbBundle.getMessage((Class)(class$org$netbeans$modules$autoupdate$AutoChecker == null ? (class$org$netbeans$modules$autoupdate$AutoChecker = AutoChecker.class$("org.netbeans.modules.autoupdate.AutoChecker")) : class$org$netbeans$modules$autoupdate$AutoChecker), (String)"MSG_AutoCheck_NotFound"), 1);
                info.showDialog(false);
            }
            return;
        }
        if (this.getAllModules() != null && this.getAllModules().size() > 0) {
            if (this.settings.isAskBefore()) {
                Wizard.go(this.allUpdates);
            } else {
                AutoCheckInfo info = new AutoCheckInfo(NbBundle.getMessage((Class)(class$org$netbeans$modules$autoupdate$AutoChecker == null ? (class$org$netbeans$modules$autoupdate$AutoChecker = AutoChecker.class$("org.netbeans.modules.autoupdate.AutoChecker")) : class$org$netbeans$modules$autoupdate$AutoChecker), (String)"MSG_AutoCheck_Found"), 1);
                if (info.showDialog(true)) {
                    Wizard.go(this.allUpdates);
                }
            }
        } else if (this.settings.isNegativeResults()) {
            AutoCheckInfo info = new AutoCheckInfo(NbBundle.getMessage((Class)(class$org$netbeans$modules$autoupdate$AutoChecker == null ? (class$org$netbeans$modules$autoupdate$AutoChecker = AutoChecker.class$("org.netbeans.modules.autoupdate.AutoChecker")) : class$org$netbeans$modules$autoupdate$AutoChecker), (String)"MSG_AutoCheck_NotFound"), 1);
            info.showDialog(false);
        }
    }

    private Collection getAllModules() {
        HashSet ret = new HashSet();
        Iterator it = this.allUpdates.values().iterator();
        while (it.hasNext()) {
            Collection c = ((Updates)it.next()).getModules();
            if (c == null) continue;
            ret.addAll(c);
        }
        return ret;
    }

    public void setValid(boolean valid) {
    }

    private boolean timeToCheck() {
        if (this.settings.getLastCheck() == null) {
            this.settings.setLastCheck(new Date());
            return false;
        }
        switch (this.settings.getPeriod()) {
            case 0: {
                return true;
            }
            case 5: {
                return false;
            }
        }
        Date lastCheck = this.settings.getLastCheck();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(lastCheck);
        calendar.set(10, 0);
        calendar.set(9, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        switch (this.settings.getPeriod()) {
            case 1: {
                calendar.add(5, 1);
                break;
            }
            case 2: {
                calendar.add(3, 1);
                break;
            }
            case 3: {
                calendar.add(3, 2);
                break;
            }
            case 4: {
                calendar.add(2, 1);
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat();
        return calendar.getTime().before(new Date());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

