/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.autoupdate.IdeDescription;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

class DependencyChecker {
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$DependencyChecker;

    DependencyChecker() {
    }

    Collection modulesToAdd(ModuleUpdate toAdd, Enumeration selected, List group, StringBuffer dontAddModuleName) {
        ArrayList result = new ArrayList();
        this.checkDependencies(toAdd.getRemoteModule(), result, selected, group, dontAddModuleName, toAdd.getLocalModule() != null);
        return result;
    }

    Collection modulesToRemove(ModuleUpdate toRemove, ModuleUpdate toReplace) {
        ArrayList result = new ArrayList();
        this.checkReverseDependencies(toRemove.getRemoteModule(), result, toReplace);
        return result;
    }

    private boolean checkDependencies(ModuleInfo md, Collection result, Enumeration selected, List group, StringBuffer dontAddModuleName, boolean isUpgrade) {
        NotifyDescriptor.Confirmation nd;
        List brokenlist;
        Set depsS = md.getDependencies();
        Dependency[] deps = depsS.toArray(new Dependency[depsS.size()]);
        boolean[] satisfied = new boolean[deps.length];
        ModuleInfo[] installedModules = Updates.getInstalledModules();
        ModuleInfo[] installedPatches = Updates.getInstalledPatches();
        int j = 0;
        while (j < deps.length) {
            Object message = null;
            if (deps[j].getType() == 1 || deps[j].getType() == 5) {
                ModuleUpdate mu;
                boolean ok = false;
                int i = 0;
                while (i < installedModules.length) {
                    ok = DependencyChecker.checkModuleDependency(deps[j], installedModules[i]);
                    if (ok) break;
                    ++i;
                }
                if (!ok) {
                    int i2 = 0;
                    while (i2 < installedPatches.length) {
                        ok = DependencyChecker.checkModuleDependency(deps[j], installedPatches[i2]);
                        if (ok) break;
                        ++i2;
                    }
                }
                if (!ok && selected != null) {
                    while (selected.hasMoreElements()) {
                        ModuleUpdate mu2 = (ModuleUpdate)selected.nextElement();
                        ok = DependencyChecker.checkModuleDependency(deps[j], mu2.getRemoteModule());
                        if (!ok) continue;
                        if (result.contains(mu2)) break;
                        result.add(mu2);
                        break;
                    }
                }
                if (!ok && group != null) {
                    Iterator it = group.iterator();
                    while (it.hasNext()) {
                        mu = (ModuleUpdate)it.next();
                        ok = DependencyChecker.checkModuleDependency(deps[j], mu.getRemoteModule());
                        if (!ok) continue;
                        if (result.contains(mu)) break;
                        result.add(mu);
                        break;
                    }
                }
                if (!ok) {
                    Iterator it = Wizard.getAllModules().iterator();
                    while (it.hasNext()) {
                        mu = (ModuleUpdate)it.next();
                        ok = DependencyChecker.checkModuleDependency(deps[j], mu.getRemoteModule());
                        if (!ok) continue;
                        if (result.contains(mu)) break;
                        result.add(mu);
                        break;
                    }
                }
                satisfied[j] = ok;
            } else if (deps[j].getType() == 4) {
                if (this.checkIdeDependency(deps[j], IdeDescription.getIdeDescription())) {
                    satisfied[j] = true;
                } else {
                    Iterator it = Wizard.getAllModules().iterator();
                    boolean ok = false;
                    while (it.hasNext()) {
                        ModuleUpdate mu = (ModuleUpdate)it.next();
                        ok = DependencyChecker.checkModuleDependency(deps[j], mu.getRemoteModule());
                        if (!ok) continue;
                        if (result.contains(mu)) break;
                        result.add(mu);
                        break;
                    }
                    satisfied[j] = ok;
                }
            } else {
                satisfied[j] = true;
            }
            ++j;
        }
        StringBuffer sb = new StringBuffer(280);
        sb.append(this.getBundle("MSG_NotSatisfied") + "MODULE :" + md.getCodeName());
        int notSatisfied = 0;
        int j2 = 0;
        while (j2 < deps.length) {
            if (!satisfied[j2]) {
                sb.append(deps[j2]);
                ++notSatisfied;
            }
            ++j2;
        }
        StringBuffer sbbroken = null;
        if (isUpgrade && (brokenlist = this.checkBrokenImplDependency(md, result)).size() > 0) {
            sbbroken = new StringBuffer(280);
            sbbroken.append("MODULE :" + md.getCodeName());
            sbbroken.append(this.getBundle("MSG_BadsList"));
            Iterator it = brokenlist.iterator();
            while (it.hasNext()) {
                sbbroken.append("\n" + ((ModuleInfo)it.next()).getCodeName());
            }
            sbbroken.append(this.getBundle("MSG_IncludeBadsAnyway"));
        }
        if (notSatisfied == 0 && sbbroken == null) {
            return true;
        }
        if (notSatisfied > 0) {
            sb.append(this.getBundle("MSG_IncludeAnyway"));
            nd = new NotifyDescriptor.Confirmation((Object)sb.toString(), 0, 0);
            if (!DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.YES_OPTION)) {
                dontAddModuleName.append(md.getDisplayName());
                return false;
            }
        }
        if (sbbroken != null) {
            nd = new NotifyDescriptor.Confirmation((Object)sbbroken.toString(), 0, 0);
            if (!DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.YES_OPTION)) {
                dontAddModuleName.append(md.getDisplayName());
            }
        }
        return false;
    }

    boolean checkReverseDependencies(ModuleInfo module, Collection result, ModuleUpdate toReplace) {
        ModuleInfo[] installedModules = Updates.getInstalledModules();
        ModuleInfo[] installedPatches = Updates.getInstalledPatches();
        Iterator it = Wizard.getAllModules().iterator();
        while (it.hasNext()) {
            ModuleUpdate mu = (ModuleUpdate)it.next();
            ModuleInfo md = mu.getRemoteModule();
            Set depsS = md.getDependencies();
            Dependency[] deps = depsS.toArray(new Dependency[depsS.size()]);
            boolean moduleOk = true;
            int j = 0;
            while (j < deps.length) {
                if (deps[j].getType() == 1 && (deps[j].getName() + "/").startsWith(module.getCodeNameBase() + "/") || deps[j].getType() == 5 && Arrays.asList(module.getProvides()).contains(deps[j].getName())) {
                    boolean ok = false;
                    int k = 0;
                    while (k < installedModules.length) {
                        ok = DependencyChecker.checkModuleDependency(deps[j], installedModules[k]);
                        if (ok) break;
                        ++k;
                    }
                    if (!ok && toReplace != null) {
                        ok = DependencyChecker.checkModuleDependency(deps[j], toReplace.getRemoteModule());
                    }
                    if (!ok) {
                        int k2 = 0;
                        while (k2 < installedPatches.length) {
                            ok = DependencyChecker.checkModuleDependency(deps[j], installedPatches[k2]);
                            if (ok) break;
                            ++k2;
                        }
                    }
                    if (!ok) {
                        moduleOk = false;
                        break;
                    }
                } else if (deps[j].getType() == 4 && deps[j].getName().equals(module.getCodeName()) && !DependencyChecker.checkModuleDependency(deps[j], IdeDescription.getIdeDescription())) {
                    moduleOk = false;
                    break;
                }
                ++j;
            }
            if (moduleOk || result.contains(mu)) continue;
            result.add(mu);
        }
        return result.size() == 0;
    }

    static boolean checkModuleDependency(Dependency dep, ModuleInfo otherModule) {
        if (dep.getType() == 5) {
            return Arrays.asList(otherModule.getProvides()).contains(dep.getName());
        }
        boolean satisfied = false;
        String depName = dep.getName();
        if (depName.equals(otherModule.getCodeName())) {
            if (dep.getComparison() == 3) {
                return true;
            }
            if (dep.getComparison() == 1) {
                if (otherModule.getSpecificationVersion() == null) {
                    return false;
                }
                return new SpecificationVersion(dep.getVersion()).compareTo((Object)otherModule.getSpecificationVersion()) <= 0;
            }
            if (otherModule.getImplementationVersion() == null) {
                return false;
            }
            return otherModule.getImplementationVersion().equals(dep.getVersion());
        }
        int dash = depName.indexOf(45);
        if (dash != -1) {
            int slash = depName.indexOf(47);
            String cnb = depName.substring(0, slash);
            int relMin = Integer.parseInt(depName.substring(slash + 1, dash));
            int relMax = Integer.parseInt(depName.substring(dash + 1));
            if (cnb.equals(otherModule.getCodeNameBase()) && relMin <= otherModule.getCodeNameRelease() && relMax >= otherModule.getCodeNameRelease()) {
                if (dep.getComparison() == 3) {
                    return true;
                }
                if (otherModule.getCodeNameRelease() > relMin) {
                    return true;
                }
                if (otherModule.getSpecificationVersion() == null) {
                    return false;
                }
                return new SpecificationVersion(dep.getVersion()).compareTo((Object)otherModule.getSpecificationVersion()) <= 0;
            }
        }
        return false;
    }

    boolean checkIdeDependency(Dependency dep, ModuleInfo ide) {
        String IDEName = ide.getCodeName();
        SpecificationVersion IDESpecVersion = ide.getSpecificationVersion();
        String IDEImplVersion = ide.getImplementationVersion();
        if (!IDEName.equals(dep.getName())) {
            return false;
        }
        if (dep.getComparison() == 1) {
            return new SpecificationVersion(dep.getVersion()).compareTo((Object)IDESpecVersion) <= 0;
        }
        if (dep.getComparison() == 2) {
            return dep.getVersion().equals(IDEImplVersion);
        }
        throw new IllegalStateException("Cannot have COMPARE_ANY on IDE dependency");
    }

    private List checkBrokenImplDependency(ModuleInfo md, Collection result) {
        ModuleInfo[] installedModules = Updates.getInstalledModules();
        ArrayList<ModuleInfo> brokenlist = new ArrayList<ModuleInfo>();
        int i = 0;
        while (i < installedModules.length) {
            Iterator deps = installedModules[i].getDependencies().iterator();
            while (deps.hasNext()) {
                Dependency dep = (Dependency)deps.next();
                if (!dep.getName().equals(md.getCodeName()) || dep.getComparison() != 2) continue;
                if (dep.getVersion().equals(md.getImplementationVersion())) break;
                Iterator it = Wizard.getAllModules().iterator();
                boolean found = false;
                while (it.hasNext()) {
                    ModuleUpdate mu = (ModuleUpdate)it.next();
                    if (!mu.getRemoteModule().getCodeName().equals(installedModules[i].getCodeName()) || mu.getRemoteModule().getSpecificationVersion().compareTo((Object)installedModules[i].getSpecificationVersion()) <= 0) continue;
                    boolean maybeOK = true;
                    Iterator depsR = mu.getRemoteModule().getDependencies().iterator();
                    while (depsR.hasNext()) {
                        Dependency depR = (Dependency)depsR.next();
                        if (!depR.getName().equals(md.getCodeName()) || depR.getComparison() != 2 || depR.getVersion().equals(md.getImplementationVersion())) continue;
                        maybeOK = false;
                        break;
                    }
                    if (!maybeOK) continue;
                    if (!result.contains(mu)) {
                        result.add(mu);
                    }
                    found = true;
                    break;
                }
                if (found) break;
                brokenlist.add(installedModules[i]);
                break;
            }
            ++i;
        }
        return brokenlist;
    }

    private String getBundle(String key) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$autoupdate$DependencyChecker == null ? (class$org$netbeans$modules$autoupdate$DependencyChecker = DependencyChecker.class$("org.netbeans.modules.autoupdate.DependencyChecker")) : class$org$netbeans$modules$autoupdate$DependencyChecker), (String)key);
    }

    static Comparator getModuleDependencyComparator() {
        return new ModuleDependencyComparator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ModuleDependencyComparator
    implements Comparator {
        ModuleDependencyComparator() {
        }

        public int compare(Object obj, Object obj1) {
            ModuleInfo modB;
            if (!(obj instanceof ModuleUpdate) || !(obj1 instanceof ModuleUpdate)) {
                return 0;
            }
            ModuleInfo modA = ((ModuleUpdate)obj).getRemoteModule();
            if (this.moduleDependsOnModule(modA, modB = ((ModuleUpdate)obj1).getRemoteModule())) {
                return 1;
            }
            if (this.moduleDependsOnModule(modB, modA)) {
                return -1;
            }
            return 0;
        }

        private boolean moduleDependsOnModule(ModuleInfo modA, ModuleInfo modB) {
            Set depsA = modA.getDependencies();
            Iterator it = depsA.iterator();
            while (it.hasNext()) {
                Dependency dep = (Dependency)it.next();
                if (dep.getType() != 1 && dep.getType() != 5 || !DependencyChecker.checkModuleDependency(dep, modB)) continue;
                return true;
            }
            return false;
        }
    }
}

