/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Iterator;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.PreparedModules;
import org.netbeans.modules.autoupdate.ProgressDialog;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

class Downloader {
    ProgressDialog progressDialog;
    private volatile boolean downloadCanceled;
    private int downloadSize;
    private long totalDownloaded;
    private long modulesCount;
    private boolean urlDownload;
    private static final String NBM_EXTENSION = "nbm";
    private Wizard.Validator validator;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$Downloader;

    public Downloader(ProgressDialog progressDialog, Wizard.Validator validator, boolean urlDownload) {
        this.validator = validator;
        this.progressDialog = progressDialog;
        this.urlDownload = urlDownload;
    }

    void doDownload() {
        this.downloadCanceled = false;
        Runnable task = new Runnable(){

            public void run() {
                Downloader.this.progressDialog.setLabelText(1, Downloader.this.getBundle("CTL_PreparingDownload_Label"));
                Downloader.this.downloadSize = Downloader.this.getTotalDownloadSize();
                if (Downloader.this.downloadCanceled) {
                    return;
                }
                Downloader.this.downloadAll();
                if (Downloader.this.downloadCanceled) {
                    return;
                }
                Downloader.this.validator.setValid(true);
            }
        };
        Wizard.getRequestProcessor().post(task);
    }

    int getTotalDownloadSize() {
        long result = 0L;
        this.modulesCount = 0L;
        Iterator it = Wizard.getAllModules().iterator();
        while (it.hasNext()) {
            ModuleUpdate mu = (ModuleUpdate)it.next();
            if (!mu.isSelected() || mu.isDownloadOK()) continue;
            result += mu.getDownloadSize();
            ++this.modulesCount;
        }
        return (int)(result / 1024L);
    }

    private void downloadAll() {
        if (this.downloadCanceled) {
            return;
        }
        this.progressDialog.setGaugeBounds(2, 0, this.downloadSize);
        this.progressDialog.setGaugeValue(2, 0);
        this.progressDialog.setLabelText(2, "");
        this.progressDialog.setGaugeValue(1, 0);
        int currentModule = 0;
        this.totalDownloaded = 0L;
        Iterator it = Wizard.getAllModules().iterator();
        long start_time = System.currentTimeMillis();
        while (it.hasNext()) {
            if (this.downloadCanceled) {
                return;
            }
            ModuleUpdate mu = (ModuleUpdate)it.next();
            if (!mu.isSelected() || mu.isDownloadOK()) continue;
            this.progressDialog.setGaugeValue(1, 0);
            this.progressDialog.setLabelText(1, mu.getName() + " [" + (currentModule + 1) + "/" + this.modulesCount + "]");
            if (this.urlDownload) {
                this.download(start_time, mu);
            } else {
                this.downloadFromLocal(start_time, mu);
            }
            ++currentModule;
        }
        this.progressDialog.setGaugeValue(2, this.downloadSize);
        String mssgTotal = MessageFormat.format(this.getBundle("FMT_DownloadedTotal"), new Integer(this.downloadSize), new Integer(this.downloadSize));
        this.progressDialog.setLabelText(2, mssgTotal);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void download(long start_time, ModuleUpdate moduleUpdate) {
        int moduleDownloaded = 0;
        int flen = 0;
        while (true) {
            File destFile = null;
            try {
                URLConnection distrConnection = null;
                distrConnection = moduleUpdate.getDistribution().openConnection();
                flen = distrConnection.getContentLength();
                moduleUpdate.setRemoteDistributionFilename(distrConnection);
                if (this.downloadCanceled) {
                    return;
                }
                moduleDownloaded = 0;
                this.progressDialog.setGaugeBounds(1, 0, flen / 1024);
                moduleUpdate.setDownloadStarted(true);
                destFile = Downloader.getNBM(moduleUpdate);
                BufferedInputStream bsrc = new BufferedInputStream(distrConnection.getInputStream());
                BufferedOutputStream bdest = new BufferedOutputStream(new FileOutputStream(destFile));
                boolean i = false;
                try {
                    while (true) {
                        void var10_11;
                        int c;
                        if ((c = bsrc.read()) == -1) break;
                        bdest.write((int)var10_11);
                        ++moduleDownloaded;
                        ++this.totalDownloaded;
                        if (this.downloadCanceled) {
                            Object var13_12 = null;
                            bsrc.close();
                            bdest.close();
                            if (this.downloadCanceled) {
                                Downloader.getNBM(moduleUpdate).delete();
                            }
                            return;
                        }
                        if (moduleDownloaded % 4096 != 0) continue;
                        this.updateOverall();
                        this.progressDialog.setGaugeValue(1, moduleDownloaded / 1024);
                    }
                    Object var13_13 = null;
                    bsrc.close();
                    bdest.close();
                    if (!this.downloadCanceled) break;
                    Downloader.getNBM(moduleUpdate).delete();
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    bsrc.close();
                    bdest.close();
                    if (this.downloadCanceled) {
                        Downloader.getNBM(moduleUpdate).delete();
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                String mssg = MessageFormat.format(this.getBundle("FMT_DownloadFailed"), moduleUpdate.getName());
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, this.getBundle("CTL_DownloadFailed"), 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (nd.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                    this.totalDownloaded -= (long)moduleDownloaded;
                    continue;
                }
                if (nd.getValue().equals(NotifyDescriptor.CANCEL_OPTION)) {
                    this.downloadCanceled = true;
                    this.validator.setValid(true);
                    return;
                }
                this.totalDownloaded -= (long)moduleDownloaded;
                this.downloadSize -= (int)(moduleUpdate.getDownloadSize() / 1024L);
                if (destFile != null) {
                    destFile.delete();
                }
                return;
            }
            break;
        }
        this.progressDialog.setGaugeValue(1, flen / 1024 + 10);
        moduleUpdate.setDownloadOK(true);
    }

    private void downloadFromLocal(long start_time, ModuleUpdate moduleUpdate) {
        this.progressDialog.setGaugeBounds(1, 0, 1);
        if (Downloader.tryCopy(moduleUpdate.getDistributionFile(), Downloader.getNBM(moduleUpdate))) {
            moduleUpdate.setDownloadOK(true);
            this.totalDownloaded += moduleUpdate.getDownloadSize();
            this.progressDialog.setGaugeValue(1, 1);
        } else {
            Downloader.getNBM(moduleUpdate).delete();
        }
        this.updateOverall();
    }

    private void updateOverall() {
        String mssgTotal = MessageFormat.format(this.getBundle("FMT_DownloadedTotal"), new Integer((int)(this.totalDownloaded / 1024L)), new Integer(this.downloadSize));
        this.progressDialog.setGaugeValue(2, (int)(this.totalDownloaded / 1024L) > this.downloadSize ? this.downloadSize : (int)(this.totalDownloaded / 1024L));
        this.progressDialog.setLabelText(2, mssgTotal);
    }

    void cancelDownload() {
        this.downloadCanceled = true;
    }

    static File getNBM(ModuleUpdate mu) {
        File destFile = new File(Autoupdater.Support.getDownloadDirectory(), mu.getDistributionFilename());
        return destFile;
    }

    static File getMovedNBM(ModuleUpdate mu) {
        File destFile = null;
        destFile = mu.isToInstallDir() ? new File(Autoupdater.Support.getInstallDownloadDirectory(), mu.getDistributionFilename()) : new File(Autoupdater.Support.getDownloadDirectory(), mu.getDistributionFilename());
        return destFile;
    }

    static boolean tryMove(ModuleUpdate mu) {
        File inst = new File(Autoupdater.Support.getInstallDownloadDirectory(), mu.getDistributionFilename());
        boolean ok = Downloader.getNBM(mu).renameTo(inst);
        if (ok) {
            return true;
        }
        ok = Downloader.tryCopy(Downloader.getNBM(mu), inst);
        if (ok) {
            Downloader.getNBM(mu).delete();
        }
        return ok;
    }

    static void saveCopy(ModuleUpdate mu, File target) {
        Downloader.tryCopy(Downloader.getNBM(mu), target);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean tryCopy(File src, File dest) {
        BufferedInputStream bsrc = null;
        FilterOutputStream bdest = null;
        try {
            try {
                int c;
                bsrc = new BufferedInputStream(new FileInputStream(src), 4096);
                bdest = new BufferedOutputStream(new FileOutputStream(dest), 4096);
                while ((c = bsrc.read()) != -1) {
                    void var4_4;
                    ((BufferedOutputStream)bdest).write((int)var4_4);
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                bsrc.close();
                bdest.close();
                throw throwable;
            }
            bsrc.close();
            bdest.close();
            {
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    static void deleteModuleNBM(ModuleUpdate mu) {
        Downloader.getNBM(mu).delete();
    }

    static void deleteDownload() {
        boolean noTestPrepared = true;
        PreparedModules prepared = null;
        if (Autoupdater.Support.getInstall_Later(true).exists()) {
            noTestPrepared = false;
            prepared = PreparedModules.getPrepared();
        }
        File[] nbms = Downloader.getNBMFiles();
        int i = 0;
        while (i < nbms.length) {
            if (noTestPrepared || !prepared.hasNBM(nbms[i].getName())) {
                nbms[i].delete();
            }
            ++i;
        }
    }

    static boolean bannedWriteToInstall() {
        return !Autoupdater.Support.getInstallDownloadDirectory().canWrite();
    }

    private static File[] getNBMFiles() {
        File[] dirList = Autoupdater.Support.getDownloadDirectory().listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(Downloader.NBM_EXTENSION);
            }
        });
        return dirList;
    }

    private String getBundle(String key) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$autoupdate$Downloader == null ? (class$org$netbeans$modules$autoupdate$Downloader = Downloader.class$("org.netbeans.modules.autoupdate.Downloader")) : class$org$netbeans$modules$autoupdate$Downloader), (String)key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

