/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.openide.modules.SpecificationVersion;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class PreparedModules {
    private static final String ELEMENT_MODULES = "module_updates";
    private static final String ELEMENT_MODULE = "module";
    private static final String ATTR_CODENAMEBASE = "codenamebase";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SPEC_VERSION = "specification_version";
    private static final String ATTR_SIZE = "size";
    private static final String ATTR_NBM_NAME = "nbm_name";
    private List modules = new ArrayList();
    private boolean pError = false;
    private static PreparedModules preparedModules;

    PreparedModules() {
    }

    static PreparedModules getPrepared() {
        if (preparedModules == null) {
            PreparedModules.readPrepared();
        }
        return preparedModules;
    }

    static void readPrepared() {
        preparedModules = new PreparedModules();
        preparedModules.read();
    }

    List getModules() {
        return this.modules;
    }

    void addModule(ModuleUpdate mu) {
        Module mod = new Module();
        mod.setCodenamebase(mu.getCodeNameBase());
        mod.setName(mu.getName());
        mod.setSize(mu.getDownloadSize());
        SpecificationVersion sv = mu.getRemoteModule().getSpecificationVersion();
        mod.setSpec_version(sv == null ? null : sv.toString());
        mod.setNbm_name(mu.getDistributionFilename());
        mod.setFrom_user_dir(!mu.isToInstallDir());
        this.modules.add(mod);
    }

    void removeModule(String codenamebase) {
        int i = 0;
        while (i < this.modules.size()) {
            Module mod = (Module)this.modules.get(i);
            if (mod.getCodenamebase().equals(codenamebase)) {
                this.modules.remove(i);
                return;
            }
            ++i;
        }
    }

    String getPreparedVersion(String codenamebase) {
        int i = 0;
        while (i < this.modules.size()) {
            Module mod = (Module)this.modules.get(i);
            if (mod.getCodenamebase().equals(codenamebase)) {
                return mod.getSpec_version();
            }
            ++i;
        }
        return null;
    }

    boolean hasNBM(String nbm_name) {
        int i = 0;
        while (i < this.modules.size()) {
            Module mod = (Module)this.modules.get(i);
            if (mod.getNbm_name().equals(nbm_name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void delete() {
        this.getInstall_Later(true).delete();
        this.getInstall_Later(false).delete();
    }

    private File getInstall_Later(boolean fromUserDir) {
        return Autoupdater.Support.getInstall_Later(fromUserDir);
    }

    void write() {
        this.write(true);
        this.write(false);
    }

    private void write(boolean toUserDir) {
        Document document = XMLUtil.createDocument((String)ELEMENT_MODULES, null, null, null);
        Element root = document.getDocumentElement();
        Element module = null;
        Iterator it = this.modules.iterator();
        boolean empty = true;
        while (it.hasNext()) {
            Module mod = (Module)it.next();
            if ((!toUserDir || !mod.isFrom_user_dir()) && (toUserDir || mod.isFrom_user_dir())) continue;
            module = document.createElement(ELEMENT_MODULE);
            module.setAttribute(ATTR_CODENAMEBASE, mod.getCodenamebase());
            module.setAttribute(ATTR_NAME, mod.getName());
            module.setAttribute(ATTR_SPEC_VERSION, mod.getSpec_version());
            module.setAttribute(ATTR_SIZE, Long.toString(mod.getSize()));
            module.setAttribute(ATTR_NBM_NAME, mod.getNbm_name());
            root.appendChild(module);
            empty = false;
        }
        if (empty) {
            return;
        }
        document.getDocumentElement().normalize();
        try {
            FileOutputStream os = new FileOutputStream(this.getInstall_Later(toUserDir));
            XMLUtil.write((Document)document, (OutputStream)os, null);
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void read() {
        this.modules.clear();
        this.read(true);
        this.read(false);
    }

    private void read(boolean fromUserDir) {
        Document document;
        try {
            File file = this.getInstall_Later(fromUserDir);
            if (!file.exists()) {
                return;
            }
            FileInputStream is = new FileInputStream(file);
            InputSource xmlInputSource = new InputSource(is);
            document = XMLUtil.parse((InputSource)xmlInputSource, (boolean)false, (boolean)false, (ErrorHandler)new ErrorCatcher(), null);
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (SAXException e) {
            System.out.println("Bad install_later");
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            System.out.println("Missing install_later");
            e.printStackTrace();
            return;
        }
        Element element = document.getDocumentElement();
        if (element != null && element.getTagName().equals(ELEMENT_MODULES)) {
            this.scanElement_module_updates(element, fromUserDir);
        }
    }

    private void scanElement_module_updates(Element element, boolean fromUserDir) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Element nodeElement;
            Node node = nodes.item(i);
            if (node.getNodeType() == 1 && (nodeElement = (Element)node).getTagName().equals(ELEMENT_MODULE)) {
                this.scanElement_module(nodeElement, fromUserDir);
            }
            ++i;
        }
    }

    private void scanElement_module(Element element, boolean fromUserDir) {
        Module module = new Module();
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals(ATTR_CODENAMEBASE)) {
                module.setCodenamebase(attr.getValue());
            }
            if (attr.getName().equals(ATTR_SPEC_VERSION)) {
                module.setSpec_version(attr.getValue());
            }
            if (attr.getName().equals(ATTR_NAME)) {
                module.setName(attr.getValue());
            }
            if (attr.getName().equals(ATTR_SIZE)) {
                try {
                    module.setSize(Long.parseLong(attr.getValue()));
                }
                catch (NumberFormatException nfe) {
                    module.setSize(0L);
                }
            }
            if (attr.getName().equals(ATTR_NBM_NAME)) {
                module.setNbm_name(attr.getValue());
            }
            module.setFrom_user_dir(fromUserDir);
            ++i;
        }
        this.modules.add(module);
    }

    class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String level, SAXParseException e) {
            PreparedModules.this.pError = true;
        }

        public void error(SAXParseException e) {
            PreparedModules.this.pError = true;
        }

        public void warning(SAXParseException e) {
        }

        public void fatalError(SAXParseException e) {
            PreparedModules.this.pError = true;
        }
    }

    class Module {
        private String name;
        private String codenamebase;
        private String spec_version;
        private long size;
        private String nbm_name;
        private boolean from_user_dir;

        Module() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCodenamebase() {
            return this.codenamebase;
        }

        public void setCodenamebase(String codenamebase) {
            this.codenamebase = codenamebase;
        }

        public String getSpec_version() {
            return this.spec_version;
        }

        public void setSpec_version(String spec_version) {
            this.spec_version = spec_version;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public String getNbm_name() {
            return this.nbm_name;
        }

        public void setNbm_name(String nbm_name) {
            this.nbm_name = nbm_name;
        }

        public boolean isFrom_user_dir() {
            return this.from_user_dir;
        }

        public void setFrom_user_dir(boolean from_user_dir) {
            this.from_user_dir = from_user_dir;
        }
    }
}

