/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.modules.autoupdate.CertificateDialog;
import org.netbeans.modules.autoupdate.Downloader;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.SelectModulesPanel;
import org.netbeans.modules.autoupdate.ServerPanel;
import org.netbeans.modules.autoupdate.SignVerifier;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class ResultsPanel
extends JPanel {
    private static final String SPACE = " ";
    private static final String BAD_DOWNLOAD = " " + ResultsPanel.getBundle("CTL_BAD_DOWNLOAD") + " ";
    private static final String CORRUPTED = " " + ResultsPanel.getBundle("CTL_CORRUPTED") + " ";
    private static final String NOT_SIGNED = " " + ResultsPanel.getBundle("CTL_NOT_SIGNED") + " ";
    private static final String SIGNED = " " + ResultsPanel.getBundle("CTL_SIGNED") + " ";
    private static final String TRUSTED = " " + ResultsPanel.getBundle("CTL_TRUSTED") + " ";
    private Wizard.Validator validator;
    private int modulesOK;
    private Dimension preferredDimension = null;
    private JTable table;
    private ResultsTableModel model;
    private static String yesToAll = ResultsPanel.getBundle("CTL_Yes_All");
    private boolean includeAll = false;
    private boolean globalAll = false;
    static final long serialVersionUID = -6053101371836354161L;
    private static File defaultDir = null;
    private ButtonGroup buttonGroup1;
    private JButton certificateButton;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JButton saveButton;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$ResultsPanel;

    public ResultsPanel(Wizard.Validator validator) {
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(3));
        this.setName(ResultsPanel.getBundle("LBL_View"));
        this.initComponents();
        this.validator = validator;
        this.model = new ResultsTableModel();
        this.table = new ServerPanel.AutoResizeTable((TableModel)this.model, 2);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new BooleanRenderer());
        this.table.getColumnModel().getColumn(1).setCellRenderer(new ResultsCellRenderer());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new BooleanRenderer());
        this.table.setSelectionMode(0);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(48);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(480);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(48);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.jScrollPane1.setViewportView(this.table);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ResultsPanel.this.selectionChange();
            }
        });
        this.selectionChange();
        this.getAccessibleContext().setAccessibleName(ResultsPanel.getBundle("LBL_View"));
        this.getAccessibleContext().setAccessibleDescription(ResultsPanel.getBundle("LBL_41"));
        this.certificateButton.getAccessibleContext().setAccessibleDescription(ResultsPanel.getBundle("ACS_View"));
        this.table.getAccessibleContext().setAccessibleDescription(ResultsPanel.getBundle("ACS_Module_List"));
        this.jLabel1.setLabelFor(this.table);
        this.jLabel1.setDisplayedMnemonic(ResultsPanel.getBundle("LAB_ModulesList_Mnemonic").charAt(0));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jTextArea1 = new JTextArea();
        this.jScrollPane1 = new JScrollPane();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.certificateButton = new JButton();
        this.saveButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.jTextArea1.setBackground(this.getBackground());
        this.jTextArea1.setFont(new Font("Dialog", 0, this.jTextArea1.getFont().getSize()));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setText(ResultsPanel.getBundle("LBL_41"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setDisabledTextColor(Color.black);
        this.jTextArea1.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel1.setText(ResultsPanel.getBundle("LAB_ModulesList"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.certificateButton.setMnemonic(ResultsPanel.getBundle("BTN_View_Mnem").charAt(0));
        this.certificateButton.setText(ResultsPanel.getBundle("BTN_View"));
        this.buttonGroup1.add(this.certificateButton);
        this.certificateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResultsPanel.this.certificateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel1.add((Component)this.certificateButton, gridBagConstraints);
        this.saveButton.setMnemonic(ResultsPanel.getBundle("BTN_SaveCopy_Mnem").charAt(0));
        this.saveButton.setText(ResultsPanel.getBundle("BTN_SaveCopy"));
        this.buttonGroup1.add(this.saveButton);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResultsPanel.this.saveButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 11, 0, 0);
        this.jPanel1.add((Component)this.saveButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        File saveDir = this.getSaveCopyDir();
        if (saveDir != null) {
            ModuleUpdate mu = this.getListSelection();
            File target = new File(saveDir, mu.getDistributionFilename());
            if (target.exists()) {
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)ResultsPanel.getBundle("MSG_OverwriteConfirmation"), 0);
                if (!DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.YES_OPTION)) {
                    return;
                }
            }
            Downloader.saveCopy(this.getListSelection(), target);
        }
    }

    private void certificateButtonActionPerformed(ActionEvent evt) {
        int accValue = CertificateDialog.showDialog(this.getListSelection().getCerts(), this.getListSelection().getSecurity());
        this.doCertAction(accValue, this.getListSelection());
        this.table.invalidate();
        this.table.repaint();
        this.selectionChange();
    }

    private void doInclude(ModuleUpdate mu) {
        if (mu.isDepending() && Downloader.bannedWriteToInstall()) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)MessageFormat.format(ResultsPanel.getBundle("MSG_CannotInstall_2"), mu.getName()));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            return;
        }
        if (mu.getSecurity() == 2) {
            if (mu.isInstallApproved()) {
                mu.setInstallApproved(false);
                this.checkValidity();
            } else {
                Object ret = null;
                if (!this.includeAll) {
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)ResultsPanel.getBundle("MSG_NotSignedConfirmation"), ResultsPanel.getBundle("CTL_NotSignedConfirmation"), 0);
                    nd.setOptions(new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION, yesToAll});
                    ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    if (ret.equals(yesToAll)) {
                        this.includeAll = true;
                    }
                }
                if (this.includeAll || ret.equals(NotifyDescriptor.YES_OPTION)) {
                    mu.setInstallApproved(true);
                    this.checkValidity();
                }
            }
        } else if (mu.getSecurity() == 3 || mu.getSecurity() == 4) {
            this.doCertAction(CertificateDialog.showDialog(mu.getCerts(), mu.getSecurity()), mu);
        } else if (mu.getSecurity() == 1) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ResultsPanel.getBundle("MSG_CorruptedJAR"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        } else {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ResultsPanel.getBundle("MSG_BadDownload"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
        this.table.invalidate();
        this.table.repaint();
        this.selectionChange();
    }

    private void doGlobal(ModuleUpdate mu) {
        if (mu.isDepending()) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)MessageFormat.format(ResultsPanel.getBundle("MSG_InstallDepending"), mu.getName()));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            return;
        }
        if (Downloader.bannedWriteToInstall()) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ResultsPanel.getBundle("MSG_InstallNoWrite"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            return;
        }
        if (mu.isToInstallDir()) {
            mu.setToInstallDir(false);
        } else {
            Object ret = null;
            if (!this.globalAll) {
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(ResultsPanel.getBundle("MSG_InstallConfirmation"), mu.getName()), 0);
                nd.setOptions(new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION, yesToAll});
                ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (ret.equals(yesToAll)) {
                    this.globalAll = true;
                }
            }
            if (this.globalAll || ret.equals(NotifyDescriptor.YES_OPTION)) {
                mu.setToInstallDir(true);
            }
        }
        this.table.invalidate();
        this.table.repaint();
        this.selectionChange();
    }

    void doCertAction(int accValue, ModuleUpdate mu) {
        switch (accValue) {
            case 1: {
                this.setApproved4All(mu.getCerts(), true, -1);
                this.checkValidity();
                break;
            }
            case 4: {
                this.setApproved4All(mu.getCerts(), false, -1);
                this.checkValidity();
                break;
            }
            case 3: {
                this.setApproved4All(mu.getCerts(), false, 3);
                this.checkValidity();
                try {
                    SignVerifier.removeCertificates(mu.getCerts());
                }
                catch (CertificateException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                catch (KeyStoreException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                catch (NoSuchAlgorithmException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                break;
            }
            case 2: {
                this.setApproved4All(mu.getCerts(), true, 4);
                this.checkValidity();
                try {
                    SignVerifier.addCertificates(mu.getCerts());
                }
                catch (CertificateException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                catch (KeyStoreException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                catch (NoSuchAlgorithmException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                break;
            }
            default: {
                return;
            }
        }
    }

    private void setApproved4All(Collection certs, boolean approved, int security) {
        if (certs == null) {
            return;
        }
        boolean bannedWriteToInstall = Downloader.bannedWriteToInstall();
        int i = 0;
        while (i < this.model.getRowCount()) {
            ModuleUpdate mu = (ModuleUpdate)this.model.getValueAt(i, 1);
            if (!(approved && mu.isDepending() && bannedWriteToInstall || mu.getCerts() == null || !certs.containsAll(mu.getCerts()))) {
                mu.setInstallApproved(approved);
                if (security == 4 || security == 3) {
                    mu.setSecurity(security);
                }
            }
            ++i;
        }
    }

    int generateResults() {
        this.modulesOK = 0;
        boolean bannedWriteToInstall = Downloader.bannedWriteToInstall();
        ArrayList<ModuleUpdate> modulelist = new ArrayList<ModuleUpdate>();
        Collection modules = Wizard.getAllModules();
        Iterator it = modules.iterator();
        boolean writeConflict = false;
        int selectRow = -1;
        while (it.hasNext()) {
            ModuleUpdate mu = (ModuleUpdate)it.next();
            if (!mu.isSelected()) continue;
            modulelist.add(mu);
            if (mu.isDownloadOK()) {
                ++this.modulesOK;
                if (selectRow == -1 && !mu.isInstallApproved()) {
                    selectRow = modulelist.size() - 1;
                }
            }
            if (!mu.isDepending()) continue;
            if (bannedWriteToInstall) {
                mu.setInstallApproved(false);
                writeConflict = true;
            }
            mu.setToInstallDir(true);
        }
        if (writeConflict) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ResultsPanel.getBundle("MSG_CannotInstall_1"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
        this.model.refreshContent(modulelist);
        if (selectRow == -1) {
            selectRow = 0;
        }
        if (this.table.getRowCount() > 0) {
            this.table.getSelectionModel().setSelectionInterval(selectRow, selectRow);
        }
        this.checkValidity();
        this.selectionChange();
        this.includeAll = false;
        this.globalAll = false;
        return this.modulesOK;
    }

    private void selectionChange() {
        ModuleUpdate mu = this.getListSelection();
        if (mu != null && (mu.getSecurity() == 3 || mu.getSecurity() == 4)) {
            this.certificateButton.setEnabled(true);
        } else {
            this.certificateButton.setEnabled(false);
        }
        if (mu != null && mu.getSecurity() != 0) {
            this.saveButton.setEnabled(true);
        } else {
            this.saveButton.setEnabled(false);
        }
    }

    private ModuleUpdate getListSelection() {
        int index = this.table.getSelectionModel().getMinSelectionIndex();
        if (index < 0) {
            return null;
        }
        return (ModuleUpdate)this.model.getValueAt(index, 1);
    }

    private void checkValidity() {
        boolean valid = false;
        int okCount = 0;
        Collection modules = Wizard.getAllModules();
        Iterator it = modules.iterator();
        while (it.hasNext()) {
            ModuleUpdate mu = (ModuleUpdate)it.next();
            if (!mu.isSelected() || !mu.isInstallApproved()) continue;
            valid = true;
            ++okCount;
        }
        this.validator.setValid(valid);
    }

    private File getSaveCopyDir() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(MessageFormat.format(ResultsPanel.getBundle("CTL_FileChooserSC_Title"), this.getListSelection().getDistributionFilename()));
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.canWrite();
            }

            public String getDescription() {
                return ResultsPanel.getBundle("CTL_FileFilterSCDescription");
            }
        });
        if (defaultDir == null) {
            defaultDir = SelectModulesPanel.getDefaultDir();
        }
        if (defaultDir != null) {
            File parent = defaultDir.getParentFile();
            if (parent != null) {
                chooser.setCurrentDirectory(parent);
                chooser.setSelectedFile(defaultDir);
            } else {
                chooser.setCurrentDirectory(defaultDir);
            }
        }
        if (chooser.showDialog(WindowManager.getDefault().getMainWindow(), ResultsPanel.getBundle("CTL_Save")) == 0) {
            defaultDir = chooser.getSelectedFile();
            return defaultDir;
        }
        return null;
    }

    private static String getBundle(String key) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$autoupdate$ResultsPanel == null ? (class$org$netbeans$modules$autoupdate$ResultsPanel = ResultsPanel.class$("org.netbeans.modules.autoupdate.ResultsPanel")) : class$org$netbeans$modules$autoupdate$ResultsPanel), (String)key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorder(new LineBorder((Color)UIManager.getDefaults().get("Button.focus")));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setBorderPainted(isSelected && table.getSelectedColumn() == column);
            this.setSelected(value != null && (Boolean)value != false);
            return this;
        }
    }

    private class ResultsCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private JLabel nameLabel;
        private JLabel securityLabel;

        public ResultsCellRenderer() {
            this.initComponents();
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String sec = "";
            if (value == null) {
                value = ResultsPanel.this.model.getValueAt(row, column);
            }
            switch (((ModuleUpdate)value).getSecurity()) {
                case 0: {
                    sec = BAD_DOWNLOAD;
                    break;
                }
                case 1: {
                    sec = CORRUPTED;
                    break;
                }
                case 2: {
                    sec = NOT_SIGNED;
                    break;
                }
                case 3: {
                    StringBuffer sb = new StringBuffer(SIGNED);
                    sb.append(ResultsPanel.SPACE + ResultsPanel.getBundle("CTL_By"));
                    Collection certs = ((ModuleUpdate)value).getCerts();
                    Iterator it = certs.iterator();
                    while (it.hasNext()) {
                        Certificate cert = (Certificate)it.next();
                        if (!(cert instanceof X509Certificate)) continue;
                        sb.append(ResultsPanel.SPACE).append(((X509Certificate)cert).getSubjectDN().getName());
                    }
                    sec = sb.toString();
                    break;
                }
                case 4: {
                    sec = TRUSTED;
                }
            }
            if (isSelected) {
                this.setBackground((Color)UIManager.getDefaults().get("Table.selectionBackground"));
                this.nameLabel.setForeground((Color)UIManager.getDefaults().get("Table.selectionForeground"));
                this.securityLabel.setForeground((Color)UIManager.getDefaults().get("Table.selectionForeground"));
            } else {
                this.setBackground((Color)UIManager.getDefaults().get("Table.background"));
                this.nameLabel.setForeground((Color)UIManager.getDefaults().get("Table.Foreground"));
                this.securityLabel.setForeground((Color)UIManager.getDefaults().get("Table.Foreground"));
            }
            this.nameLabel.setText(((ModuleUpdate)value).getName() + "  " + ResultsPanel.getBundle("CTL_Version") + ((ModuleUpdate)value).getRemoteModule().getSpecificationVersion());
            this.securityLabel.setText(sec);
            return this;
        }

        private void initComponents() {
            this.nameLabel = new JLabel();
            this.securityLabel = new JLabel();
            this.setLayout(new GridBagLayout());
            this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(1));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, 6, 0, 0);
            this.add((Component)this.nameLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 6, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)this.securityLabel, gridBagConstraints);
        }
    }

    class ResultsTableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{ResultsPanel.access$300("LBL_42"), ResultsPanel.access$300("LBL_43"), ResultsPanel.access$300("LBL_Global")};
        private List modulelist = new ArrayList();

        ResultsTableModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.modulelist.size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return ((ModuleUpdate)this.modulelist.get(row)).isInstallApproved() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (col == 1) {
                return this.modulelist.get(row);
            }
            return ((ModuleUpdate)this.modulelist.get(row)).isToInstallDir() ? Boolean.TRUE : Boolean.FALSE;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return col != 1;
        }

        public void setValueAt(Object value, int row, int col) {
            if (value instanceof Boolean) {
                if (col == 0) {
                    ResultsPanel.this.doInclude((ModuleUpdate)this.modulelist.get(row));
                } else {
                    ResultsPanel.this.doGlobal((ModuleUpdate)this.modulelist.get(row));
                }
            }
        }

        void refreshContent(List modulelist) {
            this.modulelist = modulelist;
        }
    }
}

