/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.Downloader;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.ProgressDialog;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.util.NbBundle;

class SignVerifier {
    private static final String KS_PSSWD = "open4all";
    private static final String ENTRY_SEPARATOR = "/";
    private static final String NBM_BIN = "netbeans/bin";
    private static final String NBM_LIB = "netbeans/lib";
    private static final String NBM_MAIN = "main";
    private static final String NBM_MODULES = "netbeans/modules";
    private static final String NBM_AUTOLOAD = "netbeans/modules/autoload";
    private static final String NBM_EAGER = "netbeans/modules/eager";
    private static final String JAR_EXT = ".jar";
    public static final int NOT_CHECKED = -1;
    public static final int BAD_DOWNLOAD = 0;
    public static final int CORRUPTED = 1;
    public static final int NOT_SIGNED = 2;
    public static final int SIGNED = 3;
    public static final int TRUSTED = 4;
    private static final String NEW_LINE = "\n";
    private static final String SPACE = " ";
    private static final String TAB = "\t";
    ProgressDialog progressDialog;
    private Wizard.Validator validator;
    private int verifySize;
    private long totalVerified;
    private long modulesCount;
    private boolean verifyCanceled = false;
    private boolean wizardCanceled = false;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$SignVerifier;

    SignVerifier(ProgressDialog progressDialog, Wizard.Validator validator) {
        this.validator = validator;
        this.progressDialog = progressDialog;
    }

    void doVerify() {
        this.verifyCanceled = false;
        Runnable task = new Runnable(){

            public void run() {
                SignVerifier.this.progressDialog.setLabelText(1, SignVerifier.getBundle("CTL_PreparingVerify_Label"));
                SignVerifier.this.verifySize = SignVerifier.this.getTotalVerifySize();
                if (SignVerifier.this.verifyCanceled) {
                    return;
                }
                SignVerifier.this.verifyAll();
                if (SignVerifier.this.verifyCanceled) {
                    return;
                }
                SignVerifier.this.validator.setValid(true);
            }
        };
        Wizard.getRequestProcessor().post(task);
    }

    int getTotalVerifySize() {
        long result = 0L;
        this.modulesCount = 0L;
        Iterator it = Wizard.getAllModules().iterator();
        while (it.hasNext()) {
            ModuleUpdate mu = (ModuleUpdate)it.next();
            if (!mu.isSelected() || !mu.isDownloadOK() || mu.getSecurity() != -1 && mu.getSecurity() != 0) continue;
            File file = Downloader.getNBM(mu);
            result += file.length();
            ++this.modulesCount;
        }
        return (int)(result / 1024L);
    }

    void verifyAll() {
        this.progressDialog.setGaugeBounds(2, 0, this.verifySize);
        this.progressDialog.setGaugeValue(2, 0);
        this.progressDialog.setLabelText(2, "");
        this.progressDialog.setGaugeValue(1, 0);
        int currentModule = 0;
        this.totalVerified = 0L;
        Iterator it = Wizard.getAllModules().iterator();
        while (it.hasNext()) {
            if (this.verifyCanceled) {
                return;
            }
            ModuleUpdate mu = (ModuleUpdate)it.next();
            if (!mu.isSelected() || !mu.isDownloadOK() || mu.getSecurity() != -1 && mu.getSecurity() != 0) continue;
            if (this.verifyCanceled) {
                return;
            }
            this.progressDialog.setGaugeValue(1, 0);
            this.progressDialog.setLabelText(1, mu.getName() + " [" + (currentModule + 1) + ENTRY_SEPARATOR + this.modulesCount + "]");
            File file = Downloader.getNBM(mu);
            try {
                Collection certificates = this.verifyJar(file, mu);
                if (certificates == null) {
                    mu.setSecurity(2);
                    mu.setInstallApproved(false);
                } else {
                    mu.setCerts(certificates);
                    if (this.isTrusted(certificates)) {
                        mu.setSecurity(4);
                        mu.setInstallApproved(true);
                    } else {
                        mu.setSecurity(3);
                        mu.setInstallApproved(false);
                    }
                }
            }
            catch (SecurityException e) {
                mu.setSecurity(1);
                mu.setInstallApproved(false);
            }
            catch (IOException e) {
                mu.setSecurity(0);
                mu.setInstallApproved(false);
                mu.setDownloadOK(false);
            }
            ++currentModule;
        }
        this.progressDialog.setGaugeValue(2, this.verifySize);
        String mssgTotal = MessageFormat.format(SignVerifier.getBundle("FMT_VerifiedTotal"), new Integer(this.verifySize), new Integer(this.verifySize));
        this.progressDialog.setLabelText(2, mssgTotal);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection verifyJar(File jarName, ModuleUpdate mu) throws SecurityException, IOException {
        LinkedList<JarEntry> entriesList;
        Manifest man;
        JarFile jf;
        int flen;
        boolean anyUnsigned;
        boolean anySigned;
        block23: {
            JarEntry entry;
            block24: {
                Collection collection;
                Object jis = null;
                anySigned = false;
                anyUnsigned = false;
                int moduleVerified = 0;
                flen = (int)jarName.length();
                this.progressDialog.setGaugeBounds(1, 0, flen / 1024);
                jf = new JarFile(jarName);
                man = jf.getManifest();
                Enumeration<JarEntry> entries = jf.entries();
                entriesList = new LinkedList<JarEntry>();
                byte[] buffer = new byte[8192];
                try {
                    while (true) {
                        String mssgTotal;
                        Object var19_18;
                        InputStream is;
                        block25: {
                            if (!entries.hasMoreElements()) {
                                if (!this.verifyCanceled) break block23;
                                entry = null;
                                break block24;
                            }
                            entry = entries.nextElement();
                            if (entry.getName().startsWith(NBM_LIB) || entry.getName().startsWith(NBM_BIN)) {
                                mu.setDepending(true);
                            }
                            if (entry.getName().startsWith(NBM_MAIN)) {
                                mu.setSafeToInstall(false);
                            }
                            String jarname = null;
                            if (entry.getName().startsWith(NBM_AUTOLOAD) && entry.getName().endsWith(JAR_EXT)) {
                                jarname = this.getJarModuleName(entry.getName(), "netbeans/modules/autoload/");
                                if (jarname != null) {
                                    mu.addToJarList(jarname);
                                }
                            } else if (entry.getName().startsWith(NBM_EAGER) && entry.getName().endsWith(JAR_EXT)) {
                                jarname = this.getJarModuleName(entry.getName(), "netbeans/modules/eager/");
                                if (jarname != null) {
                                    mu.addToJarList(jarname);
                                }
                            } else if (entry.getName().startsWith(NBM_MODULES) && entry.getName().endsWith(JAR_EXT) && (jarname = this.getJarModuleName(entry.getName(), "netbeans/modules/")) != null) {
                                mu.addToJarList(jarname);
                            }
                            this.progressDialog.setGaugeValue(1, moduleVerified / 1024);
                            entriesList.add(entry);
                            is = jf.getInputStream(entry);
                            try {
                                do {
                                    int n;
                                    if ((n = is.read(buffer, 0, buffer.length)) != -1) continue;
                                    break block25;
                                } while (!this.verifyCanceled);
                                collection = null;
                                var19_18 = null;
                            }
                            catch (Throwable throwable) {
                                var19_18 = null;
                                is.close();
                                this.totalVerified += entry.getCompressedSize();
                                moduleVerified = (int)((long)moduleVerified + entry.getCompressedSize());
                                mssgTotal = MessageFormat.format(SignVerifier.getBundle("FMT_VerifiedTotal"), new Integer((int)(this.totalVerified / 1024L)), new Integer(this.verifySize));
                                this.progressDialog.setGaugeValue(2, (int)(this.totalVerified / 1024L) > this.verifySize ? this.verifySize : (int)(this.totalVerified / 1024L));
                                this.progressDialog.setLabelText(2, mssgTotal);
                                this.progressDialog.setGaugeValue(1, moduleVerified / 1024);
                                throw throwable;
                            }
                            is.close();
                            this.totalVerified += entry.getCompressedSize();
                            moduleVerified = (int)((long)moduleVerified + entry.getCompressedSize());
                            mssgTotal = MessageFormat.format(SignVerifier.getBundle("FMT_VerifiedTotal"), new Integer((int)(this.totalVerified / 1024L)), new Integer(this.verifySize));
                            this.progressDialog.setGaugeValue(2, (int)(this.totalVerified / 1024L) > this.verifySize ? this.verifySize : (int)(this.totalVerified / 1024L));
                            this.progressDialog.setLabelText(2, mssgTotal);
                            this.progressDialog.setGaugeValue(1, moduleVerified / 1024);
                            Object var22_24 = null;
                            break;
                        }
                        var19_18 = null;
                        is.close();
                        this.totalVerified += entry.getCompressedSize();
                        moduleVerified = (int)((long)moduleVerified + entry.getCompressedSize());
                        mssgTotal = MessageFormat.format(SignVerifier.getBundle("FMT_VerifiedTotal"), new Integer((int)(this.totalVerified / 1024L)), new Integer(this.verifySize));
                        this.progressDialog.setGaugeValue(2, (int)(this.totalVerified / 1024L) > this.verifySize ? this.verifySize : (int)(this.totalVerified / 1024L));
                        this.progressDialog.setLabelText(2, mssgTotal);
                        this.progressDialog.setGaugeValue(1, moduleVerified / 1024);
                    }
                }
                catch (Throwable throwable) {
                    Object var22_27 = null;
                    jf.close();
                    if (!this.wizardCanceled) throw throwable;
                    Downloader.getNBM(mu).delete();
                    throw throwable;
                }
                jf.close();
                if (!this.wizardCanceled) return collection;
                Downloader.getNBM(mu).delete();
                return collection;
            }
            Object var22_25 = null;
            jf.close();
            if (!this.wizardCanceled) return entry;
            Downloader.getNBM(mu).delete();
            return entry;
        }
        Object var22_26 = null;
        jf.close();
        if (this.wizardCanceled) {
            Downloader.getNBM(mu).delete();
        }
        HashSet<Certificate> certificates = new HashSet<Certificate>();
        if (man != null) {
            Iterator e = entriesList.iterator();
            while (e.hasNext()) {
                JarEntry je = (JarEntry)e.next();
                String name = je.getName();
                Certificate[] certs = je.getCertificates();
                boolean isSigned = certs != null && certs.length > 0;
                anySigned |= isSigned;
                if (certs != null) {
                    int i = 0;
                    while (i < certs.length) {
                        certificates.add(certs[i]);
                        if (this.verifyCanceled) {
                            return null;
                        }
                        ++i;
                    }
                    continue;
                }
                if (je.isDirectory() || name.toUpperCase().startsWith("META-INF/") || je.getSize() == 0L) continue;
                anyUnsigned = true;
            }
        }
        if (anySigned && anyUnsigned) {
            throw new SecurityException(SignVerifier.getBundle("EXC_NotSignedEntity"));
        }
        this.progressDialog.setGaugeValue(1, flen / 1024 + 10);
        if (!anySigned) return null;
        HashSet<Certificate> hashSet = certificates;
        return hashSet;
    }

    public static String formatCerts(Collection collection) {
        StringBuffer sb = new StringBuffer(collection.size() * 300);
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            Certificate cert = (Certificate)it.next();
            if (cert instanceof X509Certificate) {
                try {
                    sb.append("\n\n");
                    sb.append(SignVerifier.X509CertToString((X509Certificate)cert));
                }
                catch (Exception e) {
                    sb.append(cert.toString());
                }
            } else {
                sb.append(cert.toString());
            }
            sb.append("\n\n");
        }
        return sb.toString();
    }

    boolean isTrusted(Collection certs) {
        Collection trustedCerts = this.getTrustedCerts();
        if (trustedCerts.size() <= 0 || certs.size() <= 0) {
            return false;
        }
        return trustedCerts.containsAll(certs);
    }

    static void addCertificates(Collection certs) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        KeyStore ks = SignVerifier.getKeyStore(Autoupdater.Support.getUserKSFile(), KS_PSSWD, null);
        Iterator it = certs.iterator();
        while (it.hasNext()) {
            Certificate c = (Certificate)it.next();
            if (ks.getCertificateAlias(c) != null) continue;
            String alias = null;
            int i = 0;
            while (i < 9999) {
                alias = "genAlias" + i;
                if (!ks.containsAlias(alias)) break;
                ++i;
            }
            if (alias == null) {
                throw new KeyStoreException(SignVerifier.getBundle("EXC_TooManyCertificates"));
            }
            ks.setCertificateEntry(alias, c);
        }
        SignVerifier.saveKeyStore(ks, Autoupdater.Support.getUserKSFile(), KS_PSSWD, null);
    }

    static void removeCertificates(Collection certs) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        KeyStore ks = SignVerifier.getKeyStore(Autoupdater.Support.getUserKSFile(), KS_PSSWD, null);
        Iterator it = certs.iterator();
        while (it.hasNext()) {
            Certificate c = (Certificate)it.next();
            String alias = ks.getCertificateAlias(c);
            if (alias == null) continue;
            ks.deleteEntry(alias);
        }
        SignVerifier.saveKeyStore(ks, Autoupdater.Support.getUserKSFile(), KS_PSSWD, null);
    }

    Collection getTrustedCerts() {
        ArrayList trustedCerts = new ArrayList(10);
        File cKS = Autoupdater.Support.getCentralKSFile();
        File uKS = Autoupdater.Support.getUserKSFile();
        try {
            KeyStore ks;
            if (cKS.canRead()) {
                ks = SignVerifier.getKeyStore(cKS, KS_PSSWD, null);
                trustedCerts.addAll(SignVerifier.getCertificates(ks));
            }
            if (uKS.canRead() && !uKS.equals(cKS)) {
                ks = SignVerifier.getKeyStore(uKS, KS_PSSWD, null);
                trustedCerts.addAll(SignVerifier.getCertificates(ks));
            }
        }
        catch (CertificateException e) {
        }
        catch (KeyStoreException e) {
        }
        catch (IOException e) {
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
        return trustedCerts;
    }

    private static KeyStore getKeyStore(File file, String password, String storetype) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
        }
        catch (IOException e) {
            // empty catch block
        }
        KeyStore keyStore = null;
        if (storetype == null) {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(is, password.toCharArray());
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        return keyStore;
    }

    public static void saveKeyStore(KeyStore keyStore, File file, String password, String storetype) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        FileOutputStream os = new FileOutputStream(file);
        keyStore.store(os, password.toCharArray());
        ((OutputStream)os).close();
    }

    public static Collection getCertificates(KeyStore keyStore) throws KeyStoreException {
        ArrayList<Certificate> certificates = new ArrayList<Certificate>(10);
        Enumeration<String> en = keyStore.aliases();
        while (en.hasMoreElements()) {
            String alias = en.nextElement();
            Certificate cert = keyStore.getCertificate(alias);
            certificates.add(cert);
        }
        return certificates;
    }

    void cancelVerify(boolean wizardCanceled) {
        this.verifyCanceled = true;
        this.wizardCanceled = wizardCanceled;
    }

    private static String X509CertToString(X509Certificate cert) throws Exception {
        return SignVerifier.getBundle("MSG_Owner") + SPACE + cert.getSubjectDN() + NEW_LINE + SignVerifier.getBundle("MSG_Issuer") + SPACE + cert.getIssuerDN() + NEW_LINE + SignVerifier.getBundle("MSG_SerNumber") + SPACE + cert.getSerialNumber().toString(16) + NEW_LINE + SignVerifier.getBundle("MSG_Valid") + SPACE + cert.getNotBefore().toString() + SPACE + SignVerifier.getBundle("MSG_Until") + SPACE + cert.getNotAfter().toString() + NEW_LINE + SignVerifier.getBundle("MSG_CertFinger") + NEW_LINE + SPACE + TAB + SignVerifier.getBundle("MSG_MD5") + SPACE + SPACE + SignVerifier.getCertFingerPrint("MD5", cert) + NEW_LINE + SPACE + TAB + SignVerifier.getBundle("MSG_SHA1") + SPACE + SignVerifier.getCertFingerPrint("SHA1", cert);
    }

    private static String getCertFingerPrint(String mdAlg, Certificate cert) throws Exception {
        byte[] encCertInfo = cert.getEncoded();
        MessageDigest md = MessageDigest.getInstance(mdAlg);
        byte[] digest = md.digest(encCertInfo);
        return SignVerifier.toHexString(digest);
    }

    private static String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        int i = 0;
        while (i < len) {
            SignVerifier.byte2hex(block[i], buf);
            if (i < len - 1) {
                buf.append(":");
            }
            ++i;
        }
        return buf.toString();
    }

    private static void byte2hex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }

    private String getJarModuleName(String name, String prefix) {
        if (name.substring(prefix.length()).indexOf(ENTRY_SEPARATOR) == -1) {
            String common = "netbeans/modules/";
            return name.substring(common.length());
        }
        return null;
    }

    private static String getBundle(String key) {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$autoupdate$SignVerifier == null ? (class$org$netbeans$modules$autoupdate$SignVerifier = SignVerifier.class$("org.netbeans.modules.autoupdate.SignVerifier")) : class$org$netbeans$modules$autoupdate$SignVerifier), (String)key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

