/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.StringTokenizer;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.XMLUpdates;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class XMLAutoupdateType
extends AutoupdateType {
    static final String PROP_URL = "url";
    private URL URL;
    protected String defaultURL;
    private static final String UPDATE_VERSION_PROP = "netbeans.autoupdate.version";
    public static final String UPDATE_VERSION = "1.6";
    private static final String SYSPROP_COUNTRY = "netbeans.autoupdate.country";
    private static final String SYSPROP_LANGUAGE = "netbeans.autoupdate.language";
    private static final String SYSPROP_VARIANT = "netbeans.autoupdate.variant";
    static final long serialVersionUID = 362844553432169452L;
    protected String displayName = null;
    private FileObject typeFileObject = null;
    private String url_key;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$XMLAutoupdateType;
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$Settings;

    public XMLAutoupdateType() {
        try {
            this.URL = new URL(this.getDefaultURL());
        }
        catch (MalformedURLException e) {
            this.URL = null;
        }
    }

    public XMLAutoupdateType(URL url) {
        this.URL = url;
    }

    public XMLAutoupdateType(URL url, String displayName, String url_key, Boolean enabled) {
        this(url, displayName, null, url_key, enabled);
    }

    public XMLAutoupdateType(URL url, String displayName, FileObject fo, String url_key, Boolean enabled) {
        this.typeFileObject = fo;
        this.URL = url;
        this.displayName = displayName;
        this.url_key = url_key;
        if (enabled != null) {
            this.setEnabled(enabled);
        }
    }

    public static XMLAutoupdateType createXMLAutoupdateType(FileObject fo) throws IOException {
        Object o;
        String sKey = (String)fo.getAttribute("url_key");
        URL url = sKey != null ? new URL(NbBundle.getBundle((Class)(class$org$netbeans$modules$autoupdate$XMLAutoupdateType == null ? (class$org$netbeans$modules$autoupdate$XMLAutoupdateType = XMLAutoupdateType.class$("org.netbeans.modules.autoupdate.XMLAutoupdateType")) : class$org$netbeans$modules$autoupdate$XMLAutoupdateType)).getString(sKey)) : ((o = fo.getAttribute(PROP_URL)) instanceof String ? new URL((String)o) : (URL)o);
        Boolean en = (Boolean)fo.getAttribute("enabled");
        return new XMLAutoupdateType(url, null, fo, sKey, en);
    }

    public String displayName() {
        if (this.displayName == null) {
            if (this.typeFileObject != null) {
                try {
                    this.displayName = DataObject.find((FileObject)this.typeFileObject).getNodeDelegate().getDisplayName();
                }
                catch (DataObjectNotFoundException donfe) {
                    this.displayName = donfe.getFileObject().getName();
                }
            } else {
                this.displayName = NbBundle.getBundle((Class)(class$org$netbeans$modules$autoupdate$Settings == null ? (class$org$netbeans$modules$autoupdate$Settings = XMLAutoupdateType.class$("org.netbeans.modules.autoupdate.Settings")) : class$org$netbeans$modules$autoupdate$Settings)).getString("CTL_XMLAutoupdateType_Name");
            }
        }
        return this.displayName;
    }

    public URL getURL() {
        return this.URL;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$autoupdate$XMLAutoupdateType == null ? (class$org$netbeans$modules$autoupdate$XMLAutoupdateType = XMLAutoupdateType.class$("org.netbeans.modules.autoupdate.XMLAutoupdateType")) : class$org$netbeans$modules$autoupdate$XMLAutoupdateType);
    }

    public void setURL(URL URL2) {
        URL old = this.URL;
        this.URL = URL2;
        this.firePropertyChange(PROP_URL, old, URL2);
    }

    public Updates connectForUpdates() {
        return new XMLUpdates(this.modifyURL(this.URL));
    }

    protected URL modifyURL(URL original) {
        URL updateURL = null;
        if (System.getProperty(UPDATE_VERSION_PROP) == null) {
            System.setProperty(UPDATE_VERSION_PROP, UPDATE_VERSION);
        }
        try {
            updateURL = new URL(this.encode(this.replace(original.toString())));
        }
        catch (MalformedURLException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return updateURL;
    }

    protected String replace(String string) {
        XMLAutoupdateType.setSystemProperties();
        if (string == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int prevIndex = 0;
        int index = 0;
        while ((index = string.indexOf("{", index)) != -1 && index < string.length() - 1) {
            if (string.charAt(index + 1) == '{' || string.charAt(index + 1) != '$') {
                ++index;
                continue;
            }
            sb.append(string.substring(prevIndex, index));
            int endBracketIndex = string.indexOf("}", index);
            if (endBracketIndex != -1) {
                String whatToReplace = string.substring(index + 2, endBracketIndex);
                sb.append(this.getReplacement(whatToReplace));
            }
            prevIndex = endBracketIndex == -1 ? index + 2 : endBracketIndex + 1;
            ++index;
        }
        if (prevIndex < string.length() - 1) {
            sb.append(string.substring(prevIndex));
        }
        return sb.toString();
    }

    protected String getReplacement(String whatToReplace) {
        return System.getProperty(whatToReplace, "");
    }

    protected String encode(String stringURL) {
        String rval = stringURL;
        int q = stringURL.indexOf(63);
        if (q > 0) {
            StringBuffer buf = new StringBuffer(stringURL.substring(0, q + 1));
            StringTokenizer st = new StringTokenizer(stringURL.substring(q + 1), "&");
            while (st.hasMoreTokens()) {
                String a = st.nextToken();
                int ei = a.indexOf("=");
                if (ei < 0) {
                    buf.append(URLEncoder.encode(a));
                } else {
                    buf.append(URLEncoder.encode(a.substring(0, ei)));
                    buf.append("=");
                    String tna = a.substring(ei + 1);
                    int tni = tna.indexOf("%");
                    if (tni < 0) {
                        buf.append(URLEncoder.encode(tna));
                    } else {
                        buf.append(URLEncoder.encode(tna.substring(0, tni)));
                        buf.append("%");
                        buf.append(URLEncoder.encode(tna.substring(tni + 1)));
                    }
                }
                if (!st.hasMoreTokens()) continue;
                buf.append("&");
            }
            rval = buf.toString();
        }
        return rval;
    }

    private static void setSystemProperties() {
        if (System.getProperty(SYSPROP_COUNTRY, null) == null) {
            System.setProperty(SYSPROP_COUNTRY, Locale.getDefault().getCountry());
        }
        if (System.getProperty(SYSPROP_LANGUAGE, null) == null) {
            System.setProperty(SYSPROP_LANGUAGE, Locale.getDefault().getLanguage());
        }
        if (System.getProperty(SYSPROP_VARIANT, null) == null) {
            System.setProperty(SYSPROP_VARIANT, Locale.getDefault().getVariant());
        }
    }

    protected String getDefaultURL() {
        if (this.defaultURL == null) {
            this.defaultURL = this.url_key != null ? NbBundle.getBundle((Class)(class$org$netbeans$modules$autoupdate$XMLAutoupdateType == null ? (class$org$netbeans$modules$autoupdate$XMLAutoupdateType = XMLAutoupdateType.class$("org.netbeans.modules.autoupdate.XMLAutoupdateType")) : class$org$netbeans$modules$autoupdate$XMLAutoupdateType)).getString(this.url_key) : NbBundle.getBundle((Class)(class$org$netbeans$modules$autoupdate$XMLAutoupdateType == null ? (class$org$netbeans$modules$autoupdate$XMLAutoupdateType = XMLAutoupdateType.class$("org.netbeans.modules.autoupdate.XMLAutoupdateType")) : class$org$netbeans$modules$autoupdate$XMLAutoupdateType)).getString("URL_Default_N");
        }
        return this.defaultURL;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.URL.toString().equals(this.getDefaultURL())) {
            out.writeObject(null);
        } else {
            out.writeObject(this.URL);
        }
        out.writeObject(this.displayName);
        out.writeObject(this.url_key);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        URL u = null;
        try {
            String key;
            u = (URL)in.readObject();
            String display = (String)in.readObject();
            if (display != null) {
                this.displayName = display;
            }
            if ((key = (String)in.readObject()) != null) {
                this.url_key = key;
            }
        }
        catch (OptionalDataException ode) {
            if (ode.eof) {
                u = null;
                this.setEnabled(true);
            }
            throw ode;
        }
        if (u == null || u.toString().startsWith("http://www.netbeans.org/updates/31_")) {
            this.setURL(new URL(this.getDefaultURL()));
        } else {
            this.setURL(u);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

