/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.netbeans.modules.autoupdate.ConnectingDialog;
import org.netbeans.modules.autoupdate.L10NUpdate;
import org.netbeans.modules.autoupdate.ModuleGroup;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.Settings;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUpdates
extends Updates {
    private static final String TAG_MODULE_UPDATES = "module_updates";
    private static final String TAG_MODULE = "module";
    private static final String TAG_MODULE_GROUP = "module_group";
    private static final String TAG_NOTIFICATION = "notification";
    private static final String ATTR_NOTIFICATION_URL = "url";
    private static final String TAG_ERROR = "error";
    private static final String TAG_AUTH_ERROR = "auth_error";
    private static final String TAG_OTHER_ERROR = "other_error";
    private static final String ATTR_MESSAGE_ERROR = "message";
    private ArrayList modules;
    private HashMap checkOnceMore;
    private ModuleGroup rootGroup;
    private int pError = 0;
    private String errorMess = null;
    private Date timeStamp = null;
    private String notificationText = null;
    private URL notificationURL = null;
    private URL xmlURL;
    private File[] files;
    private static ArrayList groupFiles = new ArrayList();
    private static boolean timerSet = false;
    private static boolean groupStarted = false;
    private static int oldGroupSize = 0;
    private Document document = null;
    private InputSource xmlInputSource = null;
    private AutoupdateType currentAT = null;

    XMLUpdates(URL xmlURL) {
        this.xmlURL = xmlURL;
    }

    XMLUpdates(File[] files) {
        this.files = files;
    }

    static void startGroupUpdates(File file) {
        if (groupStarted) {
            new XMLUpdates(new File[]{file}).go();
        } else {
            groupFiles.add(file);
            XMLUpdates.setTimer();
        }
    }

    private static void setTimer() {
        if (!timerSet) {
            timerSet = true;
            oldGroupSize = groupFiles.size();
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    if (oldGroupSize < groupFiles.size()) {
                        oldGroupSize = groupFiles.size();
                        RequestProcessor.getDefault().post((Runnable)this, 500);
                    } else {
                        timerSet = false;
                        groupStarted = true;
                        File[] arrFiles = new File[groupFiles.size()];
                        Iterator it = ((AbstractList)groupFiles).iterator();
                        int j = 0;
                        while (it.hasNext()) {
                            File fn = (File)it.next();
                            if (fn != null) {
                                arrFiles[j] = fn;
                            }
                            ++j;
                        }
                        groupFiles.clear();
                        groupStarted = false;
                        new XMLUpdates(arrFiles).go();
                    }
                }
            }, 500);
        }
    }

    private void go() {
        HashMap<XMLUpdates, XMLUpdates> allUpdates = new HashMap<XMLUpdates, XMLUpdates>();
        allUpdates.put(this, this);
        Wizard wiz = Wizard.go(allUpdates, 1);
        if (wiz != null) {
            this.checkDownloadedModules();
            wiz.refreshUpdatePanel();
        }
    }

    public void checkUpdates(Wizard.Validator validator) {
        this.checkUpdates(validator, "");
    }

    public void checkUpdates(Wizard.Validator validator, String ucname) {
        this.checkUpdates(validator, AutoupdateType.find(ucname));
    }

    public void checkUpdates(final Wizard.Validator validator, AutoupdateType at) {
        this.currentAT = at;
        this.pError = 0;
        this.checkCanceled = false;
        final Dialog connDialog = ConnectingDialog.getDialog(at != null ? at.getName() : null);
        Runnable task = new Runnable(){

            public void run() {
                XMLUpdates.this.parseDocument();
                Settings.getShared().setLastCheck(new Date());
                if (XMLUpdates.this.pError == 0 && XMLUpdates.this.document != null) {
                    XMLUpdates.this.buildStructures();
                } else {
                    XMLUpdates.this.pError = 1;
                }
                if (connDialog != null) {
                    ConnectingDialog.closeDialog(connDialog);
                }
                validator.setValid(true);
            }
        };
        Wizard.getRequestProcessor().post(task);
        connDialog.show();
        if (ConnectingDialog.isCanceled()) {
            this.cancelCheck();
        }
    }

    public void cancelCheck() {
        this.checkCanceled = true;
        if (this.xmlInputSource != null) {
            try {
                if (this.xmlInputSource.getByteStream() != null) {
                    this.xmlInputSource.getByteStream().close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public ModuleGroup getRootGroup() {
        return this.rootGroup;
    }

    public Collection getModules() {
        return this.modules;
    }

    public boolean isError() {
        return this.pError > 0;
    }

    public int getError() {
        return this.pError;
    }

    public String getErrorMessage() {
        return this.errorMess;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public String getNotificationText() {
        return this.notificationText;
    }

    public URL getNotificationURL() {
        return this.notificationURL;
    }

    void checkDownloadedModules() {
        this.modules = new ArrayList();
        this.rootGroup = new ModuleGroup();
        this.checkOnceMore = new HashMap();
        int i = 0;
        while (i < this.files.length) {
            ModuleUpdate update = ModuleUpdate.getModuleUpdate(this.files[i]);
            if (update != null) {
                if (update.isUpdateAvailable()) {
                    this.modules.add(update);
                    this.rootGroup.addItem(update);
                } else if (update instanceof L10NUpdate) {
                    this.checkOnceMore.put(update, this.rootGroup);
                }
            }
            ++i;
        }
        this.checkAvailablesOnceMore();
    }

    void checkAvailablesOnceMore() {
        Iterator it = this.checkOnceMore.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            L10NUpdate update = (L10NUpdate)entry.getKey();
            if (!update.isRemoteModuleAvailable(this.modules)) continue;
            this.modules.add(update);
            ((ModuleGroup)entry.getValue()).addItem(update);
        }
    }

    private void parseDocument() {
        if (this.checkCanceled) {
            return;
        }
        String showStr = System.getProperty("autoupdate.show.url");
        if (showStr != null && Boolean.valueOf(showStr).booleanValue()) {
            System.out.println("URL : " + this.xmlURL);
        }
        try {
            HttpURLConnection.setFollowRedirects(true);
            this.xmlInputSource = new InputSource(this.xmlURL.toExternalForm());
            if (this.checkCanceled) {
                return;
            }
            this.document = XMLUtil.parse((InputSource)this.xmlInputSource, (boolean)false, (boolean)false, (ErrorHandler)new ErrorCatcher(), null);
        }
        catch (SAXException e) {
            System.out.println("URL : " + this.xmlURL);
            e.printStackTrace();
            this.pError = 1;
        }
        catch (IOException e) {
            System.out.println("URL : " + this.xmlURL);
            e.printStackTrace();
            this.pError = 1;
        }
    }

    private void buildStructures() {
        if (this.checkCanceled) {
            return;
        }
        if (this.document.getDocumentElement() != null) {
            this.modules = new ArrayList();
            this.rootGroup = new ModuleGroup();
            this.checkOnceMore = new HashMap();
            if (this.detectErrorType()) {
                return;
            }
            NodeList allModules = this.document.getElementsByTagName(TAG_MODULE);
            this.processElement(this.document.getDocumentElement(), this.rootGroup);
            Node attr = this.document.getDocumentElement().getAttributes().getNamedItem("timestamp");
            if (attr != null) {
                String timeString = attr.getNodeValue() + "/GMT";
                SimpleDateFormat formatter = new SimpleDateFormat("ss/mm/HH/dd/MM/yyyy/zzz");
                ParsePosition pos = new ParsePosition(0);
                this.timeStamp = formatter.parse(timeString, pos);
            }
            this.checkAvailablesOnceMore();
        }
    }

    private boolean detectErrorType() {
        NodeList errors = this.document.getElementsByTagName(TAG_ERROR);
        if (errors.getLength() > 0) {
            NodeList auth_errors = this.document.getElementsByTagName(TAG_AUTH_ERROR);
            if (auth_errors.getLength() > 0) {
                this.pError = 2;
            } else {
                this.pError = 1;
                NodeList other_errors = this.document.getElementsByTagName(TAG_OTHER_ERROR);
                if (other_errors.getLength() > 0) {
                    this.errorMess = other_errors.item(0).getAttributes().getNamedItem(ATTR_MESSAGE_ERROR).getNodeValue();
                }
            }
        }
        return this.pError > 0;
    }

    private void processElement(Element element, ModuleGroup moduleGroup) {
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            if (this.checkCanceled) {
                return;
            }
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                if (((Element)node).getTagName().equals(TAG_MODULE)) {
                    ModuleUpdate update = ModuleUpdate.getModuleUpdate(this.xmlURL, node, this.document.getDocumentElement(), this.currentAT);
                    if (update != null) {
                        if (update.isUpdateAvailable()) {
                            this.modules.add(update);
                            moduleGroup.addItem(update);
                        } else if (update instanceof L10NUpdate) {
                            this.checkOnceMore.put(update, moduleGroup);
                        }
                    }
                } else if (((Element)node).getTagName().equals(TAG_MODULE_GROUP)) {
                    ModuleGroup group = new ModuleGroup(node);
                    moduleGroup.addItem(group);
                    this.processElement((Element)node, group);
                } else if (((Element)node).getTagName().equals(TAG_NOTIFICATION)) {
                    this.readNotification(node);
                }
            }
            ++i;
        }
    }

    private void readNotification(Node node) {
        if (this.getNotificationText() != null) {
            return;
        }
        try {
            String textURL;
            Node attr = node.getAttributes().getNamedItem(ATTR_NOTIFICATION_URL);
            String string = textURL = attr == null ? null : attr.getNodeValue();
            if (textURL != null) {
                this.notificationURL = new URL(textURL);
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer();
        NodeList innerList = node.getChildNodes();
        int i = 0;
        while (i < innerList.getLength()) {
            if (innerList.item(i).getNodeType() == 3) {
                sb.append(innerList.item(i).getNodeValue());
            }
            ++i;
        }
        this.notificationText = sb.length() > 0 ? sb.toString() : null;
    }

    class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String level, SAXParseException e) {
            XMLUpdates.this.pError = 1;
        }

        public void error(SAXParseException e) {
            XMLUpdates.this.pError = 1;
        }

        public void warning(SAXParseException e) {
        }

        public void fatalError(SAXParseException e) {
            XMLUpdates.this.pError = 1;
        }
    }
}

