/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.catalina;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Context;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.HttpRequestBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.valves.ValveBase;

public class MonitorValve
extends ValveBase {
    protected static String info = "org.netbeans.modules.web.monitor.catalina.MonitorValve/1.0";
    public static final String METAINF = "/META-INF";
    public static final String WEBINF = "/WEB-INF";
    public static final String ATTR = "netbeans.monitor.servlet";
    public static final String REPLAYSESSION = "netbeans.replay.session";
    public static final String REPLACED = "netbeans.replay.session-replaced";
    private static final boolean debug = false;

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response, ValveContext valveContext) throws IOException, ServletException {
        HttpServletRequest req = this.validRequest(request);
        if (req != null) {
            int index;
            StandardContext appContext = (StandardContext)this.getContainer();
            this.setServlet(request, appContext);
            String queryString = req.getQueryString();
            if (queryString != null && !queryString.equals("") && (index = queryString.indexOf(REPLAYSESSION)) > -1) {
                String sessionID = req.getParameter(REPLAYSESSION);
                HttpRequestBase reqImpl = null;
                try {
                    reqImpl = (HttpRequestBase)request;
                    if (sessionID == null || sessionID.equals("")) {
                        reqImpl.setRequestedSessionId(null);
                    } else {
                        reqImpl.setRequestedSessionId(sessionID);
                    }
                    reqImpl.setAttribute(REPLACED, (Object)"true");
                }
                catch (ClassCastException cce) {
                    cce.printStackTrace();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        valveContext.invokeNext(request, response);
    }

    HttpServletRequest validRequest(Request request) {
        HttpServletRequest req = null;
        try {
            req = (HttpServletRequest)request.getRequest();
        }
        catch (ClassCastException cce) {
            return null;
        }
        String contextPath = req.getContextPath();
        String requestURI = req.getRequestURI();
        String relativeURI = requestURI.substring(contextPath.length()).toUpperCase();
        if (relativeURI.startsWith(METAINF) || relativeURI.startsWith(WEBINF)) {
            return null;
        }
        return req;
    }

    void setServlet(Request request, StandardContext context) {
        Wrapper wrapper = null;
        try {
            wrapper = (Wrapper)context.map(request, true);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        if (wrapper == null) {
            return;
        }
        Servlet servlet = null;
        Context ctxt = (Context)wrapper.getParent();
        if (!ctxt.getAvailable()) {
            return;
        }
        if (wrapper.isUnavailable()) {
            return;
        }
        try {
            servlet = wrapper.allocate();
        }
        catch (ServletException e) {
            return;
        }
        catch (Throwable t) {
            return;
        }
        try {
            if (servlet != null) {
                wrapper.deallocate(servlet);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        ((HttpServletRequest)request).setAttribute(ATTR, (Object)servlet);
    }

    private void log(String s) {
        System.out.println("MonitorValve::" + s);
    }
}

