/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.io.NotSerializableException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.core.NbPlaces;
import org.netbeans.core.projects.SystemFileSystem;
import org.netbeans.core.projects.XMLSettingsHandler;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.InstanceDataObject;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.WeakSet;

public class AutomountSupport
extends FolderInstance
implements TaskListener,
RepositoryListener,
Runnable {
    private static RequestProcessor RP = new RequestProcessor("Automount");
    private static ThreadLocal VAR = new ThreadLocal();
    private static DblTask defaultTask;
    private static final int DELAY = 1000;
    private static Set createdByMe;
    private static Set sticky;
    private static Set shineAway;
    private static Set errCookies;
    private static ErrorManager err;
    static /* synthetic */ Class class$org$openide$filesystems$FileSystem;
    static /* synthetic */ Class array$Lorg$openide$filesystems$FileSystem;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$loaders$InstanceDataObject;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

    private AutomountSupport(DataObject.Container fld) {
        super(fld);
    }

    protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
        ArrayList<Object> arr = new ArrayList<Object>();
        int i = 0;
        while (i < cookies.length) {
            block8: {
                Object obj;
                try {
                    obj = cookies[i].instanceCreate();
                }
                catch (IOException ex) {
                    if (errCookies.add(cookies[i])) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                    break block8;
                }
                errCookies.remove(cookies[i]);
                if (obj instanceof FileSystem) {
                    arr.add(obj);
                } else if (obj instanceof FileSystem[]) {
                    arr.addAll(Arrays.asList((FileSystem[])obj));
                }
            }
            ++i;
        }
        if (arr.size() == 1) {
            return arr.get(0);
        }
        return arr.toArray(new FileSystem[0]);
    }

    protected Object instanceForCookie(DataObject obj, InstanceCookie cookie) throws IOException, ClassNotFoundException {
        if (errCookies.contains(cookie)) {
            obj.delete();
            return null;
        }
        try {
            return super.instanceForCookie(obj, cookie);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
            obj.delete();
            return null;
        }
    }

    protected InstanceCookie acceptContainer(DataObject.Container container) {
        return new AutomountSupport(container);
    }

    protected InstanceCookie acceptCookie(InstanceCookie cookie) throws IOException, ClassNotFoundException {
        if (cookie instanceof InstanceCookie.Of) {
            InstanceCookie.Of of = (InstanceCookie.Of)cookie;
            if (of.instanceOf(class$org$openide$filesystems$FileSystem == null ? (class$org$openide$filesystems$FileSystem = AutomountSupport.class$("org.openide.filesystems.FileSystem")) : class$org$openide$filesystems$FileSystem) || of.instanceOf(array$Lorg$openide$filesystems$FileSystem == null ? (array$Lorg$openide$filesystems$FileSystem = AutomountSupport.class$("[Lorg.openide.filesystems.FileSystem;")) : array$Lorg$openide$filesystems$FileSystem)) {
                return cookie;
            }
            return null;
        }
        Class<?> c = cookie.instanceClass();
        if (c.isArray()) {
            c = c.getComponentType();
        }
        if ((class$org$openide$filesystems$FileSystem == null ? (class$org$openide$filesystems$FileSystem = AutomountSupport.class$("org.openide.filesystems.FileSystem")) : class$org$openide$filesystems$FileSystem).isAssignableFrom(c)) {
            return cookie;
        }
        return null;
    }

    protected Task postCreationTask(Runnable run) {
        return RP.post(run);
    }

    public void taskFinished(Task task) {
        AutomountSupport.updateFileSystems(this.getList());
    }

    private List getList() {
        Object fsOrFss = null;
        try {
            fsOrFss = this.instanceCreate();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        if (fsOrFss == null) {
            return Collections.EMPTY_LIST;
        }
        if (fsOrFss instanceof FileSystem) {
            return Collections.nCopies(1, fsOrFss);
        }
        return Arrays.asList((FileSystem[])fsOrFss);
    }

    public static synchronized Task initialize() {
        if (defaultTask != null) {
            return defaultTask;
        }
        NbPlaces.getDefault();
        DataFolder folder = NbPlaces.findSessionFolder("Mount");
        AutomountSupport auto = new AutomountSupport((DataObject.Container)folder);
        auto.addTaskListener(auto);
        RequestProcessor.Task storeTask = RP.create((Runnable)auto);
        storeTask.setPriority(1);
        defaultTask = new DblTask((Task)auto, storeTask);
        Repository rep = Repository.getDefault();
        rep.addRepositoryListener((RepositoryListener)auto);
        AutomountSupport automountSupport = auto;
        synchronized (automountSupport) {
            sticky.addAll(Arrays.asList(rep.toArray()));
            if (sticky.size() > 1) {
                defaultTask.store();
            }
        }
        auto.recreate();
        return defaultTask;
    }

    public void run() {
        try {
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                public void run() {
                    NbPlaces.getDefault();
                    DataFolder df = NbPlaces.findSessionFolder("Mount");
                    DataObject[] arr = df.getChildren();
                    AutomountSupport.checkSaved(AutomountSupport.this.getList(), df, arr);
                }
            });
        }
        catch (IOException ex) {
            throw new IllegalStateException();
        }
    }

    public void fileSystemAdded(RepositoryEvent ev) {
        defaultTask.fs(ev);
    }

    public void fileSystemRemoved(RepositoryEvent ev) {
        defaultTask.fs(ev);
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent ev) {
    }

    private static boolean containsFS(FileSystem fs) {
        FileSystem[] arr = Repository.getDefault().toArray();
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == fs) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String escape(String name) throws IOException {
        try {
            Method escape = (class$org$openide$loaders$InstanceDataObject == null ? (class$org$openide$loaders$InstanceDataObject = AutomountSupport.class$("org.openide.loaders.InstanceDataObject")) : class$org$openide$loaders$InstanceDataObject).getDeclaredMethod("escapeAndCut", class$java$lang$String == null ? (class$java$lang$String = AutomountSupport.class$("java.lang.String")) : class$java$lang$String);
            ((AccessibleObject)escape).setAccessible(true);
            return (String)escape.invoke(null, (Object[])new String[]{name});
        }
        catch (Exception ex) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException("Escape support failed"), (Throwable)ex);
        }
    }

    public static String computeNewName(String requiredName, DataFolder df) throws IOException {
        if (requiredName == null || requiredName.length() == 0) {
            return null;
        }
        boolean isUsed = true;
        String srcName = requiredName;
        int i = 1;
        while (isUsed) {
            String uniqueName;
            isUsed = false;
            String escaped = AutomountSupport.escape(srcName);
            if (escaped.equals(uniqueName = FileUtil.findFreeFileName((FileObject)df.getPrimaryFile(), (String)escaped, (String)"settings"))) continue;
            isUsed = true;
            srcName = requiredName + "_" + i;
            ++i;
        }
        return srcName;
    }

    private static void checkSaved(List now, DataFolder df, DataObject[] arr) {
        Repository rep;
        Repository repository = rep = Repository.getDefault();
        synchronized (repository) {
            List<FileSystem> asList = Arrays.asList(rep.toArray());
            ArrayList<FileSystem> exists = new ArrayList<FileSystem>(asList);
            exists.removeAll(now);
            ArrayList<Object> order = new ArrayList<Object>(asList.size() * 2);
            order.addAll(Arrays.asList(arr));
            sticky.removeAll(now);
            HashSet<FileSystem> doNotDeleteFileSystems = new HashSet<FileSystem>(asList);
            doNotDeleteFileSystems.retainAll(createdByMe);
            boolean diff = false;
            Iterator it = exists.iterator();
            while (it.hasNext()) {
                FileSystem fs = (FileSystem)it.next();
                if (fs.isDefault()) continue;
                try {
                    InstanceDataObject dobj;
                    String layer;
                    String string = layer = XMLSettingsHandler.isProjectObject(fs) ? null : "session";
                    if (layer != null) {
                        SystemFileSystem.setLayerForNew(df.getPrimaryFile().getPath(), layer);
                    }
                    String name = AutomountSupport.computeNewName(fs.getDisplayName(), df);
                    try {
                        dobj = InstanceDataObject.create((DataFolder)df, (String)name, (Object)fs, null);
                    }
                    catch (NotSerializableException nse) {
                        continue;
                    }
                    if (layer != null) {
                        SystemFileSystem.setLayerForNew(df.getPrimaryFile().toString(), null);
                    }
                    if (dobj.instanceCreate() != fs) {
                        StringBuffer sb = new StringBuffer(255);
                        sb.append("This bug is caused by wrong implementation of InstanceDataObject, see ");
                        sb.append("http://www.netbeans.org/issues/show_bug.cgi?id=14557");
                        sb.append("\nSTORING: ");
                        sb.append(fs);
                        sb.append("\nINSTNCE: ");
                        sb.append(dobj.instanceCreate());
                        throw new IllegalStateException(sb.toString());
                    }
                    doNotDeleteFileSystems.add(fs);
                    if (AutomountSupport.isLog()) {
                        AutomountSupport.log(" written to disk: " + fs + " into: " + dobj);
                    }
                    order.add(dobj);
                    sticky.remove(fs);
                    diff = true;
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                catch (ClassNotFoundException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            int i = 0;
            while (i < arr.length) {
                InstanceCookie ic = (InstanceCookie)arr[i].getCookie(class$org$openide$cookies$InstanceCookie == null ? AutomountSupport.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                if (ic != null) {
                    try {
                        Object obj = ic.instanceCreate();
                        if (obj instanceof FileSystem && !doNotDeleteFileSystems.contains(obj)) {
                            arr[i].delete();
                            if (AutomountSupport.isLog()) {
                                AutomountSupport.log("  deleted from disk: " + obj + " from: " + arr[i]);
                            }
                            ((AbstractCollection)order).remove(arr[i]);
                            diff = true;
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                }
                ++i;
            }
            if (diff) {
                try {
                    df.setOrder(order.toArray(new DataObject[0]));
                    if (AutomountSupport.isLog()) {
                        AutomountSupport.log("Changed order on the disk");
                        Iterator x = ((AbstractList)order).iterator();
                        int i2 = 0;
                        while (x.hasNext()) {
                            DataObject obj = (DataObject)x.next();
                            InstanceCookie ic = (InstanceCookie)obj.getCookie(class$org$openide$cookies$InstanceCookie == null ? AutomountSupport.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                            if (ic == null) continue;
                            AutomountSupport.log("  " + i2++ + " is: " + ic.instanceCreate());
                        }
                    }
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                catch (ClassNotFoundException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }
    }

    private static void updateFileSystems(List future) {
        Repository rep;
        Repository repository = rep = Repository.getDefault();
        synchronized (repository) {
            List<FileSystem> exists = Arrays.asList(rep.toArray());
            LinkedList<FileSystem> toRemove = new LinkedList<FileSystem>(exists);
            toRemove.removeAll(future);
            toRemove.removeAll(sticky);
            AutomountSupport.log("sticky: " + sticky);
            toRemove.retainAll(createdByMe);
            if (AutomountSupport.isLog()) {
                Iterator it = toRemove.iterator();
                while (it.hasNext()) {
                    FileSystem fs = (FileSystem)it.next();
                    AutomountSupport.log("  r: " + fs + " contains: " + sticky.contains(fs));
                }
            }
            LinkedList toAdd = new LinkedList(future);
            toAdd.removeAll(exists);
            toAdd.removeAll(shineAway);
            if (AutomountSupport.isLog()) {
                Iterator it = toAdd.iterator();
                while (it.hasNext()) {
                    FileSystem fs = (FileSystem)it.next();
                    AutomountSupport.log("  a: " + fs + " contains: " + sticky.contains(fs));
                }
            }
            VAR.set(VAR);
            AutomountSupport.cycleFileSystems(toRemove, false);
            AutomountSupport.cycleFileSystems(toAdd, true);
            VAR.set(null);
            createdByMe.addAll(future);
            createdByMe.retainAll(Arrays.asList(rep.toArray()));
            FileSystem[] arr = rep.toArray();
            LinkedList future1 = new LinkedList(future);
            future1.retainAll(Arrays.asList(arr));
            int[] perm = new int[arr.length];
            int old = future1.size() + 1;
            boolean diff = false;
            int i = 0;
            while (i < arr.length) {
                if (arr[i].isDefault()) {
                    perm[i] = 0;
                } else {
                    int indx = future1.indexOf(arr[i]);
                    indx = indx == -1 ? old++ : ++indx;
                    perm[indx] = i;
                    diff |= indx != i;
                }
                ++i;
            }
            if (diff) {
                if (AutomountSupport.isLog()) {
                    AutomountSupport.log("Doing reorder");
                    int i2 = 0;
                    while (i2 < arr.length) {
                        AutomountSupport.log("  " + i2 + " <- " + perm[i2] + " now: " + arr[i2]);
                        ++i2;
                    }
                    AutomountSupport.log("On disk");
                    Iterator x = future1.iterator();
                    while (x.hasNext()) {
                        AutomountSupport.log("  " + x.next());
                    }
                    AutomountSupport.log("------");
                }
                rep.reorder(perm);
            } else {
                AutomountSupport.log("No reoder");
            }
        }
    }

    private static void cycleFileSystems(Collection fss, boolean add) {
        Repository repository = Repository.getDefault();
        Iterator it = fss.iterator();
        while (it.hasNext()) {
            FileSystem fs = (FileSystem)it.next();
            if (add) {
                FileSystem old = repository.findFileSystem(fs.getSystemName());
                if (old != null && old != fs && sticky.remove(old)) {
                    repository.removeFileSystem(old);
                }
                repository.addFileSystem(fs);
                continue;
            }
            repository.removeFileSystem(fs);
        }
    }

    private static boolean isLog() {
        if (err == null) {
            err = ErrorManager.getDefault().getInstance("org.netbeans.core.AutomountSupport");
        }
        return err.isLoggable(1);
    }

    private static void log(String msg) {
        if (AutomountSupport.isLog()) {
            err.log(msg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ boolean access$400(FileSystem x0) {
        return AutomountSupport.containsFS(x0);
    }

    static /* synthetic */ Set access$500() {
        return sticky;
    }

    static /* synthetic */ Set access$600() {
        return shineAway;
    }

    static /* synthetic */ DblTask access$700() {
        return defaultTask;
    }

    static {
        createdByMe = new WeakSet();
        sticky = new WeakSet();
        shineAway = new WeakSet();
        errCookies = new WeakSet();
    }

    private static final class DblTask
    extends Task
    implements TaskListener {
        private Task defaultInstance;
        private RequestProcessor.Task storeTask;
        private Task updateTask = Task.EMPTY;
        private boolean isStoring;

        public DblTask(Task defaultInstance, RequestProcessor.Task storeTask) {
            this.defaultInstance = defaultInstance;
            this.storeTask = storeTask;
            defaultInstance.addTaskListener((TaskListener)this);
            storeTask.addTaskListener((TaskListener)this);
        }

        public void store() {
            DblTask dblTask = this;
            synchronized (dblTask) {
                this.storeTask.schedule(1000);
                this.isStoring = true;
            }
            this.notifyRunning();
        }

        private synchronized boolean areBothFinished() {
            boolean t1;
            boolean bl = t1 = !this.isStoring || this.storeTask.isFinished();
            if (!t1) {
                return false;
            }
            boolean t2 = this.defaultInstance.isFinished();
            if (!t2) {
                return false;
            }
            boolean t3 = this.updateTask.isFinished();
            return t3;
        }

        public void waitFinished() {
            do {
                boolean storing;
                this.updateTask.waitFinished();
                this.defaultInstance.waitFinished();
                DblTask dblTask = this;
                synchronized (dblTask) {
                    storing = this.isStoring;
                }
                if (!storing) continue;
                this.storeTask.waitFinished();
            } while (!this.areBothFinished());
        }

        public void taskFinished(Task t) {
            if (this.areBothFinished()) {
                this.notifyFinished();
            }
        }

        public synchronized void fs(RepositoryEvent ev) {
            boolean isNull;
            boolean bl = isNull = VAR.get() == null;
            if (!isNull) {
                AutomountSupport.log("fs: " + ev.getFileSystem() + " added: " + ev.isAdded() + " by AU support");
                return;
            }
            RequestProcessor.Task task = RP.post(new Runnable(this, ev){
                private final /* synthetic */ RepositoryEvent val$ev;
                private final /* synthetic */ DblTask this$0;
                {
                    this.this$0 = this$0;
                    this.val$ev = val$ev;
                }

                public void run() {
                    Repository rep;
                    Repository repository = rep = Repository.getDefault();
                    synchronized (repository) {
                        FileSystem fs = this.val$ev.getFileSystem();
                        boolean c = AutomountSupport.access$400(fs);
                        boolean added = this.val$ev.isAdded();
                        AutomountSupport.access$300("fs: " + fs + " added: " + added + " contains: " + c);
                        if (added) {
                            if (c) {
                                AutomountSupport.access$500().add(fs);
                                AutomountSupport.access$600().remove(fs);
                                AutomountSupport.access$700().store();
                            }
                        } else if (!c) {
                            AutomountSupport.access$500().remove(fs);
                            AutomountSupport.access$600().add(fs);
                            AutomountSupport.access$700().store();
                        }
                    }
                    this.this$0.removeTaskListener(this.this$0);
                }
            });
            task.addTaskListener((TaskListener)this);
            this.updateTask = task;
        }
    }
}

