/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.core.FileSelector;
import org.netbeans.core.NbMainExplorer;
import org.netbeans.core.NbPresenter;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.explorer.propertysheet.PropertySheetSettings;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeOperation;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.UserCancelException;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.SafeException;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class NbNodeOperation
extends NodeOperation {
    private static final String PROP_LONGER_DISPLAY_NAME = "longerDisplayName";

    public void explore(final Node n) {
        Mutex.EVENT.readAccess(new Runnable(){
            static /* synthetic */ Class class$org$netbeans$core$NbNodeOperation;

            public void run() {
                NbMainExplorer.ExplorerTab et = new NbMainExplorer.ExplorerTab();
                et.setRootContext(n);
                et.adjustComponentPersistence();
                WindowManagerImpl wm = (WindowManagerImpl)WindowManager.getDefault();
                WorkspaceImpl curWorkspace = (WorkspaceImpl)wm.getCurrentWorkspace();
                String modeName = WindowManagerImpl.findUnusedModeName(((Component)((Object)et)).getName(), curWorkspace);
                curWorkspace.createMode(modeName, NbBundle.getBundle((Class)(class$org$netbeans$core$NbNodeOperation == null ? (class$org$netbeans$core$NbNodeOperation = 1.class$("org.netbeans.core.NbNodeOperation")) : class$org$netbeans$core$NbNodeOperation)).getString("CTL_ExplorerTitle"), null, true).dockInto((TopComponent)et);
                et.open();
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
    }

    public boolean customize(Node n) {
        final Component customizer = n.getCustomizer();
        if (customizer == null) {
            return false;
        }
        return (Boolean)Mutex.EVENT.readAccess(new Mutex.Action(){
            static /* synthetic */ Class class$org$netbeans$core$ModuleFSSection;

            public Object run() {
                if (customizer instanceof NbPresenter) {
                    ((NbPresenter)customizer).pack();
                    ((NbPresenter)customizer).show();
                    return Boolean.TRUE;
                }
                if (customizer instanceof Window) {
                    ((Window)customizer).pack();
                    customizer.setVisible(true);
                    return Boolean.TRUE;
                }
                HelpFwdPanel p = null;
                p = customizer instanceof ExplorerManager.Provider ? new ExplorerProviderFwd(customizer, (ExplorerManager.Provider)customizer) : new HelpFwdPanel(customizer);
                p.setLayout(new BorderLayout());
                p.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$core$ModuleFSSection == null ? (class$org$netbeans$core$ModuleFSSection = 2.class$("org.netbeans.core.ModuleFSSection")) : class$org$netbeans$core$ModuleFSSection), (String)"CTL_Customizer_dialog_title"));
                if (customizer.getClass().getName().startsWith("org.netbeans.modules.xml.catalog")) {
                    p.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
                }
                p.add(customizer, "Center");
                DialogDescriptor dd = new DialogDescriptor((Object)p, NbBundle.getMessage((Class)(class$org$netbeans$core$ModuleFSSection == null ? (class$org$netbeans$core$ModuleFSSection = 2.class$("org.netbeans.core.ModuleFSSection")) : class$org$netbeans$core$ModuleFSSection), (String)"CTL_Customizer_dialog_title"));
                dd.setOptions(new Object[]{NotifyDescriptor.CLOSED_OPTION});
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
                dialog.pack();
                dialog.show();
                return Boolean.TRUE;
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
    }

    public void showProperties(Node n) {
        Sheet s = new Sheet();
        s.setNodes(new Node[]{n});
        this.openProperties(s);
    }

    public void showProperties(Node[] nodes) {
        Sheet s = new Sheet();
        s.setNodes(nodes);
        this.openProperties(s);
    }

    public Node[] select(String title, String rootTitle, Node root, NodeAcceptor acceptor, Component top) throws UserCancelException {
        final FileSelector selector = new FileSelector(title, rootTitle, root, acceptor, top);
        Mutex.EVENT.readAccess(new Mutex.Action(){

            public Object run() {
                selector.show();
                return null;
            }
        });
        if (selector.cancelFlag) {
            throw new UserCancelException();
        }
        return selector.getNodes();
    }

    private void openProperties(final TopComponent tc) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                if (NbPresenter.currentModalDialog == null) {
                    WindowManagerImpl wm = (WindowManagerImpl)WindowManager.getDefault();
                    WorkspaceImpl curWorkspace = (WorkspaceImpl)wm.getCurrentWorkspace();
                    String tcName = tc.getName();
                    String modeName = WindowManagerImpl.findUnusedModeName(tcName, curWorkspace);
                    curWorkspace.createMode(modeName, tcName, null, true).dockInto(tc);
                    tc.open();
                    tc.requestFocus();
                } else {
                    DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)tc, tc.getName(), true, new Object[]{NotifyDescriptor.CLOSED_OPTION}, NotifyDescriptor.CLOSED_OPTION, 0, null, null)).show();
                }
            }
        });
    }

    public static class Sheet
    extends TopComponent {
        static final long serialVersionUID = 7807519514644165460L;
        private static Sheet sharedSheet;
        private final transient Listener listener;
        private final transient SheetNodesListener snListener;
        boolean global;
        private PropertySheet propertySheet;
        private Node[] nodes = new Node[0];
        private SettingsListener settingsListener;
        private static MessageFormat globalPropertiesFormat;
        private static MessageFormat localPropertiesFormat;
        static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertySheetSettings;
        static /* synthetic */ Class class$org$netbeans$core$NbNodeOperation;
        static /* synthetic */ Class class$org$netbeans$core$NbNodeOperation$Sheet;
        static /* synthetic */ Class class$org$netbeans$core$windows$WindowManagerImpl;

        public Sheet() {
            this(false);
        }

        public Sheet(boolean global) {
            this.global = global;
            this.propertySheet = new PropertySheet();
            ((JComponent)((Object)this)).putClientProperty("NamingType", "SDIOnlyCompName");
            ((JComponent)((Object)this)).putClientProperty("TabPolicy", "HideWhenAlone");
            ((Container)((Object)this)).setLayout(new BorderLayout());
            ((Container)((Object)this)).add((Component)this.propertySheet, "Center");
            this.setIcon(Utilities.loadImage((String)"org/netbeans/core/resources/frames/properties.gif"));
            this.listener = new Listener();
            this.snListener = new SheetNodesListener();
            this.settingsListener = new SettingsListener();
            PropertySheetSettings pss = (PropertySheetSettings)SharedClassObject.findObject((Class)(class$org$openide$explorer$propertysheet$PropertySheetSettings == null ? (class$org$openide$explorer$propertysheet$PropertySheetSettings = Sheet.class$("org.openide.explorer.propertysheet.PropertySheetSettings")) : class$org$openide$explorer$propertysheet$PropertySheetSettings));
            pss.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.settingsListener, (Object)pss));
            this.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)(class$org$netbeans$core$NbNodeOperation == null ? (class$org$netbeans$core$NbNodeOperation = Sheet.class$("org.netbeans.core.NbNodeOperation")) : class$org$netbeans$core$NbNodeOperation)).getString("ACSN_PropertiesSheet"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)(class$org$netbeans$core$NbNodeOperation == null ? (class$org$netbeans$core$NbNodeOperation = Sheet.class$("org.netbeans.core.NbNodeOperation")) : class$org$netbeans$core$NbNodeOperation)).getString("ACSD_PropertiesSheet"));
            this.updateGlobalListening();
        }

        public static Sheet getDefault() {
            if (sharedSheet == null) {
                sharedSheet = new Sheet(true);
            }
            return sharedSheet;
        }

        public HelpCtx getHelpCtx() {
            return ExplorerPanel.getHelpCtx((Node[])this.nodes, (HelpCtx)new HelpCtx(class$org$netbeans$core$NbNodeOperation$Sheet == null ? (class$org$netbeans$core$NbNodeOperation$Sheet = Sheet.class$("org.netbeans.core.NbNodeOperation$Sheet")) : class$org$netbeans$core$NbNodeOperation$Sheet));
        }

        public void requestFocus() {
            super.requestFocus();
            this.propertySheet.requestFocus();
        }

        public void open(Workspace workspace) {
            Workspace realWorkspace;
            Mode tcMode;
            if (this.global && (tcMode = (realWorkspace = workspace == null ? WindowManager.getDefault().getCurrentWorkspace() : workspace).findMode((TopComponent)this)) == null) {
                Mode mode = realWorkspace.findMode("properties");
                if (mode == null) {
                    mode = realWorkspace.createMode("properties", NbBundle.getBundle((Class)(class$org$netbeans$core$windows$WindowManagerImpl == null ? (class$org$netbeans$core$windows$WindowManagerImpl = Sheet.class$("org.netbeans.core.windows.WindowManagerImpl")) : class$org$netbeans$core$windows$WindowManagerImpl)).getString("CTL_PropertiesWindow"), null);
                }
                mode.dockInto((TopComponent)this);
            }
            super.open(workspace);
            if (this.global) {
                SwingUtilities.invokeLater(this.listener);
            }
        }

        protected void updateTitle() {
            Mode ourMode = WindowManager.getDefault().getCurrentWorkspace().findMode((TopComponent)this);
            String nodeTitle = null;
            ArrayList<Node> copyNodes = new ArrayList<Node>(Arrays.asList(this.nodes));
            FeatureDescriptor node = null;
            if (!copyNodes.isEmpty()) {
                node = (Node)copyNodes.get(0);
            }
            if (node == null) {
                nodeTitle = "";
            } else {
                nodeTitle = node.getDisplayName();
                Object alternativeDisplayName = node.getValue(NbNodeOperation.PROP_LONGER_DISPLAY_NAME);
                if (alternativeDisplayName instanceof String) {
                    nodeTitle = (String)alternativeDisplayName;
                }
            }
            Object[] titleParams = new Object[]{new Integer(copyNodes.size()), nodeTitle};
            if (ourMode != null && "properties".equals(ourMode.getName())) {
                if (globalPropertiesFormat == null) {
                    globalPropertiesFormat = new MessageFormat(NbBundle.getMessage((Class)(class$org$netbeans$core$NbNodeOperation == null ? (class$org$netbeans$core$NbNodeOperation = Sheet.class$("org.netbeans.core.NbNodeOperation")) : class$org$netbeans$core$NbNodeOperation), (String)"CTL_FMT_GlobalProperties"));
                }
                this.setName(globalPropertiesFormat.format(titleParams));
            } else {
                if (localPropertiesFormat == null) {
                    localPropertiesFormat = new MessageFormat(NbBundle.getMessage((Class)(class$org$netbeans$core$NbNodeOperation == null ? (class$org$netbeans$core$NbNodeOperation = Sheet.class$("org.netbeans.core.NbNodeOperation")) : class$org$netbeans$core$NbNodeOperation), (String)"CTL_FMT_LocalProperties"));
                }
                this.setName(localPropertiesFormat.format(titleParams));
            }
        }

        public void setNodes(Node[] nodes) {
            this.setNodesWithoutReattaching(nodes);
            this.snListener.detach();
            this.snListener.attach(nodes);
        }

        private void setNodesWithoutReattaching(Node[] nodes) {
            this.nodes = nodes;
            this.propertySheet.setNodes(nodes);
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ Sheet this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.this$0.updateTitle();
                }
            });
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            if (this.global) {
                out.writeObject(null);
            } else {
                Node.Handle[] arr = NodeOp.toHandles((Node[])this.nodes);
                out.writeObject(arr);
            }
            out.writeBoolean(this.global);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            try {
                super.readExternal(in);
            }
            catch (SafeException se) {
                // empty catch block
            }
            Object obj = in.readObject();
            if (obj instanceof NbMarshalledObject || obj instanceof ExplorerManager) {
                this.global = (Boolean)in.readObject();
            } else {
                Node[] nodes;
                if (obj == null) {
                    nodes = TopComponent.getRegistry().getActivatedNodes();
                } else {
                    Node.Handle[] arr = (Node.Handle[])obj;
                    try {
                        nodes = NodeOp.fromHandles((Node.Handle[])arr);
                    }
                    catch (IOException ex) {
                        ErrorManager errMgr = ErrorManager.getDefault();
                        errMgr.annotate((Throwable)ex, NbBundle.getBundle((Class)(class$org$netbeans$core$NbNodeOperation == null ? (class$org$netbeans$core$NbNodeOperation = Sheet.class$("org.netbeans.core.NbNodeOperation")) : class$org$netbeans$core$NbNodeOperation)).getString("EXC_CannotLoadNodes"));
                        errMgr.notify(1, (Throwable)ex);
                        nodes = new Node[]{};
                    }
                }
                this.global = in.readBoolean();
                this.setNodes(nodes);
            }
        }

        public Object readResolve() throws ObjectStreamException {
            if (this.global) {
                return Sheet.getDefault();
            }
            if (this.nodes == null || this.nodes.length <= 0) {
                return null;
            }
            return this;
        }

        protected Object writeReplace() throws ObjectStreamException {
            if (this.global) {
                return new Replacer();
            }
            return super.writeReplace();
        }

        private void updateGlobalListening() {
            if (this.global) {
                TopComponent.getRegistry().addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.listener, (Object)TopComponent.getRegistry()));
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static {
            globalPropertiesFormat = null;
            localPropertiesFormat = null;
        }

        private class SheetNodesListener
        extends NodeAdapter
        implements Runnable {
            private HashMap listenerMap;
            private HashMap pListenerMap;

            SheetNodesListener() {
            }

            public void nodeDestroyed(NodeEvent ev) {
                Node destroyedNode = ev.getNode();
                NodeListener listener = (NodeListener)this.listenerMap.get(destroyedNode);
                PropertyChangeListener pListener = (PropertyChangeListener)this.pListenerMap.get(destroyedNode);
                destroyedNode.removeNodeListener(listener);
                destroyedNode.removePropertyChangeListener(pListener);
                this.listenerMap.remove(destroyedNode);
                this.pListenerMap.remove(destroyedNode);
                if (this.listenerMap.isEmpty() && !Sheet.this.global) {
                    Sheet.this.setCloseOperation(0);
                    Sheet.this.close();
                } else {
                    Sheet.this.setNodesWithoutReattaching(this.listenerMap.keySet().toArray(new Node[this.listenerMap.size()]));
                }
            }

            public void attach(Node[] nodes) {
                this.listenerMap = new HashMap(nodes.length * 2);
                this.pListenerMap = new HashMap(nodes.length * 2);
                NodeListener curListener = null;
                PropertyChangeListener pListener = null;
                int i = 0;
                while (i < nodes.length) {
                    curListener = WeakListener.node((NodeListener)this, (Object)nodes[i]);
                    pListener = WeakListener.propertyChange((PropertyChangeListener)((Object)this), (Object)nodes[i]);
                    this.listenerMap.put(nodes[i], curListener);
                    this.pListenerMap.put(nodes[i], pListener);
                    nodes[i].addNodeListener(curListener);
                    nodes[i].addPropertyChangeListener(pListener);
                    ++i;
                }
            }

            public void detach() {
                if (this.listenerMap == null) {
                    return;
                }
                Iterator iter = this.listenerMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry curEntry = iter.next();
                    ((Node)curEntry.getKey()).removeNodeListener((NodeListener)curEntry.getValue());
                }
                Iterator iter2 = this.pListenerMap.entrySet().iterator();
                while (iter2.hasNext()) {
                    Map.Entry curEntry = iter2.next();
                    ((Node)curEntry.getKey()).removePropertyChangeListener((PropertyChangeListener)curEntry.getValue());
                }
                this.listenerMap = null;
                this.pListenerMap = null;
            }

            public void propertyChange(PropertyChangeEvent pce) {
                if ("displayName".equals(pce.getPropertyName())) {
                    SwingUtilities.invokeLater(this);
                }
            }

            public void run() {
                Sheet.this.updateTitle();
            }
        }

        final class SettingsListener
        implements PropertyChangeListener {
            SettingsListener() {
            }

            public void propertyChange(PropertyChangeEvent e) {
                String name = e.getPropertyName();
                if (name == null) {
                    return;
                }
                if (name.equals("sortingMode")) {
                    try {
                        Sheet.this.propertySheet.setSortingMode(((Integer)e.getNewValue()).intValue());
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else if (name.equals("displayWritableOnly")) {
                    Sheet.this.propertySheet.setDisplayWritableOnly(((Boolean)e.getNewValue()).booleanValue());
                } else if (name.equals("valueColor")) {
                    Sheet.this.propertySheet.setValueColor((Color)e.getNewValue());
                } else if (name.equals("disabledPropertyColor")) {
                    Sheet.this.propertySheet.setDisabledPropertyColor((Color)e.getNewValue());
                } else if (name.equals("plastic")) {
                    Sheet.this.propertySheet.setPlastic(((Boolean)e.getNewValue()).booleanValue());
                } else if (name.equals("propertyPaintingStyle")) {
                    Sheet.this.propertySheet.setPropertyPaintingStyle(((Integer)e.getNewValue()).intValue());
                }
            }
        }

        private class Listener
        implements Runnable,
        PropertyChangeListener {
            Listener() {
            }

            public void propertyChange(PropertyChangeEvent ev) {
                if (ev.getPropertyName().equals("activatedNodes") && NbPresenter.currentModalDialog == null && ((Component)((Object)Sheet.this)).isShowing()) {
                    this.activate();
                }
            }

            public void run() {
                this.activate();
            }

            public void activate() {
                Node[] arr = TopComponent.getRegistry().getActivatedNodes();
                Sheet.this.setNodes(arr);
            }
        }

        private static final class Replacer
        implements Serializable {
            static final long serialVersionUID = -7897067133215740572L;

            Replacer() {
            }

            private Object readResolve() throws ObjectStreamException {
                return Sheet.getDefault();
            }
        }
    }

    private static final class ExplorerProviderFwd
    extends HelpFwdPanel
    implements ExplorerManager.Provider {
        private ExplorerManager.Provider explProvider;

        private ExplorerProviderFwd(Component innerComp, ExplorerManager.Provider explProvider) {
            super(innerComp);
            this.explProvider = explProvider;
        }

        public ExplorerManager getExplorerManager() {
            return this.explProvider.getExplorerManager();
        }
    }

    private static class HelpFwdPanel
    extends JPanel
    implements HelpCtx.Provider {
        private Component innerComp;
        private boolean active = false;

        private HelpFwdPanel(Component innerComp) {
            this.innerComp = innerComp;
        }

        public HelpCtx getHelpCtx() {
            HelpCtx helpCtx;
            try {
                if (this.active) {
                    HelpCtx helpCtx2 = null;
                    Object var4_2 = null;
                    this.active = false;
                    return helpCtx2;
                }
                this.active = true;
                helpCtx = HelpCtx.findHelp((Component)this.innerComp);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.active = false;
                throw throwable;
            }
            Object var4_3 = null;
            this.active = false;
            return helpCtx;
        }
    }
}

