/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.openide.util.NbBundle;

public class TabControl
extends JComponent
implements Serializable,
Accessible {
    static final long serialVersionUID = 7374902493096688301L;
    public static final boolean DIR_UP = true;
    public static final boolean DIR_DOWN = false;
    protected boolean direction = true;
    protected boolean hideOne = false;
    protected int minWidth = 50;
    private static final int DEFAULT_MIN_WIDTH = 50;
    private int selectedIndex;
    private int focusedIndex;
    private int showedIndex;
    protected Vector tabs = new Vector();
    protected static final int indent = 4;
    protected static final int margin = 1;
    protected Vector sizes = new Vector();
    protected int firstVisible;
    protected int lastVisible;
    protected boolean allVisible;
    protected static final int posButtonSize = 10;

    public TabControl() {
        Color defaultBackground = UIManager.getColor("TabbedPane.selected");
        Color defaultForeground = UIManager.getColor("TabbedPane.tabForeground");
        Font defaultFont = UIManager.getFont("TabbedPane.font");
        this.setBackground(defaultBackground);
        this.setForeground(defaultForeground);
        this.setFont(defaultFont);
    }

    private synchronized void clearTabs() {
        this.tabs.removeAllElements();
        this.sizes.removeAllElements();
        this.firstVisible = 0;
        this.lastVisible = 0;
        this.allVisible = true;
        int old = this.selectedIndex;
        this.selectedIndex = -1;
        if (this.selectedIndex != old) {
            this.fireIndexChange(old, this.selectedIndex);
        }
    }

    public synchronized void setSelectedIndex(int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index >= this.tabs.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int old = this.selectedIndex;
        this.selectedIndex = index;
        this.focusedIndex = index;
        this.fireIndexChange(old, this.selectedIndex);
        this.repaint();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public synchronized void setFocusedIndex(int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index >= this.tabs.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int old = this.focusedIndex;
        this.focusedIndex = index;
        this.repaint();
    }

    public int getFocusedIndex() {
        return this.focusedIndex;
    }

    public synchronized void nextFocusedWorkspace() {
        ++this.focusedIndex;
        if (this.focusedIndex > this.tabs.size() - 1) {
            this.focusedIndex = 0;
        }
        this.setSelectedIndex(this.focusedIndex);
    }

    public synchronized void previousFocusedWorkspace() {
        --this.focusedIndex;
        if (this.focusedIndex < 0) {
            this.focusedIndex = this.tabs.size() - 1;
        }
        this.setSelectedIndex(this.focusedIndex);
    }

    public int getTabCount() {
        return this.tabs.size();
    }

    public int pointToIndex(int x) {
        int sum = 0;
        int i = this.firstVisible;
        while (i <= this.lastVisible) {
            if (x < (sum += ((Integer)this.sizes.elementAt(i)).intValue())) {
                return i;
            }
            ++i;
        }
        return this.lastVisible;
    }

    public String getTabLabel(int index) throws ArrayIndexOutOfBoundsException {
        return (String)this.tabs.elementAt(index);
    }

    public synchronized void addTab(String newTab) {
        int index = this.tabs.size();
        this.addTabAt(newTab, index);
    }

    public synchronized void addTabAt(String newTab, int index) throws ArrayIndexOutOfBoundsException {
        int w = this.stringWidth(this.getFontM(), newTab) + 10 + 3;
        if (w < this.minWidth) {
            w = this.minWidth;
        }
        this.tabs.insertElementAt(newTab, index);
        this.sizes.insertElementAt(new Integer(w), index);
        this.setSelectedIndex(0);
        this.setFocusedIndex(0);
        this.checkWidth(true);
        this.repaint();
    }

    public synchronized void replaceTabAt(String newTab, int index) {
        int w = this.stringWidth(this.getFontM(), newTab) + 10 + 3;
        if (w < this.minWidth) {
            w = this.minWidth;
        }
        this.tabs.set(index, newTab);
        this.sizes.set(index, new Integer(w));
        this.checkWidth(true);
        this.repaint();
    }

    public synchronized void removeTabAt(int index) throws ArrayIndexOutOfBoundsException {
        this.tabs.removeElementAt(index);
        this.sizes.removeElementAt(index);
        if (this.tabs.size() == 0) {
            this.clearTabs();
            return;
        }
        if (this.selectedIndex > index) {
            if (this.selectedIndex > 0) {
                --this.selectedIndex;
            }
        } else if (this.selectedIndex == index) {
            if (this.selectedIndex == this.tabs.size()) {
                --this.selectedIndex;
            }
            this.fireIndexChange(index, this.selectedIndex);
        }
        this.focusedIndex = this.selectedIndex;
        if (this.firstVisible > 0) {
            --this.firstVisible;
        }
        if (this.lastVisible > 0) {
            --this.lastVisible;
        }
        this.checkWidth(true);
        this.repaint();
    }

    public void removeAllTabs() {
        this.clearTabs();
        this.repaint();
    }

    public synchronized void makeVisible(int index) {
        if (index < this.firstVisible || index > this.lastVisible) {
            this.firstVisible = index;
            this.lastVisible = index;
            this.checkWidth(true);
            this.repaint();
        }
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void checkWidth(boolean dir) {
        block12: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            d = this.getSize();
                            w = this.countTotalSize();
                            if (w > d.width) break block13;
                            this.allVisible = true;
                            this.firstVisible = 0;
                            this.lastVisible = this.tabs.size() - 1;
                            break block12;
                        }
                        wMax = d.width - 32;
                        if (wMax >= 0) break block14;
                        this.firstVisible = 0;
                        this.lastVisible = 0;
                        this.allVisible = false;
                        break block12;
                    }
                    if (!this.allVisible) break block15;
                    this.allVisible = false;
                    this.showedIndex = this.selectedIndex != this.focusedIndex ? this.focusedIndex : this.selectedIndex;
                    if (this.countTotalSize(0, this.showedIndex) < wMax) {
                        this.firstVisible = 0;
                        this.lastVisible = this.showedIndex;
                        while (this.lastVisible < this.sizes.size()) {
                            if (this.countTotalSize(0, this.lastVisible) > wMax) {
                                --this.lastVisible;
                                break block12;
                            }
                            ++this.lastVisible;
                        }
                    } else {
                        this.lastVisible = this.showedIndex;
                        this.firstVisible = 0;
                        while (this.firstVisible <= this.lastVisible) {
                            if (this.countTotalSize(this.firstVisible, this.lastVisible) >= wMax) {
                                ++this.firstVisible;
                                continue;
                            }
                            break block12;
                        }
                    }
                    break block12;
                }
                if (this.countTotalSize(this.firstVisible, this.lastVisible) >= wMax) break block16;
                this.firstVisible = 0;
                while (this.firstVisible < this.lastVisible) {
                    if (this.countTotalSize(this.firstVisible, this.lastVisible) < wMax) break;
                    ++this.firstVisible;
                }
                while (this.lastVisible < this.sizes.size() - 1) {
                    if (this.countTotalSize(this.firstVisible, this.lastVisible) > wMax) {
                        --this.lastVisible;
                        break block12;
                    }
                    ++this.lastVisible;
                }
                break block12;
            }
            if (!dir) ** GOTO lbl61
            while (this.firstVisible < this.lastVisible) {
                if (this.countTotalSize(this.firstVisible, this.lastVisible) >= wMax) {
                    ++this.firstVisible;
                    continue;
                }
                break block12;
            }
            break block12;
            while (this.countTotalSize(this.firstVisible, this.lastVisible) >= wMax) {
                --this.lastVisible;
lbl61:
                // 2 sources

                if (this.lastVisible > this.firstVisible) continue;
            }
        }
    }

    public void setDirection(boolean direct) {
        if (this.direction != direct) {
            this.direction = direct;
            this.repaint();
        }
    }

    public boolean getDirection() {
        return this.direction;
    }

    public void setHideIfOne(boolean hide) {
        if (this.hideOne != hide) {
            this.hideOne = hide;
            this.repaint();
        }
    }

    public boolean getHideIfOne() {
        return this.hideOne;
    }

    public void setMinWidth(int aMinWidth) {
        this.minWidth = aMinWidth;
        this.countSizes();
        this.checkWidth(true);
        this.repaint();
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public synchronized void setFont(Font f) {
        super.setFont(f);
        this.countSizes();
        this.checkWidth(true);
        this.repaint();
    }

    public void paint(Graphics g) {
        if (!this.hideOne || this.tabs.size() > 1) {
            this.showedIndex = this.selectedIndex != this.focusedIndex ? this.focusedIndex : this.selectedIndex;
            Dimension s = this.getSize();
            if (this.tabs.size() > 0) {
                int i;
                int top;
                int horizTrans = 2;
                int start = 0;
                FontMetrics f = this.getFontM();
                int fontYPos = s.height < f.getHeight() ? s.height : (s.height + f.getHeight()) / 6 * 3 - 1;
                int focusStart = 0;
                int focusWidth = 0;
                if (this.allVisible) {
                    this.firstVisible = 0;
                    this.lastVisible = this.sizes.size() - 1;
                }
                int t = this.firstVisible;
                while (t <= this.lastVisible) {
                    top = 0;
                    int left = start;
                    int height = s.height - 1;
                    int width = (Integer)this.sizes.elementAt(t);
                    int fontYPosDelta = 0;
                    if (this.showedIndex == t) {
                        focusStart = start;
                        focusWidth = width - 1;
                        if (!this.direction) {
                            fontYPosDelta -= horizTrans;
                            top -= horizTrans;
                        } else {
                            ++height;
                        }
                    } else if (this.direction) {
                        top += horizTrans;
                        fontYPosDelta += horizTrans;
                    }
                    if (t == this.showedIndex) {
                        g.setColor(this.getBackground());
                    } else {
                        Color col = UIManager.getColor("TabbedPane.shadow");
                        g.setColor(col != null ? col : this.getBackground());
                    }
                    g.fillRect(left, top, width, height);
                    g.setColor(this.getForeground());
                    String str = new String((String)this.tabs.elementAt(t));
                    int delta = f.stringWidth(str);
                    delta = (width - delta - 10) / 2;
                    g.drawString(str, start + 1 + 4 + delta, fontYPos + fontYPosDelta);
                    start += width;
                    if (t == this.showedIndex || t == this.showedIndex - 1) {
                        g.setColor(Color.black);
                        g.drawLine(left + --width, top, left + width, top + height);
                    }
                    if (t == this.showedIndex) {
                        g.setColor(this.getBackground());
                    } else {
                        Color col = UIManager.getColor("TabbedPane.shadow");
                        g.setColor(col != null ? col : this.getBackground());
                    }
                    --width;
                    if (this.showedIndex == t && !this.direction) {
                        --top;
                        ++height;
                    }
                    int i2 = 0;
                    while (i2 < 1) {
                        g.draw3DRect(left, top, width, height, true);
                        ++left;
                        ++top;
                        width -= 2;
                        height -= 2;
                        ++i2;
                    }
                    ++t;
                }
                if (!this.allVisible) {
                    int height;
                    top = s.height - 4 - 2 - 10;
                    int width = height = 12;
                    int left = s.width - 4 - 4 - 20;
                    int[] xP = new int[3];
                    int[] yP = new int[3];
                    int os = left + 2 + 10;
                    int difr = 1;
                    int q = 0;
                    while (q <= 1) {
                        boolean b = true;
                        switch (q) {
                            case 0: {
                                xP[0] = os - 1 - 10 + difr;
                                xP[1] = os - 1 - difr;
                                xP[2] = xP[1];
                                yP[0] = top + 1 + 5;
                                yP[1] = top + 1 + difr;
                                yP[2] = top + 1 + 10 - difr;
                                if (this.firstVisible != 0) break;
                                b = false;
                                break;
                            }
                            case 1: {
                                int j = 0;
                                while (j <= 2) {
                                    xP[j] = 2 * os - xP[j];
                                    ++j;
                                }
                                if (this.lastVisible != this.tabs.size() - 1) break;
                                b = false;
                            }
                        }
                        if (b) {
                            g.setColor(this.getBackground());
                            int i3 = 0;
                            while (i3 < 1) {
                                g.draw3DRect(left + i3, top + i3, width - 2 * i3, height - 2 * i3, true);
                                ++i3;
                            }
                            g.setColor(this.getForeground());
                            g.fillPolygon(xP, yP, 3);
                        }
                        left += 12;
                        ++q;
                    }
                }
                if (this.direction) {
                    g.setColor(this.getBackground());
                    i = 0;
                    while (i < 1) {
                        g.draw3DRect(0, s.height - i - 1, focusStart + 1, 1, true);
                        g.draw3DRect(focusStart + focusWidth - 1 + i + 1, s.height - i - 1, s.width - focusStart - focusWidth + 1, 1, true);
                        ++i;
                    }
                    g.setColor(this.getBackground());
                    g.fillRect(focusStart + 1, s.height - 1 - 1, 1, 2);
                } else {
                    g.setColor(this.getBackground());
                    i = 0;
                    while (i < 1) {
                        if (this.showedIndex != this.firstVisible) {
                            g.draw3DRect(1 - i - 1, -1, focusStart, 1 + i, true);
                        }
                        g.draw3DRect(focusStart + focusWidth - 1 - 1, -1, s.width - focusStart - focusWidth + 1, 1 + i, true);
                        ++i;
                    }
                    g.setColor(this.getBackground());
                    g.fillRect(focusStart + focusWidth - 1 - 1, 0, 1, 1);
                    g.setColor(Color.black);
                    g.drawLine(focusStart, s.height - horizTrans, focusStart + focusWidth, s.height - horizTrans);
                    g.drawLine(focusStart + focusWidth, 1, s.width, 1);
                    if (this.showedIndex != this.firstVisible) {
                        g.drawLine(0, 1, focusStart - 1, 1);
                    }
                }
            } else {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, s.width, s.height);
                g.setColor(this.getForeground());
                g.drawRect(0, 0, s.width - 1, s.height - 1);
            }
        }
    }

    public Dimension getMinimumSize() {
        int w = this.countMaxSize();
        FontMetrics f = this.getFontM();
        if (this.sizes.size() > 1) {
            w += 32;
            w = Math.min(w, this.countTotalSize());
        }
        int h = 2 + f.getHeight() * 4 / 3;
        if (this.hideOne && this.tabs.size() < 2) {
            return new Dimension(0, h);
        }
        return new Dimension(w, h);
    }

    public Dimension getPreferredSize() {
        Font font;
        int w = this.countTotalSize();
        if (w == 0) {
            w = 2;
        }
        FontMetrics f = ((Component)this).getFontMetrics((font = this.getFont()) == null ? new Font("Helvetica", 0, 12) : font);
        int h = 2 + f.getHeight() * 4 / 3;
        if (this.hideOne && this.tabs.size() < 2) {
            return new Dimension(0, h);
        }
        return new Dimension(w, h);
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        int a = this.firstVisible;
        int b = this.lastVisible;
        this.checkWidth(false);
        if (a != this.firstVisible || b != this.lastVisible) {
            this.repaint();
        }
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        int a = this.firstVisible;
        int b = this.lastVisible;
        this.checkWidth(false);
        if (a != this.firstVisible || b != this.lastVisible) {
            this.repaint();
        }
    }

    private FontMetrics getFontM() {
        Font font = this.getFont();
        return ((Component)this).getFontMetrics(font == null ? new Font("Helvetica", 0, 12) : font);
    }

    private int stringWidth(FontMetrics f, String s) {
        return f.stringWidth(s);
    }

    private void countSizes() {
        int n = this.tabs.size();
        this.sizes.removeAllElements();
        if (n > 0) {
            FontMetrics f = this.getFontM();
            int i = 0;
            while (i < n) {
                int w = this.stringWidth(this.getFontM(), (String)this.tabs.elementAt(i)) + 10 + 1;
                if (w < this.minWidth) {
                    w = this.minWidth;
                }
                this.sizes.addElement(new Integer(w));
                ++i;
            }
        }
    }

    private int countTotalSize(int from, int till) {
        int result = 0;
        int i = from;
        while (i <= till) {
            result += ((Integer)this.sizes.elementAt(i)).intValue();
            ++i;
        }
        return result;
    }

    private int countTotalSize() {
        return this.countTotalSize(0, this.sizes.size() - 1);
    }

    private int countMaxSize() {
        int result = 0;
        int i = 0;
        while (i < this.sizes.size()) {
            result = Math.max(result, (Integer)this.sizes.elementAt(i));
            ++i;
        }
        return result;
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.isConsumed() || e.getID() != 500) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        int sum = 0;
        int old = this.selectedIndex;
        if (old == -1) {
            return;
        }
        int i = this.firstVisible;
        while (i <= this.lastVisible) {
            if (x < (sum += ((Integer)this.sizes.elementAt(i)).intValue())) break;
            ++i;
        }
        if (x < sum && this.selectedIndex != i) {
            this.setSelectedIndex(i);
            this.setFocusedIndex(i);
        } else if (!this.allVisible) {
            Dimension s = this.getSize();
            int tmp = s.height - 4;
            if (y >= tmp - 2 - 10 && y < tmp) {
                tmp = s.width - 4 - 4 - 20;
                if (x >= tmp && x < tmp + 2 + 10 && this.firstVisible > 0) {
                    --this.firstVisible;
                    this.checkWidth(false);
                    this.repaint();
                }
                if (x >= tmp + 2 + 10 && x < tmp + 4 + 20 && this.lastVisible < this.tabs.size() - 1) {
                    ++this.lastVisible;
                    this.checkWidth(true);
                    this.repaint();
                }
            }
        }
    }

    public void addIndexChangeListener(PropertyChangeListener l) {
        this.addPropertyChangeListener("selectedIndex", l);
    }

    public void removeIndexChangeListener(PropertyChangeListener l) {
        this.removePropertyChangeListener("selectedIndex", l);
    }

    protected void fireIndexChange(int oldValue, int newValue) {
        this.firePropertyChange("selectedIndex", oldValue, newValue);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleWorkspaces();
        }
        return this.accessibleContext;
    }

    protected class AccessibleWorkspaces
    extends JComponent.AccessibleJComponent {
        static /* synthetic */ Class class$org$netbeans$core$awt$TabControl;

        protected AccessibleWorkspaces() {
            super(TabControl.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        public String getAccessibleName() {
            String nameWorkspace = TabControl.this.focusedIndex + 1 + "." + (String)TabControl.this.tabs.elementAt(TabControl.this.focusedIndex);
            return nameWorkspace;
        }

        public String getAccessibleDescription() {
            return NbBundle.getMessage((Class)(class$org$netbeans$core$awt$TabControl == null ? (class$org$netbeans$core$awt$TabControl = AccessibleWorkspaces.class$("org.netbeans.core.awt.TabControl")) : class$org$netbeans$core$awt$TabControl), (String)"ACS_Workspace_Description");
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

