/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.core.projects.FixedFileSystem;
import org.openide.ErrorManager;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

abstract class HelpHelper {
    private static final String menudir = "Menu/Help/HelpShortcuts/";
    private static final String actiondir = "Actions/Help/";
    private static final String helpsetdir = "Services/JavaHelp/";

    private HelpHelper() {
    }

    public static void addHelpSet(String helpSetResource, ClassLoader c) {
        block9: {
            if (helpSetResource == null) {
                throw new NullPointerException();
            }
            String fname = HelpHelper.computeHCFilename(helpSetResource);
            FixedFileSystem ffs = FixedFileSystem.getDefault();
            try {
                XMLReader r = XMLUtil.createXMLReader();
                HelpSetHandler handler = new HelpSetHandler();
                r.setContentHandler(handler);
                r.setErrorHandler(handler);
                r.setEntityResolver(handler);
                r.setDTDHandler(handler);
                URL url = HelpHelper.findHelpSet(helpSetResource, c);
                if (url == null) {
                    throw new FileNotFoundException(helpSetResource);
                }
                r.parse(new InputSource(url.toString()));
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
                try {
                    PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
                    pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    pw.println("<!DOCTYPE helpsetref PUBLIC \"-//NetBeans//DTD JavaHelp Help Set Reference 1.0//EN\" \"http://www.netbeans.org/dtds/helpsetref-1_0.dtd\">");
                    pw.print("<helpsetref url=\"");
                    pw.print(XMLUtil.toAttributeValue((String)("nbdocs:/" + helpSetResource)));
                    pw.println("\" merge=\"true\"/>");
                    pw.flush();
                    Object var10_11 = null;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    baos.close();
                    throw throwable;
                }
                baos.close();
                byte[] contents = baos.toByteArray();
                ffs.add(helpsetdir + fname, new FixedFileSystem.Instance(false, "text/xml", contents, handler.title, new URL("nbres:/org/netbeans/modules/javahelp/resources/empty.gif")));
                if (handler.homeID == null) break block9;
                baos = new ByteArrayOutputStream(1000);
                try {
                    PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
                    pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    pw.println("<!DOCTYPE helpctx PUBLIC \"-//NetBeans//DTD Help Context 1.0//EN\" \"http://www.netbeans.org/dtds/helpcontext-1_0.dtd\">");
                    pw.print("<helpctx id=\"");
                    pw.print(XMLUtil.toAttributeValue((String)handler.homeID));
                    pw.println("\" showmaster=\"false\"/>");
                    pw.flush();
                    Object var12_15 = null;
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    baos.close();
                    throw throwable;
                }
                baos.close();
                contents = baos.toByteArray();
                ffs.add(menudir + fname, new FixedFileSystem.Instance(false, "text/xml", contents, handler.title, new URL("nbres:/org/netbeans/modules/javahelp/resources/empty.gif")));
                ffs.add(actiondir + fname, new FixedFileSystem.Instance(false, "text/xml", contents, handler.title, new URL("nbres:/org/netbeans/modules/javahelp/resources/help.gif")));
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
            catch (SAXException saxe) {
                ErrorManager.getDefault().notify((Throwable)saxe);
            }
        }
    }

    private static String computeHCFilename(String helpSetResource) {
        if (helpSetResource.endsWith(".hs")) {
            helpSetResource = helpSetResource.substring(0, helpSetResource.length() - 3);
        }
        return helpSetResource.replace('/', '-') + ".xml";
    }

    public static void removeHelpSet(String helpSetResource) {
        if (helpSetResource == null) {
            throw new NullPointerException();
        }
        String fname = HelpHelper.computeHCFilename(helpSetResource);
        FixedFileSystem ffs = FixedFileSystem.getDefault();
        ffs.remove(helpsetdir + fname);
        ffs.remove(menudir + fname);
        ffs.remove(actiondir + fname);
    }

    public static boolean validateHelpSet(String res, ClassLoader loader) {
        return HelpHelper.findHelpSet(res, loader) != null;
    }

    private static URL findHelpSet(String res, ClassLoader loader) {
        URL main = loader.getResource(res);
        if (main != null) {
            return main;
        }
        File f = InstalledFileLocator.getDefault().locate("docs/" + res, null, true);
        if (f != null) {
            try {
                return Utilities.toURL((File)f);
            }
            catch (MalformedURLException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return null;
    }

    static final class HelpSetHandler
    extends DefaultHandler {
        private String title = null;
        private String homeID = null;
        private boolean inTitle = false;
        private boolean inHomeID = false;
        private StringBuffer pcdata = new StringBuffer();

        HelpSetHandler() {
        }

        public void startElement(String ns, String name, String qname, Attributes attributes) throws SAXException {
            if (qname.equals("title")) {
                this.inTitle = true;
            } else if (qname.equals("homeID")) {
                this.inHomeID = true;
            }
        }

        public void endElement(String ns, String name, String qname) throws SAXException {
            if (this.inTitle) {
                this.title = this.pcdata.toString();
            } else if (this.inHomeID) {
                this.homeID = this.pcdata.toString();
            }
            this.pcdata.setLength(0);
            this.inTitle = false;
            this.inHomeID = false;
        }

        public void characters(char[] text, int start, int len) throws SAXException {
            if (this.inTitle || this.inHomeID) {
                this.pcdata.append(text, start, len);
            }
        }

        public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
            if ("-//Sun Microsystems Inc.//DTD JavaHelp HelpSet Version 1.0//EN".equals(publicID)) {
                return new InputSource("nbres:/org/netbeans/modules/javahelp/resources/helpset_1_0.dtd");
            }
            return null;
        }

        public void error(SAXParseException saxpe) throws SAXException {
            throw saxpe;
        }
    }
}

