/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.core.LoaderPoolNode;
import org.netbeans.core.modules.DuplicateException;
import org.netbeans.core.modules.Events;
import org.netbeans.core.modules.InvalidException;
import org.netbeans.core.modules.Module;
import org.netbeans.core.modules.ModuleHistory;
import org.netbeans.core.modules.ModuleManager;
import org.netbeans.core.modules.Util;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInstall;
import org.openide.modules.SpecificationVersion;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.WeakSet;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

final class ModuleList {
    public static final String PUBLIC_ID = "-//NetBeans//DTD Module Status 1.0//EN";
    public static final String SYSTEM_ID = "http://www.netbeans.org/dtds/module-status-1_0.dtd";
    private static final boolean VALIDATE_XML = true;
    private final ModuleManager mgr;
    private final FileObject folder;
    private final List autoscanFolders;
    private final Events ev;
    private final Map stati = new HashMap(100);
    private boolean triggered = false;
    private final Listener listener = new Listener();
    private final Map compatibilitySers = new HashMap(100);
    private final Set myAtomicActions = Collections.synchronizedSet(new WeakSet(100));
    private static final String[] NEWLY_AUTOLOADED = new String[]{"org.netbeans.modules.vcscore", "org.netbeans.modules.debugger.core", "org.openidex.util", "org.netbeans.modules.j2eeserver"};
    private static final String[] NEWLY_EAGER = new String[]{"org.netbeans.modules.apisupport.ant", "org.netbeans.modules.i18n.form", "org.netbeans.modules.web.core.syntax", "org.netbeans.modules.properties.syntax"};
    private static final String[][] RENAMED_JARS = new String[][]{{"projectx.jar", "projects.jar"}, {"txt.jar", "text.jar"}};
    private static final byte[] SERNULL = new byte[]{-84, -19, 0, 5, 112};
    private static final byte[] MODULE_XML_INTRO = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Module Status 1.0//EN\"\n                        \"http://www.netbeans.org/dtds/module-status-1_0.dtd\">\n<module name=\"".getBytes();
    private static final byte[] MODULE_XML_INTRO_END = ">\n".getBytes();
    private static final byte[] MODULE_XML_DIV2 = "   <param name=\"".getBytes();
    private static final byte[] MODULE_XML_DIV3 = "/param>\n".getBytes();
    private static final byte[] MODULE_XML_END = "/module>\n".getBytes();
    private static RequestProcessor rpListener = null;
    static /* synthetic */ Class class$org$openide$modules$ModuleInstall;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$io$ObjectOutput;

    public ModuleList(ModuleManager mgr, FileObject folder, List autoscanFolders, Events ev) {
        this.mgr = mgr;
        this.folder = folder;
        this.autoscanFolders = autoscanFolders;
        this.ev = ev;
        Util.err.log("ModuleList created, storage in " + folder + ", scanning " + autoscanFolders);
    }

    public Set scan() {
        this.ev.log("startScan");
        HashSet scanned = new HashSet(100);
        Set knownModules = this.mgr.getModules();
        HashSet<File> knownJars = new HashSet<File>(knownModules.size() * 4 / 3 + 1);
        Iterator it = knownModules.iterator();
        while (it.hasNext()) {
            Module m = (Module)((Object)it.next());
            if (m.isFixed()) continue;
            knownJars.add(m.getJarFile());
        }
        it = this.autoscanFolders.iterator();
        while (it.hasNext()) {
            this.scanDir((AutoscanFolder)it.next(), scanned, knownJars);
        }
        this.ev.log("finishScan", scanned);
        return scanned;
    }

    private void scanDir(AutoscanFolder dir, Set scanned, Set knownJars) {
        Util.err.log("ModuleList: scanning for new modules in " + dir.folder);
        File[] jars = dir.folder.listFiles(Util.jarFilter());
        if (jars == null) {
            throw new IllegalStateException("Could not read module directory: " + dir.folder);
        }
        int i = 0;
        while (i < jars.length) {
            File jar = jars[i];
            if (!knownJars.contains(jar)) {
                try {
                    scanned.add(this.mgr.create(jar, new ModuleHistory(dir.origin, jar.getName()), false, dir.autoload, dir.eager));
                }
                catch (IOException ioe) {
                    Util.err.annotate((Throwable)ioe, 0, "Module file: " + jar, null, null, null);
                    Util.err.notify((Throwable)ioe);
                }
                catch (DuplicateException de) {
                    int nueRel;
                    Module old = de.getOldModule();
                    Module nue = de.getNewModule();
                    Util.err.log("Duplicate encountered; original: " + old.getJarFile() + "; trying: " + jar);
                    if (old.isFixed()) {
                        Util.err.log("Module " + (Object)((Object)old) + " was fixed, cannot overinstall");
                    }
                    if (old.isEnabled()) {
                        Util.err.log("Module " + (Object)((Object)old) + " already enabled, cannot overinstall");
                    }
                    int oldRel = old.getCodeNameRelease();
                    if (oldRel < (nueRel = nue.getCodeNameRelease())) {
                        Util.err.log("Will not release-upgrade " + (Object)((Object)old) + " automatically");
                    }
                    if (oldRel > nueRel) {
                        Util.err.log("Will not release-downgrade " + (Object)((Object)old));
                    }
                    SpecificationVersion oldSpec = old.getSpecificationVersion();
                    SpecificationVersion nueSpec = nue.getSpecificationVersion();
                    if (nueSpec == null || oldSpec != null && oldSpec.compareTo((Object)nueSpec) >= 0) {
                        Util.err.log("Will not downgrade/fail to upgrade " + (Object)((Object)old));
                    }
                    if (old.getHistory() instanceof ModuleHistory && !((ModuleHistory)old.getHistory()).isAutoscan()) {
                        Util.err.log("Will not try to override ad-hoc installation");
                    }
                    Util.err.log("Will try to upgrade " + (Object)((Object)old));
                    this.mgr.delete(old);
                    ModuleHistory history = new ModuleHistory(dir.origin, jar.getName());
                    if (old.getHistory() instanceof ModuleHistory) {
                        history.setInstallerState(((ModuleHistory)old.getHistory()).getInstallerState());
                    }
                    history.upgrade(oldRel, oldSpec);
                    try {
                        scanned.add(this.mgr.create(jar, history, false, dir.autoload, dir.eager));
                    }
                    catch (IOException ioe) {
                        Util.err.annotate((Throwable)ioe, 0, "Module file for aborted upgrade: " + jar, null, null, null);
                        Util.err.notify((Throwable)ioe);
                    }
                    catch (DuplicateException de2) {
                        IllegalStateException ise = new IllegalStateException(de2.toString());
                        Util.err.annotate((Throwable)ise, (Throwable)de2);
                        throw ise;
                    }
                }
            }
            ++i;
        }
    }

    public Set readInitial() {
        this.ev.log("startRead");
        final HashSet read = new HashSet();
        try {
            this.folder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileObject[] children = ModuleList.this.folder.getChildren();
                    ModuleList.this.ev.log("perfTick", "list of files found");
                    XMLReader reader = null;
                    int i = 0;
                    while (i < children.length) {
                        block31: {
                            if (!children[i].hasExt("ser")) {
                                if (children[i].hasExt("xml")) {
                                    try {
                                        File jar;
                                        Object var14_18;
                                        Map props;
                                        String nameDashes = children[i].getName();
                                        char[] badChars = new char[]{'.', '/', '>', '='};
                                        int j = 0;
                                        while (j < 4) {
                                            if (nameDashes.indexOf(badChars[j]) != -1) {
                                                throw new IllegalArgumentException("Bad name: " + nameDashes);
                                            }
                                            ++j;
                                        }
                                        String name = nameDashes.replace('-', '.').intern();
                                        Dependency.create((int)1, (String)name);
                                        InputStream is = children[i].getInputStream();
                                        try {
                                            props = ModuleList.this.readStatus(new BufferedInputStream(is));
                                            if (props == null) {
                                                Util.err.log(16, "Note - failed to parse " + children[i] + " the quick way, falling back on XMLReader");
                                                is.close();
                                                is = children[i].getInputStream();
                                                InputSource src = new InputSource(is);
                                                src.setSystemId(children[i].getURL().toExternalForm());
                                                if (reader == null) {
                                                    try {
                                                        reader = XMLUtil.createXMLReader();
                                                    }
                                                    catch (SAXException e) {
                                                        IllegalStateException ise = new IllegalStateException(e.toString());
                                                        Util.err.annotate((Throwable)ise, (Throwable)e);
                                                        throw ise;
                                                    }
                                                    reader.setEntityResolver(ModuleList.this.listener);
                                                    reader.setErrorHandler(ModuleList.this.listener);
                                                }
                                                props = ModuleList.this.readStatus(src, reader);
                                            }
                                            var14_18 = null;
                                        }
                                        catch (Throwable throwable) {
                                            var14_18 = null;
                                            is.close();
                                            throw throwable;
                                        }
                                        is.close();
                                        if (!name.equals(props.get("name"))) {
                                            throw new IOException("Code name mismatch: " + name + " vs. " + props.get("name"));
                                        }
                                        String origin = (String)props.get("origin");
                                        String relativeJar = (String)props.get("jar");
                                        try {
                                            jar = ModuleList.this.findJarByName(origin, relativeJar);
                                        }
                                        catch (NoSuchOriginException nsoe) {
                                            ModuleList.this.ev.log("missingJarOrigin", origin, relativeJar);
                                            try {
                                                children[i].delete();
                                            }
                                            catch (IOException ioe) {
                                                Util.err.notify((Throwable)ioe);
                                            }
                                            break block31;
                                        }
                                        catch (FileNotFoundException fnfe) {
                                            ModuleList.this.ev.log("missingJarFile", new File(fnfe.getMessage()));
                                            try {
                                                children[i].delete();
                                            }
                                            catch (IOException ioe) {
                                                Util.err.notify((Throwable)ioe);
                                            }
                                            break block31;
                                        }
                                        ModuleHistory history = new ModuleHistory(origin, origin.equals("adhoc") ? null : relativeJar);
                                        Integer prevReleaseI = (Integer)props.get("release");
                                        int prevRelease = prevReleaseI == null ? -1 : prevReleaseI;
                                        SpecificationVersion prevSpec = (SpecificationVersion)props.get("specversion");
                                        history.upgrade(prevRelease, prevSpec);
                                        Boolean reloadableB = (Boolean)props.get("reloadable");
                                        boolean reloadable = reloadableB != null ? reloadableB : false;
                                        Boolean enabledB = (Boolean)props.get("enabled");
                                        boolean enabled = enabledB != null ? enabledB : false;
                                        Boolean autoloadB = (Boolean)props.get("autoload");
                                        boolean autoload = autoloadB != null ? autoloadB : false;
                                        Boolean eagerB = (Boolean)props.get("eager");
                                        if (eagerB == null) {
                                            int j2 = 0;
                                            while (j2 < NEWLY_EAGER.length) {
                                                if (name.equals(NEWLY_EAGER[j2])) {
                                                    eagerB = Boolean.TRUE;
                                                    enabled = false;
                                                    break;
                                                }
                                                ++j2;
                                            }
                                        }
                                        boolean eager = eagerB != null ? eagerB : false;
                                        String installer = (String)props.get("installer");
                                        if (installer != null) {
                                            Object var30_36;
                                            if (!installer.equals(nameDashes + ".ser")) {
                                                throw new IOException("Incorrect installer ser name: " + installer);
                                            }
                                            FileObject installerSer = ModuleList.this.folder.getFileObject(nameDashes, "ser");
                                            if (installerSer == null) {
                                                throw new IOException("No such install ser: " + installer + "; I see only: " + Arrays.asList(children));
                                            }
                                            byte[] buf = new byte[(int)installerSer.getSize()];
                                            InputStream is2 = installerSer.getInputStream();
                                            try {
                                                is2.read(buf);
                                                var30_36 = null;
                                            }
                                            catch (Throwable throwable) {
                                                var30_36 = null;
                                                is2.close();
                                                throw throwable;
                                            }
                                            is2.close();
                                            history.setInstallerState(buf);
                                            props.put("installerState", buf);
                                        }
                                        Module m = ModuleList.this.mgr.create(jar, history, reloadable, autoload, eager);
                                        read.add(m);
                                        DiskStatus status = new DiskStatus();
                                        status.module = m;
                                        status.file = children[i];
                                        status.pendingInstall = enabled;
                                        status.diskProps = props;
                                        ModuleList.this.stati.put(name, status);
                                    }
                                    catch (Exception e) {
                                        Util.err.annotate((Throwable)e, 4096, "Error encountered while reading " + children[i], null, null, null);
                                        Util.err.notify((Throwable)e);
                                    }
                                } else {
                                    Util.err.log("Strange file encountered in modules folder: " + children[i]);
                                }
                            }
                            ModuleList.this.ev.log("modulesFileProcessed", children[i]);
                        }
                        ++i;
                    }
                    if (Util.err.isLoggable(0)) {
                        Util.err.log("read initial XML files: stati=" + ModuleList.this.stati);
                    }
                    ModuleList.this.ev.log("finishRead", read);
                    ModuleList.this.folder.addFileChangeListener(WeakListener.fileChange((FileChangeListener)ModuleList.this.listener, (Object)ModuleList.this.folder));
                }
            });
        }
        catch (IOException ioe) {
            Util.err.notify((Throwable)ioe);
        }
        return read;
    }

    private File findJarByName(String origin, String relativeJar) throws IOException {
        if (origin.equals("adhoc")) {
            File jar = new File(relativeJar);
            if (!jar.isAbsolute()) {
                throw new IOException("With adhoc base, jar must be absolute");
            }
            if (!jar.isFile()) {
                throw new FileNotFoundException(jar.getAbsolutePath());
            }
            return jar;
        }
        Iterator it = this.autoscanFolders.iterator();
        String missingJarPath = null;
        while (it.hasNext()) {
            AutoscanFolder dir = (AutoscanFolder)it.next();
            if (!origin.equals(dir.origin)) continue;
            File f = new File(dir.folder, relativeJar);
            if (f.isFile()) {
                return f;
            }
            if (missingJarPath != null) continue;
            missingJarPath = f.getAbsolutePath();
        }
        if (missingJarPath != null) {
            throw new FileNotFoundException(missingJarPath);
        }
        throw new NoSuchOriginException(origin);
    }

    public void trigger(Set scanned) {
        this.ev.log("perfStart", "ModuleList.trigger");
        if (this.triggered) {
            throw new IllegalStateException("Duplicate call to trigger()");
        }
        HashSet<Module> maybeEnable = new HashSet<Module>(scanned);
        Iterator it = this.stati.values().iterator();
        while (it.hasNext()) {
            DiskStatus status = (DiskStatus)it.next();
            if (!status.pendingInstall) continue;
            status.pendingInstall = false;
            Module m = status.module;
            if (m.isEnabled() || m.isFixed() || m.isAutoload() || m.isEager()) {
                throw new IllegalStateException();
            }
            maybeEnable.add(m);
        }
        this.ev.log("perfTick", "modules to enable prepared");
        if (!maybeEnable.isEmpty()) {
            this.ev.log("startAutoRestore", maybeEnable);
            this.installNew(maybeEnable);
            this.ev.log("finishAutoRestore", maybeEnable);
        }
        Util.err.log("ModuleList.trigger: enabled new modules, flushing changes...");
        this.triggered = true;
        this.flushInitial();
        this.ev.log("perfEnd", "ModuleList.trigger");
    }

    void installNew(Set modules) {
        if (modules.isEmpty()) {
            return;
        }
        this.ev.log("perfStart", "ModuleList.installNew");
        Iterator it = modules.iterator();
        while (it.hasNext()) {
            Module m = (Module)((Object)it.next());
            if (m.isAutoload() || m.isEager()) {
                it.remove();
                continue;
            }
            if (m.isEnabled()) {
                Util.err.log("#17295 fix active for " + m.getCodeNameBase());
                it.remove();
                continue;
            }
            if (m.isValid()) continue;
            Util.err.log("#17471 fix active for " + m.getCodeNameBase());
            it.remove();
        }
        List toEnable = this.mgr.simulateEnable(modules);
        it = toEnable.iterator();
        while (it.hasNext()) {
            Module m = (Module)((Object)it.next());
            if (m.isAutoload() || m.isEager() || modules.contains((Object)m)) continue;
            modules.add(m);
        }
        HashSet missing = new HashSet(modules);
        missing.removeAll(toEnable);
        if (!missing.isEmpty()) {
            Util.transitiveClosureModuleDependencies(this.mgr, missing);
            it = missing.iterator();
            while (it.hasNext()) {
                Module m = (Module)((Object)it.next());
                if (!m.getProblems().isEmpty()) continue;
                it.remove();
            }
            this.ev.log("failedInstallNew", missing);
            modules.removeAll(missing);
        }
        try {
            this.mgr.enable(modules);
        }
        catch (InvalidException ie) {
            Util.err.notify(1, (Throwable)ie);
            Module bad = ie.getModule();
            if (bad == null) {
                throw new IllegalStateException();
            }
            this.ev.log("failedInstallNewUnexpected", (Object)bad, ie);
            modules.remove((Object)bad);
            this.installNew(modules);
        }
        this.ev.log("perfEnd", "ModuleList.installNew");
    }

    void installPrepare(Module m, ModuleInstall inst) {
        if (!(m.getHistory() instanceof ModuleHistory)) {
            Util.err.log((Object)((Object)m) + " had strange history " + m.getHistory() + ", ignoring...");
            return;
        }
        ModuleHistory hist = (ModuleHistory)m.getHistory();
        byte[] compatSer = (byte[])this.compatibilitySers.get(inst.getClass().getName());
        if (compatSer != null) {
            Util.err.log("Had some old-style state for " + (Object)((Object)m));
            if (ModuleList.isReallyExternalizable(inst.getClass())) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
                    new NbObjectOutputStream((OutputStream)baos).writeObject(inst);
                    baos.close();
                    if (Utilities.compareObjects((Object)compatSer, (Object)baos.toByteArray())) {
                        Util.err.log("Old-style state for " + (Object)((Object)m) + " was gratuitous");
                    } else {
                        Util.err.log("Old-style state for " + (Object)((Object)m) + " was useful, loading it...");
                        hist.setInstallerState(new byte[0]);
                        ByteArrayInputStream is = new ByteArrayInputStream(compatSer);
                        Object o = new NbObjectInputStream((InputStream)is).readObject();
                        if (o != inst) {
                            throw new ClassCastException("Stored " + o + " but expecting " + inst);
                        }
                    }
                }
                catch (Exception e) {
                    Util.err.notify((Throwable)e);
                    hist.setInstallerState(new byte[0]);
                }
                catch (LinkageError le) {
                    Util.err.notify((Throwable)le);
                    hist.setInstallerState(new byte[0]);
                }
            } else {
                Util.err.log((Object)((Object)m) + " did not want to store install state");
            }
        } else if (hist.getInstallerState() != null) {
            Util.err.log("Loading install state for " + (Object)((Object)m));
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(hist.getInstallerState());
                Object o = new NbObjectInputStream((InputStream)is).readObject();
                if (o != inst) {
                    throw new ClassCastException("Stored " + o + " but expecting " + inst);
                }
            }
            catch (Exception e) {
                Util.err.notify((Throwable)e);
            }
            catch (LinkageError le) {
                Util.err.notify((Throwable)le);
            }
        } else if (ModuleList.isReallyExternalizable(inst.getClass())) {
            Util.err.log("Checking pre-install state of " + (Object)((Object)m));
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
                new NbObjectOutputStream((OutputStream)baos).writeObject(inst);
                baos.close();
                hist.setInstallerState(baos.toByteArray());
            }
            catch (Exception e) {
                Util.err.notify((Throwable)e);
                hist.setInstallerState(new byte[0]);
            }
            catch (LinkageError le) {
                Util.err.notify((Throwable)le);
                hist.setInstallerState(new byte[0]);
            }
        } else {
            Util.err.log((Object)((Object)m) + " did not want to store install state");
        }
    }

    private static boolean isReallyExternalizable(Class clazz) {
        Class c = clazz;
        while (c != (class$org$openide$modules$ModuleInstall == null ? ModuleList.class$("org.openide.modules.ModuleInstall") : class$org$openide$modules$ModuleInstall) && c != (class$java$lang$Object == null ? ModuleList.class$("java.lang.Object") : class$java$lang$Object)) {
            try {
                Method m = c.getDeclaredMethod("writeExternal", class$java$io$ObjectOutput == null ? (class$java$io$ObjectOutput = ModuleList.class$("java.io.ObjectOutput")) : class$java$io$ObjectOutput);
                return true;
            }
            catch (NoSuchMethodException nsme) {
                try {
                    Method m = c.getDeclaredMethod("writeReplace", new Class[0]);
                    return true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    c = c.getSuperclass();
                }
            }
        }
        if (c == (class$java$lang$Object == null ? (class$java$lang$Object = ModuleList.class$("java.lang.Object")) : class$java$lang$Object)) {
            throw new IllegalArgumentException("Class " + clazz + " was not a ModuleInstall");
        }
        return false;
    }

    void installPostpare(Module m, ModuleInstall inst) {
        block7: {
            if (!(m.getHistory() instanceof ModuleHistory)) {
                Util.err.log((Object)((Object)m) + " had strange history " + m.getHistory() + ", ignoring...");
                return;
            }
            ModuleHistory hist = (ModuleHistory)m.getHistory();
            if (hist.getInstallerState() != null) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
                    new NbObjectOutputStream((OutputStream)baos).writeObject(inst);
                    baos.close();
                    byte[] old = hist.getInstallerState();
                    byte[] nue = baos.toByteArray();
                    if (Utilities.compareObjects((Object)old, (Object)nue)) {
                        Util.err.log((Object)((Object)m) + " did not change installer state (" + old.length + " bytes), not writing anything");
                        break block7;
                    }
                    Util.err.log((Object)((Object)m) + " changed installer state after loading");
                    hist.setInstallerState(nue);
                }
                catch (Exception e) {
                    Util.err.notify((Throwable)e);
                }
                catch (LinkageError le) {
                    Util.err.notify((Throwable)le);
                }
            } else {
                Util.err.log((Object)((Object)m) + " has no saved state");
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void upgradeCompatibly() {
        Util.err.log("Looking for old installedModules.xml & externalizedModules.ser to upgrade");
        boolean didAnythingGlobally = false;
        try {
            Iterator it = this.autoscanFolders.iterator();
            while (it.hasNext()) {
                Object var38_42;
                boolean willwrite;
                boolean installation;
                AutoscanFolder dir = (AutoscanFolder)it.next();
                if (dir.autoload || dir.eager) continue;
                if (dir.origin.equals("installation")) {
                    installation = true;
                } else if (dir.origin.equals("user")) {
                    installation = false;
                } else {
                    Util.err.log("Skipping over weird autoscan folder: " + dir);
                    continue;
                }
                File instmod = new File(dir.folder, "installedModules.xml");
                if (!instmod.isFile()) continue;
                File sysmod = new File(new File(dir.folder.getParentFile(), "system"), "Modules");
                sysmod.mkdirs();
                boolean bl = willwrite = sysmod.isDirectory() && sysmod.canWrite();
                if (!installation && !willwrite) {
                    throw new IOException("Cannot upgrade user modules dir");
                }
                this.ev.log("converting", instmod);
                Util.err.log("Converting " + instmod + "; willwrite=" + willwrite);
                boolean didAnything = false;
                FileInputStream is = new FileInputStream(instmod);
                try {
                    Document doc = XMLUtil.parse((InputSource)new InputSource(is), (boolean)false, (boolean)false, (ErrorHandler)this.listener, null);
                    Element root = doc.getDocumentElement();
                    if (!root.getNodeName().equals("modules")) {
                        throw new IOException("Bad format: " + instmod);
                    }
                    NodeList nl = root.getElementsByTagName("module");
                    int i = 0;
                    while (i < nl.getLength()) {
                        block49: {
                            Object var36_41;
                            Throwable throwable2;
                            Object var34_39;
                            OutputStream os;
                            FileLock lock;
                            Element moduleel = (Element)nl.item(i);
                            String name = moduleel.getAttribute("codenamebase");
                            if (name == null) {
                                throw new IOException("Bad format: " + instmod);
                            }
                            String nameDashes = name.replace('.', '-');
                            if (installation && this.folder.getFileObject(nameDashes, "xml") != null) {
                                Util.err.log("Module " + name + " from installation is already converted");
                            } else {
                                Object v1;
                                String reloadS;
                                if (!installation && new File(sysmod, nameDashes + ".xml").isFile()) {
                                    throw new IOException("Should not simultaneously have " + instmod + " and " + new File(sysmod, nameDashes + ".xml"));
                                }
                                Util.err.log("Converting module " + name);
                                didAnything = true;
                                didAnythingGlobally = true;
                                Document ndoc = XMLUtil.createDocument((String)"module", null, (String)PUBLIC_ID, (String)SYSTEM_ID);
                                Element nmoduleel = ndoc.getDocumentElement();
                                nmoduleel.setAttribute("name", name);
                                boolean newlyAutoloaded = false;
                                int j = 0;
                                while (j < NEWLY_AUTOLOADED.length) {
                                    if (name.equals(NEWLY_AUTOLOADED[j])) {
                                        Util.err.log(name + " is newly autoloaded");
                                        newlyAutoloaded = true;
                                        break;
                                    }
                                    ++j;
                                }
                                boolean newlyEager = false;
                                int j2 = 0;
                                while (j2 < NEWLY_EAGER.length) {
                                    if (name.equals(NEWLY_EAGER[j2])) {
                                        Util.err.log(name + " is newly eager");
                                        newlyEager = true;
                                        break;
                                    }
                                    ++j2;
                                }
                                Element param = (Element)nmoduleel.appendChild(ndoc.createElement("param"));
                                param.setAttribute("name", "autoload");
                                param.appendChild(ndoc.createTextNode(String.valueOf(newlyAutoloaded)));
                                param = (Element)nmoduleel.appendChild(ndoc.createElement("param"));
                                param.setAttribute("name", "eager");
                                param.appendChild(ndoc.createTextNode(String.valueOf(newlyEager)));
                                if (!newlyAutoloaded && !newlyEager) {
                                    param = (Element)nmoduleel.appendChild(ndoc.createElement("param"));
                                    param.setAttribute("name", "enabled");
                                    param.appendChild(ndoc.createTextNode(moduleel.getAttribute("enabled")));
                                }
                                param = (Element)nmoduleel.appendChild(ndoc.createElement("param"));
                                param.setAttribute("name", "jar");
                                String jarname = moduleel.getAttribute("url");
                                int j3 = 0;
                                while (j3 < RENAMED_JARS.length) {
                                    if (jarname.equals(RENAMED_JARS[j3][0])) {
                                        Util.err.log("Renaming " + RENAMED_JARS[j3][0] + " to " + RENAMED_JARS[j3][1]);
                                        jarname = RENAMED_JARS[j3][1];
                                        break;
                                    }
                                    ++j3;
                                }
                                param.appendChild(ndoc.createTextNode(jarname));
                                param = (Element)nmoduleel.appendChild(ndoc.createElement("param"));
                                param.setAttribute("name", "origin");
                                String origin = moduleel.getAttribute("base");
                                if (origin.equals("central")) {
                                    origin = newlyAutoloaded ? "installation/autoload" : (newlyEager ? "installation/eager" : "installation");
                                } else if (origin.equals("user")) {
                                    if (newlyAutoloaded) {
                                        origin = "user/autoload";
                                    } else if (newlyEager) {
                                        origin = "user/eager";
                                    }
                                } else {
                                    if (!origin.equals("jarfile")) throw new IOException("Unrecognized base: " + origin);
                                    origin = "adhoc";
                                }
                                param.appendChild(ndoc.createTextNode(origin));
                                String relS = moduleel.getAttribute("release");
                                if (relS.length() > 0 && !relS.equals("-1")) {
                                    param = (Element)nmoduleel.appendChild(ndoc.createElement("param"));
                                    param.setAttribute("name", "release");
                                    param.appendChild(ndoc.createTextNode(relS));
                                }
                                if ((reloadS = moduleel.getAttribute("reloadable")).length() == 0) {
                                    reloadS = "false";
                                }
                                param = (Element)nmoduleel.appendChild(ndoc.createElement("param"));
                                param.setAttribute("name", "reloadable");
                                param.appendChild(ndoc.createTextNode(reloadS));
                                String sv = moduleel.getAttribute("specversion");
                                if (!sv.equals("null")) {
                                    param = (Element)nmoduleel.appendChild(ndoc.createElement("param"));
                                    param.setAttribute("name", "specversion");
                                    param.appendChild(ndoc.createTextNode(sv));
                                }
                                lock = null;
                                if (willwrite) {
                                    os = new FileOutputStream(new File(sysmod, nameDashes + ".xml"));
                                } else {
                                    FileObject xml = this.folder.createData(nameDashes, "xml");
                                    lock = xml.lock();
                                    os = xml.getOutputStream(lock);
                                }
                                XMLUtil.write((Document)ndoc, (OutputStream)os, (String)"UTF-8");
                                var34_39 = null;
                                try {
                                    os.close();
                                    v1 = null;
                                }
                                catch (Throwable throwable2) {
                                    v1 = var36_41 = null;
                                }
                                if (lock != null) {
                                    lock.releaseLock();
                                }
                            }
                            break block49;
                            catch (Throwable throwable3) {
                                Object v2;
                                var34_39 = null;
                                try {
                                    os.close();
                                    v2 = null;
                                }
                                catch (Throwable throwable2) {
                                    v2 = var36_41 = null;
                                }
                                if (lock == null) throw throwable3;
                                lock.releaseLock();
                                throw throwable3;
                            }
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    var38_42 = null;
                    ((InputStream)is).close();
                    throw throwable;
                }
                var38_42 = null;
                ((InputStream)is).close();
                if (willwrite && !instmod.delete()) {
                    throw new IOException("Could not delete obsolete file: " + instmod);
                }
                File extmod = new File(dir.folder, "externalizedModules.ser");
                if (!extmod.isFile()) continue;
                if (didAnything) {
                    this.readExternalizedModules(extmod);
                }
                if (!willwrite || extmod.delete()) continue;
                throw new IOException("Could not delete obsolete file: " + extmod);
            }
        }
        catch (Exception e) {
            Util.err.notify((Throwable)e);
        }
        if (didAnythingGlobally) {
            LinkedList<FileObject> parents = new LinkedList<FileObject>();
            FileObject fo = this.folder;
            while (fo != null) {
                parents.addFirst(fo);
                fo = fo.getParent();
            }
            Iterator godown = parents.iterator();
            while (godown.hasNext()) {
                ((FileObject)godown.next()).refresh(true);
            }
            FileObject[] kids = this.folder.getChildren();
            int i = 0;
            while (i < kids.length) {
                Date filesysMod;
                Date actualMod;
                kids[i].refresh(true);
                File actual = FileUtil.toFile((FileObject)kids[i]);
                if (actual != null && !(actualMod = new Date(actual.lastModified())).equals(filesysMod = kids[i].lastModified())) {
                    throw new IllegalStateException("Wrong lastModified for " + actual + ": should be " + actualMod + ", was " + filesysMod);
                }
                ++i;
            }
        }
        Util.err.log("Successfully refreshed contents of folder " + this.folder);
    }

    private void readExternalizedModules(File extmod) throws IOException {
        Util.err.log("Reading " + extmod);
        FileInputStream is = new FileInputStream(extmod);
        try {
            ObjectInputStream oi = new ObjectInputStream(is);
            while (true) {
                int len = oi.readInt();
                byte[] block = new byte[len];
                oi.readFully(block);
                if (Utilities.compareObjects((Object)block, (Object)SERNULL)) {
                    try {
                        this.transferLoaderPool(oi);
                    }
                    catch (IOException e) {
                        Throwable t = Util.err.annotate((Throwable)new IOException("Can't upgrade DataLoaderPool storage."), (Throwable)e);
                        Util.err.notify(t);
                    }
                    break;
                }
                try {
                    int namelen;
                    String name;
                    int hi = block[6];
                    int lo = block[7];
                    if (hi < 0) {
                        hi += 256;
                    }
                    if (lo < 0) {
                        lo += 256;
                    }
                    if (!(name = new String(block, 8, namelen = hi * 256 + lo, "UTF-8")).equals("org.openide.util.SharedClassObject$WriteReplace")) {
                        Util.err.log("Skipping serialized block with replacer " + name);
                        continue;
                    }
                    hi = block[98];
                    lo = block[99];
                    if (hi < 0) {
                        hi += 256;
                    }
                    if (lo < 0) {
                        lo += 256;
                    }
                    if ((name = new String(block, 100, namelen = hi * 256 + lo, "UTF-8")).equals("org.openide.modules.ModuleInstall")) continue;
                    Util.err.log("Read serialized block for " + name);
                    this.compatibilitySers.put(name, block);
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    IOException ioe = new IOException(aioobe.toString());
                    Util.err.annotate((Throwable)ioe, (Throwable)aioobe);
                    throw ioe;
                }
            }
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            ((InputStream)is).close();
            throw throwable;
        }
        ((InputStream)is).close();
    }

    private void transferLoaderPool(ObjectInput oi) throws IOException {
        FileObject pool = LoaderPoolNode.getLoaderPoolStorage(true);
        FileLock lock = pool.lock();
        try {
            ObjectOutputStream os = new ObjectOutputStream(pool.getOutputStream(lock));
            try {
                while (oi.available() > 0) {
                    int len = oi.readInt();
                    byte[] block = new byte[len];
                    oi.readFully(block);
                    os.writeInt(len);
                    os.write(block);
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                os.close();
                throw throwable;
            }
            os.close();
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            lock.releaseLock();
            throw throwable;
        }
        lock.releaseLock();
    }

    private Map readStatus(InputSource is, XMLReader reader) throws IOException, SAXException {
        if (reader == null) {
            reader = XMLUtil.createXMLReader((boolean)true);
            reader.setEntityResolver(this.listener);
            reader.setErrorHandler(this.listener);
        }
        final HashMap m = new HashMap();
        DefaultHandler handler = new DefaultHandler(){
            private String modName;
            private String paramName;
            private StringBuffer data = new StringBuffer();

            public void startElement(String uri, String localname, String qname, Attributes attrs) throws SAXException {
                if ("module".equals(qname)) {
                    this.modName = attrs.getValue("name");
                    if (this.modName == null) {
                        throw new SAXException("No module name");
                    }
                    m.put("name", this.modName.intern());
                } else if (this.modName != null && "param".equals(qname)) {
                    this.paramName = attrs.getValue("name");
                    if (this.paramName == null) {
                        throw new SAXException("No param name");
                    }
                    this.paramName = this.paramName.intern();
                    this.data.setLength(0);
                }
            }

            public void characters(char[] ch, int start, int len) {
                if (this.modName != null && this.paramName != null) {
                    this.data.append(ch, start, len);
                }
            }

            public void endElement(String uri, String localname, String qname) throws SAXException {
                if ("param".equals(qname)) {
                    if (this.modName != null && this.paramName != null) {
                        if (this.data.length() == 0) {
                            throw new SAXException("No text contents in " + this.paramName + " of " + this.modName);
                        }
                        try {
                            m.put(this.paramName, ModuleList.this.processStatusParam(this.paramName, this.data.toString()));
                        }
                        catch (NumberFormatException nfe) {
                            SAXException saxe = new SAXException(nfe.toString());
                            Util.err.annotate((Throwable)saxe, (Throwable)nfe);
                            throw saxe;
                        }
                        this.data.setLength(0);
                        this.paramName = null;
                    }
                } else if ("module".equals(qname)) {
                    this.modName = null;
                }
            }
        };
        reader.setContentHandler(handler);
        reader.parse(is);
        this.sanityCheckStatus(m);
        return m;
    }

    private Object processStatusParam(String k, String v) throws NumberFormatException {
        if (k == "release") {
            return new Integer(v);
        }
        if (k == "enabled" || k == "autoload" || k == "eager" || k == "reloadable") {
            return Boolean.valueOf(v);
        }
        if (k == "specversion") {
            return new SpecificationVersion(v);
        }
        if (v.length() < 100) {
            v = v.intern();
        }
        return v;
    }

    private void sanityCheckStatus(Map m) throws IOException {
        if (m.get("origin") == null) {
            throw new IOException("Must define origin param");
        }
        if (m.get("jar") == null) {
            throw new IOException("Must define jar param");
        }
        if (m.get("autoload") != null && ((Boolean)m.get("autoload")).booleanValue() && m.get("enabled") != null) {
            throw new IOException("Autoloads cannot specify enablement");
        }
        if (m.get("eager") != null && ((Boolean)m.get("eager")).booleanValue() && m.get("enabled") != null) {
            throw new IOException("Eager modules cannot specify enablement");
        }
    }

    private Map readStatus(InputStream is) throws IOException {
        HashMap<String, Object> m = new HashMap<String, Object>(15);
        if (!this.expect(is, MODULE_XML_INTRO)) {
            Util.err.log("Could not read intro");
            return null;
        }
        String name = this.readTo(is, '\"');
        if (name == null) {
            Util.err.log("Could not read code name base");
            return null;
        }
        m.put("name", name.intern());
        if (!this.expect(is, MODULE_XML_INTRO_END)) {
            Util.err.log("Could not read stuff after cnb");
            return null;
        }
        block6: while (true) {
            int c = is.read();
            switch (c) {
                case 32: {
                    if (!this.expect(is, MODULE_XML_DIV2)) {
                        Util.err.log("Could not read up to param");
                        return null;
                    }
                    String k = this.readTo(is, '\"');
                    if (k == null) {
                        Util.err.log("Could not read param");
                        return null;
                    }
                    k = k.intern();
                    if (is.read() != 62) {
                        Util.err.log("No > at end of <param> " + k);
                        return null;
                    }
                    String v = this.readTo(is, '<');
                    if (v == null) {
                        Util.err.log("Could not read value of " + k);
                        return null;
                    }
                    if (!this.expect(is, MODULE_XML_DIV3)) {
                        Util.err.log("Could not read end of param " + k);
                        return null;
                    }
                    try {
                        m.put(k, this.processStatusParam(k, v));
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        Util.err.log("Number misparse: " + nfe);
                        return null;
                    }
                }
                case 60: {
                    if (!this.expect(is, MODULE_XML_END)) {
                        Util.err.log("Strange ending");
                        return null;
                    }
                    if (is.read() == -1) break block6;
                    Util.err.log("Trailing garbage");
                    return null;
                }
                default: {
                    Util.err.log("Strange stuff after <param>s: " + c);
                    return null;
                }
            }
        }
        this.sanityCheckStatus(m);
        return m;
    }

    private boolean expect(InputStream is, byte[] stuff) throws IOException {
        int c;
        int len = stuff.length;
        boolean inNewline = false;
        int i = 0;
        while (i < len) {
            c = is.read();
            if (c == 10 || c == 13) {
                if (inNewline) continue;
                inNewline = true;
                c = 10;
            } else {
                inNewline = false;
            }
            if (c == stuff[i++]) continue;
            return false;
        }
        if (stuff[len - 1] == 10) {
            if (!is.markSupported()) {
                throw new IOException("Mark not supported");
            }
            is.mark(1);
            c = is.read();
            if (c != -1 && c != 10 && c != 13) {
                is.reset();
            }
        }
        return true;
    }

    private String readTo(InputStream is, char delim) throws IOException {
        if (delim == '\n') {
            throw new IOException("Not implemented");
        }
        CharArrayWriter caw = new CharArrayWriter(100);
        boolean inNewline = false;
        int c;
        while ((c = is.read()) != -1) {
            if (c > 126) {
                return null;
            }
            if (c == 10 || c == 13) {
                if (inNewline) continue;
                inNewline = true;
                c = 10;
            } else {
                if (c < 32 && c != 9) {
                    return null;
                }
                inNewline = false;
            }
            if (c == delim) {
                return caw.toString();
            }
            caw.write(c);
        }
        return null;
    }

    private void writeStatus(Map m, OutputStream os) throws IOException {
        String codeName = (String)m.get("name");
        if (codeName == null) {
            throw new IllegalArgumentException("no code name present");
        }
        OutputStreamWriter w = new OutputStreamWriter(os, "UTF-8");
        w.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        w.write("<!DOCTYPE module PUBLIC \"");
        w.write(PUBLIC_ID);
        w.write("\"\n                        \"");
        w.write(SYSTEM_ID);
        w.write("\">\n");
        w.write("<module name=\"");
        w.write(XMLUtil.toAttributeValue((String)codeName));
        w.write("\">\n");
        Iterator it = new TreeMap(m).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            if (name.equals("installerState") || name.equals("name")) continue;
            Object val = entry.getValue();
            w.write("    <param name=\"");
            w.write(XMLUtil.toAttributeValue((String)name));
            w.write("\">");
            w.write(XMLUtil.toElementContent((String)val.toString()));
            w.write("</param>\n");
        }
        w.write("</module>\n");
        ((Writer)w).flush();
    }

    private DiskStatus writeOut(Module m, DiskStatus old) throws IOException {
        DiskStatus nue;
        if (old == null) {
            nue = new DiskStatus();
            nue.module = m;
            nue.diskProps = this.computeProperties(m);
        } else {
            nue = old;
        }
        FileSystem.AtomicAction aa = new FileSystem.AtomicAction(){

            public void run() throws IOException {
                if (nue.file == null) {
                    boolean created = true;
                    nue.file = ModuleList.this.folder.createData(((String)nue.diskProps.get("name")).replace('.', '-'), "xml");
                } else {
                    boolean created = false;
                    if (nue.dirty) {
                        throw new IOException("Will not clobber external changes in " + nue.file);
                    }
                }
                Util.err.log("ModuleList: (re)writing " + nue.file);
                FileLock lock = nue.file.lock();
                try {
                    OutputStream os = nue.file.getOutputStream(lock);
                    try {
                        ModuleList.this.writeStatus(nue.diskProps, os);
                        Object var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        os.close();
                        throw throwable;
                    }
                    os.close();
                    Object var7_9 = null;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    lock.releaseLock();
                    throw throwable;
                }
                lock.releaseLock();
                byte[] data = (byte[])nue.diskProps.get("installerState");
                String installerName = (String)nue.diskProps.get("installer");
                FileObject ser = ModuleList.this.folder.getFileObject(installerName);
                if (data != null) {
                    if (ser == null) {
                        int idx = installerName.lastIndexOf(46);
                        ser = ModuleList.this.folder.createData(installerName.substring(0, idx), installerName.substring(idx + 1));
                    }
                    lock = ser.lock();
                    try {
                        OutputStream os = ser.getOutputStream(lock);
                        try {
                            os.write(data);
                            Object var9_14 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_15 = null;
                            os.close();
                            throw throwable;
                        }
                        os.close();
                        Object var11_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_18 = null;
                        lock.releaseLock();
                        throw throwable;
                    }
                    lock.releaseLock();
                    {
                    }
                }
            }
        };
        this.myAtomicActions.add(aa);
        this.folder.getFileSystem().runAtomicAction(aa);
        return nue;
    }

    private void deleteFromDisk(final Module m, final DiskStatus status) throws IOException {
        final String nameDashes = m.getCodeNameBase().replace('.', '-');
        FileSystem.AtomicAction aa = new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileObject xml = ModuleList.this.folder.getFileObject(nameDashes, "xml");
                if (xml == null) {
                    Util.err.log("ModuleList: " + (Object)((Object)m) + "'s XML already gone from disk");
                    return;
                }
                if (status.dirty) {
                    throw new IOException("Unapproved external change to " + xml);
                }
                Util.err.log("ModuleList: deleting " + xml);
                xml.delete();
                FileObject ser = ModuleList.this.folder.getFileObject(nameDashes, "ser");
                if (ser != null) {
                    Util.err.log("(and also " + ser + ")");
                    ser.delete();
                }
            }
        };
        this.myAtomicActions.add(aa);
        this.folder.getFileSystem().runAtomicAction(aa);
    }

    private void flushInitial() {
        Util.err.log("Flushing initial module list...");
        Iterator it = this.mgr.getModules().iterator();
        while (it.hasNext()) {
            Module m = (Module)((Object)it.next());
            DiskStatus status = (DiskStatus)this.stati.get(m.getCodeNameBase());
            if (status == null) continue;
            this.moduleChanged(m, status);
            m.addPropertyChangeListener(this.listener);
        }
        this.moduleListChanged();
        this.mgr.addPropertyChangeListener(this.listener);
    }

    private void moduleListChanged() {
        Map map = this.stati;
        synchronized (map) {
            if (Util.err.isLoggable(0)) {
                Util.err.log("ModuleList: moduleListChanged; stati=" + this.stati);
            }
            Iterator<Object> it = this.mgr.getModules().iterator();
            while (it.hasNext()) {
                String name;
                Module m = (Module)((Object)it.next());
                if (m.isFixed() || this.stati.get(name = m.getCodeNameBase()) != null) continue;
                Util.err.log("moduleListChanged: added: " + (Object)((Object)m));
                try {
                    this.stati.put(name, this.writeOut(m, null));
                    m.addPropertyChangeListener(this.listener);
                }
                catch (IOException ioe) {
                    Util.err.notify((Throwable)ioe);
                }
            }
            it = this.stati.values().iterator();
            while (it.hasNext()) {
                DiskStatus status = (DiskStatus)it.next();
                if (status.module.isValid()) continue;
                status.module.removePropertyChangeListener(this.listener);
                Module nue = this.mgr.get(status.module.getCodeNameBase());
                if (nue != null) {
                    Util.err.log("moduleListChanged: recreated: " + (Object)((Object)nue));
                    nue.addPropertyChangeListener(this.listener);
                    status.module = nue;
                    this.moduleChanged(nue, status);
                    continue;
                }
                Util.err.log("moduleListChanged: deleted: " + (Object)((Object)status.module));
                it.remove();
                try {
                    this.deleteFromDisk(status.module, status);
                }
                catch (IOException ioe) {
                    Util.err.notify((Throwable)ioe);
                }
            }
        }
    }

    private void moduleChanged(Module m, DiskStatus status) {
        DiskStatus diskStatus = status;
        synchronized (diskStatus) {
            Map newProps;
            if (Util.err.isLoggable(0)) {
                Util.err.log("ModuleList: moduleChanged: " + (Object)((Object)m));
            }
            if (!Utilities.compareObjects((Object)status.diskProps, (Object)(newProps = this.computeProperties(m)))) {
                if (Util.err.isLoggable(0)) {
                    HashSet changes = new HashSet(newProps.entrySet());
                    changes.removeAll(status.diskProps.entrySet());
                    Util.err.log("ModuleList: changes are " + changes);
                }
                status.diskProps = newProps;
                try {
                    this.writeOut(m, status);
                }
                catch (IOException ioe) {
                    Util.err.notify((Throwable)ioe);
                }
            }
        }
    }

    private Map computeProperties(Module m) {
        SpecificationVersion spec;
        if (m.isFixed() || !m.isValid()) {
            throw new IllegalArgumentException("fixed or invalid: " + (Object)((Object)m));
        }
        if (!(m.getHistory() instanceof ModuleHistory)) {
            throw new IllegalArgumentException("weird history: " + (Object)((Object)m));
        }
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("name", m.getCodeNameBase());
        int rel = m.getCodeNameRelease();
        if (rel >= 0) {
            p.put("release", new Integer(rel));
        }
        if ((spec = m.getSpecificationVersion()) != null) {
            p.put("specversion", spec);
        }
        if (!m.isAutoload() && !m.isEager()) {
            p.put("enabled", m.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
        }
        p.put("autoload", m.isAutoload() ? Boolean.TRUE : Boolean.FALSE);
        p.put("eager", m.isEager() ? Boolean.TRUE : Boolean.FALSE);
        p.put("reloadable", m.isReloadable() ? Boolean.TRUE : Boolean.FALSE);
        ModuleHistory hist = (ModuleHistory)m.getHistory();
        p.put("origin", hist.getOrigin());
        if (hist.getOrigin().equals("adhoc")) {
            p.put("jar", m.getJarFile().getAbsolutePath());
        } else {
            p.put("jar", hist.getRelativeJar());
        }
        if (hist.getInstallerStateChanged()) {
            p.put("installer", m.getCodeNameBase().replace('.', '-') + ".ser");
            p.put("installerState", hist.getInstallerState());
        }
        return p;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class DiskStatus {
        public Module module;
        public FileObject file;
        public boolean pendingInstall = false;
        public Map diskProps;
        public boolean dirty = false;

        public String toString() {
            return "DiskStatus[module=" + (Object)((Object)this.module) + ",valid=" + this.module.isValid() + ",file=" + this.file + ",dirty=" + this.dirty + ",pendingInstall=" + this.pendingInstall + ",diskProps=" + this.diskProps + "]";
        }
    }

    private final class Listener
    implements PropertyChangeListener,
    ErrorHandler,
    EntityResolver,
    FileChangeListener,
    Runnable {
        private boolean listening = true;
        private boolean pendingRun = false;
        static /* synthetic */ Class class$org$netbeans$core$modules$ModuleList;

        Listener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!ModuleList.this.triggered) {
                throw new IllegalStateException("Property change before trigger()");
            }
            String prop = evt.getPropertyName();
            Object src = evt.getSource();
            if (!this.listening) {
                if (Util.err.isLoggable(1)) {
                    Util.err.log("ModuleList: ignoring own change " + prop + " from " + src);
                }
                return;
            }
            if ("classLoader".equals(prop) || "enabledModules".equals(prop) || "classLoader".equals(prop) || "problems".equals(prop) || "valid".equals(prop)) {
                return;
            }
            if ("modules".equals(prop)) {
                ModuleList.this.moduleListChanged();
            } else if (src instanceof Module) {
                Module m = (Module)((Object)src);
                if (!m.isValid()) {
                    return;
                }
                DiskStatus status = (DiskStatus)ModuleList.this.stati.get(m.getCodeNameBase());
                if (status == null) {
                    throw new IllegalStateException("Unknown module " + (Object)((Object)m) + "; stati=" + ModuleList.this.stati);
                }
                if (status.pendingInstall && "enabled".equals(prop)) {
                    throw new IllegalStateException("Got PROP_ENABLED on " + (Object)((Object)m) + " before trigger()");
                }
                ModuleList.this.moduleChanged(m, status);
            } else {
                Util.err.log("Unexpected property change: " + evt + " prop=" + prop + " src=" + src);
            }
        }

        public void warning(SAXParseException e) throws SAXException {
            Util.err.notify(16, (Throwable)e);
        }

        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        public InputSource resolveEntity(String pubid, String sysid) throws SAXException, IOException {
            if (pubid.equals(ModuleList.PUBLIC_ID)) {
                return new InputSource((class$org$netbeans$core$modules$ModuleList == null ? (class$org$netbeans$core$modules$ModuleList = Listener.class$("org.netbeans.core.modules.ModuleList")) : class$org$netbeans$core$modules$ModuleList).getResource("module-status-1_0.dtd").toExternalForm());
            }
            return EntityCatalog.getDefault().resolveEntity(pubid, sysid);
        }

        public void fileDeleted(FileEvent ev) {
            if (this.isOurs(ev)) {
                if (Util.err.isLoggable(1)) {
                    Util.err.log("ModuleList: got expected deletion " + ev);
                }
                return;
            }
            FileObject fo = ev.getFile();
            this.fileDeleted0(fo.getName(), fo.getExt());
        }

        public void fileDataCreated(FileEvent ev) {
            if (this.isOurs(ev)) {
                if (Util.err.isLoggable(1)) {
                    Util.err.log("ModuleList: got expected creation " + ev);
                }
                return;
            }
            FileObject fo = ev.getFile();
            this.fileCreated0(fo, fo.getName(), fo.getExt());
        }

        public void fileRenamed(FileRenameEvent ev) {
            if (this.isOurs((FileEvent)ev)) {
                throw new IllegalStateException("I don't rename anything! " + ev);
            }
            FileObject fo = ev.getFile();
            this.fileDeleted0(ev.getName(), ev.getExt());
            this.fileCreated0(fo, fo.getName(), fo.getExt());
        }

        private void fileCreated0(FileObject fo, String name, String ext) {
            if ("xml".equals(ext)) {
                String codenamebase = name.replace('-', '.');
                DiskStatus status = (DiskStatus)ModuleList.this.stati.get(codenamebase);
                Util.err.log("ModuleList: outside file creation event for " + codenamebase);
                if (status != null) {
                    status.dirty = true;
                }
                this.runme();
            } else if ("ser".equals(ext)) {
                // empty if block
            }
        }

        private void fileDeleted0(String name, String ext) {
            if ("xml".equals(ext)) {
                String codenamebase = name.replace('-', '.');
                DiskStatus status = (DiskStatus)ModuleList.this.stati.get(codenamebase);
                Util.err.log("ModuleList: outside file deletion event for " + codenamebase);
                if (status != null) {
                    status.dirty = true;
                }
                this.runme();
            } else if ("ser".equals(ext)) {
                // empty if block
            }
        }

        public void fileChanged(FileEvent ev) {
            if (this.isOurs(ev)) {
                if (Util.err.isLoggable(1)) {
                    Util.err.log("ModuleList: got expected modification " + ev);
                }
                return;
            }
            FileObject fo = ev.getFile();
            String name = fo.getName();
            String ext = fo.getExt();
            if ("xml".equals(ext)) {
                String codenamebase = name.replace('-', '.');
                DiskStatus status = (DiskStatus)ModuleList.this.stati.get(codenamebase);
                Util.err.log("ModuleList: outside file modification event for " + codenamebase + ": " + ev);
                if (status != null) {
                    status.dirty = true;
                }
                this.runme();
            } else if ("ser".equals(ext)) {
                // empty if block
            }
        }

        public void fileFolderCreated(FileEvent ev) {
        }

        public void fileAttributeChanged(FileAttributeEvent ev) {
        }

        private boolean isOurs(FileEvent ev) {
            Iterator it = ModuleList.this.myAtomicActions.iterator();
            while (it.hasNext()) {
                if (!ev.firedFrom((FileSystem.AtomicAction)it.next())) continue;
                return true;
            }
            return false;
        }

        private synchronized void runme() {
            if (!this.pendingRun) {
                this.pendingRun = true;
                if (rpListener == null) {
                    rpListener = new RequestProcessor("org.netbeans.core.modules.ModuleList.Listener");
                }
                rpListener.post((Runnable)this);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Listener listener = this;
            synchronized (listener) {
                this.pendingRun = false;
            }
            Util.err.log("ModuleList: will process outstanding external XML changes");
            ModuleList.this.mgr.mutexPrivileged().enterWriteAccess();
            try {
                try {
                    ModuleList.this.folder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(this){
                        private final /* synthetic */ Listener this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() throws IOException {
                            Map xmlfiles = Listener.access$1600(this.this$1);
                            Map dirtyprops = Listener.access$1700(this.this$1, xmlfiles);
                            Listener.access$1802(this.this$1, false);
                            try {
                                Listener.access$1900(this.this$1, xmlfiles, dirtyprops);
                                Listener.access$2000(this.this$1, xmlfiles, dirtyprops);
                                Listener.access$2100(this.this$1, xmlfiles, dirtyprops);
                                Listener.access$2200(this.this$1, xmlfiles, dirtyprops);
                                Listener.access$2300(this.this$1, xmlfiles, dirtyprops);
                                Listener.access$2400(this.this$1, xmlfiles, dirtyprops);
                                Listener.access$2500(this.this$1, xmlfiles, dirtyprops);
                                Object var4_3 = null;
                            }
                            catch (Throwable throwable) {
                                Object var4_4 = null;
                                Listener.access$1802(this.this$1, true);
                                Listener.access$2600(this.this$1, xmlfiles, dirtyprops);
                                Listener.access$2700(this.this$1, xmlfiles, dirtyprops);
                                throw throwable;
                            }
                            Listener.access$1802(this.this$1, true);
                            Listener.access$2600(this.this$1, xmlfiles, dirtyprops);
                            Listener.access$2700(this.this$1, xmlfiles, dirtyprops);
                        }
                    });
                    Util.err.log("ModuleList: finished processing outstanding external XML changes");
                }
                catch (IOException ioe) {
                    Util.err.notify((Throwable)ioe);
                    Object var4_3 = null;
                    ModuleList.this.mgr.mutexPrivileged().exitWriteAccess();
                    return;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ModuleList.this.mgr.mutexPrivileged().exitWriteAccess();
                throw throwable;
            }
            ModuleList.this.mgr.mutexPrivileged().exitWriteAccess();
        }

        private Map prepareXMLFiles() {
            Util.err.log("ModuleList: prepareXMLFiles");
            HashMap<String, FileObject> xmlfiles = new HashMap<String, FileObject>(100);
            FileObject[] kids = ModuleList.this.folder.getChildren();
            int i = 0;
            while (i < kids.length) {
                if (kids[i].hasExt("xml")) {
                    xmlfiles.put(kids[i].getName().replace('-', '.'), kids[i]);
                }
                ++i;
            }
            return xmlfiles;
        }

        private Map prepareDirtyProps(Map xmlfiles) throws IOException {
            Util.err.log("ModuleList: prepareDirtyProps");
            HashMap<String, Map> dirtyprops = new HashMap<String, Map>(100);
            Iterator it = xmlfiles.entrySet().iterator();
            while (it.hasNext()) {
                Object var13_10;
                Map.Entry entry = it.next();
                String cnb = (String)entry.getKey();
                DiskStatus status = (DiskStatus)ModuleList.this.stati.get(cnb);
                if (status != null && !status.dirty) continue;
                FileObject xmlfile = (FileObject)entry.getValue();
                InputStream is = xmlfile.getInputStream();
                try {
                    InputSource src = new InputSource(is);
                    src.setSystemId(xmlfile.getURL().toString());
                    try {
                        dirtyprops.put(cnb, ModuleList.this.readStatus(src, null));
                    }
                    catch (SAXException saxe) {
                        IOException ioe = new IOException(saxe.toString());
                        Util.err.annotate((Throwable)ioe, (Throwable)saxe);
                        throw ioe;
                    }
                    var13_10 = null;
                }
                catch (Throwable throwable) {
                    var13_10 = null;
                    is.close();
                    throw throwable;
                }
                is.close();
                {
                }
            }
            return dirtyprops;
        }

        private void stepCheckReloadable(Map xmlfiles, Map dirtyprops) {
            Util.err.log("ModuleList: stepCheckReloadable");
            Iterator it = dirtyprops.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String cnb = (String)entry.getKey();
                DiskStatus status = (DiskStatus)ModuleList.this.stati.get(cnb);
                if (status == null) continue;
                Map props = (Map)entry.getValue();
                Boolean diskReloadableB = (Boolean)props.get("reloadable");
                boolean diskReloadable = diskReloadableB != null ? diskReloadableB : false;
                boolean memReloadable = status.module.isReloadable();
                if (memReloadable == diskReloadable) continue;
                Util.err.log("Disk change in reloadable for " + cnb + " from " + memReloadable + " to " + diskReloadable);
                status.module.setReloadable(diskReloadable);
            }
        }

        private void stepCreate(Map xmlfiles, Map dirtyprops) throws IOException {
            Util.err.log("ModuleList: stepCreate");
            Iterator it = xmlfiles.entrySet().iterator();
            while (it.hasNext()) {
                HashMap<String, Boolean> statusProps;
                Module m;
                String relativeJar;
                Map.Entry entry = it.next();
                String cnb = (String)entry.getKey();
                if (ModuleList.this.stati.containsKey(cnb)) continue;
                FileObject xmlfile = (FileObject)entry.getValue();
                HashMap<String, Boolean> props = (HashMap<String, Boolean>)dirtyprops.get(cnb);
                if (!cnb.equals(props.get("name"))) {
                    throw new IOException("Code name mismatch");
                }
                String origin = (String)props.get("origin");
                File jar = ModuleList.this.findJarByName(origin, relativeJar = (String)props.get("jar"));
                if (!jar.isFile()) {
                    throw new IOException("No such module JAR: " + jar);
                }
                Boolean reloadableB = (Boolean)props.get("reloadable");
                boolean reloadable = reloadableB != null ? reloadableB : false;
                Boolean autoloadB = (Boolean)props.get("autoload");
                boolean autoload = autoloadB != null ? autoloadB : false;
                Boolean eagerB = (Boolean)props.get("eager");
                boolean eager = eagerB != null ? eagerB : false;
                try {
                    m = ModuleList.this.mgr.create(jar, new ModuleHistory(origin, relativeJar), reloadable, autoload, eager);
                }
                catch (DuplicateException dupe) {
                    IOException ioe = new IOException(dupe.toString());
                    Util.err.annotate((Throwable)ioe, (Throwable)dupe);
                    throw ioe;
                }
                m.addPropertyChangeListener(this);
                if (props.get("enabled") != null && ((Boolean)props.get("enabled")).booleanValue()) {
                    statusProps = new HashMap<String, Boolean>(props);
                    statusProps.put("enabled", Boolean.FALSE);
                } else {
                    statusProps = props;
                }
                DiskStatus status = new DiskStatus();
                status.module = m;
                status.file = xmlfile;
                status.diskProps = statusProps;
                ModuleList.this.stati.put(cnb, status);
            }
        }

        private void stepEnable(Map xmlfiles, Map dirtyprops) throws IOException {
            Util.err.log("ModuleList: stepEnable");
            HashSet<Module> toenable = new HashSet<Module>();
            Iterator it = dirtyprops.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String cnb = (String)entry.getKey();
                Map props = (Map)entry.getValue();
                if (props.get("enabled") == null || !((Boolean)props.get("enabled")).booleanValue()) continue;
                DiskStatus status = (DiskStatus)ModuleList.this.stati.get(cnb);
                if (status.diskProps.get("enabled") != null && ((Boolean)status.diskProps.get("enabled")).booleanValue()) continue;
                if (status.module.isEnabled()) {
                    throw new IllegalStateException("Already enabled: " + (Object)((Object)status.module));
                }
                toenable.add(status.module);
            }
            ModuleList.this.installNew(toenable);
        }

        private void stepDisable(Map xmlfiles, Map dirtyprops) throws IOException {
            Util.err.log("ModuleList: stepDisable");
            HashSet<Module> todisable = new HashSet<Module>();
            Iterator it = dirtyprops.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String cnb = (String)entry.getKey();
                Map props = (Map)entry.getValue();
                if (props.get("enabled") != null && ((Boolean)props.get("enabled")).booleanValue()) continue;
                DiskStatus status = (DiskStatus)ModuleList.this.stati.get(cnb);
                if (status.diskProps.get("enabled") == null || !((Boolean)status.diskProps.get("enabled")).booleanValue()) continue;
                if (!status.module.isEnabled()) {
                    throw new IllegalStateException("Already disabled: " + (Object)((Object)status.module));
                }
                todisable.add(status.module);
            }
            if (todisable.isEmpty()) {
                return;
            }
            List reallydisable = ModuleList.this.mgr.simulateDisable(todisable);
            it = reallydisable.iterator();
            while (it.hasNext()) {
                Module m = (Module)((Object)it.next());
                if (m.isAutoload() || m.isEager() || todisable.contains((Object)m)) continue;
                todisable.add(m);
            }
            ModuleList.this.mgr.disable(todisable);
        }

        private void stepDelete(Map xmlfiles, Map dirtyprops) throws IOException {
            Module m;
            Util.err.log("ModuleList: stepDelete");
            HashSet<Module> todelete = new HashSet<Module>();
            Iterator it = ModuleList.this.stati.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String cnb = (String)entry.getKey();
                DiskStatus status = (DiskStatus)entry.getValue();
                if (xmlfiles.containsKey(cnb)) continue;
                Module m2 = status.module;
                todelete.add(m2);
                it.remove();
            }
            if (todelete.isEmpty()) {
                return;
            }
            HashSet<Module> todisable = new HashSet<Module>();
            it = todelete.iterator();
            while (it.hasNext()) {
                Module m3 = (Module)((Object)it.next());
                if (!m3.isEnabled() || m3.isAutoload() || m3.isEager()) continue;
                todisable.add(m3);
            }
            List reallydisable = ModuleList.this.mgr.simulateDisable(todisable);
            it = reallydisable.iterator();
            while (it.hasNext()) {
                m = (Module)((Object)it.next());
                if (m.isAutoload() || m.isEager() || todisable.contains((Object)m)) continue;
                todisable.add(m);
            }
            ModuleList.this.mgr.disable(todisable);
            it = todelete.iterator();
            while (it.hasNext()) {
                m = (Module)((Object)it.next());
                if (m.isEnabled()) {
                    if (!m.isAutoload() && !m.isEager()) {
                        throw new IllegalStateException("Module " + (Object)((Object)m) + " scheduled for deletion could not be disabled yet was not an autoload nor eager");
                    }
                    ModuleList.this.ev.log("cantDeleteEnabledAutoload", (Object)m);
                    it.remove();
                    continue;
                }
                ModuleList.this.mgr.delete(m);
            }
        }

        private void stepCheckMisc(Map xmlfiles, Map dirtyprops) {
            Util.err.log("ModuleList: stepCheckMisc");
            String[] toCheck = new String[]{"jar", "origin", "autoload", "eager", "release", "specversion"};
            Iterator it = dirtyprops.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String cnb = (String)entry.getKey();
                Map props = (Map)entry.getValue();
                DiskStatus status = (DiskStatus)ModuleList.this.stati.get(cnb);
                Map diskProps = status.diskProps;
                int i = 0;
                while (i < toCheck.length) {
                    Object inMem;
                    String prop = toCheck[i];
                    Object onDisk = props.get(prop);
                    if (!Utilities.compareObjects(onDisk, inMem = diskProps.get(prop))) {
                        ModuleList.this.ev.log("miscPropMismatch", (Object)status.module, prop, onDisk, inMem);
                    }
                    ++i;
                }
            }
        }

        private void stepCheckSer(Map xmlfiles, Map dirtyprops) {
        }

        private void stepUpdateProps(Map xmlfiles, Map dirtyprops) {
            Util.err.log("ModuleList: stepUpdateProps");
            Iterator it = dirtyprops.entrySet().iterator();
            while (it.hasNext()) {
                Map props;
                Map.Entry entry = it.next();
                String cnb = (String)entry.getKey();
                DiskStatus status = (DiskStatus)ModuleList.this.stati.get(cnb);
                if (status == null) continue;
                status.diskProps = props = (Map)entry.getValue();
            }
        }

        private void stepMarkClean(Map xmlfiles, Map dirtyprops) {
            Util.err.log("ModuleList: stepMarkClean");
            Iterator it = ModuleList.this.stati.values().iterator();
            while (it.hasNext()) {
                DiskStatus status = (DiskStatus)it.next();
                status.dirty = false;
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ Map access$1600(Listener x0) {
            return x0.prepareXMLFiles();
        }

        static /* synthetic */ Map access$1700(Listener x0, Map x1) throws IOException {
            return x0.prepareDirtyProps(x1);
        }

        static /* synthetic */ boolean access$1802(Listener x0, boolean x1) {
            x0.listening = x1;
            return x0.listening;
        }

        static /* synthetic */ void access$1900(Listener x0, Map x1, Map x2) {
            x0.stepCheckReloadable(x1, x2);
        }

        static /* synthetic */ void access$2000(Listener x0, Map x1, Map x2) throws IOException {
            x0.stepCreate(x1, x2);
        }

        static /* synthetic */ void access$2100(Listener x0, Map x1, Map x2) throws IOException {
            x0.stepEnable(x1, x2);
        }

        static /* synthetic */ void access$2200(Listener x0, Map x1, Map x2) throws IOException {
            x0.stepDisable(x1, x2);
        }

        static /* synthetic */ void access$2300(Listener x0, Map x1, Map x2) throws IOException {
            x0.stepDelete(x1, x2);
        }

        static /* synthetic */ void access$2400(Listener x0, Map x1, Map x2) {
            x0.stepCheckMisc(x1, x2);
        }

        static /* synthetic */ void access$2500(Listener x0, Map x1, Map x2) {
            x0.stepCheckSer(x1, x2);
        }

        static /* synthetic */ void access$2600(Listener x0, Map x1, Map x2) {
            x0.stepUpdateProps(x1, x2);
        }

        static /* synthetic */ void access$2700(Listener x0, Map x1, Map x2) {
            x0.stepMarkClean(x1, x2);
        }
    }

    private static final class NoSuchOriginException
    extends IOException {
        public final String origin;

        public NoSuchOriginException(String origin) {
            super("Unrecognized origin: " + origin);
            this.origin = origin;
        }
    }

    public static final class AutoscanFolder {
        public final File folder;
        public final String origin;
        public final boolean autoload;
        public final boolean eager;

        public AutoscanFolder(File folder, String origin, boolean autoload, boolean eager) {
            if (autoload && eager) {
                throw new IllegalArgumentException();
            }
            this.folder = folder;
            this.origin = origin;
            this.autoload = autoload;
            this.eager = eager;
        }

        public String toString() {
            return "AutoscanFolder[folder=" + this.folder + ",origin=" + this.origin + ",autoload=" + this.autoload + ",eager=" + this.eager + "]";
        }
    }
}

